/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.dao.UccPriceChangeRecordMapper;
import com.tydic.commodity.dao.UccSkuAddCoefficientLogMapper;
import com.tydic.commodity.dao.UccSkuAddCoefficientMapper;
import com.tydic.commodity.estore.ability.api.UccSkuAddPriceBatchInsertService;
import com.tydic.commodity.estore.ability.bo.UccSkuAddPriceBatchInsertBO;
import com.tydic.commodity.estore.ability.bo.UccSkuAddPriceBatchInsertReqBO;
import com.tydic.commodity.estore.ability.bo.UccSkuAddPriceBatchInsertRspBO;
import com.tydic.commodity.po.UccPriceChangeRecordPO;
import com.tydic.commodity.po.UccSkuAddCoefficientLogPO;
import com.tydic.commodity.po.UccSkuAddCoefficientPO;
import com.tydic.commodity.utils.DateUtils;
import com.tydic.commodity.utils.ValidatorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.estore.ability.api.UccSkuAddPriceBatchInsertService"})
public class UccSkuAddPriceBatchInsertServiceImpl
implements UccSkuAddPriceBatchInsertService {
    private static final Logger log = LoggerFactory.getLogger(UccSkuAddPriceBatchInsertServiceImpl.class);
    @Autowired
    private UccSkuAddCoefficientMapper uccSkuAddCoefficientMapper;
    @Autowired
    private UccSkuAddCoefficientLogMapper uccSkuAddCoefficientLogMapper;
    @Autowired
    private UccPriceChangeRecordMapper uccPriceChangeRecordMapper;

    @PostMapping(value={"batchInsertSkuAddPrice"})
    public UccSkuAddPriceBatchInsertRspBO batchInsertSkuAddPrice(@RequestBody UccSkuAddPriceBatchInsertReqBO reqBO) {
        this.validate(reqBO);
        UccSkuAddPriceBatchInsertRspBO rspBO = new UccSkuAddPriceBatchInsertRspBO();
        try {
            ValidatorUtil.validator((Object)reqBO);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u4f20\u5165\u53c2\u6570\u975e\u6cd5\uff01");
            return rspBO;
        }
        ArrayList<UccSkuAddCoefficientPO> uccSkuAddCoefficientPOS = new ArrayList<UccSkuAddCoefficientPO>();
        List skuId = reqBO.getAddPriceInfoList().stream().map(UccSkuAddPriceBatchInsertBO::getSkuId).collect(Collectors.toList());
        List uccSkuAddCoefficientPOS1 = this.uccSkuAddCoefficientMapper.selectBySkuIds(skuId);
        if (!CollectionUtils.isEmpty((Collection)uccSkuAddCoefficientPOS1)) {
            ArrayList uccSkuAddPriceBatchInsertBOS = new ArrayList();
            List havSkus = uccSkuAddCoefficientPOS1.stream().map(UccSkuAddCoefficientPO::getSkuId).collect(Collectors.toList());
            reqBO.getAddPriceInfoList().forEach(each -> {
                if (!havSkus.contains(each.getSkuId())) {
                    uccSkuAddPriceBatchInsertBOS.add(each);
                }
            });
            reqBO.setAddPriceInfoList(uccSkuAddPriceBatchInsertBOS);
        }
        reqBO.getAddPriceInfoList().forEach(skuPriceInfo -> {
            UccSkuAddCoefficientPO uccSkuAddCoefficientPO = new UccSkuAddCoefficientPO();
            BeanCopier beanCopier = BeanCopier.create(UccSkuAddPriceBatchInsertBO.class, UccSkuAddCoefficientPO.class, (boolean)false);
            beanCopier.copy(skuPriceInfo, (Object)uccSkuAddCoefficientPO, null);
            uccSkuAddCoefficientPO.setUpdateOperId(reqBO.getName());
            uccSkuAddCoefficientPO.setUpdateTime(new Date());
            uccSkuAddCoefficientPO.setAddCoefficient(skuPriceInfo.getSkuAddCoefficient());
            uccSkuAddCoefficientPO.setCatalogId(skuPriceInfo.getCatalogId());
            uccSkuAddCoefficientPO.setEffectiveTime(skuPriceInfo.getEffectiveTime());
            uccSkuAddCoefficientPO.setExpiresTime(skuPriceInfo.getExpiresTime());
            Date beforeDateStartTime = DateUtils.getCurrentDateStartTime((Date)skuPriceInfo.getEffectiveTime());
            if (new Date().compareTo(beforeDateStartTime) >= 0) {
                uccSkuAddCoefficientPO.setEffectiveStatus(UccConstants.SKU_ADD_COEFFICIENT_EFFECTIVE);
            } else {
                uccSkuAddCoefficientPO.setEffectiveStatus(UccConstants.SKU_ADD_COEFFICIENT_WAIT_EFFECTIVE);
            }
            uccSkuAddCoefficientPOS.add(uccSkuAddCoefficientPO);
        });
        if (CollectionUtils.isEmpty(uccSkuAddCoefficientPOS)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u6240\u6709\u5355\u54c1\u90fd\u5df2\u6dfb\u52a0\u52a0\u4ef7\u7cfb\u6570\uff01");
            return rspBO;
        }
        try {
            this.uccSkuAddCoefficientMapper.batchInsert(uccSkuAddCoefficientPOS);
        }
        catch (Exception e) {
            log.error("\u65b0\u589e\u5931\u8d25\uff1a" + e);
            throw new ZTBusinessException("\u90e8\u5206\u5355\u54c1\u65b0\u589e\u52a0\u4ef7\u5931\u8d25\uff01");
        }
        ArrayList<UccSkuAddCoefficientLogPO> uccSkuAddCoefficientLogPOS = new ArrayList<UccSkuAddCoefficientLogPO>();
        for (UccSkuAddCoefficientPO uccSkuAddCoefficientPO : uccSkuAddCoefficientPOS) {
            UccSkuAddCoefficientLogPO uccSkuAddCoefficientLogPO = new UccSkuAddCoefficientLogPO();
            BeanCopier beanCopier = BeanCopier.create(UccSkuAddCoefficientPO.class, UccSkuAddCoefficientLogPO.class, (boolean)false);
            beanCopier.copy((Object)uccSkuAddCoefficientPO, (Object)uccSkuAddCoefficientLogPO, null);
            uccSkuAddCoefficientLogPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            uccSkuAddCoefficientLogPO.setSkuPriceId(uccSkuAddCoefficientPO.getSkuId());
            uccSkuAddCoefficientLogPO.setCreateTime(new Date());
            uccSkuAddCoefficientLogPO.setEffectiveTime(uccSkuAddCoefficientPO.getEffectiveTime());
            uccSkuAddCoefficientLogPO.setExpiresTime(uccSkuAddCoefficientPO.getExpiresTime());
            uccSkuAddCoefficientLogPO.setUpdateOperId(reqBO.getName());
            if (!ObjectUtils.isEmpty((Object)reqBO.getUsername())) {
                uccSkuAddCoefficientLogPO.setAccountNumber(reqBO.getUsername());
            }
            uccSkuAddCoefficientLogPOS.add(uccSkuAddCoefficientLogPO);
        }
        try {
            this.uccSkuAddCoefficientLogMapper.batchInsert(uccSkuAddCoefficientLogPOS);
        }
        catch (Exception e) {
            log.error("\u65b0\u589e\u65e5\u5fd7\u5931\u8d25\uff1a" + e);
            throw new ZTBusinessException("\u6279\u91cf\u65b0\u589e\u65e5\u5fd7\u5f02\u5e38\uff1a" + e.getMessage());
        }
        this.addPriceChangeRecord(uccSkuAddCoefficientPOS);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6dfb\u52a0\u6210\u529f\uff01");
        return rspBO;
    }

    private void addPriceChangeRecord(List<UccSkuAddCoefficientPO> addPriceBOList) {
        List priceChangeRecordPOS = addPriceBOList.stream().map(e -> {
            UccPriceChangeRecordPO recordPO = new UccPriceChangeRecordPO();
            recordPO.setStatus(Integer.valueOf(1));
            recordPO.setCatalogId(e.getCatalogId());
            recordPO.setRecordId(Long.valueOf(Sequence.getInstance().nextId()));
            recordPO.setSkuId(e.getSkuId());
            recordPO.setSupplierShopId(e.getSupplierShopId());
            return recordPO;
        }).collect(Collectors.toList());
        try {
            this.uccPriceChangeRecordMapper.insertBatch(priceChangeRecordPOS);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            log.error("\u65b0\u589e\u5b9a\u65f6\u4efb\u52a1\u5904\u7406\u8868\u5931\u8d25");
        }
    }

    private void validate(UccSkuAddPriceBatchInsertReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getAddPriceInfoList())) {
            throw new BusinessException("8888", "\u5982\u6b64\u90a3\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        for (UccSkuAddPriceBatchInsertBO uccSkuAddPriceBatchInsertBO : reqBO.getAddPriceInfoList()) {
            if (ObjectUtils.isEmpty((Object)uccSkuAddPriceBatchInsertBO.getEffectiveTime())) {
                throw new BusinessException("8888", "\u5165\u53c2 effectiveTime \u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (ObjectUtils.isEmpty((Object)uccSkuAddPriceBatchInsertBO.getExpiresTime()) || uccSkuAddPriceBatchInsertBO.getEffectiveTime().compareTo(uccSkuAddPriceBatchInsertBO.getExpiresTime()) <= 0) continue;
            throw new BusinessException("8888", "\u5931\u6548\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u751f\u6548\u65f6\u95f4\uff01");
        }
    }

    public static void main(String[] args) {
        String str = "null-34134234";
        System.out.println("null-00028308".toString().split("-"));
        String[] split = str.split("-");
        System.err.println(JSON.toJSONString((Object)split));
    }
}

