/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.ability.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.dao.UccPriceChangeRecordMapper;
import com.tydic.commodity.dao.UccSkuAddCoefficientMapper;
import com.tydic.commodity.estore.ability.api.UccSkuAddPriceBatchDeleteService;
import com.tydic.commodity.estore.ability.bo.UccSkuAddPriceBatchDeleteReqBO;
import com.tydic.commodity.estore.ability.bo.UccSkuAddPriceBatchDeleteRspBO;
import com.tydic.commodity.estore.busi.api.UccSkuAddPriceBatchDeleteBusiService;
import com.tydic.commodity.po.UccPriceChangeRecordPO;
import com.tydic.commodity.po.UccSkuAddCoefficientPO;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.estore.ability.api.UccSkuAddPriceBatchDeleteService"})
public class UccSkuAddPriceBatchDeleteServiceImpl
implements UccSkuAddPriceBatchDeleteService {
    private static final Logger log = LoggerFactory.getLogger(UccSkuAddPriceBatchDeleteServiceImpl.class);
    @Autowired
    private UccSkuAddPriceBatchDeleteBusiService uccSkuAddPriceBatchDeleteBusiService;
    @Autowired
    private UccPriceChangeRecordMapper uccPriceChangeRecordMapper;
    @Autowired
    private UccSkuAddCoefficientMapper uccSkuAddCoefficientMapper;

    @PostMapping(value={"batchDeleteSkuAddPrice"})
    public UccSkuAddPriceBatchDeleteRspBO batchDeleteSkuAddPrice(@RequestBody UccSkuAddPriceBatchDeleteReqBO reqBO) {
        UccSkuAddPriceBatchDeleteRspBO rspBO = new UccSkuAddPriceBatchDeleteRspBO();
        if (CollectionUtils.isEmpty((Collection)reqBO.getSkuIds())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5165\u53c2\u4e3a\u7a7a");
            return rspBO;
        }
        List skuAddCoefficientPOS = this.uccSkuAddCoefficientMapper.getListBySku(reqBO.getSkuIds());
        UccSkuAddPriceBatchDeleteRspBO batchDeleteRspBO = this.uccSkuAddPriceBatchDeleteBusiService.batchDeleteSkuAddPrice(reqBO);
        this.addPriceChangeRecord(skuAddCoefficientPOS);
        return batchDeleteRspBO;
    }

    private void addPriceChangeRecord(List<UccSkuAddCoefficientPO> addPriceBOList) {
        List priceChangeRecordPOS = addPriceBOList.stream().map(e -> {
            UccPriceChangeRecordPO recordPO = new UccPriceChangeRecordPO();
            recordPO.setStatus(Integer.valueOf(1));
            recordPO.setCatalogId(e.getCatalogId());
            recordPO.setRecordId(Long.valueOf(Sequence.getInstance().nextId()));
            recordPO.setSkuId(e.getSkuId());
            recordPO.setSupplierShopId(e.getSupplierShopId());
            return recordPO;
        }).collect(Collectors.toList());
        try {
            this.uccPriceChangeRecordMapper.insertBatch(priceChangeRecordPOS);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            log.error("\u65b0\u589e\u5b9a\u65f6\u4efb\u52a1\u5904\u7406\u8868\u5931\u8d25");
        }
    }
}

