/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.dao.UccPriceChangeRecordMapper;
import com.tydic.commodity.dao.UccSkuAddCoefficientLogMapper;
import com.tydic.commodity.dao.UccSkuAddCoefficientMapper;
import com.tydic.commodity.estore.ability.api.UccSkuAddPriceBatchUpdateService;
import com.tydic.commodity.estore.ability.bo.UccAddPriceInfoBO;
import com.tydic.commodity.estore.ability.bo.UccSkuAddPriceBatchUpdateReqBO;
import com.tydic.commodity.estore.ability.bo.UccSkuAddPriceBatchUpdateRspBO;
import com.tydic.commodity.po.UccPriceChangeRecordPO;
import com.tydic.commodity.po.UccSkuAddCoefficientLogPO;
import com.tydic.commodity.po.UccSkuAddCoefficientPO;
import com.tydic.commodity.utils.DateUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.estore.ability.api.UccSkuAddPriceBatchUpdateService"})
public class UccSkuAddPriceBatchUpdateServiceImpl
implements UccSkuAddPriceBatchUpdateService {
    private static final Logger log = LoggerFactory.getLogger(UccSkuAddPriceBatchUpdateServiceImpl.class);
    @Autowired
    private UccSkuAddCoefficientMapper uccSkuAddCoefficientMapper;
    @Autowired
    private UccSkuAddCoefficientLogMapper uccSkuAddCoefficientLogMapper;
    private Sequence sequence = Sequence.getInstance();
    @Autowired
    private UccPriceChangeRecordMapper uccPriceChangeRecordMapper;

    @PostMapping(value={"batchUpdateSkuAddPrice"})
    public UccSkuAddPriceBatchUpdateRspBO batchUpdateSkuAddPrice(@RequestBody UccSkuAddPriceBatchUpdateReqBO reqBO) {
        UccSkuAddPriceBatchUpdateRspBO rspBO = new UccSkuAddPriceBatchUpdateRspBO();
        this.validate(reqBO);
        List addPriceInfoList = reqBO.getAddPriceInfoList();
        List skuIds = addPriceInfoList.stream().map(UccAddPriceInfoBO::getSkuId).collect(Collectors.toList());
        List uccSkuAddCoefficientPOS = this.uccSkuAddCoefficientMapper.selectBySkuIds(skuIds);
        this.uccSkuAddCoefficientLogMapper.batchUpdateTime(skuIds);
        List<UccSkuAddCoefficientPO> updateListBO = this.createUpdateListBO(addPriceInfoList, reqBO);
        List<UccSkuAddCoefficientLogPO> batchInsertLogBO = this.createBatchInsertLogBO(updateListBO, reqBO, uccSkuAddCoefficientPOS);
        this.uccSkuAddCoefficientLogMapper.batchInsert(batchInsertLogBO);
        for (UccSkuAddCoefficientPO uccSkuAddCoefficientPO : updateListBO) {
            Date beforeDateStartTime = DateUtils.getCurrentDateStartTime((Date)uccSkuAddCoefficientPO.getEffectiveTime());
            if (new Date().compareTo(beforeDateStartTime) >= 0) {
                uccSkuAddCoefficientPO.setEffectiveStatus(UccConstants.SKU_ADD_COEFFICIENT_EFFECTIVE);
                continue;
            }
            uccSkuAddCoefficientPO.setEffectiveStatus(UccConstants.SKU_ADD_COEFFICIENT_WAIT_EFFECTIVE);
        }
        this.uccSkuAddCoefficientMapper.batchUpdateAddPrice(updateListBO);
        this.addPriceChangeRecord(uccSkuAddCoefficientPOS);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void addPriceChangeRecord(List<UccSkuAddCoefficientPO> addPriceBOList) {
        List priceChangeRecordPOS = addPriceBOList.stream().map(e -> {
            UccPriceChangeRecordPO recordPO = new UccPriceChangeRecordPO();
            recordPO.setStatus(Integer.valueOf(1));
            recordPO.setCatalogId(e.getCatalogId());
            recordPO.setRecordId(Long.valueOf(this.sequence.nextId()));
            recordPO.setSkuId(e.getSkuId());
            recordPO.setSupplierShopId(e.getSupplierShopId());
            return recordPO;
        }).collect(Collectors.toList());
        try {
            this.uccPriceChangeRecordMapper.insertBatch(priceChangeRecordPOS);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            log.error("\u65b0\u589e\u5b9a\u65f6\u4efb\u52a1\u5904\u7406\u8868\u5931\u8d25");
        }
    }

    private void validate(UccSkuAddPriceBatchUpdateReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getAddPriceInfoList())) {
            throw new BusinessException("8888", "\u5165\u53c2\u4e3a\u7a7a\uff01");
        }
        for (UccAddPriceInfoBO infoBO : reqBO.getAddPriceInfoList()) {
            if (ObjectUtils.isEmpty((Object)infoBO.getEffectiveTime())) {
                throw new BusinessException("8888", "\u5165\u53c2 effectiveTime \u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (ObjectUtils.isEmpty((Object)infoBO.getExpiresTime()) || infoBO.getEffectiveTime().compareTo(infoBO.getExpiresTime()) <= 0) continue;
            throw new BusinessException("8888", "\u5931\u6548\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u751f\u6548\u65f6\u95f4\uff01");
        }
    }

    private List<UccSkuAddCoefficientPO> createUpdateListBO(List<UccAddPriceInfoBO> addPriceInfoList, UccSkuAddPriceBatchUpdateReqBO reqBO) {
        ArrayList<UccSkuAddCoefficientPO> list = new ArrayList<UccSkuAddCoefficientPO>();
        for (UccAddPriceInfoBO uccAddPriceInfoBO : addPriceInfoList) {
            UccSkuAddCoefficientPO uccSkuAddCoefficientPO = new UccSkuAddCoefficientPO();
            uccSkuAddCoefficientPO.setSkuId(uccAddPriceInfoBO.getSkuId());
            uccSkuAddCoefficientPO.setAddCoefficient(uccAddPriceInfoBO.getSkuAddCoefficient());
            uccSkuAddCoefficientPO.setAllowMarketPrice(uccAddPriceInfoBO.getAllowMoreMarket());
            uccSkuAddCoefficientPO.setExpiresTime(uccAddPriceInfoBO.getExpiresTime());
            uccSkuAddCoefficientPO.setEffectiveTime(uccAddPriceInfoBO.getEffectiveTime());
            uccSkuAddCoefficientPO.setUpdateTime(new Date());
            uccSkuAddCoefficientPO.setUpdateOperId(reqBO.getName());
            list.add(uccSkuAddCoefficientPO);
        }
        return list;
    }

    private List<UccSkuAddCoefficientLogPO> createBatchInsertLogBO(List<UccSkuAddCoefficientPO> uccSkuAddCoefficientPOS, UccSkuAddPriceBatchUpdateReqBO reqBO, List<UccSkuAddCoefficientPO> beforeData) {
        ArrayList<UccSkuAddCoefficientLogPO> list = new ArrayList<UccSkuAddCoefficientLogPO>();
        for (UccSkuAddCoefficientPO uccSkuAddCoefficientPO : uccSkuAddCoefficientPOS) {
            UccSkuAddCoefficientLogPO uccSkuAddCoefficientLogPO = new UccSkuAddCoefficientLogPO();
            BeanUtils.copyProperties((Object)uccSkuAddCoefficientPO, (Object)uccSkuAddCoefficientLogPO);
            uccSkuAddCoefficientLogPO.setId(Long.valueOf(this.sequence.nextId()));
            uccSkuAddCoefficientLogPO.setCreateOperId(reqBO.getName());
            uccSkuAddCoefficientLogPO.setAccountNumber(reqBO.getUsername());
            uccSkuAddCoefficientLogPO.setUpdateOperId(reqBO.getName());
            uccSkuAddCoefficientLogPO.setUpdateTime(new Date());
            uccSkuAddCoefficientLogPO.setCreateTime(new Date());
            List collect = beforeData.stream().filter(s -> s.getSkuId().equals(uccSkuAddCoefficientPO.getSkuId())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(collect)) {
                UccSkuAddCoefficientPO beforeBO = (UccSkuAddCoefficientPO)collect.get(0);
                uccSkuAddCoefficientLogPO.setSupplierShopId(beforeBO.getSupplierShopId());
                uccSkuAddCoefficientLogPO.setShopName(beforeBO.getShopName());
                uccSkuAddCoefficientLogPO.setSkuPriceId(beforeBO.getSkuId());
            }
            list.add(uccSkuAddCoefficientLogPO);
        }
        return list;
    }

    public static void main(String[] args) {
        String result = JSON.toJSONString((Object)"{\n    \"result\": {\n        \"brandName\": \"AIMO/\u7231\u58a8\",\n        \"brandPic\": null,\n        \"category\": [\n            \"259433\",\n            \"271592\",\n            \"271593\"\n        ],\n        \"imagePath\": \"oss/PRODUCT/BIG/BIG_AA0417498_01.jpg?x-oss-process=style/common_style\",\n        \"introduction\": \"<!DOCTYPE html><html lang='en'><head><meta http-equiv='Content-Type' content='text/html; charset=UTF-8'><meta http-equiv='x-ua-compatible' content='IE=edge'><title>\u9707\u5764\u884c\u91c7\u8d2d\u670d\u52a1\u5e73\u53f0 - \u5168\u56fd\u9886\u5148\u7684MRO\u5de5\u4e1a\u7528\u54c1\u4e00\u7ad9\u5f0f\u91c7\u8d2d\u670d\u52a1\u5e73\u53f0</title><!-- title_icon --><meta http-equiv='pragma' content='no-cache'> <meta http-equiv='Cache-Control' content='no-cache, must-revalidate'> <meta http-equiv='expires' content='0'><!-- \u901a\u7528\u7684css\u6837\u5f0f\u653e\u5728\u8fd9\u91cc\uff0c\u81ea\u5b9a\u4e49\u7684\u653e\u5728\u81ea\u5df1\u7528\u5230\u7684\u5730\u65b9 --><link rel='stylesheet' type='text/css' href='https://zkh-esp-public.oss-cn-hangzhou.aliyuncs.com/Webshop/images/product_detail.css'></head><body><div><!-- \u8be6\u7ec6\u4fe1\u606f start --><div class='detailed_info' id='zkh_cp_detail_info'><div class='detail_content clearfix' id='advantage'><div class='left_imgs'><div id='href01'><h5><div><span>\u4ea7\u54c1\u4ecb\u7ecd&nbsp;/&nbsp;<i>Introduction</i><em class='triangle01'></em></span></div><em class='slogan'></em><em class='triangle02'></em></h5><h6>\u5546\u54c1\u5c5e\u6027\uff1a</h6><div class='goods_feature_box'><span class='goods_feature'><label>\u989c\u8272:</label>\u9ec4\u5e95\u9ed1\u5b57</span><span class='goods_feature'><label>\u9500\u552e\u5355\u4f4d:</label>\u4e2a</span><span class='goods_feature'><label>\u957f\u5ea6:</label>8m</span><span class='goods_feature'><label>\u5bbd\u5ea6:</label>12mm</span></div><h6>\u4ea7\u54c1\u7279\u70b9\uff1a</h6><p>\u00b7\u8010\u78e8\u635f\u3001\u4e0d\u6613\u6495\u53bb\u3001\u8010\u6469\u64e6\u3001\u8010\u8150\u8680\u3001\u8010\u892a\u8272\u3001\u8010\u9ad8\u4f4e\u6e29\u3001\u9632\u6c34\u9632\u6cb9</p><h6>\u9002\u7528\u573a\u5408\uff1a</h6><p>\u00b7\u914d\u5408\u5144\u5f1f\u6807\u7b7e\u6253\u5370\u673a\u4f7f\u7528</p><img  src='http://pathfinder-private.oss-cn-shanghai.aliyuncs.com//PRODUCT/BIG/BIG_AA0417498_01.jpg?x-oss-process=style/common_style'></div><div id='href04'><h5><div><span>\u4ea7\u54c1\u53c2\u6570&nbsp;/&nbsp;<i>Parameter</i><em class='triangle01'></em></span></div><em class='slogan'></em><em class='triangle02'></em></h5><img  src='http://pathfinder-private.oss-cn-shanghai.aliyuncs.com//PRODUCT/FFB/PARM_AA0417498_01.jpg?x-oss-process=style/common_style'></div></div></div><!-- \u516c\u53f8\u670d\u52a1\u4fe1\u606fstart --><div class='company_ads' id='contact_us' style='box-sizing: border-box;'><table><tbody><tr><th style='width: 44px;'><img src='https://esp-image.zkh360.com/Webshop/images/icon01.png?x-oss-process=style/common_style'></th><td><h5>\u5173\u4e8e\u9707\u5764\u884c</h5><p>\u9707\u5764\u884c\uff08zkh360)----\u5168\u79f0\u4e3a\u9707\u5764\u884c\u5de5\u4e1a\u8d85\u5e02\u3002\u662f\u4e00\u4e2a\u4e13\u4e1a\u94f8\u5c31\u81ea\u4fe1\u3001\u7740\u773c\u957f\u8fdc\u53d1\u5c55\u3001\u5e76\u4e14\u4e50\u4e8e\u627f\u62c5\u793e\u4f1a\u8d23\u4efb\u7684\u56e2\u961f\uff0c\u7aed\u8bda\u671f\u5f85\u4e0e\u60a8\u7684\u5408\u4f5c\uff01</p></td></tr><tr><th><img src='https://esp-image.zkh360.com/Webshop/images/icon02.png?x-oss-process=style/common_style'></th><td><h5>\u6b63\u54c1\u4fdd\u8bc1</h5><p>\u9707\u5764\u884c\u5de5\u4e1a\u8d85\u5e02\u5411\u60a8\u4fdd\u8bc1\u6240\u552e\u5546\u54c1\u5747\u4e3a\u6b63\u54c1\u884c\u8d27\uff0c\u5f00\u5177\u6b63\u89c4\u53d1\u7968\u3002</p></td></tr><tr><th><img src='https://esp-image.zkh360.com/Webshop/images/icon03.png?x-oss-process=style/common_style'></th><td><h5>\u5168\u573a\u514d\u8fd0\u8d39</h5><p>\u81ea 2014 \u5e748\u670825\u65e5\u8d77\uff0c\u6211\u53f8\u5b9e\u884c\u5168\u7ebf\u514d\u8fd0\u8d39\u7684\u8fd0\u8f93\u6536\u8d39\u6807\u51c6\uff0c\u4e0d\u8bba\u666e\u8d27\u6216\u5371\u9669\u54c1\uff0c\u4e0d\u8bba\u8d2d\u4e70\u6570\u91cf\u548c\u91d1\u989d\uff0c\u7686\u53ef\u4eab\u53d7\u6211\u53f8\u7684\u514d\u8d39\u914d\u9001\u670d\u52a1\u3002</p></td></tr><tr><th><img src='https://esp-image.zkh360.com/Webshop/images/icon04.png?x-oss-process=style/common_style'></th><td><h5>\u9000\u6362\u8d27\u65e0\u5fe7</h5><p>\u51ed\u8d28\u4fdd\u8bc1\u4e66\u53ca\u9707\u5764\u884c\u53d1\u7968\uff0c\u53ef\u4eab\u53d7\u5168\u56fd\u8054\u4fdd\u670d\u52a1\uff0c\u4e0e\u60a8\u4eb2\u4e34\u5546\u573a\u9009\u8d2d\u7684\u5546\u54c1\u4eab\u53d7\u76f8\u540c\u7684\u8d28\u91cf\u4fdd\u8bc1\u3002\u5982\u6709\u4efb\u4f55\u95ee\u9898\u5747\u53ef\u5b89\u5168\u9000\u6362\u8d27\u7269\uff0c\u8bf7\u60a8\u653e\u5fc3\u8d2d\u4e70\uff01</p></td></tr></tbody></table></div><!-- \u516c\u53f8\u670d\u52a1\u4fe1\u606fend --></div></div></body></html>\",\n        \"isReturn\": 0,\n        \"name\": \"AIMO/\u7231\u58a8 \u5f3a\u7c98\u6027\u7ebf\u7f06\u6807\u7b7e\u8272\u5e26 WZe-631 12mm\u9ec4\u5e95\u9ed1\u5b57 \u4e2d\u6027\u5305\u88c5 1\u4e2a \u9500\u552e\u5355\u4f4d\uff1a\u4e2a\",\n        \"param\": [\n            {\n                \"attrCode\": null,\n                \"attrGroupCode\": null,\n                \"attrGroupName\": null,\n                \"attrGroupSeq\": null,\n                \"attrName\": \"\u989c\u8272\",\n                \"attrSeq\": \"5\",\n                \"attrValue\": \"\u9ec4\u5e95\u9ed1\u5b57\"\n            },\n            {\n                \"attrCode\": null,\n                \"attrGroupCode\": null,\n                \"attrGroupName\": null,\n                \"attrGroupSeq\": null,\n                \"attrName\": \"\u9500\u552e\u5355\u4f4d\",\n                \"attrSeq\": \"1\",\n                \"attrValue\": \"\u4e2a\"\n            },\n            {\n                \"attrCode\": null,\n                \"attrGroupCode\": null,\n                \"attrGroupName\": null,\n                \"attrGroupSeq\": null,\n                \"attrName\": \"\u957f\u5ea6\",\n                \"attrSeq\": \"3\",\n                \"attrValue\": \"8m\"\n            },\n            {\n                \"attrCode\": null,\n                \"attrGroupCode\": null,\n                \"attrGroupName\": null,\n                \"attrGroupSeq\": null,\n                \"attrName\": \"\u5bbd\u5ea6\",\n                \"attrSeq\": \"2\",\n                \"attrValue\": \"12mm\"\n            }\n        ],\n        \"productArea\": null,\n        \"skuGroup\": [\n            {\n                \"deliveryTime\": 9,\n                \"denominator\": null,\n                \"group\": \"\u80f6\",\n                \"imagePath\": \"oss/PRODUCT/BIG/BIG_AA0417498_01.jpg?x-oss-process=style/common_style\",\n                \"introduction\": \"<!DOCTYPE html><html lang='en'><head><meta http-equiv='Content-Type' content='text/html; charset=UTF-8'><meta http-equiv='x-ua-compatible' content='IE=edge'><title>\u9707\u5764\u884c\u91c7\u8d2d\u670d\u52a1\u5e73\u53f0 - \u5168\u56fd\u9886\u5148\u7684MRO\u5de5\u4e1a\u7528\u54c1\u4e00\u7ad9\u5f0f\u91c7\u8d2d\u670d\u52a1\u5e73\u53f0</title><!-- title_icon --><meta http-equiv='pragma' content='no-cache'> <meta http-equiv='Cache-Control' content='no-cache, must-revalidate'> <meta http-equiv='expires' content='0'><!-- \u901a\u7528\u7684css\u6837\u5f0f\u653e\u5728\u8fd9\u91cc\uff0c\u81ea\u5b9a\u4e49\u7684\u653e\u5728\u81ea\u5df1\u7528\u5230\u7684\u5730\u65b9 --><link rel='stylesheet' type='text/css' href='https://zkh-esp-public.oss-cn-hangzhou.aliyuncs.com/Webshop/images/product_detail.css'></head><body><div><!-- \u8be6\u7ec6\u4fe1\u606f start --><div class='detailed_info' id='zkh_cp_detail_info'><div class='detail_content clearfix' id='advantage'><div class='left_imgs'><div id='href01'><h5><div><span>\u4ea7\u54c1\u4ecb\u7ecd&nbsp;/&nbsp;<i>Introduction</i><em class='triangle01'></em></span></div><em class='slogan'></em><em class='triangle02'></em></h5><h6>\u5546\u54c1\u5c5e\u6027\uff1a</h6><div class='goods_feature_box'><span class='goods_feature'><label>\u989c\u8272:</label>\u9ec4\u5e95\u9ed1\u5b57</span><span class='goods_feature'><label>\u9500\u552e\u5355\u4f4d:</label>\u4e2a</span><span class='goods_feature'><label>\u957f\u5ea6:</label>8m</span><span class='goods_feature'><label>\u5bbd\u5ea6:</label>12mm</span></div><h6>\u4ea7\u54c1\u7279\u70b9\uff1a</h6><p>\u00b7\u8010\u78e8\u635f\u3001\u4e0d\u6613\u6495\u53bb\u3001\u8010\u6469\u64e6\u3001\u8010\u8150\u8680\u3001\u8010\u892a\u8272\u3001\u8010\u9ad8\u4f4e\u6e29\u3001\u9632\u6c34\u9632\u6cb9</p><h6>\u9002\u7528\u573a\u5408\uff1a</h6><p>\u00b7\u914d\u5408\u5144\u5f1f\u6807\u7b7e\u6253\u5370\u673a\u4f7f\u7528</p><img  src='http://pathfinder-private.oss-cn-shanghai.aliyuncs.com//PRODUCT/BIG/BIG_AA0417498_01.jpg?x-oss-process=style/common_style'></div><div id='href04'><h5><div><span>\u4ea7\u54c1\u53c2\u6570&nbsp;/&nbsp;<i>Parameter</i><em class='triangle01'></em></span></div><em class='slogan'></em><em class='triangle02'></em></h5><img  src='http://pathfinder-private.oss-cn-shanghai.aliyuncs.com//PRODUCT/FFB/PARM_AA0417498_01.jpg?x-oss-process=style/common_style'></div></div></div><!-- \u516c\u53f8\u670d\u52a1\u4fe1\u606fstart --><div class='company_ads' id='contact_us' style='box-sizing: border-box;'><table><tbody><tr><th style='width: 44px;'><img src='https://esp-image.zkh360.com/Webshop/images/icon01.png?x-oss-process=style/common_style'></th><td><h5>\u5173\u4e8e\u9707\u5764\u884c</h5><p>\u9707\u5764\u884c\uff08zkh360)----\u5168\u79f0\u4e3a\u9707\u5764\u884c\u5de5\u4e1a\u8d85\u5e02\u3002\u662f\u4e00\u4e2a\u4e13\u4e1a\u94f8\u5c31\u81ea\u4fe1\u3001\u7740\u773c\u957f\u8fdc\u53d1\u5c55\u3001\u5e76\u4e14\u4e50\u4e8e\u627f\u62c5\u793e\u4f1a\u8d23\u4efb\u7684\u56e2\u961f\uff0c\u7aed\u8bda\u671f\u5f85\u4e0e\u60a8\u7684\u5408\u4f5c\uff01</p></td></tr><tr><th><img src='https://esp-image.zkh360.com/Webshop/images/icon02.png?x-oss-process=style/common_style'></th><td><h5>\u6b63\u54c1\u4fdd\u8bc1</h5><p>\u9707\u5764\u884c\u5de5\u4e1a\u8d85\u5e02\u5411\u60a8\u4fdd\u8bc1\u6240\u552e\u5546\u54c1\u5747\u4e3a\u6b63\u54c1\u884c\u8d27\uff0c\u5f00\u5177\u6b63\u89c4\u53d1\u7968\u3002</p></td></tr><tr><th><img src='https://esp-image.zkh360.com/Webshop/images/icon03.png?x-oss-process=style/common_style'></th><td><h5>\u5168\u573a\u514d\u8fd0\u8d39</h5><p>\u81ea 2014 \u5e748\u670825\u65e5\u8d77\uff0c\u6211\u53f8\u5b9e\u884c\u5168\u7ebf\u514d\u8fd0\u8d39\u7684\u8fd0\u8f93\u6536\u8d39\u6807\u51c6\uff0c\u4e0d\u8bba\u666e\u8d27\u6216\u5371\u9669\u54c1\uff0c\u4e0d\u8bba\u8d2d\u4e70\u6570\u91cf\u548c\u91d1\u989d\uff0c\u7686\u53ef\u4eab\u53d7\u6211\u53f8\u7684\u514d\u8d39\u914d\u9001\u670d\u52a1\u3002</p></td></tr><tr><th><img src='https://esp-image.zkh360.com/Webshop/images/icon04.png?x-oss-process=style/common_style'></th><td><h5>\u9000\u6362\u8d27\u65e0\u5fe7</h5><p>\u51ed\u8d28\u4fdd\u8bc1\u4e66\u53ca\u9707\u5764\u884c\u53d1\u7968\uff0c\u53ef\u4eab\u53d7\u5168\u56fd\u8054\u4fdd\u670d\u52a1\uff0c\u4e0e\u60a8\u4eb2\u4e34\u5546\u573a\u9009\u8d2d\u7684\u5546\u54c1\u4eab\u53d7\u76f8\u540c\u7684\u8d28\u91cf\u4fdd\u8bc1\u3002\u5982\u6709\u4efb\u4f55\u95ee\u9898\u5747\u53ef\u5b89\u5168\u9000\u6362\u8d27\u7269\uff0c\u8bf7\u60a8\u653e\u5fc3\u8d2d\u4e70\uff01</p></td></tr></tbody></table></div><!-- \u516c\u53f8\u670d\u52a1\u4fe1\u606fend --></div></div></body></html>\",\n                \"isReturn\": 0,\n                \"mfgSku\": \"AA0417498\",\n                \"mincrement\": null,\n                \"model\": \"WZe-631\",\n                \"molecule\": null,\n                \"moq\": 10,\n                \"name\": \"AIMO/\u7231\u58a8 \u5f3a\u7c98\u6027\u7ebf\u7f06\u6807\u7b7e\u8272\u5e26 WZe-631 12mm\u9ec4\u5e95\u9ed1\u5b57 \u4e2d\u6027\u5305\u88c5 1\u4e2a \u9500\u552e\u5355\u4f4d\uff1a\u4e2a\",\n                \"param\": [\n                    {\n                        \"attrCode\": null,\n                        \"attrGroupCode\": null,\n                        \"attrGroupName\": null,\n                        \"attrGroupSeq\": null,\n                        \"attrName\": \"\u989c\u8272\",\n                        \"attrSeq\": \"5\",\n                        \"attrValue\": \"\u9ec4\u5e95\u9ed1\u5b57\"\n                    },\n                    {\n                        \"attrCode\": null,\n                        \"attrGroupCode\": null,\n                        \"attrGroupName\": null,\n                        \"attrGroupSeq\": null,\n                        \"attrName\": \"\u9500\u552e\u5355\u4f4d\",\n                        \"attrSeq\": \"1\",\n                        \"attrValue\": \"\u4e2a\"\n                    },\n                    {\n                        \"attrCode\": null,\n                        \"attrGroupCode\": null,\n                        \"attrGroupName\": null,\n                        \"attrGroupSeq\": null,\n                        \"attrName\": \"\u957f\u5ea6\",\n                        \"attrSeq\": \"3\",\n                        \"attrValue\": \"8m\"\n                    },\n                    {\n                        \"attrCode\": null,\n                        \"attrGroupCode\": null,\n                        \"attrGroupName\": null,\n                        \"attrGroupSeq\": null,\n                        \"attrName\": \"\u5bbd\u5ea6\",\n                        \"attrSeq\": \"2\",\n                        \"attrValue\": \"12mm\"\n                    }\n                ],\n                \"saleUnit\": \"\u4e2a\",\n                \"settleRate\": null,\n                \"settleUnit\": null,\n                \"sku\": \"AA0417498\",\n                \"spec\": \"12mm\u9ec4\u5e95\u9ed1\u5b57 \u4e2d\u6027\u5305\u88c5\",\n                \"state\": 1,\n                \"type\": 1,\n                \"unit\": \"WZe-631 12mm\u9ec4\u5e95\u9ed1\u5b57 \u4e2d\u6027\u5305\u88c5\",\n                \"upc\": null,\n                \"wareNum\": \"\",\n                \"weight\": null\n            }\n        ],\n        \"spu\": \"AA0417498\",\n        \"tax\": 13,\n        \"taxCode\": \"1090512990000000000\",\n        \"wareQD\": \"\"\n    },\n    \"resultCode\": \"0000\",\n    \"resultMessage\": \"success\",\n    \"success\": true\n}");
        JSONObject parse = JSON.parseObject((String)result);
        System.err.println(parse.getString("deliveryTime"));
    }
}

