/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.constant.ExcelNewUtils;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.dao.UccPriceChangeRecordMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.estore.ability.api.UccSkuAddPriceImportAbilityService;
import com.tydic.commodity.estore.ability.bo.UccExcelImportAddPriceBO;
import com.tydic.commodity.estore.ability.bo.UccSkuAddPriceImportAbilityReqBO;
import com.tydic.commodity.estore.ability.bo.UccSkuAddPriceImportAbilityRspBO;
import com.tydic.commodity.estore.busi.api.UccSkuAddPriceImportBusiService;
import com.tydic.commodity.estore.busi.api.UccSkuPriceUpdateBusiService;
import com.tydic.commodity.estore.busi.bo.UccSkuAddPriceImportBusiReqBO;
import com.tydic.commodity.po.UccPriceChangeRecordPO;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.utils.DateUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.estore.ability.api.UccSkuAddPriceImportAbilityService"})
public class UccSkuAddPriceImportAbilityServiceImpl
implements UccSkuAddPriceImportAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccSkuAddPriceImportAbilityServiceImpl.class);
    @Autowired
    private UccSkuAddPriceImportBusiService uccSkuAddPriceImportBusiService;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSkuPriceUpdateBusiService uccSkuPriceUpdateBusiService;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;
    @Autowired
    private UccPriceChangeRecordMapper uccPriceChangeRecordMapper;
    private static final Sequence SEQUENCE = Sequence.getInstance();

    @PostMapping(value={"skuAddPriceImport"})
    public UccSkuAddPriceImportAbilityRspBO skuAddPriceImport(@RequestBody UccSkuAddPriceImportAbilityReqBO reqBO) {
        UccSkuAddPriceImportAbilityRspBO rspBO = new UccSkuAddPriceImportAbilityRspBO();
        ArrayList<UccExcelImportAddPriceBO> failList = new ArrayList<UccExcelImportAddPriceBO>();
        if (StringUtils.isEmpty((Object)reqBO.getUrl())) {
            throw new BusinessException("8888", "url \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        List<UccExcelImportAddPriceBO> addPriceBOList = this.getSpuInfoFromExcel(reqBO.getUrl());
        this.validate(addPriceBOList, failList);
        if (!CollectionUtils.isEmpty(failList)) {
            rspBO.setCount(Integer.valueOf(addPriceBOList.size()));
            rspBO.setFailCount(Integer.valueOf(addPriceBOList.size()));
            rspBO.setFailList(failList);
            rspBO.setRespDesc(failList.get(0).getFailDes());
            rspBO.setRespCode("8888");
            return rspBO;
        }
        UccSkuAddPriceImportBusiReqBO busiReqBO = new UccSkuAddPriceImportBusiReqBO();
        busiReqBO.setUserId(reqBO.getUserId());
        busiReqBO.setUsername(reqBO.getUsername());
        busiReqBO.setName(reqBO.getName());
        busiReqBO.setList(addPriceBOList);
        UccSkuAddPriceImportAbilityRspBO addPriceImportRspBO = this.uccSkuAddPriceImportBusiService.dealSkuPriceAddImport(busiReqBO);
        if ("0000".equals(addPriceImportRspBO.getRespCode())) {
            this.addPriceChangeRecord(addPriceBOList);
            rspBO.setSuccessList(addPriceBOList);
            rspBO.setCount(Integer.valueOf(addPriceBOList.size()));
            rspBO.setSuccessCount(Integer.valueOf(addPriceBOList.size()));
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        throw new BusinessException("8888", addPriceImportRspBO.getRespDesc());
    }

    private void addPriceChangeRecord(List<UccExcelImportAddPriceBO> addPriceBOList) {
        List priceChangeRecordPOS = addPriceBOList.stream().map(e -> {
            UccPriceChangeRecordPO recordPO = new UccPriceChangeRecordPO();
            recordPO.setStatus(Integer.valueOf(1));
            recordPO.setCatalogId(e.getCommodityTypeId());
            recordPO.setRecordId(Long.valueOf(SEQUENCE.nextId()));
            recordPO.setSkuId(e.getSkuId());
            recordPO.setSupplierShopId(e.getSupplierShopId());
            return recordPO;
        }).collect(Collectors.toList());
        try {
            this.uccPriceChangeRecordMapper.insertBatch(priceChangeRecordPOS);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            log.error("\u65b0\u589e\u5b9a\u65f6\u4efb\u52a1\u5904\u7406\u8868\u5931\u8d25");
        }
    }

    private String validate(List<UccExcelImportAddPriceBO> addPriceBOList, ArrayList<UccExcelImportAddPriceBO> failList) {
        if (CollectionUtils.isEmpty(addPriceBOList)) {
            throw new BusinessException("8888", "\u6a21\u677f\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        List skuCodes = addPriceBOList.stream().map(UccExcelImportAddPriceBO::getSkuCode).distinct().collect(Collectors.toList());
        if (skuCodes.size() != addPriceBOList.size()) {
            Map<String, List<UccExcelImportAddPriceBO>> filterMap = addPriceBOList.stream().collect(Collectors.groupingBy(UccExcelImportAddPriceBO::getSkuCode));
            for (String string : filterMap.keySet()) {
                if (filterMap.get(string).size() <= 1) continue;
                UccExcelImportAddPriceBO priceBO = filterMap.get(string).get(0);
                priceBO.setFailDes("\u5355\u54c1\u7f16\u7801\u91cd\u590d");
                failList.add(priceBO);
            }
        }
        if (!CollectionUtils.isEmpty(failList)) {
            return null;
        }
        List skuPos = this.uccSkuMapper.getSkuIdByCodes(skuCodes);
        if (skuPos.size() != skuCodes.size()) {
            List existSkuCodes = skuPos.stream().map(UccSkuPo::getSkuCode).collect(Collectors.toList());
            for (UccExcelImportAddPriceBO priceBO : addPriceBOList) {
                if (existSkuCodes.contains(priceBO.getSkuCode())) continue;
                priceBO.setFailDes("\u5355\u54c1\u7f16\u7801\u4e0d\u5b58\u5728\uff01");
                failList.add(priceBO);
            }
        } else {
            Map<String, List<UccSkuPo>> skuMaps = skuPos.stream().collect(Collectors.groupingBy(UccSkuPo::getSkuCode));
            for (UccExcelImportAddPriceBO priceBO : addPriceBOList) {
                UccSkuPo skuPo = skuMaps.get(priceBO.getSkuCode()).get(0);
                if (skuPo.getSkuSource() != 2) {
                    priceBO.setFailDes("\u975e\u7535\u5546\u5546\u54c1\u65e0\u6cd5\u8bbe\u7f6e\u52a0\u4ef7\u4fe1\u606f\uff01");
                    failList.add(priceBO);
                    continue;
                }
                priceBO.setSkuId(skuPo.getSkuId());
                priceBO.setExtSkuId(skuPo.getExtSkuId());
                priceBO.setExtSpuId(skuPo.getExtSpuId());
                priceBO.setCommodityTypeId(skuPo.getCommodityTypeId());
                priceBO.setCommodityId(skuPo.getCommodityId());
                priceBO.setSupplierShopId(skuPo.getSupplierShopId());
                priceBO.setShopName(skuPo.getShopName());
            }
        }
        if (!CollectionUtils.isEmpty(failList)) {
            return null;
        }
        for (UccExcelImportAddPriceBO uccExcelImportAddPriceBO : addPriceBOList) {
            if (StringUtils.isEmpty((Object)uccExcelImportAddPriceBO.getAllowMarketPriceDes())) {
                uccExcelImportAddPriceBO.setFailDes("\u662f\u5426\u5141\u8bb8\u8d85\u8fc7\u5e02\u573a\u4ef7\u5fc5\u586b\uff01");
                failList.add(uccExcelImportAddPriceBO);
                continue;
            }
            if (!"\u662f".equals(uccExcelImportAddPriceBO.getAllowMarketPriceDes()) && !"\u5426".equals(uccExcelImportAddPriceBO.getAllowMarketPriceDes())) {
                uccExcelImportAddPriceBO.setFailDes("\u662f\u5426\u5141\u8bb8\u8d85\u8fc7\u5e02\u573a\u4ef7\u53ea\u80fd\u586b\u5199\u662f/\u5426");
                failList.add(uccExcelImportAddPriceBO);
                continue;
            }
            if (StringUtils.isEmpty((Object)uccExcelImportAddPriceBO.getEffectiveTimeDes())) {
                uccExcelImportAddPriceBO.setFailDes("\u751f\u6548\u65f6\u95f4\u5fc5\u586b\uff01");
                failList.add(uccExcelImportAddPriceBO);
                continue;
            }
            try {
                uccExcelImportAddPriceBO.setEffectiveTime(DateUtils.strToDateAsFormat((String)uccExcelImportAddPriceBO.getEffectiveTimeDes(), (String)"yyyy-MM-dd"));
            }
            catch (Exception e) {
                uccExcelImportAddPriceBO.setFailDes("\u751f\u6548\u65f6\u95f4\u5e74\u6708\u65e5\u671f\u683c\u5f0f\u4e0d\u7b26\u5408\u89c4\u8303\uff01");
                failList.add(uccExcelImportAddPriceBO);
                continue;
            }
            if (uccExcelImportAddPriceBO.getAddCoefficient().compareTo(new BigDecimal("0")) < 0) {
                uccExcelImportAddPriceBO.setFailDes("\u52a0\u4ef7\u7cfb\u6570\u4e0d\u80fd\u5c0f\u4e8e0");
                failList.add(uccExcelImportAddPriceBO);
                continue;
            }
            if (!ObjectUtils.isEmpty((Object)uccExcelImportAddPriceBO.getExpiresTimeDes())) {
                try {
                    uccExcelImportAddPriceBO.setExpiresTime(DateUtils.strToDateAsFormat((String)uccExcelImportAddPriceBO.getExpiresTimeDes(), (String)"yyyy-MM-dd"));
                }
                catch (Exception e) {
                    uccExcelImportAddPriceBO.setFailDes("\u5931\u6548\u65f6\u95f4\u5e74\u6708\u65e5\u671f\u683c\u5f0f\u4e0d\u7b26\u5408\u89c4\u8303\uff01");
                    failList.add(uccExcelImportAddPriceBO);
                    continue;
                }
                if (uccExcelImportAddPriceBO.getExpiresTime().compareTo(uccExcelImportAddPriceBO.getEffectiveTime()) < 0) {
                    uccExcelImportAddPriceBO.setFailDes("\u5931\u6548\u65f6\u95f4\u4e0d\u5f97\u65e9\u4e8e\u751f\u6548\u65f6\u95f4\uff01");
                    failList.add(uccExcelImportAddPriceBO);
                    continue;
                }
            }
            if ("\u662f".equals(uccExcelImportAddPriceBO.getAllowMarketPriceDes())) {
                uccExcelImportAddPriceBO.setAllowMarketPrice(Integer.valueOf(1));
                continue;
            }
            uccExcelImportAddPriceBO.setAllowMarketPrice(Integer.valueOf(0));
        }
        return null;
    }

    private List<UccExcelImportAddPriceBO> getSpuInfoFromExcel(String url) {
        ArrayList<UccExcelImportAddPriceBO> uccExcelImportAddPriceBOS;
        block11: {
            List<Object> data = new ArrayList();
            List<String> head = null;
            try {
                List<List<String>> excel = this.dealEcxel(url, 3, 0);
                head = excel.get(0);
                data = this.dealEcxel(url, 3, 0);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ZTBusinessException(e.getMessage());
            }
            int rowNum = 2;
            uccExcelImportAddPriceBOS = new ArrayList<UccExcelImportAddPriceBO>();
            try {
                if (!org.apache.commons.collections.CollectionUtils.isNotEmpty(data)) break block11;
                for (List list : data) {
                    String skuCode;
                    ++rowNum;
                    UccExcelImportAddPriceBO uccExcelImportAddPriceBO = new UccExcelImportAddPriceBO();
                    int i = 0;
                    if (StringUtils.isEmpty((Object)(skuCode = (String)list.get(i++)))) {
                        throw new BusinessException("8888", "\u5355\u54c1\u7f16\u7801\u5b58\u5728\u7a7a\u7684\u6570\u636e\u884c\uff01[" + i + "]");
                    }
                    uccExcelImportAddPriceBO.setSkuCode(UccSkuAddPriceImportAbilityServiceImpl.doubleToInteger(skuCode));
                    String skuName = (String)list.get(i++);
                    if (StringUtils.isEmpty((Object)skuName)) {
                        throw new BusinessException("8888", "\u5355\u54c1\u540d\u79f0\u5b58\u5728\u7a7a\u7684\u6570\u636e\u884c\uff01");
                    }
                    uccExcelImportAddPriceBO.setSkuName(skuName);
                    String addCoefficient = (String)list.get(i++);
                    if (StringUtils.isEmpty((Object)addCoefficient)) {
                        addCoefficient = "0";
                    }
                    uccExcelImportAddPriceBO.setAddCoefficient(new BigDecimal(addCoefficient));
                    String allowMarketPrice = (String)list.get(i++);
                    uccExcelImportAddPriceBO.setAllowMarketPriceDes(allowMarketPrice);
                    String effectiveTimeDes = (String)list.get(i++);
                    uccExcelImportAddPriceBO.setEffectiveTimeDes(effectiveTimeDes);
                    try {
                        String expiresTimeDes = (String)list.get(i++);
                        if (!StringUtils.isEmpty((Object)expiresTimeDes)) {
                            uccExcelImportAddPriceBO.setExpiresTimeDes(expiresTimeDes);
                        }
                    }
                    catch (IndexOutOfBoundsException e) {
                        uccExcelImportAddPriceBO.setExpiresTimeDes(null);
                    }
                    uccExcelImportAddPriceBOS.add(uccExcelImportAddPriceBO);
                }
            }
            catch (Exception e) {
                log.error(e.getMessage());
                e.printStackTrace();
                throw new ZTBusinessException("\u7b2c" + rowNum + "\u884c\u6570\u636e\u51fa\u73b0\u95ee\u9898,\u8bf7\u68c0\u67e5\u683c\u5f0f!");
            }
        }
        log.info("==============\u8bfb\u53d6\u7684\u5546\u54c1\u52a0\u4ef7\u4fe1\u606f===============");
        log.info(JSON.toJSONString(uccExcelImportAddPriceBOS));
        return uccExcelImportAddPriceBOS;
    }

    public static String doubleToInteger(String str) {
        if (StringUtils.isEmpty((Object)str)) {
            return "";
        }
        return new BigDecimal(str).stripTrailingZeros().toPlainString();
    }

    private List<List<String>> dealEcxel(String url, Integer startReadLine, Integer sheetAt) {
        if (StringUtils.isEmpty((Object)url)) {
            return new ArrayList<List<String>>();
        }
        ArrayList<List<String>> lines = new ArrayList<List<String>>();
        try {
            ExcelNewUtils.getExcelDate((String)url, lines, (Integer)startReadLine, (Integer)sheetAt);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            e.printStackTrace();
            throw new ZTBusinessException("\u5904\u7406Excel\u5931\u8d25");
        }
        log.info("\u8bfb\u53d6\u5230\u7684\u6570\u636e\uff1a" + JSONObject.toJSONString(lines));
        if (org.apache.commons.collections.CollectionUtils.isEmpty(lines)) {
            throw new BusinessException("8888", "\u6a21\u677f\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        return lines;
    }
}

