/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.ability.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.dao.UccAddCoefficientMapper;
import com.tydic.commodity.dao.UccCommodityTypeMapper;
import com.tydic.commodity.estore.ability.api.UccCommdTypeAddCoefficientQryAbilityService;
import com.tydic.commodity.estore.ability.bo.UccCommdTypeAddCoefficientQryReqBO;
import com.tydic.commodity.estore.ability.bo.UccCommdTypeAddCoefficientQryRspBO;
import com.tydic.commodity.estore.busi.api.UccCommdTypeAddCoefficientQryBusiService;
import com.tydic.commodity.po.UccAddCoefficientPO;
import com.tydic.commodity.po.UccCommodityTypePo;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.estore.ability.api.UccCommdTypeAddCoefficientQryAbilityService"})
public class UccCommdTypeAddCoefficientQryAbilityServiceImpl
implements UccCommdTypeAddCoefficientQryAbilityService {
    @Autowired
    private UccCommdTypeAddCoefficientQryBusiService uccCommdTypeAddCoefficientLogQryBusiService;
    @Autowired
    private UccAddCoefficientMapper uccAddCoefficientMapper;
    @Autowired
    private UccCommodityTypeMapper uccCommodityTypeMapper;

    @PostMapping(value={"commdTypeAddCoefficient"})
    public UccCommdTypeAddCoefficientQryRspBO commdTypeAddCoefficient(@RequestBody UccCommdTypeAddCoefficientQryReqBO reqBO) {
        this.validate(reqBO);
        this.validateV(reqBO);
        return this.uccCommdTypeAddCoefficientLogQryBusiService.commdTypeAddCoefficient(reqBO);
    }

    private void validateV(UccCommdTypeAddCoefficientQryReqBO reqBO) {
        UccCommodityTypePo commodityTypePo = this.uccCommodityTypeMapper.queryPoByCommodityTypeId(reqBO.getCatalogId());
        if (ObjectUtils.isEmpty((Object)commodityTypePo)) {
            throw new BusinessException("8888", "\u5546\u54c1\u7c7b\u578b\u4e0d\u5408\u6cd5!");
        }
        UccAddCoefficientPO checkPo = new UccAddCoefficientPO();
        checkPo.setCatalogId(reqBO.getCatalogId());
        checkPo.setSupplierId(reqBO.getSupplierId());
        checkPo.setSupplierShopId(reqBO.getSupplierShopId());
        Page page = new Page(1, 10);
        List uccAddCoefficientPOS = this.uccAddCoefficientMapper.qryAddCoefficient(checkPo, page);
        if (!CollectionUtils.isEmpty((Collection)uccAddCoefficientPOS)) {
            throw new BusinessException("8888", "\u5546\u54c1\u7c7b\u578b-\u7535\u5546\u5df2\u7ecf\u5b58\u5728\u914d\u7f6e\u4fe1\u606f!");
        }
    }

    private void validate(UccCommdTypeAddCoefficientQryReqBO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO.getSupplierId())) {
            throw new BusinessException("8888", "\u53c2\u6570 supplierId \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getAddCoefficient())) {
            throw new BusinessException("8888", "\u53c2\u6570 addCoefficient \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getCatalogId())) {
            throw new BusinessException("8888", "\u53c2\u6570 catalogId \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getAllowMarketPrice())) {
            throw new BusinessException("8888", "\u53c2\u6570 allowMarketPrice \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getSupplierId())) {
            throw new BusinessException("8888", "\u53c2\u6570 supplierId \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getSupplierName())) {
            throw new BusinessException("8888", "\u53c2\u6570 supplierName \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getSupplierShopId())) {
            throw new BusinessException("8888", "\u53c2\u6570 supplierShopId \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getUserId())) {
            throw new BusinessException("8888", "\u53c2\u6570 userId \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getUsername())) {
            throw new BusinessException("8888", "\u53c2\u6570 username \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

