/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.dao.UccPriceChangeRecordMapper;
import com.tydic.commodity.dao.UccSkuAddCoefficientMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.estore.ability.bo.UccEfficientPriceChangeTaskAbilityReqBO;
import com.tydic.commodity.estore.ability.bo.UccEfficientPriceChangeTaskAbilityRspBO;
import com.tydic.commodity.estore.ability.bo.UccSkuAddCoefficientBO;
import com.tydic.commodity.estore.busi.api.UccEfficientPriceChangeTaskBusiService;
import com.tydic.commodity.po.UccPriceChangeRecordPO;
import com.tydic.commodity.po.UccSkuAddCoefficientPO;
import com.tydic.commodity.utils.DateUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccEfficientPriceChangeTaskBusiServiceImpl
implements UccEfficientPriceChangeTaskBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccEfficientPriceChangeTaskBusiServiceImpl.class);
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;
    @Autowired
    private UccSkuAddCoefficientMapper uccSkuAddCoefficientMapper;
    @Autowired
    private UccPriceChangeRecordMapper uccPriceChangeRecordMapper;

    @Override
    public UccEfficientPriceChangeTaskAbilityRspBO efficientPriceChangeTask(UccEfficientPriceChangeTaskAbilityReqBO reqBO) {
        ArrayList lists = new ArrayList();
        List<UccSkuAddCoefficientPO> expires = this.dealUpdateStatusExpires();
        List<UccSkuAddCoefficientPO> effcients = this.dealUpdateStatusEffcient();
        if (!CollectionUtils.isEmpty(expires)) {
            List expiresBOs = expires.stream().map(e -> (UccSkuAddCoefficientBO)JSONObject.parseObject((String)JSON.toJSONString((Object)e), UccSkuAddCoefficientBO.class)).collect(Collectors.toList());
            lists.addAll(expiresBOs);
        }
        if (!CollectionUtils.isEmpty(effcients)) {
            List effcientsBOs = effcients.stream().map(e -> (UccSkuAddCoefficientBO)JSONObject.parseObject((String)JSON.toJSONString((Object)e), UccSkuAddCoefficientBO.class)).collect(Collectors.toList());
            lists.addAll(effcientsBOs);
        }
        if (!CollectionUtils.isEmpty(lists)) {
            List uccPriceChangeRecordPOS = lists.stream().map(e -> {
                UccPriceChangeRecordPO uccPriceChangeRecordPO = new UccPriceChangeRecordPO();
                uccPriceChangeRecordPO.setRecordId(Long.valueOf(Sequence.getInstance().nextId()));
                uccPriceChangeRecordPO.setSkuId(e.getSkuId());
                uccPriceChangeRecordPO.setSupplierShopId(e.getSupplierShopId());
                uccPriceChangeRecordPO.setCatalogId(e.getCatalogId());
                uccPriceChangeRecordPO.setStatus(Integer.valueOf(1));
                return uccPriceChangeRecordPO;
            }).collect(Collectors.toList());
            this.uccPriceChangeRecordMapper.insertBatch(uccPriceChangeRecordPOS);
        }
        UccEfficientPriceChangeTaskAbilityRspBO rspBO = new UccEfficientPriceChangeTaskAbilityRspBO();
        rspBO.setRespCode("0000");
        return rspBO;
    }

    private List<UccSkuAddCoefficientPO> dealUpdateStatusEffcient() {
        Date beforeDateStartTime = DateUtils.getCurrentDateStartTime((Date)new Date());
        UccSkuAddCoefficientPO select = new UccSkuAddCoefficientPO();
        select.setEffectiveTimeEnd(beforeDateStartTime);
        select.setEffectiveStatus(UccConstants.SKU_ADD_COEFFICIENT_WAIT_EFFECTIVE);
        List coefficientPOList = this.uccSkuAddCoefficientMapper.getEffcient(select);
        log.info("=============\u751f\u6548\u7684\u52a0\u4ef7\u914d\u7f6e======================");
        log.info(JSON.toJSONString((Object)coefficientPOList));
        log.info("=============\u751f\u6548\u7684\u52a0\u4ef7\u914d\u7f6e======================");
        if (!CollectionUtils.isEmpty((Collection)coefficientPOList)) {
            try {
                List skuIds = coefficientPOList.stream().map(UccSkuAddCoefficientPO::getSkuId).collect(Collectors.toList());
                this.uccSkuAddCoefficientMapper.updateStatusBySkuId(skuIds, UccConstants.SKU_ADD_COEFFICIENT_EFFECTIVE);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BusinessException("8888", "\u66f4\u65b0\u4e3a\u5931\u6548\u72b6\u6001\u5931\u8d25\uff01");
            }
        }
        return coefficientPOList;
    }

    private List<UccSkuAddCoefficientPO> dealUpdateStatusExpires() {
        Date beforeDateStartTime = DateUtils.getCurrentDateStartTime((Date)new Date());
        UccSkuAddCoefficientPO select = new UccSkuAddCoefficientPO();
        select.setExpiresTimeEnd(beforeDateStartTime);
        select.setEffectiveStatus(UccConstants.SKU_ADD_COEFFICIENT_EFFECTIVE);
        select.setExpiresFlag(Integer.valueOf(1));
        List coefficientPOList = this.uccSkuAddCoefficientMapper.getEffcient(select);
        log.info("=============\u5df2\u5931\u6548\u7684\u52a0\u4ef7\u914d\u7f6e======================");
        log.info(JSON.toJSONString((Object)coefficientPOList));
        log.info("=============\u5df2\u5931\u6548\u7684\u52a0\u4ef7\u914d\u7f6e======================");
        List<Object> skuIds = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)coefficientPOList)) {
            try {
                skuIds = coefficientPOList.stream().map(UccSkuAddCoefficientPO::getSkuId).collect(Collectors.toList());
                this.uccSkuAddCoefficientMapper.updateStatusBySkuId(skuIds, UccConstants.SKU_ADD_COEFFICIENT_EXPIRES);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BusinessException("8888", "\u66f4\u65b0\u4e3a\u5931\u6548\u72b6\u6001\u5931\u8d25\uff01");
            }
        }
        return coefficientPOList;
    }
}

