/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.RspUccBo;
import com.tydic.commodity.base.bo.SelfRunSyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.dao.UccPriceChangeRecordMapper;
import com.tydic.commodity.estore.ability.api.UccPriceUpdateTaskAbilityService;
import com.tydic.commodity.estore.ability.bo.UccSkuAddCoefficientBO;
import com.tydic.commodity.estore.busi.api.UccEfficientPriceUpdateBusiService;
import com.tydic.commodity.estore.busi.bo.UccEfficientPriceUpdateBusiReqBO;
import com.tydic.commodity.estore.busi.bo.UccEfficientPriceUpdateBusiRspBO;
import com.tydic.commodity.po.UccPriceChangeRecordPO;
import com.tydic.commodity.utils.PropertiesUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.estore.ability.api.UccPriceUpdateTaskAbilityService"})
public class UccPriceUpdateTaskAbilityServiceImpl
implements UccPriceUpdateTaskAbilityService {
    @Autowired
    private UccPriceChangeRecordMapper uccPriceChangeRecordMapper;
    @Autowired
    private UccEfficientPriceUpdateBusiService uccEfficientPriceUpdateBusiService;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;

    @PostMapping(value={"updateTaskPrice"})
    public RspUccBo updateTaskPrice() {
        Page page = new Page(1, 1000);
        UccPriceChangeRecordPO select = new UccPriceChangeRecordPO();
        select.setStatus(Integer.valueOf(1));
        List listPage = this.uccPriceChangeRecordMapper.getListPage(select, page);
        if (!CollectionUtils.isEmpty((Collection)listPage)) {
            List recordIds = listPage.stream().map(UccPriceChangeRecordPO::getRecordId).collect(Collectors.toList());
            this.uccPriceChangeRecordMapper.updateBatchStatus(recordIds, Integer.valueOf(2));
            UccEfficientPriceUpdateBusiReqBO updateBusiReqBO = new UccEfficientPriceUpdateBusiReqBO();
            List<UccSkuAddCoefficientBO> uccSkuAddCoefficientBOS = listPage.stream().map(e -> {
                UccSkuAddCoefficientBO coefficientBO = new UccSkuAddCoefficientBO();
                coefficientBO.setSkuId(e.getSkuId());
                coefficientBO.setCatalogId(e.getCatalogId());
                coefficientBO.setSupplierShopId(e.getSupplierShopId());
                return coefficientBO;
            }).collect(Collectors.toList());
            updateBusiReqBO.setAddCoefficientBOS(uccSkuAddCoefficientBOS);
            UccEfficientPriceUpdateBusiRspBO rspBO = this.uccEfficientPriceUpdateBusiService.dealPriceUpdate(updateBusiReqBO);
            if ("0000".equals(rspBO.getRespCode())) {
                this.uccPriceChangeRecordMapper.deleteByIds(recordIds);
                Map syncSkus = listPage.stream().collect(Collectors.groupingBy(UccPriceChangeRecordPO::getSupplierShopId, Collectors.mapping(UccPriceChangeRecordPO::getSkuId, Collectors.toList())));
                for (Long shopId : syncSkus.keySet()) {
                    SelfRunSyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SelfRunSyncSceneCommodityToEsReqBO();
                    syncSceneCommodityToEsReqBO.setSkuIds(syncSkus.get(shopId));
                    syncSceneCommodityToEsReqBO.setSupplierId(shopId);
                    syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_UPDATE_TYPE);
                    syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
                    syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_PRICE.intValue());
                    this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
                }
            }
        }
        RspUccBo rspUccBo = new RspUccBo();
        rspUccBo.setRespDesc("\u6210\u529f");
        rspUccBo.setRespCode("0000");
        return rspUccBo;
    }
}

