/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.busi.impl;

import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.dao.UccAddCoefficientMapper;
import com.tydic.commodity.dao.UccParamsConfigDetailMapper;
import com.tydic.commodity.dao.UccParamsConfigMapper;
import com.tydic.commodity.dao.UccSkuAddCoefficientMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.estore.ability.bo.UccCoefficentBO;
import com.tydic.commodity.estore.ability.bo.UccSkuAddCoefficientBO;
import com.tydic.commodity.estore.busi.api.UccEfficientPriceUpdateBusiService;
import com.tydic.commodity.estore.busi.bo.UccEfficientPriceUpdateBusiReqBO;
import com.tydic.commodity.estore.busi.bo.UccEfficientPriceUpdateBusiRspBO;
import com.tydic.commodity.po.UccAddCoefficientPO;
import com.tydic.commodity.po.UccParamsConfigDetailPO;
import com.tydic.commodity.po.UccParamsConfigPO;
import com.tydic.commodity.po.UccSkuAddCoefficientPO;
import com.tydic.commodity.po.UccSkuPricePo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class UccEfficientPriceUpdateBusiServiceImpl
implements UccEfficientPriceUpdateBusiService {
    @Autowired
    private UccSkuAddCoefficientMapper uccSkuAddCoefficientMapper;
    @Autowired
    private UccAddCoefficientMapper uccAddCoefficientMapper;
    @Autowired
    private UccParamsConfigMapper uccParamsConfigMapper;
    @Autowired
    private UccParamsConfigDetailMapper uccParamsConfigDetailMapper;
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;

    @Override
    public UccEfficientPriceUpdateBusiRspBO dealPriceUpdate(UccEfficientPriceUpdateBusiReqBO reqBO) {
        ArrayList<UccSkuPricePo> pricePos = new ArrayList<UccSkuPricePo>();
        for (UccSkuAddCoefficientBO coefficientBO : reqBO.getAddCoefficientBOS()) {
            UccCoefficentBO uccCoefficentBO = this.getCoefficent(coefficientBO);
            BigDecimal addCoefficient = uccCoefficentBO.getAddCoefficient();
            Integer allowMarketPrice = uccCoefficentBO.getAllowMarketPrice();
            UccSkuPricePo pricePo = this.uccSkuPriceMapper.getCoefficientPriceBySkuId(coefficientBO.getSkuId(), addCoefficient.add(new BigDecimal("1")));
            pricePo.setSalePrice(pricePo.getNewSalePrice());
            if (allowMarketPrice == 0 && pricePo.getNewSalePrice().compareTo(pricePo.getMarketPrice()) > 0) {
                pricePo.setSalePrice(pricePo.getMarketPrice());
            }
            pricePos.add(pricePo);
        }
        try {
            this.uccSkuPriceMapper.updateBatch(pricePos, reqBO.getAddCoefficientBOS().stream().map(UccSkuAddCoefficientBO::getSkuId).collect(Collectors.toList()));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("8888", "\u6279\u91cf\u66f4\u65b0\u4ef7\u683c\u5f02\u5e38\uff01");
        }
        UccEfficientPriceUpdateBusiRspBO rspBO = new UccEfficientPriceUpdateBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private UccCoefficentBO getCoefficent(UccSkuAddCoefficientBO coefficientBO) {
        UccCoefficentBO bo = new UccCoefficentBO();
        BigDecimal addCoefficient = new BigDecimal(0);
        Integer allowMarketPrice = 0;
        UccSkuAddCoefficientPO uccSkuAddCoefficientPO = this.uccSkuAddCoefficientMapper.selectBySkuIdEfficient(coefficientBO.getSkuId());
        if (uccSkuAddCoefficientPO != null) {
            if (uccSkuAddCoefficientPO.getAddCoefficient() != null) {
                addCoefficient = uccSkuAddCoefficientPO.getAddCoefficient();
                addCoefficient = addCoefficient.divide(new BigDecimal(100), 8, 5);
            }
            if (uccSkuAddCoefficientPO.getAllowMarketPrice() != null) {
                allowMarketPrice = uccSkuAddCoefficientPO.getAllowMarketPrice();
            }
        } else {
            UccAddCoefficientPO uccAddCoefficientPO = this.uccAddCoefficientMapper.qryCoefficientByCatalogIdAndSupplierShopId(coefficientBO.getCatalogId(), coefficientBO.getSupplierShopId());
            if (uccAddCoefficientPO != null) {
                if (uccAddCoefficientPO.getAddCoefficient() != null) {
                    addCoefficient = uccAddCoefficientPO.getAddCoefficient();
                    addCoefficient = addCoefficient.divide(new BigDecimal(100), 8, 5);
                }
                if (uccAddCoefficientPO.getAllowMarketPrice() != null) {
                    allowMarketPrice = uccAddCoefficientPO.getAllowMarketPrice();
                }
            } else {
                UccParamsConfigPO uccMallParamsConfigPO = new UccParamsConfigPO();
                uccMallParamsConfigPO.setParamsCode("ESTORE_DEFAULT_COEFFICIENT");
                UccParamsConfigPO modelBy = this.uccParamsConfigMapper.getModelBy(uccMallParamsConfigPO);
                if (modelBy != null) {
                    UccParamsConfigDetailPO uccMallParamsConfigDetailPO = new UccParamsConfigDetailPO();
                    uccMallParamsConfigDetailPO.setParamsId(modelBy.getParamsId());
                    uccMallParamsConfigDetailPO.setBusinessType(coefficientBO.getSupplierShopId().toString());
                    UccParamsConfigDetailPO detailPO = this.uccParamsConfigDetailMapper.getModelBy(uccMallParamsConfigDetailPO);
                    if (ObjectUtils.isEmpty((Object)detailPO)) {
                        uccMallParamsConfigDetailPO.setBusinessType(null);
                        uccMallParamsConfigDetailPO.setProperty("\u7cfb\u7edf");
                        detailPO = this.uccParamsConfigDetailMapper.getModelBy(uccMallParamsConfigDetailPO);
                    }
                    if (detailPO != null) {
                        if (!StringUtils.isEmpty((Object)detailPO.getRule())) {
                            addCoefficient = new BigDecimal(detailPO.getRule());
                            addCoefficient = addCoefficient.divide(new BigDecimal(100), 8, 5);
                        }
                        allowMarketPrice = 0;
                    }
                }
            }
        }
        bo.setAddCoefficient(addCoefficient);
        bo.setAllowMarketPrice(allowMarketPrice);
        return bo;
    }
}

