/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.busi.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.dao.UccSkuAddCoefficientLogMapper;
import com.tydic.commodity.dao.UccSkuAddCoefficientMapper;
import com.tydic.commodity.estore.ability.bo.UccExcelImportAddPriceBO;
import com.tydic.commodity.estore.ability.bo.UccSkuAddPriceImportAbilityRspBO;
import com.tydic.commodity.estore.busi.api.UccSkuAddPriceImportBusiService;
import com.tydic.commodity.estore.busi.bo.UccSkuAddPriceImportBusiReqBO;
import com.tydic.commodity.po.UccSkuAddCoefficientLogPO;
import com.tydic.commodity.po.UccSkuAddCoefficientPO;
import com.tydic.commodity.utils.DateUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class UccSkuAddPriceImportBusiServiceImpl
implements UccSkuAddPriceImportBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccSkuAddPriceImportBusiServiceImpl.class);
    @Autowired
    private UccSkuAddCoefficientMapper uccSkuAddCoefficientMapper;
    @Autowired
    private UccSkuAddCoefficientLogMapper uccSkuAddCoefficientLogMapper;
    private static final Sequence sequence = Sequence.getInstance();

    @Override
    public UccSkuAddPriceImportAbilityRspBO dealSkuPriceAddImport(UccSkuAddPriceImportBusiReqBO reqBO) {
        List skuIds = reqBO.getList().stream().map(UccExcelImportAddPriceBO::getSkuId).collect(Collectors.toList());
        List uccSkuAddCoefficientPOS = this.uccSkuAddCoefficientMapper.selectBySkuIds(skuIds);
        if (CollectionUtils.isEmpty((Collection)uccSkuAddCoefficientPOS)) {
            this.dealAddCoefficient(reqBO);
        } else {
            ArrayList<UccExcelImportAddPriceBO> exists = new ArrayList<UccExcelImportAddPriceBO>();
            ArrayList<UccExcelImportAddPriceBO> notExists = new ArrayList<UccExcelImportAddPriceBO>();
            List existSkus = uccSkuAddCoefficientPOS.stream().map(UccSkuAddCoefficientPO::getSkuId).collect(Collectors.toList());
            for (UccExcelImportAddPriceBO addPriceBO : reqBO.getList()) {
                if (existSkus.contains(addPriceBO.getSkuId())) {
                    exists.add(addPriceBO);
                    continue;
                }
                notExists.add(addPriceBO);
            }
            if (!CollectionUtils.isEmpty(exists)) {
                this.dealUpdateCoefficient(exists, reqBO);
            }
            if (!CollectionUtils.isEmpty(notExists)) {
                reqBO.setList(notExists);
                this.dealAddCoefficient(reqBO);
            }
        }
        UccSkuAddPriceImportAbilityRspBO rspBO = new UccSkuAddPriceImportAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void dealUpdateCoefficient(ArrayList<UccExcelImportAddPriceBO> exists, UccSkuAddPriceImportBusiReqBO reqBO) {
        Date time = new Date();
        try {
            List skuIds = exists.stream().map(UccExcelImportAddPriceBO::getSkuId).collect(Collectors.toList());
            List uccSkuAddCoefficientPOS = this.uccSkuAddCoefficientMapper.selectBySkuIds(skuIds);
            this.uccSkuAddCoefficientLogMapper.batchUpdateTime(skuIds);
            List<UccSkuAddCoefficientPO> updateListBO = this.createUpdateListBO(exists, reqBO);
            List<UccSkuAddCoefficientLogPO> batchInsertLogBO = this.createBatchInsertLogBO(updateListBO, reqBO, uccSkuAddCoefficientPOS, time);
            this.uccSkuAddCoefficientLogMapper.batchInsert(batchInsertLogBO);
            for (UccSkuAddCoefficientPO uccSkuAddCoefficientPO : updateListBO) {
                Date beforeDateStartTime = DateUtils.getCurrentDateStartTime((Date)uccSkuAddCoefficientPO.getEffectiveTime());
                if (new Date().compareTo(beforeDateStartTime) >= 0) {
                    uccSkuAddCoefficientPO.setEffectiveStatus(UccConstants.SKU_ADD_COEFFICIENT_EFFECTIVE);
                    continue;
                }
                uccSkuAddCoefficientPO.setEffectiveStatus(UccConstants.SKU_ADD_COEFFICIENT_WAIT_EFFECTIVE);
            }
            this.uccSkuAddCoefficientMapper.batchUpdateAddPrice(updateListBO);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("8888", "\u6279\u91cf\u66f4\u65b0\u52a0\u4ef7\u4fe1\u606f\u5931\u8d25\uff01\u8bf7\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458\uff01");
        }
    }

    private List<UccSkuAddCoefficientPO> createUpdateListBO(List<UccExcelImportAddPriceBO> addPriceInfoList, UccSkuAddPriceImportBusiReqBO reqBO) {
        ArrayList<UccSkuAddCoefficientPO> list = new ArrayList<UccSkuAddCoefficientPO>();
        for (UccExcelImportAddPriceBO uccAddPriceInfoBO : addPriceInfoList) {
            UccSkuAddCoefficientPO uccSkuAddCoefficientPO = new UccSkuAddCoefficientPO();
            uccSkuAddCoefficientPO.setSkuId(uccAddPriceInfoBO.getSkuId());
            uccSkuAddCoefficientPO.setAddCoefficient(uccAddPriceInfoBO.getAddCoefficient());
            uccSkuAddCoefficientPO.setAllowMarketPrice(uccAddPriceInfoBO.getAllowMarketPrice());
            uccSkuAddCoefficientPO.setExpiresTime(uccAddPriceInfoBO.getExpiresTime());
            uccSkuAddCoefficientPO.setEffectiveTime(uccAddPriceInfoBO.getEffectiveTime());
            uccSkuAddCoefficientPO.setUpdateTime(new Date());
            uccSkuAddCoefficientPO.setUpdateOperId(reqBO.getName());
            uccSkuAddCoefficientPO.setSupplierShopId(uccAddPriceInfoBO.getSupplierShopId());
            uccSkuAddCoefficientPO.setShopName(uccAddPriceInfoBO.getShopName());
            list.add(uccSkuAddCoefficientPO);
        }
        return list;
    }

    private List<UccSkuAddCoefficientLogPO> createBatchInsertLogBO(List<UccSkuAddCoefficientPO> uccSkuAddCoefficientPOS, UccSkuAddPriceImportBusiReqBO reqBO, List<UccSkuAddCoefficientPO> beforeData, Date time) {
        ArrayList<UccSkuAddCoefficientLogPO> list = new ArrayList<UccSkuAddCoefficientLogPO>();
        for (UccSkuAddCoefficientPO uccSkuAddCoefficientPO : uccSkuAddCoefficientPOS) {
            UccSkuAddCoefficientLogPO uccSkuAddCoefficientLogPO = new UccSkuAddCoefficientLogPO();
            BeanUtils.copyProperties((Object)uccSkuAddCoefficientPO, (Object)uccSkuAddCoefficientLogPO);
            uccSkuAddCoefficientLogPO.setId(Long.valueOf(sequence.nextId()));
            uccSkuAddCoefficientLogPO.setCreateOperId(reqBO.getUsername());
            uccSkuAddCoefficientLogPO.setAccountNumber(reqBO.getUsername());
            uccSkuAddCoefficientLogPO.setUpdateOperId(reqBO.getName());
            uccSkuAddCoefficientLogPO.setUpdateTime(time);
            uccSkuAddCoefficientLogPO.setCreateTime(time);
            uccSkuAddCoefficientLogPO.setShopName(uccSkuAddCoefficientPO.getShopName());
            uccSkuAddCoefficientLogPO.setSupplierShopId(uccSkuAddCoefficientPO.getSupplierShopId());
            list.add(uccSkuAddCoefficientLogPO);
        }
        return list;
    }

    private void dealAddCoefficient(UccSkuAddPriceImportBusiReqBO reqBO) {
        ArrayList uccSkuAddCoefficientPOS = new ArrayList();
        reqBO.getList().forEach(skuPriceInfo -> {
            UccSkuAddCoefficientPO uccSkuAddCoefficientPO = new UccSkuAddCoefficientPO();
            BeanUtils.copyProperties((Object)skuPriceInfo, (Object)uccSkuAddCoefficientPO);
            uccSkuAddCoefficientPO.setUpdateOperId(reqBO.getName());
            uccSkuAddCoefficientPO.setUpdateTime(new Date());
            uccSkuAddCoefficientPO.setAddCoefficient(skuPriceInfo.getAddCoefficient());
            uccSkuAddCoefficientPO.setCatalogId(skuPriceInfo.getCommodityTypeId());
            uccSkuAddCoefficientPO.setEffectiveTime(skuPriceInfo.getEffectiveTime());
            uccSkuAddCoefficientPO.setExpiresTime(skuPriceInfo.getExpiresTime());
            uccSkuAddCoefficientPO.setSkuId(skuPriceInfo.getSkuId());
            uccSkuAddCoefficientPO.setCommodityId(skuPriceInfo.getCommodityId());
            uccSkuAddCoefficientPO.setShopName(skuPriceInfo.getShopName());
            uccSkuAddCoefficientPO.setVendorId(skuPriceInfo.getSupplierShopId());
            uccSkuAddCoefficientPO.setVendorName(skuPriceInfo.getShopName());
            uccSkuAddCoefficientPO.setExtSkuId(skuPriceInfo.getExtSkuId());
            uccSkuAddCoefficientPO.setExtSpuId(skuPriceInfo.getExtSpuId());
            uccSkuAddCoefficientPO.setCommodityId(skuPriceInfo.getCommodityId());
            Date beforeDateStartTime = DateUtils.getCurrentDateStartTime((Date)skuPriceInfo.getEffectiveTime());
            if (new Date().compareTo(beforeDateStartTime) >= 0) {
                uccSkuAddCoefficientPO.setEffectiveStatus(UccConstants.SKU_ADD_COEFFICIENT_EFFECTIVE);
            } else {
                uccSkuAddCoefficientPO.setEffectiveStatus(UccConstants.SKU_ADD_COEFFICIENT_WAIT_EFFECTIVE);
            }
            uccSkuAddCoefficientPOS.add(uccSkuAddCoefficientPO);
        });
        try {
            this.uccSkuAddCoefficientMapper.batchInsert(uccSkuAddCoefficientPOS);
        }
        catch (Exception e) {
            log.error("\u65b0\u589e\u5931\u8d25\uff1a" + e);
            e.printStackTrace();
            throw new ZTBusinessException("\u5355\u54c1\u6279\u91cf\u52a0\u4ef7\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u8fd0\u8425\u4eba\u5458\uff01");
        }
        ArrayList<UccSkuAddCoefficientLogPO> uccSkuAddCoefficientLogPOS = new ArrayList<UccSkuAddCoefficientLogPO>();
        for (UccSkuAddCoefficientPO uccSkuAddCoefficientPO : uccSkuAddCoefficientPOS) {
            UccSkuAddCoefficientLogPO uccSkuAddCoefficientLogPO = new UccSkuAddCoefficientLogPO();
            BeanUtils.copyProperties((Object)uccSkuAddCoefficientPO, (Object)uccSkuAddCoefficientLogPO);
            uccSkuAddCoefficientLogPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            uccSkuAddCoefficientLogPO.setSkuPriceId(uccSkuAddCoefficientPO.getSkuId());
            uccSkuAddCoefficientLogPO.setCreateTime(new Date());
            uccSkuAddCoefficientLogPO.setEffectiveTime(uccSkuAddCoefficientPO.getEffectiveTime());
            uccSkuAddCoefficientLogPO.setExpiresTime(uccSkuAddCoefficientPO.getExpiresTime());
            if (!ObjectUtils.isEmpty((Object)reqBO.getUsername())) {
                uccSkuAddCoefficientLogPO.setAccountNumber(reqBO.getUsername());
            }
            uccSkuAddCoefficientLogPO.setUpdateOperId(reqBO.getName());
            uccSkuAddCoefficientLogPO.setSupplierShopId(uccSkuAddCoefficientPO.getSupplierShopId());
            uccSkuAddCoefficientLogPO.setShopName(uccSkuAddCoefficientPO.getShopName());
            uccSkuAddCoefficientLogPOS.add(uccSkuAddCoefficientLogPO);
        }
        try {
            this.uccSkuAddCoefficientLogMapper.batchInsert(uccSkuAddCoefficientLogPOS);
        }
        catch (Exception e) {
            log.error("\u65b0\u589e\u65e5\u5fd7\u5931\u8d25\uff1a" + e);
            e.printStackTrace();
            throw new ZTBusinessException("\u5355\u54c1\u6279\u91cf\u52a0\u4ef7\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u8fd0\u8425\u4eba\u5458\uff01\uff01\uff1a");
        }
    }
}

