/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.busi.impl;

import com.tydic.commodity.dao.UccSkuAddCoefficientMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.estore.busi.api.UccSkuPriceUpdateBusiService;
import com.tydic.commodity.estore.busi.bo.UccSkuPriceUpdateBusiReqBO;
import com.tydic.commodity.estore.busi.bo.UccSkuPriceUpdateBusiRspBO;
import com.tydic.commodity.po.UccSkuAddCoefficientPO;
import com.tydic.commodity.po.UccSkuPricePo;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccSkuPriceUpdateBusiServiceImpl
implements UccSkuPriceUpdateBusiService {
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;
    @Autowired
    private UccSkuAddCoefficientMapper uccSkuAddCoefficientMapper;

    @Override
    public UccSkuPriceUpdateBusiRspBO dealPriceUpdate(UccSkuPriceUpdateBusiReqBO reqBO) {
        UccSkuPriceUpdateBusiRspBO rspBO = new UccSkuPriceUpdateBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        List uccSkuAddCoefficientPOS = this.uccSkuAddCoefficientMapper.selectEffectiveBySkuIds(reqBO.getSkuIds());
        if (!CollectionUtils.isEmpty((Collection)uccSkuAddCoefficientPOS)) {
            Map<Long, BigDecimal> addCoefficients = uccSkuAddCoefficientPOS.stream().collect(Collectors.toMap(UccSkuAddCoefficientPO::getSkuId, UccSkuAddCoefficientPO::getAddCoefficient));
            List skuIds = uccSkuAddCoefficientPOS.stream().map(UccSkuAddCoefficientPO::getSkuId).collect(Collectors.toList());
            List prices = this.uccSkuPriceMapper.getPricesBySkuIds(skuIds);
            for (UccSkuPricePo price : prices) {
                BigDecimal addCoefficient = addCoefficients.get(price.getSkuId());
                addCoefficient = addCoefficient.divide(new BigDecimal(100), 8, 5);
                BigDecimal salePrice = this.uccSkuPriceMapper.getPrice(addCoefficient.add(new BigDecimal("1")), new BigDecimal(price.getAgreementPrice()));
                price.setSalePrice(Long.valueOf(salePrice.longValue()));
            }
            this.uccSkuPriceMapper.updateBatch(prices, skuIds);
            Map<Long, List<Long>> syncSkus = prices.stream().collect(Collectors.groupingBy(UccSkuPricePo::getSupplierShopId, Collectors.mapping(UccSkuPricePo::getSkuId, Collectors.toList())));
            rspBO.setSyncSku(syncSkus);
            return rspBO;
        }
        return rspBO;
    }
}

