/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.ability.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.dao.UccCommodityTypeMapper;
import com.tydic.commodity.dao.UccEMdmCatalogMapper;
import com.tydic.commodity.dao.UccSkuAddCoefficientMapper;
import com.tydic.commodity.estore.ability.api.UccSkuAddPriceListQueryService;
import com.tydic.commodity.estore.ability.bo.UccSkuAddPriceListQueryInfoBO;
import com.tydic.commodity.estore.ability.bo.UccSkuAddPriceListQueryReqBO;
import com.tydic.commodity.estore.ability.bo.UccSkuAddPriceListQueryRspBO;
import com.tydic.commodity.po.CnncUccSkuAddPricePO;
import com.tydic.commodity.po.UccCommodityTypePo;
import com.tydic.commodity.po.UccEMdmCatalogPO;
import com.tydic.commodity.utils.MoneyUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.estore.ability.api.UccSkuAddPriceListQueryService"})
public class UccSkuAddPriceListQueryServiceImpl
implements UccSkuAddPriceListQueryService {
    @Autowired
    private UccSkuAddCoefficientMapper uccSkuAddCoefficientMapper;
    @Autowired
    private UccEMdmCatalogMapper cnncUccEMdmCatalogMapper;
    @Autowired
    private UccCommodityTypeMapper uccCommodityTypeMapper;

    @PostMapping(value={"querySkuAddPriceList"})
    public UccSkuAddPriceListQueryRspBO querySkuAddPriceList(@RequestBody UccSkuAddPriceListQueryReqBO reqBO) {
        UccSkuAddPriceListQueryRspBO rspBO = new UccSkuAddPriceListQueryRspBO();
        if (reqBO == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5165\u53c2\u4e3a\u7a7a");
            return rspBO;
        }
        if (StringUtils.isEmpty((Object)reqBO.getExtSkuId())) {
            reqBO.setExtSkuId(null);
        }
        if (StringUtils.isEmpty((Object)reqBO.getSkuName())) {
            reqBO.setSkuName(null);
        }
        CnncUccSkuAddPricePO cnncUccSkuAddPricePO = new CnncUccSkuAddPricePO();
        BeanUtils.copyProperties((Object)reqBO, (Object)cnncUccSkuAddPricePO);
        cnncUccSkuAddPricePO.setSupplierShopId(reqBO.getSupplierId());
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        List cnncUccSkuAddPricePOS = this.uccSkuAddCoefficientMapper.queryPage(cnncUccSkuAddPricePO, page);
        if (!CollectionUtils.isEmpty((Collection)cnncUccSkuAddPricePOS)) {
            ArrayList<UccSkuAddPriceListQueryInfoBO> rows = new ArrayList<UccSkuAddPriceListQueryInfoBO>(16);
            for (CnncUccSkuAddPricePO uccSkuAddPricePO : cnncUccSkuAddPricePOS) {
                UccSkuAddPriceListQueryInfoBO uccSkuAddPriceListQueryInfoBO = new UccSkuAddPriceListQueryInfoBO();
                BeanUtils.copyProperties((Object)uccSkuAddPricePO, (Object)uccSkuAddPriceListQueryInfoBO);
                this.getTypeName(uccSkuAddPricePO, uccSkuAddPriceListQueryInfoBO);
                if (UccConstants.SKU_ADD_COEFFICIENT_WAIT_EFFECTIVE.equals(uccSkuAddPricePO.getEffectiveStatus())) {
                    uccSkuAddPriceListQueryInfoBO.setEffectiveStatusDes("\u5f85\u751f\u6548");
                }
                if (UccConstants.SKU_ADD_COEFFICIENT_EFFECTIVE.equals(uccSkuAddPricePO.getEffectiveStatus())) {
                    uccSkuAddPriceListQueryInfoBO.setEffectiveStatusDes("\u751f\u6548");
                }
                if (UccConstants.SKU_ADD_COEFFICIENT_EXPIRES.equals(uccSkuAddPricePO.getEffectiveStatus())) {
                    uccSkuAddPriceListQueryInfoBO.setEffectiveStatusDes("\u5931\u6548");
                }
                uccSkuAddPriceListQueryInfoBO.setAgreementPrice(MoneyUtils.haoToYuan((BigDecimal)uccSkuAddPriceListQueryInfoBO.getAgreementPrice()));
                uccSkuAddPriceListQueryInfoBO.setSalePrice(MoneyUtils.haoToYuan((BigDecimal)uccSkuAddPriceListQueryInfoBO.getSalePrice()));
                uccSkuAddPriceListQueryInfoBO.setMarketPrice(MoneyUtils.haoToYuan((BigDecimal)uccSkuAddPriceListQueryInfoBO.getMarketPrice()));
                rows.add(uccSkuAddPriceListQueryInfoBO);
            }
            rspBO.setRows(rows);
            rspBO.setPageNo(page.getPageNo());
            rspBO.setTotal(page.getTotalCount());
            rspBO.setRecordsTotal(page.getTotalCount());
        }
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    private void getTypeName(CnncUccSkuAddPricePO uccSkuAddPricePO, UccSkuAddPriceListQueryInfoBO addPriceListQueryInfoBO) {
        UccCommodityTypePo commodityTypePo = this.uccCommodityTypeMapper.queryPoByCommodityTypeId(uccSkuAddPricePO.getCommodityTypeId());
        if (!ObjectUtils.isEmpty((Object)commodityTypePo)) {
            addPriceListQueryInfoBO.setCatalogName(commodityTypePo.getCommodityTypeName());
        }
    }

    List<UccEMdmCatalogPO> findParent(List<Long> catalogId) {
        ArrayList<UccEMdmCatalogPO> poList = new ArrayList<UccEMdmCatalogPO>();
        List qryRspList = this.cnncUccEMdmCatalogMapper.queryByIds(catalogId);
        if (CollectionUtils.isEmpty((Collection)qryRspList)) {
            return poList;
        }
        poList.addAll(qryRspList);
        ArrayList<Long> next = new ArrayList<Long>();
        qryRspList.forEach(a -> {
            if (a.getCatalogLevel() > 1) {
                next.add(a.getParentCatalogId());
            }
        });
        if (CollectionUtils.isEmpty(next)) {
            return poList;
        }
        List<UccEMdmCatalogPO> parent = this.findParent(next);
        poList.addAll(parent);
        return poList;
    }
}

