/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.self.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.bo.UccBatchSpuBO;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.dao.UccCommodityLogMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccSkuLogMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccCommodityLogPO;
import com.tydic.commodity.po.UccSkuLogPo;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.self.ability.bo.UccDeleteCommodityAbilityReqBO;
import com.tydic.commodity.self.ability.bo.UccDeleteCommodityAbilityRspBO;
import com.tydic.commodity.self.busi.api.UccDeleteCommodityBusiService;
import com.tydic.commodity.utils.RedisUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UccDeleteCommodityBusiServiceImpl
implements UccDeleteCommodityBusiService {
    private static final Logger log = LogManager.getLogger(UccDeleteCommodityBusiServiceImpl.class);
    @Autowired
    private UccSkuMapper uccExtSkuMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccSkuLogMapper uccSkuLogMapper;
    @Autowired
    private UccCommodityLogMapper uccCommodityLogMapper;
    @Autowired
    private RedisUtils redisUtils;

    @Override
    public UccDeleteCommodityAbilityRspBO dealDeleteCommodity(UccDeleteCommodityAbilityReqBO reqBO) {
        List reqCmmds = reqBO.getBatchSpuList().stream().map(UccBatchSpuBO::getCommodityId).collect(Collectors.toList());
        List skuPos = new ArrayList();
        try {
            skuPos = this.uccExtSkuMapper.qeryBatchSkuByComms(reqCmmds);
            List uccCommodityPos = this.uccCommodityMapper.qeryBatchCommdity(reqCmmds);
            this.uccExtSkuMapper.batchDeleteSku(reqCmmds);
            this.uccCommodityMapper.batchDeleteCommodity(reqCmmds);
            long batchId = Sequence.getInstance().nextId();
            Date date = new Date();
            List uccSkuLogPos = skuPos.stream().map(e -> {
                UccSkuLogPo skuLogPo = (UccSkuLogPo)JSONObject.parseObject((String)JSON.toJSONString((Object)e), UccSkuLogPo.class);
                skuLogPo.setBatchId(Long.valueOf(batchId));
                skuLogPo.setUpdateTime(date);
                skuLogPo.setUpdateOperId(reqBO.getUserId().toString());
                skuLogPo.setUpdateOperName(reqBO.getName());
                skuLogPo.setRemark("\u8349\u7a3f\u5220\u9664");
                return skuLogPo;
            }).collect(Collectors.toList());
            List uccCommodityLogPOS = uccCommodityPos.stream().map(e -> {
                UccCommodityLogPO commodityLogPo = (UccCommodityLogPO)JSONObject.parseObject((String)JSON.toJSONString((Object)e), UccCommodityLogPO.class);
                commodityLogPo.setBatchId(Long.valueOf(batchId));
                commodityLogPo.setUpdateTime(date);
                commodityLogPo.setUpdateOperId(reqBO.getUserId().toString());
                commodityLogPo.setUpdateOperName(reqBO.getName());
                commodityLogPo.setRemark("\u8349\u7a3f\u5220\u9664");
                return commodityLogPo;
            }).collect(Collectors.toList());
            this.uccSkuLogMapper.insertBatch(uccSkuLogPos);
            this.uccCommodityLogMapper.insertBatch(uccCommodityLogPOS);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new BusinessException("8888", "\u5220\u9664\u5931\u8d25\uff01" + e2.getMessage());
        }
        if (CollectionUtils.isNotEmpty(skuPos)) {
            for (UccSkuPo uccSkuPo : skuPos) {
                if (null == uccSkuPo.getSkuSource() || uccSkuPo.getSkuSource() != 3) continue;
                String redisKey = "SKU_REPEAT_CHECK_" + uccSkuPo.getBrandName() + "_" + uccSkuPo.getModel() + "_" + uccSkuPo.getMeasureName();
                log.info("\u5220\u9664\u7f13\u5b58-\u6279\u91cf-\u534f\u8bae\u54c1\u53bb\u91cd,redisKey == {}, uccSkuPo=={}", (Object)redisKey, (Object)uccSkuPo);
                this.redisUtils.del(redisKey);
            }
        }
        UccDeleteCommodityAbilityRspBO rspBO = new UccDeleteCommodityAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

