package com.tydic.llm.starter.config;

import com.tydic.llm.starter.service.LlmClient;
import com.tydic.llm.starter.service.impl.LlmClientImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * LLM自动配置类
 * Spring Boot启动时自动加载
 *
 * @author tydic
 */
@Slf4j
@Configuration
@EnableConfigurationProperties(LlmProperties.class)
@ConditionalOnProperty(prefix = "llm", name = "enabled", havingValue = "true", matchIfMissing = true)
public class LlmAutoConfiguration {

    @Bean
    @ConditionalOnMissingBean
    public LlmClient LlmClient(LlmProperties llmProperties) {
        log.info("初始化 LlmClient, 配置信息: {}", llmProperties.toString());
        return new LlmClientImpl(llmProperties);
    }
}
