/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.llm.starter.service.impl;

import com.tydic.llm.starter.bo.LlmReqBO;
import com.tydic.llm.starter.bo.LlmRsqBO;
import com.tydic.llm.starter.config.LlmProperties;
import com.tydic.llm.starter.exception.LlmException;
import com.tydic.llm.starter.models.LlmModelService;
import com.tydic.llm.starter.models.dyc.QwenPrivateModelImpl;
import com.tydic.llm.starter.models.hunyuan.HunyuanModelImpl;
import com.tydic.llm.starter.models.qianfan.QianfanModelImpl;
import com.tydic.llm.starter.models.qwen.QwenModelImpl;
import com.tydic.llm.starter.service.LlmClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LlmClientImpl
implements LlmClient {
    private static final Logger log = LoggerFactory.getLogger(LlmClientImpl.class);
    private final LlmProperties llmProperties;

    public LlmClientImpl(LlmProperties llmProperties) {
        this.llmProperties = llmProperties;
    }

    @Override
    public LlmRsqBO chat(LlmReqBO reqBO) {
        LlmModelService llmModelService;
        log.info("chat llmProperties:{}", (Object)this.llmProperties.toString());
        if ("qwen".equals(this.llmProperties.getLlmType())) {
            llmModelService = new QwenModelImpl();
        } else if ("qianfan".equals(this.llmProperties.getLlmType())) {
            llmModelService = new QianfanModelImpl();
        } else if ("hunyuan".equals(this.llmProperties.getLlmType())) {
            llmModelService = new HunyuanModelImpl();
        } else if ("qwen-private".equals(this.llmProperties.getLlmType())) {
            llmModelService = new QwenPrivateModelImpl();
        } else {
            throw new LlmException("\u6682\u4e0d\u652f\u6301\u7684\u5927\u6a21\u578b\u7c7b\u578b");
        }
        return llmModelService.chat(reqBO, this.llmProperties);
    }
}

