/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mdp.gen.ability.impl;

import cn.hutool.core.util.StrUtil;
import com.tydic.mdp.atom.api.ComFileUploadService;
import com.tydic.mdp.atom.bo.ComFileAppBo;
import com.tydic.mdp.atom.bo.ComFileUploadAppReqBo;
import com.tydic.mdp.atom.bo.ComFileUploadAppRspBo;
import com.tydic.mdp.dao.GenGitInformationMapper;
import com.tydic.mdp.dao.GenObjEntityPropertiesMapper;
import com.tydic.mdp.dao.GenObjInformationMapper;
import com.tydic.mdp.dao.MdpModuleInformationMapper;
import com.tydic.mdp.dao.MdpObjGroupInformationMapper;
import com.tydic.mdp.dao.MdpObjInformationMapper;
import com.tydic.mdp.dao.MdpObjMethodInformationMapper;
import com.tydic.mdp.exception.MdpBusinessException;
import com.tydic.mdp.gen.ability.api.GenGeneratorCodeAbilityService;
import com.tydic.mdp.gen.ability.bo.GenGeneratorCodeAbilityReqBO;
import com.tydic.mdp.gen.ability.bo.GenGeneratorCodeAbilityRspBO;
import com.tydic.mdp.gen.ability.bo.GeneratorReqBO;
import com.tydic.mdp.gen.atom.api.GenUploadGitAtomService;
import com.tydic.mdp.gen.atom.bo.GenUploadGitAtomReqBO;
import com.tydic.mdp.po.GenGitInformationPO;
import com.tydic.mdp.po.GenObjEntityPropertiesPO;
import com.tydic.mdp.po.GenObjInformationPO;
import com.tydic.mdp.po.MdpModuleInformationPO;
import com.tydic.mdp.po.MdpObjGroupInformationPO;
import com.tydic.mdp.po.MdpObjInformationPO;
import com.tydic.mdp.po.MdpObjMethodInformationPO;
import com.tydic.mdp.util.GenControllerRspBO;
import com.tydic.mdp.util.GenControllerUtils;
import com.tydic.mdp.util.SysGenConItem;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.zip.ZipOutputStream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class GenGeneratorCodeAbilityServiceImpl
implements GenGeneratorCodeAbilityService {
    @Autowired
    private ComFileUploadService comFileUploadService;
    @Autowired
    private MdpObjInformationMapper mdpObjInformationMapper;
    @Autowired
    private MdpObjGroupInformationMapper mdpObjGroupInformationMapper;
    @Autowired
    private MdpObjMethodInformationMapper mdpObjMethodInformationMapper;
    @Autowired
    private MdpModuleInformationMapper mdpModuleInformationMapper;
    @Autowired
    private GenObjInformationMapper genObjInformationMapper;
    @Autowired
    private GenObjEntityPropertiesMapper genObjEntityPropertiesMapper;
    @Autowired
    private GenUploadGitAtomService genUploadGitAtomService;
    @Autowired
    private GenGitInformationMapper genGitInformationMapper;
    private static final String OUT = "0";
    @Value(value="${generator.packageName:com.tydic.pesapp.service}")
    private String packageName;

    public GenGeneratorCodeAbilityRspBO generatorController(GenGeneratorCodeAbilityReqBO reqBO) {
        this.val(reqBO);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ZipOutputStream zip = new ZipOutputStream(outputStream);
        GenObjInformationPO genObjInformationPO = new GenObjInformationPO();
        genObjInformationPO.setBindingIds(reqBO.getBindingList().stream().map(GeneratorReqBO::getBindingId).collect(Collectors.toList()));
        List genObjInformationPOs = this.genObjInformationMapper.getList(genObjInformationPO);
        Map<String, GenObjInformationPO> informationPOMap = genObjInformationPOs.stream().collect(Collectors.toMap(GenObjInformationPO::getBindingId, o -> o));
        ArrayList<GenGitInformationPO> genGitInformationPos = new ArrayList<GenGitInformationPO>();
        List mdpModuleInformationPOS = genObjInformationPOs.stream().map(genObjInformation -> {
            MdpModuleInformationPO mdpModuleInformationPO = new MdpModuleInformationPO();
            mdpModuleInformationPO.setEnvCode(genObjInformation.getEnvCode());
            mdpModuleInformationPO.setTenantCode(genObjInformation.getTenantCode());
            mdpModuleInformationPO.setProjectCode(genObjInformation.getProjectCode());
            mdpModuleInformationPO.setModuleCode(genObjInformation.getModuleCode());
            mdpModuleInformationPO.setObjCode(genObjInformation.getObjCode());
            GenGitInformationPO genGitInformationPO = new GenGitInformationPO();
            genGitInformationPO.setTenanttCode(genObjInformation.getTenantCode());
            genGitInformationPO.setProjectCode(genObjInformation.getProjectCode());
            genGitInformationPos.add(genGitInformationPO);
            return mdpModuleInformationPO;
        }).collect(Collectors.toList());
        List moduleInformationPOS = this.mdpModuleInformationMapper.getObjInfoList(mdpModuleInformationPOS);
        Map<String, MdpModuleInformationPO> mdpModuleInformationPOMap = moduleInformationPOS.stream().collect(Collectors.toMap(m -> m.getEnvCode() + m.getTenantCode() + m.getProjectCode() + m.getModuleCode() + m.getObjCode(), o -> o));
        ArrayList<MdpObjMethodInformationPO> mdpModuleInformationPOList = new ArrayList<MdpObjMethodInformationPO>();
        for (GenObjInformationPO genObjInformation2 : genObjInformationPOs) {
            String key = genObjInformation2.getEnvCode() + genObjInformation2.getTenantCode() + genObjInformation2.getProjectCode() + genObjInformation2.getModuleCode() + genObjInformation2.getObjCode();
            MdpModuleInformationPO mdpModuleInformationPO = mdpModuleInformationPOMap.get(key);
            MdpObjMethodInformationPO mdpObjMethodInformationPO = new MdpObjMethodInformationPO();
            mdpObjMethodInformationPO.setObjId(mdpModuleInformationPO.getObjId());
            mdpObjMethodInformationPO.setObjMethodCode(genObjInformation2.getObjMethodCode());
            mdpModuleInformationPOList.add(mdpObjMethodInformationPO);
        }
        List methodList = this.mdpObjMethodInformationMapper.getMethodList(mdpModuleInformationPOList);
        Map<String, MdpObjMethodInformationPO> methodInformationPOMap = methodList.stream().collect(Collectors.toMap(m -> m.getObjId() + m.getObjMethodCode(), o -> o));
        Map<String, GenGitInformationPO> genGitInformationPOMap = this.getGitInfo(genGitInformationPos, reqBO);
        for (GeneratorReqBO generatorReqBO : reqBO.getBindingList()) {
            GenObjInformationPO genObjInformation3 = informationPOMap.get(generatorReqBO.getBindingId());
            String key = genObjInformation3.getEnvCode() + genObjInformation3.getTenantCode() + genObjInformation3.getProjectCode() + genObjInformation3.getModuleCode() + genObjInformation3.getObjCode();
            MdpModuleInformationPO mdpModuleInformationPO = mdpModuleInformationPOMap.get(key);
            MdpObjMethodInformationPO mdpObjMethodInformationPO = methodInformationPOMap.get(mdpModuleInformationPO.getObjId() + genObjInformation3.getObjMethodCode());
            GenControllerRspBO genControllerRspBO = GenControllerUtils.generatorCode((SysGenConItem)this.createGeneratorParam(genObjInformation3, mdpModuleInformationPO, mdpObjMethodInformationPO), (ZipOutputStream)zip);
            if (!reqBO.getIsUpLoadGit().booleanValue() || !StringUtils.isNotBlank((CharSequence)genControllerRspBO.getContent())) continue;
            GenGitInformationPO genGitInformationPO = genGitInformationPOMap.get(genObjInformation3.getTenantCode() + genObjInformation3.getProjectCode());
            if (null == genGitInformationPO) {
                throw new MdpBusinessException("198888", StrUtil.format((CharSequence)"\u79df\u6237\uff1a{} {}\u9879\u76eegit\u4e0a\u4f20\u4fe1\u606f\u672a\u914d\u7f6e", (Object[])new Object[]{genObjInformation3.getTenantCode(), genObjInformation3.getProjectCode()}));
            }
            GenUploadGitAtomReqBO genUploadGitAtomReqBO = new GenUploadGitAtomReqBO();
            genUploadGitAtomReqBO.setBranch(genObjInformation3.getEnvCode());
            genUploadGitAtomReqBO.setIpAddress(genGitInformationPO.getWarehouseIp());
            genUploadGitAtomReqBO.setFilePath(genGitInformationPO.getUploadAddress());
            genUploadGitAtomReqBO.setClassName(genControllerRspBO.getClassName());
            genUploadGitAtomReqBO.setContent(genControllerRspBO.getContent());
            genUploadGitAtomReqBO.setProjectId(genGitInformationPO.getProjectId());
            genUploadGitAtomReqBO.setPrivateToken(genGitInformationPO.getPrivateToken());
            this.genUploadGitAtomService.uploadGit(genUploadGitAtomReqBO);
        }
        IOUtils.closeQuietly((OutputStream)zip);
        ComFileUploadAppReqBo comFileUploadAppReqBO = new ComFileUploadAppReqBo();
        ArrayList<ComFileAppBo> files = new ArrayList<ComFileAppBo>();
        ComFileAppBo comFileAppBo = new ComFileAppBo();
        comFileAppBo.setFile(outputStream.toByteArray());
        comFileAppBo.setFileName("my-generator.zip");
        files.add(comFileAppBo);
        comFileUploadAppReqBO.setFiles(files);
        ComFileUploadAppRspBo comFileUploadAppRspBo = this.comFileUploadService.upload(comFileUploadAppReqBO);
        GenGeneratorCodeAbilityRspBO rspBO = new GenGeneratorCodeAbilityRspBO();
        rspBO.setFileList(comFileUploadAppRspBo.getFileList());
        return rspBO;
    }

    private Map<String, GenGitInformationPO> getGitInfo(List<GenGitInformationPO> genGitInformationPos, GenGeneratorCodeAbilityReqBO reqBO) {
        if (reqBO.getIsUpLoadGit().booleanValue()) {
            List gitInformationPOS = this.genGitInformationMapper.getListByList(genGitInformationPos);
            if (CollectionUtils.isNotEmpty((Collection)gitInformationPOS)) {
                return gitInformationPOS.stream().collect(Collectors.toMap(g -> g.getTenanttCode() + g.getProjectCode(), o -> o));
            }
            return new HashMap<String, GenGitInformationPO>(0);
        }
        return null;
    }

    private SysGenConItem createGeneratorParam(GenObjInformationPO genObjInformationPO, MdpModuleInformationPO mdpModuleInformationPO, MdpObjMethodInformationPO mdpObjMethodInformationPO) {
        SysGenConItem sysGenConItem = new SysGenConItem();
        String genUrl = genObjInformationPO.getGenUrl();
        String[] urls = genUrl.split("/");
        sysGenConItem.setModuleCode(GenGeneratorCodeAbilityServiceImpl.toCamelCase(genObjInformationPO.getModuleCode()));
        sysGenConItem.setObjCode(GenGeneratorCodeAbilityServiceImpl.toCamelCase(genObjInformationPO.getObjCode()));
        sysGenConItem.setObjMethodCode(GenGeneratorCodeAbilityServiceImpl.toCamelCase(genObjInformationPO.getObjMethodCode()));
        sysGenConItem.setRandom(urls[urls.length - 1]);
        sysGenConItem.setFileName(genObjInformationPO.getObjCode().replaceAll("Service", "Controller") + GenGeneratorCodeAbilityServiceImpl.toUpperCaseFirstOne(sysGenConItem.getRandom()));
        sysGenConItem.setComments(mdpModuleInformationPO.getObjInfo());
        sysGenConItem.setApiPath(mdpModuleInformationPO.getObjUrl());
        sysGenConItem.setMethodId(mdpObjMethodInformationPO.getObjMethodId().toString());
        sysGenConItem.setGenObjId(genObjInformationPO.getGenObjId());
        MdpObjGroupInformationPO mdpObjGroupInformationPO = new MdpObjGroupInformationPO();
        mdpObjGroupInformationPO.setObjGroupId(mdpObjMethodInformationPO.getInObjGroupId());
        mdpObjGroupInformationPO = this.mdpObjGroupInformationMapper.getModelBy(mdpObjGroupInformationPO);
        MdpObjInformationPO mdpObjInformationPO = new MdpObjInformationPO();
        mdpObjInformationPO.setObjId(mdpObjGroupInformationPO.getObjId());
        mdpObjInformationPO = this.mdpObjInformationMapper.getModelBy(mdpObjInformationPO);
        sysGenConItem.setParamName(mdpObjInformationPO.getObjName());
        sysGenConItem.setParamClassPath(mdpObjInformationPO.getObjUrl());
        GenObjEntityPropertiesPO genObjEntityPropertiesPO = new GenObjEntityPropertiesPO();
        genObjEntityPropertiesPO.setGenObjId(genObjInformationPO.getGenObjId());
        genObjEntityPropertiesPO.setInOutType(OUT);
        List objEntityPropertiesPOS = this.genObjEntityPropertiesMapper.getList(genObjEntityPropertiesPO);
        sysGenConItem.setRspMoFilter(objEntityPropertiesPOS.stream().map(GenObjEntityPropertiesPO::getAttrName).collect(Collectors.toList()));
        sysGenConItem.setPackageName(this.packageName);
        if ("query".equals(genObjInformationPO.getObjMethodType())) {
            sysGenConItem.setType("2");
            sysGenConItem.setQryUrl("${qry.url:59.110.230.30:8089/query}");
            sysGenConItem.setQryTimeOut("${qry.timeout:6000}");
        } else {
            sysGenConItem.setType("1");
        }
        return sysGenConItem;
    }

    private void val(GenGeneratorCodeAbilityReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getBindingList())) {
            throw new MdpBusinessException("198888", "\u7ed1\u5b9aid\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (GeneratorReqBO generatorReqBO : reqBO.getBindingList()) {
            if (!StringUtils.isBlank((CharSequence)generatorReqBO.getBindingId())) continue;
            throw new MdpBusinessException("198888", "\u7ed1\u5b9aid\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private static String toCamelCase(String code) {
        return StrUtil.toCamelCase((CharSequence)StrUtil.toUnderlineCase((CharSequence)code));
    }

    public static String toUpperCaseFirstOne(String s) {
        if (Character.isUpperCase(s.charAt(0))) {
            return s;
        }
        return Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }
}

