/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mdp.gen.atom.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.mdp.gen.atom.api.GenGeneratorWikiDocumentAtomService;
import com.tydic.mdp.gen.atom.bo.GenDocInterfaceAtomReqBO;
import com.tydic.mdp.gen.atom.bo.GenDocInterfaceAtomRspBO;
import freemarker.template.Template;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import org.apache.commons.lang3.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfigurer;

@Service
public class GenGeneratorWikiDocumentAtomServiceImpl
implements GenGeneratorWikiDocumentAtomService {
    private static final Logger log = LoggerFactory.getLogger(GenGeneratorWikiDocumentAtomServiceImpl.class);
    @Autowired
    private FreeMarkerConfigurer configurer;

    @Override
    public GenDocInterfaceAtomRspBO dealWikiContentFreeMarker(GenDocInterfaceAtomReqBO docInterfaceBo) {
        StringWriter stringWriter = new StringWriter();
        HashMap<String, Object> templateMap = new HashMap<String, Object>(16);
        templateMap.put("interfaceServiceName", docInterfaceBo.getInterfaceServiceName());
        templateMap.put("interfaceMethodName", docInterfaceBo.getInterfaceMethodName());
        templateMap.put("value", docInterfaceBo.getValue());
        String path = docInterfaceBo.getPath();
        if (StringUtils.hasText((String)path) && path.charAt(0) == '/') {
            path = path.substring(1);
        }
        templateMap.put("path", path);
        templateMap.put("interfaceServiceFullName", docInterfaceBo.getInterfaceServiceFullName());
        templateMap.put("interfaceReqBos", docInterfaceBo.getInterfaceReqBos());
        templateMap.put("interfaceRspBo", docInterfaceBo.getInterfaceRspBo());
        templateMap.put("fieldReqBos", docInterfaceBo.getFieldReqBos());
        templateMap.put("fieldRspBos", docInterfaceBo.getFieldRspBos());
        templateMap.put("logic", docInterfaceBo.getLogic());
        templateMap.put("keyDataChanges", docInterfaceBo.getKeyDataChanges());
        if (StringUtils.hasText((String)docInterfaceBo.getAccountName())) {
            templateMap.put("accountName", StringEscapeUtils.escapeHtml4((String)docInterfaceBo.getAccountName()));
        }
        if (StringUtils.hasText((String)docInterfaceBo.getReqJson())) {
            try {
                templateMap.put("reqJson", StringEscapeUtils.escapeHtml4((String)JSON.toJSONString((Object)JSON.parseObject((String)docInterfaceBo.getReqJson()), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat})));
            }
            catch (Exception e) {
                templateMap.put("reqJson", "\u62a5\u6587\u4e0d\u662f\u6b63\u786eJSON\uff0c\u8bf7\u8054\u7cfb\u540e\u7aef\u7814\u53d1\u4fee\u6539\u4e3a\u6b63\u786eJSON");
            }
        }
        if (StringUtils.hasText((String)docInterfaceBo.getRspJson())) {
            try {
                templateMap.put("rspJson", StringEscapeUtils.escapeHtml4((String)JSON.toJSONString((Object)JSON.parseObject((String)docInterfaceBo.getRspJson()), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat})));
            }
            catch (Exception e) {
                templateMap.put("rspJson", "\u62a5\u6587\u4e0d\u662f\u6b63\u786eJSON\uff0c\u8bf7\u8054\u7cfb\u540e\u7aef\u7814\u53d1\u4fee\u6539\u4e3a\u6b63\u786eJSON");
            }
        }
        try {
            Template template = this.configurer.getConfiguration().getTemplate("conferenceFreeMarker.ftl", "UTF-8");
            template.process(templateMap, (Writer)stringWriter);
        }
        catch (Exception e) {
            log.info("FreeMarker\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
        }
        stringWriter.flush();
        GenDocInterfaceAtomRspBO genDocInterfaceAtomRspBO = new GenDocInterfaceAtomRspBO();
        genDocInterfaceAtomRspBO.setUpLoadContent(stringWriter.toString());
        return genDocInterfaceAtomRspBO;
    }
}

