/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mdp.gen.atom.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.mdp.exception.MdpBusinessException;
import com.tydic.mdp.gen.atom.api.GenWikiAtomService;
import com.tydic.mdp.gen.atom.bo.GenWikiCreateReqBO;
import com.tydic.mdp.gen.atom.bo.GenWikiCreateRspBO;
import com.tydic.mdp.gen.atom.bo.GenWikiGetByIdReqBO;
import com.tydic.mdp.gen.atom.bo.GenWikiGetByIdRspBO;
import com.tydic.mdp.gen.atom.bo.GenWikiGetReqBO;
import com.tydic.mdp.gen.atom.bo.GenWikiGetRspBO;
import com.tydic.mdp.gen.atom.bo.GenWikiUpdateByIdReqBO;
import com.tydic.mdp.gen.atom.bo.GenWikiUpdateByIdRspBO;
import com.tydic.mdp.util.SSLClient;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class GenWikiAtomServiceImpl
implements GenWikiAtomService {
    private static final Logger log = LoggerFactory.getLogger(GenWikiAtomServiceImpl.class);
    @Value(value="${wiki.host:https://wiki.tydiczt.cn}")
    private String wikiHost;
    @Value(value="${wiki.url:/rest/api/content}")
    private String wikiUrl;
    @Value(value="${wiki.upload.parentId:182787102}")
    private String wikiUploadParentId;
    @Value(value="${wiki.upload.space:~wenle}")
    private String wikiUploadSpace;
    @Value(value="${wiki.basic.code:Basic d2VubGU6d2VubGU=}")
    private String wikiBasicCode;

    @Override
    public GenWikiCreateRspBO create(GenWikiCreateReqBO reqBO) {
        String param = this.createParam(reqBO.getTitle(), reqBO.getContent(), false, null);
        String url = this.wikiHost + this.wikiUrl;
        log.info("\u521b\u5efa\u9875\u9762\u5165\u53c2\uff1a{}, url:{}", (Object)param, (Object)url);
        String rspStr = SSLClient.doPost((String)url, (String)param, (String)"Authorization", (String)this.wikiBasicCode);
        JSONObject rsp = JSONObject.parseObject((String)rspStr);
        log.info("\u521b\u5efa\u9875\u9762\u51fa\u53c2\uff1a{}", (Object)rsp.toJSONString());
        if ("400".equals(rsp.getString("statusCode")) && StringUtils.isNotBlank((CharSequence)rsp.getString("message"))) {
            throw new MdpBusinessException("198888", StrUtil.format((CharSequence)"\u521b\u5efawiki\u9875\u9762\u5931\u8d25\uff1a{}", (Object[])new Object[]{rsp.getString("message")}));
        }
        GenWikiCreateRspBO genWikiCreateRspBO = new GenWikiCreateRspBO();
        genWikiCreateRspBO.setPageId(rsp.getString("id"));
        genWikiCreateRspBO.setPageTitle(rsp.getString("title"));
        genWikiCreateRspBO.setPageUrl(this.wikiHost + "/pages/viewpage.action?pageId=" + rsp.getString("id"));
        return genWikiCreateRspBO;
    }

    @Override
    public GenWikiGetRspBO getByTitle(GenWikiGetReqBO reqBO) {
        String url = this.wikiHost + this.wikiUrl;
        HashMap<String, String> headers = new HashMap<String, String>(1);
        headers.put("Authorization", this.wikiBasicCode);
        HashMap<String, String> queryMap = new HashMap<String, String>(1);
        queryMap.put("spaceKey", this.wikiUploadSpace);
        queryMap.put("title", reqBO.getTitle().replace(" ", "+"));
        log.info("\u67e5\u8be2\u9875\u9762url:{}", (Object)url);
        String rspStr = SSLClient.doGet((String)url, headers, queryMap);
        JSONObject rsp = JSONObject.parseObject((String)rspStr);
        log.info("\u67e5\u8be2\u9875\u9762\u51fa\u53c2\uff1a{}", (Object)rsp.toJSONString());
        if (StringUtils.isNotBlank((CharSequence)rsp.getString("message"))) {
            throw new MdpBusinessException("198888", StrUtil.format((CharSequence)"\u67e5\u8be2wiki\u9875\u9762\u5f02\u5e38\uff1a{}", (Object[])new Object[]{rsp.getString("message")}));
        }
        return (GenWikiGetRspBO)((Object)JSONObject.parseObject((String)rspStr, GenWikiGetRspBO.class));
    }

    @Override
    public GenWikiGetByIdRspBO getById(GenWikiGetByIdReqBO reqBO) {
        String url = this.wikiHost + this.wikiUrl + "/" + reqBO.getId();
        HashMap<String, String> headers = new HashMap<String, String>(1);
        headers.put("Authorization", this.wikiBasicCode);
        log.info("\u67e5\u8be2\u9875\u9762url:{}", (Object)url);
        String rspStr = SSLClient.doGet((String)url, headers, null);
        JSONObject rsp = JSONObject.parseObject((String)rspStr);
        log.info("\u67e5\u8be2\u9875\u9762\u51fa\u53c2\uff1a{}", (Object)rsp.toJSONString());
        if (StringUtils.isNotBlank((CharSequence)rsp.getString("message"))) {
            throw new MdpBusinessException("198888", StrUtil.format((CharSequence)"\u67e5\u8be2wiki\u9875\u9762\u5f02\u5e38\uff1a{}", (Object[])new Object[]{rsp.getString("message")}));
        }
        return (GenWikiGetByIdRspBO)((Object)JSONObject.parseObject((String)rspStr, GenWikiGetByIdRspBO.class));
    }

    @Override
    public GenWikiUpdateByIdRspBO update(GenWikiUpdateByIdReqBO reqBO) {
        String param = this.createParam(reqBO.getTitle(), reqBO.getContent(), true, reqBO.getVersionNumber());
        String url = this.wikiHost + this.wikiUrl + "/" + reqBO.getId();
        log.info("\u66f4\u65b0\u9875\u9762\u5165\u53c2\uff1a{}, url:{}", (Object)param, (Object)url);
        String rspStr = SSLClient.doPut((String)url, (String)param, (String)"Authorization", (String)this.wikiBasicCode);
        JSONObject rsp = JSONObject.parseObject((String)rspStr);
        log.info("\u66f4\u65b0\u9875\u9762\u51fa\u53c2\uff1a{}", (Object)rsp.toJSONString());
        if ("400".equals(rsp.getString("statusCode")) && StringUtils.isNotBlank((CharSequence)rsp.getString("message"))) {
            throw new MdpBusinessException("198888", StrUtil.format((CharSequence)"\u66f4\u65b0wiki\u9875\u9762\u5931\u8d25\uff1a{}", (Object[])new Object[]{rsp.getString("message")}));
        }
        GenWikiUpdateByIdRspBO genWikiUpdateByIdRspBO = new GenWikiUpdateByIdRspBO();
        genWikiUpdateByIdRspBO.setPageId(rsp.getString("id"));
        genWikiUpdateByIdRspBO.setPageTitle(rsp.getString("title"));
        genWikiUpdateByIdRspBO.setPageUrl(this.wikiHost + "/pages/viewpage.action?pageId=" + rsp.getString("id"));
        return genWikiUpdateByIdRspBO;
    }

    private String createParam(String title, String content, boolean isUpdate, String versionNumber) {
        JSONObject param = new JSONObject();
        JSONArray ancestors = new JSONArray();
        JSONObject ancestor = new JSONObject();
        ancestor.put("id", (Object)this.wikiUploadParentId);
        ancestors.add((Object)ancestor);
        JSONObject space = new JSONObject();
        space.put("key", (Object)this.wikiUploadSpace);
        JSONObject body = new JSONObject();
        JSONObject storage = new JSONObject();
        storage.put("value", (Object)content);
        storage.put("representation", (Object)"storage");
        body.put("storage", (Object)storage);
        if (isUpdate) {
            JSONObject version = new JSONObject();
            version.put("number", (Object)versionNumber);
            param.put("version", (Object)version);
        }
        param.put("ancestors", (Object)ancestors);
        param.put("type", (Object)"page");
        param.put("title", (Object)title);
        param.put("space", (Object)space);
        param.put("body", (Object)body);
        return param.toJSONString();
    }
}

