/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mdp.plugin.service;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.mdp.plugin.bo.MdpDynamicInfoDataBO;
import com.tydic.mdp.plugin.bo.MdpPluginRulePropertiesReqBO;
import com.tydic.mdp.plugin.bo.MdpPluginRulePropertiesRspBO;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service(value="mdpPluginRulePropertiesService")
public class MdpPluginRulePropertiesService {
    private static final Logger log = LoggerFactory.getLogger(MdpPluginRulePropertiesService.class);
    @Value(value="${mdp.dynamic.info.url:http:localhost:8081/mdp/api/queryDynamicInfo}")
    private String mdpDynamicInfoUrl;
    @Autowired
    private JdbcTemplate jdbcTemplate;

    @PostConstruct
    public void init() {
        log.info("\u5143\u6570\u636e\u89c4\u5219\u5c5e\u6027\u83b7\u53d6\u670d\u52a1\u521d\u59cb\u5316\u5b8c\u6210");
    }

    public MdpPluginRulePropertiesRspBO getProperties(MdpPluginRulePropertiesReqBO reqBo) {
        MdpPluginRulePropertiesRspBO retBo = new MdpPluginRulePropertiesRspBO();
        retBo.setRespCode("8888");
        String validateResult = this.validateReqArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateResult)) {
            retBo.setRespDesc(validateResult);
            return retBo;
        }
        String result = HttpUtil.post((String)this.mdpDynamicInfoUrl, (String)JSON.toJSONString((Object)reqBo));
        if (StringUtils.isEmpty((Object)result) || result.contains(String.valueOf(404))) {
            log.error("\u8c03\u7528\u5143\u6570\u636e\u52a8\u6001\u8bed\u53e5\u83b7\u53d6\u7ed3\u679c\u4e3a\u7a7a");
            retBo.setRespDesc("\u8c03\u7528\u5143\u6570\u636e\u52a8\u6001\u8bed\u53e5\u83b7\u53d6\u7ed3\u679c\u4e3a\u7a7a");
            return retBo;
        }
        MdpDynamicInfoDataBO mdpDataBo = (MdpDynamicInfoDataBO)JSON.parseObject((String)result, MdpDynamicInfoDataBO.class);
        if (StringUtils.isEmpty((Object)mdpDataBo.getDynamicSql())) {
            log.error("\u8c03\u7528\u5143\u6570\u636e\u5e73\u53f0\u672a\u83b7\u53d6\u5230\u52a8\u6001\u8bed\u53e5");
            retBo.setRespDesc("\u8c03\u7528\u5143\u6570\u636e\u5e73\u53f0\u672a\u83b7\u53d6\u5230\u52a8\u6001\u8bed\u53e5");
            return retBo;
        }
        log.info("\u6839\u636e\u89c4\u5219ID[{}]\u83b7\u53d6\u5230\u7684\u52a8\u6001\u8bed\u53e5\u4e3a\uff1a{}", (Object)reqBo.getRuleId(), (Object)mdpDataBo.getDynamicSql());
        Map dynamicResultMap = this.jdbcTemplate.queryForMap(mdpDataBo.getDynamicSql());
        String valueRule = JSON.toJSONString((Object)dynamicResultMap);
        log.info("\u6267\u884c\u52a8\u6001\u8bed\u53e5\u83b7\u53d6\u5230\u7684\u6570\u636e\uff1a{}", (Object)valueRule);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        retBo.setValueRule(valueRule);
        return retBo;
    }

    private String validateReqArgs(MdpPluginRulePropertiesReqBO reqBo) {
        if (ObjectUtils.isEmpty((Object)reqBo)) {
            return "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (null == reqBo.getRuleId()) {
            return "\u89c4\u5219ID\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

