/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.merchant.mmc.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.merchant.mmc.ability.MmcShopDeployeListExportAbilityService;
import com.tydic.merchant.mmc.ability.bo.MmcShopChannelQueryAbilityDataBo;
import com.tydic.merchant.mmc.ability.bo.MmcShopDeployeListExportAbilityReqBo;
import com.tydic.merchant.mmc.ability.bo.MmcShopDeployeListExportAbilityRspDataBo;
import com.tydic.merchant.mmc.base.MmcRspDownloadPageBo;
import com.tydic.merchant.mmc.base.MmcRspPageBaseDataBo;
import com.tydic.merchant.mmc.base.MmcRspPageBo;
import com.tydic.merchant.mmc.base.MmcRspPageDataBo;
import com.tydic.merchant.mmc.comb.MmcShopDeployListQueryCombService;
import com.tydic.merchant.mmc.comb.bo.MmcShopDeployListQueryCombReqBo;
import com.tydic.merchant.mmc.comb.bo.MmcShopListQueryCombDataBo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="mmcShopDeployeListExportAbilityService")
@org.apache.dubbo.config.annotation.Service(version="1.0.0", group="MMC_GROUP", interfaceClass=MmcShopDeployeListExportAbilityService.class)
public class MmcShopDeployeListExportAbilityServiceImpl
implements MmcShopDeployeListExportAbilityService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    @Autowired
    private MmcShopDeployListQueryCombService mmcShopDeployListQueryCombService;

    public MmcRspDownloadPageBo<MmcRspPageBaseDataBo<MmcShopDeployeListExportAbilityRspDataBo>> exportData(MmcShopDeployeListExportAbilityReqBo reqBo) {
        MmcRspDownloadPageBo retBo = new MmcRspDownloadPageBo();
        MmcRspPageBaseDataBo retData = new MmcRspPageBaseDataBo();
        ArrayList<MmcShopDeployeListExportAbilityRspDataBo> retRows = new ArrayList<MmcShopDeployeListExportAbilityRspDataBo>();
        String validateStr = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            this.LOGGER.info("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            retBo.setCode("4006");
            retBo.setMessage("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        MmcShopDeployListQueryCombReqBo combReqBo = new MmcShopDeployListQueryCombReqBo();
        BeanUtils.copyProperties((Object)reqBo, (Object)combReqBo);
        MmcRspPageBo combRetBo = this.mmcShopDeployListQueryCombService.qryShopDeployList(combReqBo);
        if (!"0000".equals(combRetBo.getRespCode())) {
            this.LOGGER.error("\u8c03\u7528comb\u67e5\u8be2\u5931\u8d25\uff1a" + combRetBo.getRespDesc());
            retBo.setCode(combRetBo.getRespCode());
            retBo.setMessage(combRetBo.getRespDesc());
            return retBo;
        }
        MmcRspPageDataBo combRspData = (MmcRspPageDataBo)combRetBo.getData();
        List combDataBoList = combRspData.getRows();
        if (CollectionUtils.isEmpty((Collection)combDataBoList)) {
            this.LOGGER.info("\u67e5\u8be2\u5230\u7684\u6570\u636e\u96c6\u4e3a\u7a7a");
            retBo.setCode("4006");
            retBo.setMessage("\u67e5\u8be2\u5230\u7684\u6570\u636e\u96c6\u4e3a\u7a7a");
            return retBo;
        }
        int serialNumber = 0;
        for (MmcShopListQueryCombDataBo combDataBo : combDataBoList) {
            MmcShopDeployeListExportAbilityRspDataBo abilityDataBo = new MmcShopDeployeListExportAbilityRspDataBo();
            BeanUtils.copyProperties((Object)combDataBo, (Object)abilityDataBo);
            abilityDataBo.setSerialNumber(Integer.valueOf(++serialNumber));
            List channelList = combDataBo.getChannel();
            StringBuilder channelSb = new StringBuilder();
            int i = 0;
            for (MmcShopChannelQueryAbilityDataBo channelBo : channelList) {
                channelSb.append(i++ == channelList.size() - 1 ? channelBo.getChannelName() : channelBo.getChannelName() + ",");
            }
            abilityDataBo.setChannel(channelSb.toString());
            if (!StringUtils.isEmpty((Object)combDataBo.getExpireTime())) {
                abilityDataBo.setExpireTime(new DateTime((Object)combDataBo.getExpireTime()).toString(DATE_FORMAT));
            }
            if (!StringUtils.isEmpty((Object)combDataBo.getCreateTime())) {
                abilityDataBo.setCreateTime(new DateTime((Object)combDataBo.getCreateTime()).toString(DATE_FORMAT));
            }
            if (!StringUtils.isEmpty((Object)combDataBo.getUpdateTime())) {
                abilityDataBo.setUpdateTime(new DateTime((Object)combDataBo.getUpdateTime()).toString(DATE_FORMAT));
            }
            retRows.add(abilityDataBo);
        }
        BeanUtils.copyProperties((Object)combRspData, (Object)retData);
        retData.setRows(retRows);
        retBo.setData((Object)retData);
        retData.setRespCode("0000");
        retData.setRespDesc("\u6210\u529f");
        retBo.setCode("0");
        retBo.setMessage("\u6210\u529f");
        this.LOGGER.info("\u5e97\u94fa\u90e8\u7f72\u5bfc\u51fa\u670d\u52a1\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)retBo));
        return retBo;
    }

    private String validateArgs(MmcShopDeployeListExportAbilityReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (!StringUtils.isEmpty((Object)reqBo.getQueryType())) {
            String queryType = reqBo.getQueryType().toString();
            if (!"1".equals(queryType) && !"2".equals(queryType)) {
                return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'queryType'\u53ea\u80fd\u4e3aSHOP_DEPLOYE_QUERY_TYPE_WAITING(1)\u6216SHOP_DEPLOYE_QUERY_TYPE_DEPLOYED(2)";
            }
        } else {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'queryType'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

