/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.merchant.mmc.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.merchant.mmc.ability.MmcShopInfoPushAbilityService;
import com.tydic.merchant.mmc.ability.MmcShopRecommendPushQueryAbilityService;
import com.tydic.merchant.mmc.ability.bo.MmcShopInfoPushAbilityReqBo;
import com.tydic.merchant.mmc.ability.bo.MmcShopInfoPushAbilityRspBo;
import com.tydic.merchant.mmc.ability.bo.MmcShopRecommendListQueryAbilityRspDataBo;
import com.tydic.merchant.mmc.ability.bo.MmcShopRecommendPushQueryAbilityReqBo;
import com.tydic.merchant.mmc.ability.bo.MmcShopRecommendPushQueryAbilityRspBo;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="mmcShopInfoPushAbilityService")
@org.apache.dubbo.config.annotation.Service(version="1.0.0", group="MMC_GROUP", interfaceClass=MmcShopInfoPushAbilityService.class)
public class MmcShopInfoPushAbilityServiceImpl
implements MmcShopInfoPushAbilityService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private static final String CMS_RESP_CODE = "code";
    private static final String CMS_RESP_CODE_SUCCESS_VALUE = "0";
    @Value(value="${cms.mass.article.push.url}")
    private String pushUrl;
    @Value(value="${cms.mass.article.delete.url}")
    private String deleteUrl;
    @Autowired
    private MmcShopRecommendPushQueryAbilityService mmcShopRecommendPushQueryAbilityService;

    public MmcShopInfoPushAbilityRspBo pushShopInfo(MmcShopInfoPushAbilityReqBo reqBo) {
        this.LOGGER.info("------------\u5e97\u94fa\u4fe1\u606f\u63a8\u9001\u670d\u52a1\uff1a" + reqBo);
        MmcShopInfoPushAbilityRspBo retBo = new MmcShopInfoPushAbilityRspBo();
        String validateStr = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            this.LOGGER.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            retBo.setRespCode("4018");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        MmcShopRecommendPushQueryAbilityReqBo qryReqBo = new MmcShopRecommendPushQueryAbilityReqBo();
        BeanUtils.copyProperties((Object)reqBo, (Object)qryReqBo);
        MmcShopRecommendPushQueryAbilityRspBo qryRspBo = this.mmcShopRecommendPushQueryAbilityService.shopPushQuery(qryReqBo);
        if (!"0000".equals(qryRspBo.getRespCode())) {
            this.LOGGER.error("\u8c03\u7528\u67e5\u8be2\u670d\u52a1\u9519\u8bef\uff1a" + qryRspBo.getRespDesc());
            BeanUtils.copyProperties((Object)qryRspBo, (Object)retBo);
            return retBo;
        }
        boolean isDeleted = this.deleteDataByCode(reqBo.getColumnCode(), retBo);
        if (!isDeleted) {
            return retBo;
        }
        boolean isSuccess = this.pushData(reqBo, qryRspBo, retBo);
        if (!isSuccess) {
            return retBo;
        }
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private boolean pushData(MmcShopInfoPushAbilityReqBo reqBo, MmcShopRecommendPushQueryAbilityRspBo qryRspBo, MmcShopInfoPushAbilityRspBo retBo) {
        String resultData;
        for (MmcShopRecommendListQueryAbilityRspDataBo dataBo : qryRspBo.getData()) {
            dataBo.setBasicTitle(reqBo.getBasicTitle());
            dataBo.setColumnCode(reqBo.getColumnCode());
        }
        String postData = JSON.toJSONString((Object)qryRspBo.getData());
        this.LOGGER.info("\u5411CMS\u63a8\u9001\u7684\u6570\u636e\u4e3a\uff1a" + postData);
        try {
            resultData = this.postData(postData, this.pushUrl);
        }
        catch (Exception e) {
            this.LOGGER.error("\u5411CMS\u63a8\u9001\u6570\u636e\u65f6\u53d1\u751f\u5f02\u5e38\uff1a" + e);
            retBo.setRespCode("4018");
            retBo.setRespDesc("\u5411CMS\u63a8\u9001\u6570\u636e\u65f6\u53d1\u751f\u5f02\u5e38\uff1a" + e.getMessage());
            return false;
        }
        this.LOGGER.info("\u63a8\u9001\u8fd4\u56de\u53c2\u6570\u4e3a\uff1a" + resultData);
        JSONObject reslut = JSONObject.parseObject((String)resultData);
        if (reslut.get((Object)CMS_RESP_CODE).equals(CMS_RESP_CODE_SUCCESS_VALUE)) {
            this.LOGGER.error("\u5411CMS\u63a8\u9001\u6570\u636e\u5931\u8d25\uff1a" + reslut.get((Object)"message"));
            retBo.setRespCode("4018");
            retBo.setRespDesc("\u5411CMS\u63a8\u9001\u6570\u636e\u5931\u8d25\uff1a" + reslut.get((Object)"message"));
            return false;
        }
        this.LOGGER.info("------------\u5411CMS\u63a8\u9001\u6570\u636e\u6210\u529f-----------");
        return true;
    }

    private boolean deleteDataByCode(String columnCode, MmcShopInfoPushAbilityRspBo retBo) {
        String deleteResultData;
        JSONObject deleteDataStr = new JSONObject();
        deleteDataStr.put(CMS_RESP_CODE, (Object)columnCode);
        try {
            deleteResultData = this.postData(deleteDataStr.toJSONString(), this.deleteUrl);
        }
        catch (Exception e) {
            this.LOGGER.error("\u6839\u636ecolumnCode=" + columnCode + "\u5220\u9664\u6570\u636e\u65f6\u53d1\u751f\u5f02\u5e38:" + e.getMessage());
            retBo.setRespCode("4018");
            retBo.setRespDesc("\u6839\u636ecolumnCode=" + columnCode + "\u5220\u9664\u6570\u636e\u65f6\u53d1\u751f\u5f02\u5e38:" + e.getMessage());
            return false;
        }
        this.LOGGER.info("-----------\u8c03\u7528CMS\u5220\u9664\u6570\u636e\u8fd4\u56de\u7ed3\u679c\uff1a" + deleteResultData);
        JSONObject deleteResult = JSONObject.parseObject((String)deleteResultData);
        this.LOGGER.info(deleteResult.get((Object)CMS_RESP_CODE).toString());
        if (deleteResult.get((Object)CMS_RESP_CODE).equals(CMS_RESP_CODE_SUCCESS_VALUE)) {
            this.LOGGER.error("\u6839\u636ecolumnCode\u5220\u9664\u6570\u636e\u5931\u8d25\uff1a" + deleteResult.get((Object)"message"));
            retBo.setRespCode("4018");
            retBo.setRespDesc("\u6839\u636ecolumnCode\u5220\u9664\u6570\u636e\u5931\u8d25\uff1a" + deleteResult.get((Object)"message"));
            return false;
        }
        this.LOGGER.info("-----------\u6839\u636ecolumnCode=" + columnCode + "\u5220\u9664\u6570\u636e\u6210\u529f-----------");
        return true;
    }

    private String postData(String postData, String path) throws Exception {
        MediaType mediaType = MediaType.parse((String)"application/json; charset=utf-8");
        RequestBody requestBody = RequestBody.create((MediaType)mediaType, (String)postData);
        Request request = new Request.Builder().addHeader("Content-Type", "application/json").url(path).post(requestBody).build();
        OkHttpClient client = new OkHttpClient();
        Response response = client.newCall(request).execute();
        assert (response.body() != null);
        return response.body().string();
    }

    private String validateArgs(MmcShopInfoPushAbilityReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getBasicTitle())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'basicTitle'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getColumnCode())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'columnCode'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getChannel())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'channel'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

