/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.merchant.mmc.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.merchant.mmc.atom.api.MmcDicMapQueryAtomService;
import com.tydic.merchant.mmc.atom.bo.MmcDicMapQueryAtomReqBo;
import com.tydic.merchant.mmc.atom.bo.MmcDicMapQueryAtomRspBo;
import com.tydic.merchant.mmc.base.MmcRspPageBaseDataBo;
import com.tydic.merchant.mmc.busi.MmcFitmentShopPageListQueryBusiService;
import com.tydic.merchant.mmc.busi.bo.MmcFitmentShopPageListQueryBusiReqBo;
import com.tydic.merchant.mmc.dao.MmcFitmentPageMapper;
import com.tydic.merchant.mmc.dao.po.MmcFitmentPagePo;
import com.tydic.merchant.mmc.data.MmcFitmentShopPageDataBo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="mmcFitmentShopPageListQueryBusiService")
public class MmcFitmentShopPageListQueryBusiServiceImpl
implements MmcFitmentShopPageListQueryBusiService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private MmcFitmentPageMapper mmcFitmentPageMapper;
    @Autowired
    private MmcDicMapQueryAtomService mmcDicMapQueryAtomService;

    public MmcRspPageBaseDataBo<MmcFitmentShopPageDataBo> queryPage(MmcFitmentShopPageListQueryBusiReqBo reqBo) {
        this.LOGGER.info("\u5e97\u94fa\u88c5\u4fee-\u5e97\u94fa\u9875\u9762\u5217\u8868\u67e5\u8be2-Busi\u670d\u52a1:" + reqBo);
        MmcRspPageBaseDataBo retBo = new MmcRspPageBaseDataBo();
        ArrayList<MmcFitmentShopPageDataBo> retRows = new ArrayList<MmcFitmentShopPageDataBo>();
        retBo.setRows(retRows);
        String validateStr = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            this.LOGGER.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            retBo.setRespCode("2027");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        Page<MmcFitmentPagePo> page = this.getPage(reqBo);
        MmcFitmentPagePo reqPo = new MmcFitmentPagePo();
        BeanUtils.copyProperties((Object)reqBo, (Object)reqPo);
        List<MmcFitmentPagePo> retPos = this.mmcFitmentPageMapper.selectPage(reqPo, page);
        if (CollectionUtils.isEmpty(retPos)) {
            this.LOGGER.error("\u8c03\u7528mapper\u67e5\u8be2\u5230\u7684\u6570\u636e\u4e3a\u7a7a");
            retBo.setRespCode("2027");
            retBo.setRespDesc("\u8c03\u7528mapper\u67e5\u8be2\u5230\u7684\u6570\u636e\u4e3a\u7a7a");
            return retBo;
        }
        ArrayList<String> types = new ArrayList<String>();
        types.add("MMC_FITMENT_PAGE_MAIN_PAGE");
        types.add("MMC_FITMENT_PAGE_PUTAWAY");
        Map<String, Map<String, String>> dicMap = this.getDicMap(types);
        for (MmcFitmentPagePo po : retPos) {
            MmcFitmentShopPageDataBo dataBo = new MmcFitmentShopPageDataBo();
            BeanUtils.copyProperties((Object)po, (Object)dataBo);
            dataBo.setPutAwayDesc(dicMap.get("MMC_FITMENT_PAGE_PUTAWAY").get(po.getPutaway() + ""));
            dataBo.setMainPageDesc(dicMap.get("MMC_FITMENT_PAGE_MAIN_PAGE").get(po.getMainPage() + ""));
            retRows.add(dataBo);
        }
        retBo.setPageNo(Integer.valueOf(page.getPageNo()));
        retBo.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        retBo.setTotal(Integer.valueOf(page.getTotalPages()));
        return retBo;
    }

    private Map<String, Map<String, String>> getDicMap(List<String> types) {
        HashMap<String, Map<String, String>> dicMap = new HashMap<String, Map<String, String>>(16);
        MmcDicMapQueryAtomReqBo atomReqBo = new MmcDicMapQueryAtomReqBo();
        for (String type : types) {
            atomReqBo.setType(type);
            MmcDicMapQueryAtomRspBo atomRetBo = this.mmcDicMapQueryAtomService.qryDicMap(atomReqBo);
            dicMap.put(type, atomRetBo.getDicMap());
        }
        return dicMap;
    }

    private Page<MmcFitmentPagePo> getPage(MmcFitmentShopPageListQueryBusiReqBo reqBo) {
        Page page;
        if (reqBo.getPageNo() != 1) {
            page = new Page(reqBo.getPageNo().intValue(), reqBo.getPageSize().intValue());
        } else {
            page = new Page();
            BeanUtils.copyProperties((Object)reqBo, (Object)page);
            if (reqBo.getPageNo() < 1) {
                page.setPageNo(1);
            }
            if (reqBo.getPageSize() < 1) {
                page.setPageSize(10);
            }
        }
        return page;
    }

    private String validateArgs(MmcFitmentShopPageListQueryBusiReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getShopId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'shopId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

