/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.merchant.mmc.busi.impl;

import com.tydic.merchant.mmc.atom.api.MmcAuditRequestAtomService;
import com.tydic.merchant.mmc.atom.api.MmcShopChannelCreateAtomService;
import com.tydic.merchant.mmc.atom.bo.MmcAuditRequestAtomReqBo;
import com.tydic.merchant.mmc.atom.bo.MmcAuditRequestAtomRspBo;
import com.tydic.merchant.mmc.atom.bo.MmcShopChannelCreateAtomReqBo;
import com.tydic.merchant.mmc.atom.bo.MmcShopChannelCreateAtomRspBo;
import com.tydic.merchant.mmc.busi.MmcShopSettingUpdateService;
import com.tydic.merchant.mmc.busi.bo.MmcShopSettingUpdateReqBo;
import com.tydic.merchant.mmc.busi.bo.MmcShopSettingUpdateRspBo;
import com.tydic.merchant.mmc.dao.MmcInfoShopMapper;
import com.tydic.merchant.mmc.dao.MmcRelShopChannelMapper;
import com.tydic.merchant.mmc.dao.MmcRelShopSettingMapper;
import com.tydic.merchant.mmc.dao.po.MmcInfoShopPo;
import com.tydic.merchant.mmc.dao.po.MmcRelShopChannelPo;
import com.tydic.merchant.mmc.dao.po.MmcRelShopSettingPo;
import com.tydic.merchant.mmc.exception.MmcBusinessException;
import java.util.Date;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="mmcShopSettingUpdateService")
public class MmcShopSettingUpdateServiceImpl
implements MmcShopSettingUpdateService {
    @Autowired
    private MmcShopChannelCreateAtomService mmcShopChannelCreateAtomService;
    @Autowired
    private MmcRelShopChannelMapper mmcRelShopChannelMapper;
    @Autowired
    private MmcRelShopSettingMapper mmcRelShopSettingMapper;
    @Autowired
    private MmcInfoShopMapper mmcInfoShopMapper;
    @Autowired
    private MmcAuditRequestAtomService mmcAuditRequestAtomService;
    @Value(value="${mmc.approval.shop.setting.prokey}")
    private String shopSettingProKey;
    @Value(value="${CALL_PRC_SYS_CODE}")
    private String approvalSysCode;

    public MmcShopSettingUpdateRspBo updateShopSetting(MmcShopSettingUpdateReqBo reqBo) {
        MmcShopSettingUpdateRspBo rspBo = new MmcShopSettingUpdateRspBo();
        String validateArgStr = this.validateReqArg(reqBo);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            rspBo.setRespCode("2018");
            rspBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return rspBo;
        }
        Date dbDate = this.mmcInfoShopMapper.getDbDate();
        MmcRelShopSettingPo updatePo = new MmcRelShopSettingPo();
        BeanUtils.copyProperties((Object)reqBo, (Object)updatePo);
        updatePo.setUpdateTime(dbDate);
        updatePo.setUpdateOper(reqBo.getUpdateOper());
        this.mmcRelShopSettingMapper.updateByPrimaryKeySelective(updatePo);
        Long shopId = reqBo.getShopId();
        List channels = reqBo.getChannel();
        if (channels != null && !channels.isEmpty()) {
            MmcRelShopChannelPo deleteRelPo = new MmcRelShopChannelPo();
            deleteRelPo.setShopId(shopId);
            deleteRelPo.setType(Integer.parseInt("2"));
            deleteRelPo.setSettingId(reqBo.getSettingId());
            int deleteShopChannel = this.mmcRelShopChannelMapper.deleteByCondition(deleteRelPo);
            if (deleteShopChannel < 1) {
                throw new MmcBusinessException("6004", "\u5220\u9664\u5e97\u94fa-\u6e20\u9053\u5173\u7cfb\u8fd4\u56de\u503c\u5c0f\u4e8e1");
            }
            MmcShopChannelCreateAtomReqBo createChannelBo = new MmcShopChannelCreateAtomReqBo();
            createChannelBo.setChannels(channels);
            createChannelBo.setCreateDate(dbDate);
            createChannelBo.setRemark("\u5e97\u94fa\u8bbe\u7f6e\u66f4\u65b0\u5199\u5165\u6e20\u9053");
            createChannelBo.setShopId(shopId);
            createChannelBo.setType("2");
            createChannelBo.setSettingId(reqBo.getSettingId());
            MmcShopChannelCreateAtomRspBo creteShopChannelRspBo = this.mmcShopChannelCreateAtomService.createShopChannel(createChannelBo);
            if (!"0000".equals(creteShopChannelRspBo.getRespCode())) {
                throw new MmcBusinessException("6004", "\u63d2\u5165\u5e97\u94fa-\u6e20\u9053\u9519\u8bef\uff1a" + creteShopChannelRspBo.getRespDesc());
            }
        }
        MmcInfoShopPo updateShopBoToSetting = new MmcInfoShopPo();
        updateShopBoToSetting.setShopId(reqBo.getShopId());
        updateShopBoToSetting.setStatus(Integer.parseInt("6"));
        this.mmcInfoShopMapper.updateByPrimaryKeySelective(updateShopBoToSetting);
        if (reqBo.isAudit()) {
            MmcAuditRequestAtomReqBo auditBo = this.assembleAuditBo(reqBo, reqBo.getSettingId());
            MmcAuditRequestAtomRspBo auditRspBo = this.mmcAuditRequestAtomService.auditRequest(auditBo);
            if (!"0000".equals(auditRspBo.getRespCode())) {
                throw new MmcBusinessException("6003", "\u8c03\u7528\u5ba1\u6279\u670d\u52a1\u9519\u8bef\uff1a" + auditRspBo.getRespDesc());
            }
            MmcInfoShopPo updateShopBo = new MmcInfoShopPo();
            updateShopBo.setShopId(reqBo.getShopId());
            updateShopBo.setStatus(Integer.parseInt("5"));
            this.mmcInfoShopMapper.updateByPrimaryKeySelective(updateShopBo);
            MmcRelShopSettingPo updateSettingPo = new MmcRelShopSettingPo();
            updateSettingPo.setSettingId(reqBo.getSettingId());
            updateSettingPo.setStatus(Integer.parseInt("2"));
            this.mmcRelShopSettingMapper.updateByPrimaryKeySelective(updateSettingPo);
        }
        rspBo.setUpdateTime(dbDate);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private MmcAuditRequestAtomReqBo assembleAuditBo(MmcShopSettingUpdateReqBo reqBo, Long settingId) {
        MmcAuditRequestAtomReqBo auditBo = new MmcAuditRequestAtomReqBo();
        auditBo.setProcDefKey(this.shopSettingProKey);
        auditBo.setSysCode(this.approvalSysCode);
        auditBo.setCreateOperId(reqBo.getUpdateOper());
        auditBo.setCreateOperName(reqBo.getUpdateOper());
        auditBo.setRemark("\u5e97\u94fa(" + reqBo.getShopId() + ")\u8bbe\u7f6e\u5ba1\u6279");
        auditBo.setObjId(settingId.toString());
        auditBo.setObjType(Integer.parseInt("2"));
        auditBo.setObjCode(reqBo.getShopId().toString());
        auditBo.setObjName(reqBo.getShopName());
        return auditBo;
    }

    private String validateReqArg(MmcShopSettingUpdateReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (reqBo.getSettingId() == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027settingId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (reqBo.getShopId() == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027shopId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (reqBo.getStatus() == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027status\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

