/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.merchant.mmc.config;

import com.alibaba.druid.pool.DruidDataSource;
import com.ohaotian.plugin.db.OrderSequence;
import com.ohaotian.plugin.db.impl.OrderSequenceImpl;
import com.tydic.merchant.mmc.config.MmcPropertiesManager;
import com.tydic.merchant.mmc.enums.MmcPropertiesEnum;
import com.tydic.merchant.mmc.enums.MmcSequencesEnum;
import com.tydic.merchant.mmc.exception.MmcBusinessException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component(value="mmcSequenceManager")
public class MmcSequenceManager {
    @Autowired
    private MmcPropertiesManager mmcPropertiesManager;
    @Autowired
    private DataSource dataSource;
    private Map<String, OrderSequence> cacheSequenceMap = new HashMap<String, OrderSequence>();
    private Map<String, ConcurrentLinkedQueue<Long>> cacheQueueMap = new HashMap<String, ConcurrentLinkedQueue<Long>>(32);
    private int cacheValueCount = 2000;

    public long nextId(String seqName) throws SQLException {
        ConcurrentLinkedQueue<Long> cacheQueue = this.cacheQueueMap.get(seqName);
        if (cacheQueue == null) {
            throw new MmcBusinessException("9001", "\u8be5\u5e8f\u5217(" + seqName + ")\u672a\u5b9a\u4e49\u5728PaySequenceKeys\u4e2d");
        }
        if (cacheQueue.isEmpty()) {
            this.pushValues(seqName);
        }
        return cacheQueue.poll();
    }

    @PostConstruct
    public void initOrderSequences() {
        String sequenceCacheCount = this.mmcPropertiesManager.getValue(MmcPropertiesEnum.SEQUANCE_CACHE_COUNT.getName());
        if (!StringUtils.isEmpty((Object)sequenceCacheCount)) {
            this.cacheValueCount = Integer.parseInt(sequenceCacheCount);
        }
        for (MmcSequencesEnum seq : MmcSequencesEnum.values()) {
            String seqName = seq.name();
            OrderSequence seqInstantce = this.cacheSequenceMap.get(seqName);
            if (seqInstantce != null) continue;
            this.cacheSequenceMap.put(seqName, (OrderSequence)new OrderSequenceImpl(seqName, (DruidDataSource)this.dataSource));
            this.cacheQueueMap.put(seqName, new ConcurrentLinkedQueue());
        }
    }

    private synchronized void pushValues(String seqName) throws SQLException {
        OrderSequence seqInstantce = this.cacheSequenceMap.get(seqName);
        ConcurrentLinkedQueue<Long> cacheQueue = this.cacheQueueMap.get(seqName);
        if (!cacheQueue.isEmpty()) {
            return;
        }
        long[] ids = seqInstantce.nextIds(this.cacheValueCount);
        LinkedList<Long> idList = new LinkedList<Long>();
        for (long id : ids) {
            idList.add(id);
        }
        cacheQueue.addAll(idList);
    }
}

