/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.merchant.mmc.busi.impl;

import com.tydic.merchant.mmc.ability.bo.MmcShopChannelQueryAbilityDataBo;
import com.tydic.merchant.mmc.atom.api.MmcDicMapQueryAtomService;
import com.tydic.merchant.mmc.atom.bo.MmcDicMapQueryAtomReqBo;
import com.tydic.merchant.mmc.atom.bo.MmcDicMapQueryAtomRspBo;
import com.tydic.merchant.mmc.busi.MmcShopSettingDetailQueryBusiService;
import com.tydic.merchant.mmc.busi.bo.MmcShopSettingDetailQueryBusiReqBo;
import com.tydic.merchant.mmc.busi.bo.MmcShopSettingDetailQueryBusiRspBo;
import com.tydic.merchant.mmc.constants.MmcDictionaryValueConstants;
import com.tydic.merchant.mmc.dao.MmcRelShopChannelMapper;
import com.tydic.merchant.mmc.dao.MmcRelShopSettingMapper;
import com.tydic.merchant.mmc.dao.po.MmcRelShopChannelPo;
import com.tydic.merchant.mmc.dao.po.MmcRelShopSettingPo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="mmcShopSettingDetailQueryBusiService")
public class MmcShopSettingDetailQueryBusiServiceImpl
implements MmcShopSettingDetailQueryBusiService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private MmcRelShopSettingMapper mmcRelShopSettingMapper;
    @Autowired
    private MmcRelShopChannelMapper mmcRelShopChannelMapper;
    @Autowired
    private MmcDicMapQueryAtomService mmcDicMapQueryAtomService;

    public MmcShopSettingDetailQueryBusiRspBo queryShopDetail(MmcShopSettingDetailQueryBusiReqBo reqBo) {
        this.LOGGER.info("\u5e97\u94fa\u8bbe\u7f6e\u4e2d\u8be6\u60c5\u67e5\u8be2 busi\u670d\u52a1\uff1a" + reqBo);
        MmcShopSettingDetailQueryBusiRspBo retBo = new MmcShopSettingDetailQueryBusiRspBo();
        String validateStr = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            this.LOGGER.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            retBo.setRespCode("112013");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        MmcRelShopSettingPo reqPo = new MmcRelShopSettingPo();
        BeanUtils.copyProperties((Object)reqBo, (Object)reqPo);
        reqPo.setStatus(Integer.parseInt("1"));
        List<MmcRelShopSettingPo> retPos = this.mmcRelShopSettingMapper.selectByCondition(reqPo);
        if (retPos == null || retPos.isEmpty()) {
            this.LOGGER.error("\u672a\u67e5\u8be2\u5230\u4e0e\u6b64ID(" + reqBo.getShopId() + ")\u76f8\u5339\u914d\u7684\u6570\u636e");
            retBo.setRespCode("112013");
            retBo.setRespDesc("\u672a\u67e5\u8be2\u5230\u4e0e\u6b64ID(" + reqBo.getShopId() + ")\u76f8\u5339\u914d\u7684\u6570\u636e");
            return retBo;
        }
        Map<String, Map<String, String>> dicMap = this.queryDicMap(reqBo);
        MmcRelShopChannelPo relShopChannelPo = new MmcRelShopChannelPo();
        relShopChannelPo.setShopId(reqBo.getShopId());
        relShopChannelPo.setSettingId(retPos.get(0).getSettingId());
        relShopChannelPo.setType(MmcDictionaryValueConstants.REL_SHOP_CHANNEL_TYPE_SETTING);
        List<MmcRelShopChannelPo> relList = this.mmcRelShopChannelMapper.selectByCondition(relShopChannelPo);
        ArrayList<MmcShopChannelQueryAbilityDataBo> channelList = new ArrayList<MmcShopChannelQueryAbilityDataBo>();
        if (!CollectionUtils.isEmpty(relList)) {
            for (MmcRelShopChannelPo channelPo : relList) {
                MmcShopChannelQueryAbilityDataBo channelBo = new MmcShopChannelQueryAbilityDataBo();
                channelBo.setChannelId(channelPo.getChannel());
                channelBo.setChannelName(dicMap.get("REL_SHOP_SETTING_CHANNEL").get(channelPo.getChannel() + ""));
                channelList.add(channelBo);
            }
        }
        BeanUtils.copyProperties((Object)retPos.get(0), (Object)retBo);
        retBo.setStatusName(dicMap.get("REL_SHOP_SETTING_STATUS").get(retBo.getStatus() + ""));
        retBo.setChannel(channelList);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private Map<String, Map<String, String>> queryDicMap(MmcShopSettingDetailQueryBusiReqBo reqBo) {
        ArrayList<String> typeList = new ArrayList<String>();
        typeList.add("REL_SHOP_SETTING_STATUS");
        typeList.add("REL_SHOP_SETTING_CHANNEL");
        HashMap<String, Map<String, String>> dicMap = new HashMap<String, Map<String, String>>(16);
        MmcDicMapQueryAtomReqBo dicMapReqBo = new MmcDicMapQueryAtomReqBo();
        for (String type : typeList) {
            dicMapReqBo.setType(type);
            MmcDicMapQueryAtomRspBo dicMapRetBo = this.mmcDicMapQueryAtomService.qryDicMap(dicMapReqBo);
            if (!"0000".equals(dicMapRetBo.getRespCode())) {
                this.LOGGER.error("\u83b7\u53d6type= " + type + "\u7684\u503c\u53ca\u7ffb\u8bd1map\u5931\u8d25");
                continue;
            }
            Map<String, String> valueMap = dicMapRetBo.getDicMap();
            dicMap.put(type, valueMap);
        }
        return dicMap;
    }

    private String validateArgs(MmcShopSettingDetailQueryBusiReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getShopId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'shopId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

