/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.busi;

import com.tydic.nbchat.train.mapper.PptCreationRecordMapper;
import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import com.tydic.nicc.dc.boot.starter.util.DateTimeUtil;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PptCounterBusiService {
    private static final Logger log = LoggerFactory.getLogger(PptCounterBusiService.class);
    private final RedisHelper redisHelper;
    @Resource
    private PptCreationRecordMapper pptCreationRecordMapper;

    public PptCounterBusiService(RedisHelper redisHelper) {
        this.redisHelper = redisHelper;
    }

    private static String getPptCounterDayKey(String userId, String pptType) {
        String day = DateTimeUtil.getTimeShortString((Date)new Date(), (String)"yyyyMMdd");
        return "nbchat-train:ppt_count_" + pptType + ":" + day + ":" + userId;
    }

    public void incrementPptCounter(String tenantCode, String userId, String pptType) {
        if (!"00000000".equals(tenantCode)) {
            return;
        }
        try {
            String key = PptCounterBusiService.getPptCounterDayKey(userId, pptType);
            this.redisHelper.incr(key, 1L);
            this.redisHelper.expire(key, 86400L);
        }
        catch (Exception e) {
            log.error("Failed to increment PPT counter for user: {}", (Object)userId, (Object)e);
        }
    }

    public long getPptCounter(String userId, String pptType) {
        try {
            return this.pptCreationRecordMapper.countTodayPpt("00000000", userId, pptType);
        }
        catch (Exception e) {
            log.error("Failed to get PPT counter for user: {}", (Object)userId, (Object)e);
            return 0L;
        }
    }
}

