/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.busi;

import com.tydic.nbchat.train.api.bo.eums.AnchorType;
import com.tydic.nbchat.train.api.bo.eums.CustomizeStatusEnum;
import com.tydic.nbchat.train.api.bo.tdh.TdhCustomizeRecordQueryReqBO;
import com.tydic.nbchat.train.api.bo.tdh.TdhVirtualAnchorQueryReqBO;
import com.tydic.nbchat.train.mapper.TdhVirtualAnchorMapper;
import com.tydic.nbchat.train.mapper.po.TdhVirtualAnchor;
import com.tydic.nicc.dc.boot.starter.util.DateTimeUtil;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class TdhAnchorBusiService {
    private static final Logger log = LoggerFactory.getLogger(TdhAnchorBusiService.class);
    @Resource
    private TdhVirtualAnchorMapper virtualAnchorMapper;

    public TdhVirtualAnchor addAnchor(TdhCustomizeRecordQueryReqBO request) {
        TdhVirtualAnchor anchor = new TdhVirtualAnchor();
        anchor.setAnchorId(IdWorker.nextAutoIdStr());
        anchor.setTenantCode(request.getTenantCode());
        anchor.setUserId(request.getUserId());
        anchor.setName(request.getVoiceName());
        anchor.setAnchorConfig(AnchorType.COSYVOICE.getCode());
        anchor.setOrderNo(request.getOrderNo());
        anchor.setCustomizeStatus(CustomizeStatusEnum.ORDER_CREATE.getCode());
        if (StringUtils.isEmpty((CharSequence)request.getVolcId())) {
            anchor.setVoice("cvo_" + DateTimeUtil.getTimeShortString((Date)new Date(), (String)"yyyyMMddHHmmss"));
        } else {
            anchor.setVoice(request.getVolcId());
        }
        anchor.setDemoUrl(request.getVoiceDemo());
        anchor.setCreateTime(new Date());
        anchor.setAnchorSource("1");
        anchor.setCategory("\u5b9a\u5236");
        anchor.setType("\u901a\u7528\u573a\u666f");
        anchor.setLanguage("\u4e2d\u6587");
        this.virtualAnchorMapper.insertSelective(anchor);
        return anchor;
    }

    public void add(TdhVirtualAnchorQueryReqBO request) {
        TdhVirtualAnchor po = new TdhVirtualAnchor();
        BeanUtils.copyProperties((Object)request, (Object)po);
        if (StringUtils.isEmpty((CharSequence)request.getAnchorId())) {
            this.virtualAnchorMapper.insertSelective(po);
        } else {
            this.virtualAnchorMapper.update(po);
        }
    }

    public void updateAnchor(TdhVirtualAnchorQueryReqBO request) {
        if (StringUtils.isEmpty((CharSequence)request.getOrderNo())) {
            log.info("\u66f4\u65b0\u6570\u5b57\u4eba\u4fe1\u606f\u5931\u8d25\uff0corderNo\u4e3a\u7a7a");
            return;
        }
        TdhVirtualAnchor po = new TdhVirtualAnchor();
        BeanUtils.copyProperties((Object)request, (Object)po);
        this.virtualAnchorMapper.updateByOrderNo(po);
    }
}

