/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.config;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.impl.LaissezFaireSubTypeValidator;
import java.time.Duration;
import java.util.HashMap;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.serializer.Jackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@Configuration
@EnableCaching
public class CacheConfig {
    @Bean
    public CacheManager cacheManager(RedisConnectionFactory redisConnectionFactory) {
        Jackson2JsonRedisSerializer jackson2JsonRedisSerializer = new Jackson2JsonRedisSerializer(Object.class);
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
        objectMapper.activateDefaultTyping((PolymorphicTypeValidator)LaissezFaireSubTypeValidator.instance, ObjectMapper.DefaultTyping.NON_FINAL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES, false);
        jackson2JsonRedisSerializer.setObjectMapper(objectMapper);
        RedisCacheConfiguration defaultConfig = RedisCacheConfiguration.defaultCacheConfig().entryTtl(Duration.ofHours(1L)).serializeKeysWith(RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)new StringRedisSerializer())).serializeValuesWith(RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)jackson2JsonRedisSerializer)).disableCachingNullValues();
        HashMap<String, RedisCacheConfiguration> cacheConfigurations = new HashMap<String, RedisCacheConfiguration>();
        cacheConfigurations.put("nbchat-train:tdh_virtual_human", defaultConfig.entryTtl(Duration.ofHours(2L)));
        cacheConfigurations.put("nbchat-train:tdh_template", defaultConfig.entryTtl(Duration.ofHours(4L)));
        cacheConfigurations.put("nbchat-train:tdh_virtual_anchor", defaultConfig.entryTtl(Duration.ofHours(2L)));
        cacheConfigurations.put("nbchat-train:tdh_foreground", defaultConfig.entryTtl(Duration.ofHours(6L)));
        cacheConfigurations.put("nbchat-train:tdh_background", defaultConfig.entryTtl(Duration.ofHours(6L)));
        cacheConfigurations.put("nbchat-train:tdh_audio", defaultConfig.entryTtl(Duration.ofHours(4L)));
        cacheConfigurations.put("nbchat-train:tdh_ai_match", defaultConfig.entryTtl(Duration.ofMinutes(30L)));
        return RedisCacheManager.builder((RedisConnectionFactory)redisConnectionFactory).cacheDefaults(defaultConfig).withInitialCacheConfigurations(cacheConfigurations).build();
    }
}

