/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.config;

import com.alibaba.fastjson.JSON;
import java.lang.reflect.Method;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.StringJoiner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.stereotype.Component;

@Component(value="customCacheKeyGenerator")
public class CustomCacheKeyGenerator
implements KeyGenerator {
    private static final Logger log = LoggerFactory.getLogger(CustomCacheKeyGenerator.class);

    public Object generate(Object target, Method method, Object ... params) {
        try {
            String baseKey = target.getClass().getSimpleName() + "." + method.getName();
            if (params == null || params.length == 0) {
                return baseKey + ":noParams";
            }
            StringJoiner paramsJoiner = new StringJoiner(":");
            for (Object param : params) {
                if (param == null) {
                    paramsJoiner.add("null");
                    continue;
                }
                if (this.isSimpleType(param)) {
                    paramsJoiner.add(param.toString());
                    continue;
                }
                String jsonString = JSON.toJSONString((Object)param);
                String md5 = this.stringToMD5(jsonString);
                paramsJoiner.add(md5);
            }
            String paramString = paramsJoiner.toString();
            String finalKey = baseKey + ":" + this.stringToMD5(paramString);
            log.debug("\u751f\u6210\u7f13\u5b58Key: {} -> {}", (Object)baseKey, (Object)finalKey);
            return finalKey;
        }
        catch (Exception e) {
            log.error("\u751f\u6210\u7f13\u5b58Key\u5931\u8d25", (Throwable)e);
            return target.getClass().getSimpleName() + "." + method.getName() + ":" + Arrays.hashCode(params);
        }
    }

    private boolean isSimpleType(Object obj) {
        Class<?> clazz = obj.getClass();
        return clazz.isPrimitive() || clazz == String.class || clazz == Boolean.class || clazz == Character.class || clazz == Byte.class || clazz == Short.class || clazz == Integer.class || clazz == Long.class || clazz == Float.class || clazz == Double.class || Number.class.isAssignableFrom(clazz);
    }

    private String stringToMD5(String plainText) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(plainText.getBytes());
            byte[] digest = md.digest();
            StringBuilder sb = new StringBuilder();
            for (byte b : digest) {
                sb.append(String.format("%02x", b & 0xFF));
            }
            return sb.toString();
        }
        catch (Exception e) {
            log.warn("MD5\u8ba1\u7b97\u5931\u8d25\uff0c\u4f7f\u7528hashCode\u66ff\u4ee3: {}", (Object)e.getMessage());
            return String.valueOf(plainText.hashCode());
        }
    }
}

