/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.aliyuncs.CommonRequest;
import com.aliyuncs.CommonResponse;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.http.ProtocolType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.tydic.nbchat.train.core.config.AliAkskConfigProperties;
import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import com.tydic.nicc.dc.boot.starter.util.DateTimeUtil;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AliAccessTokenHelper {
    private static final Logger log = LoggerFactory.getLogger(AliAccessTokenHelper.class);
    private final AliAkskConfigProperties aliConfigProperties;
    private final RedisHelper redisHelper;
    private static final String REGIONID = "cn-shanghai";
    private static final String DOMAIN = "nls-meta.cn-shanghai.aliyuncs.com";
    private static final String API_VERSION = "2019-02-28";
    private static final String REQUEST_ACTION = "CreateToken";
    private static final String KEY_TOKEN = "Token";
    private static final String KEY_ID = "Id";
    private static final String KEY_EXPIRETIME = "ExpireTime";
    private static final String NBCHAT_NLS_TOKEN = "NBCHAT_NLS_TOKEN";
    private IAcsClient iAcsClient;
    private DefaultProfile profile;

    public IAcsClient getiAcsClient() {
        return this.iAcsClient;
    }

    public AliAccessTokenHelper(AliAkskConfigProperties aliConfigProperties, RedisHelper redisHelper) {
        this.aliConfigProperties = aliConfigProperties;
        this.redisHelper = redisHelper;
        this.profile = DefaultProfile.getProfile((String)REGIONID, (String)aliConfigProperties.getAccessKey(), (String)aliConfigProperties.getSecretKey());
        this.iAcsClient = new DefaultAcsClient((IClientProfile)this.profile);
    }

    public String getAccessToken() {
        String token = (String)this.redisHelper.get(NBCHAT_NLS_TOKEN);
        if (StringUtils.isBlank((CharSequence)token)) {
            log.info("\u5237\u65b0token - \u5f00\u59cb...");
            token = this.flashAccessToken();
        }
        return token;
    }

    public String flashAccessToken() {
        DefaultAcsClient client = new DefaultAcsClient((IClientProfile)this.profile);
        CommonRequest request = new CommonRequest();
        request.setDomain(DOMAIN);
        request.setVersion(API_VERSION);
        request.setAction(REQUEST_ACTION);
        request.setMethod(MethodType.POST);
        request.setProtocol(ProtocolType.HTTPS);
        CommonResponse response = null;
        try {
            response = client.getCommonResponse(request);
        }
        catch (ClientException e) {
            log.warn("\u5237\u65b0token - \u5f02\u5e38:{}", (Object)request, (Object)e);
            try {
                response = client.getCommonResponse(request);
            }
            catch (ClientException ex) {
                log.error("\u5237\u65b0token - \u91cd\u8bd5\u5f02\u5e38:{}", (Object)request, (Object)ex);
            }
        }
        String token = "";
        if (response.getHttpStatus() == 200) {
            JSONObject result = JSON.parseObject((String)response.getData());
            token = result.getJSONObject(KEY_TOKEN).getString(KEY_ID);
            long expireTime = result.getJSONObject(KEY_TOKEN).getLongValue(KEY_EXPIRETIME) * 1000L;
            String expireDate = DateTimeUtil.getTimeShortString((Date)new Date(expireTime), (String)"yyyy-MM-dd HH:mm:ss");
            log.info("\u5237\u65b0token - \u83b7\u53d6\u5230\u7684Token: {}\uff0cexpireDate: {}", (Object)token, (Object)expireDate);
            long expSec = (expireTime - System.currentTimeMillis()) / 1000L;
            this.redisHelper.set(NBCHAT_NLS_TOKEN, (Object)token, expSec - 60L);
        } else {
            try {
                TimeUnit.SECONDS.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.flashAccessToken();
        }
        return token;
    }
}

