/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.aliyuncs.CommonRequest;
import com.aliyuncs.CommonResponse;
import com.aliyuncs.http.FormatType;
import com.aliyuncs.http.MethodType;
import com.tydic.nbchat.train.api.CourseVoiceAsrListener;
import com.tydic.nbchat.train.api.CourseVoiceListener;
import com.tydic.nbchat.train.api.NbchatTrainSectionApi;
import com.tydic.nbchat.train.api.bo.asr_tts.AsrVoiceResult;
import com.tydic.nbchat.train.api.bo.asr_tts.AsrVoiceTaskContext;
import com.tydic.nbchat.train.api.bo.asr_tts.AsrVoiceTaskRequest;
import com.tydic.nbchat.train.api.bo.asr_tts.TtsVoiceResult;
import com.tydic.nbchat.train.api.bo.asr_tts.TtsVoiceTaskContext;
import com.tydic.nbchat.train.api.bo.asr_tts.TtsVoiceTaskRequest;
import com.tydic.nbchat.train.api.bo.eums.AnchorType;
import com.tydic.nbchat.train.api.bo.listener.CourseVoiceAsrOnSuccess;
import com.tydic.nbchat.train.api.bo.listener.CourseVoiceOnError;
import com.tydic.nbchat.train.api.bo.listener.CourseVoiceOnSuccess;
import com.tydic.nbchat.train.core.config.AliTtsConfigProperties;
import com.tydic.nbchat.train.core.helper.AliAccessTokenHelper;
import com.tydic.nbchat.train.core.helper.NlsHelperApi;
import com.tydic.nbchat.train.core.util.TrainCommonUtil;
import com.tydic.nbchat.train.mapper.NbchatTrainCourseMapper;
import com.tydic.nbchat.train.mapper.NbchatTrainSectionsMapper;
import com.tydic.nbchat.train.mapper.po.NbchatTrainCourse;
import com.tydic.nbchat.train.mapper.po.NbchatTrainSections;
import com.tydic.nicc.dc.base.bo.Rsp;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AliAsrTtsHelper
implements NlsHelperApi {
    private static final Logger log = LoggerFactory.getLogger(AliAsrTtsHelper.class);
    private static final String ASR_FILETRANS_DOMAN = "filetrans.cn-shanghai.aliyuncs.com";
    private static final String ASR_FILETRANS_PRODUCT = "nls-filetrans";
    private final AliAccessTokenHelper aliAccessTokenHelper;
    private final AliTtsConfigProperties aliTtsConfigProperties;
    private final CourseVoiceListener courseVoiceListener;
    private final CourseVoiceAsrListener courseVoiceAsrListener;
    private final NbchatTrainSectionApi nbchatTrainSectionApi;
    @Resource
    NbchatTrainCourseMapper nbchatTrainCourseMapper;
    @Resource
    NbchatTrainSectionsMapper nbchatTrainSectionsMapper;

    public AliAsrTtsHelper(AliAccessTokenHelper aliAccessTokenHelper, AliTtsConfigProperties aliTtsConfigProperties, @Autowired(required=false) CourseVoiceListener courseVoiceListener, @Autowired(required=false) CourseVoiceAsrListener courseVoiceAsrListener, NbchatTrainSectionApi nbchatTrainSectionApi) {
        this.aliAccessTokenHelper = aliAccessTokenHelper;
        this.aliTtsConfigProperties = aliTtsConfigProperties;
        this.courseVoiceListener = courseVoiceListener;
        this.courseVoiceAsrListener = courseVoiceAsrListener;
        this.nbchatTrainSectionApi = nbchatTrainSectionApi;
        log.info("\u521d\u59cb\u5316tts\u914d\u7f6e:{}", (Object)aliTtsConfigProperties);
    }

    @Override
    public String anchorConfig() {
        return AnchorType.ALI.getCode();
    }

    @Override
    public void createAudioTask(String courseId, String sectionId, boolean courseAll) {
        if (!courseAll && StringUtils.isNotEmpty((CharSequence)courseId)) {
            NbchatTrainCourse course = this.nbchatTrainCourseMapper.selectByPrimaryKey(courseId);
            this.createAudioTask(courseId, null, course.getCourseDesc(), true);
        }
        if (StringUtils.isNotEmpty((CharSequence)sectionId)) {
            Rsp rsp = this.nbchatTrainSectionApi.querySection(sectionId);
            this.createAudioTask(null, sectionId, (String)rsp.getData(), true);
        }
        if (courseAll && StringUtils.isNotEmpty((CharSequence)courseId)) {
            List nbchatTrainSections = this.nbchatTrainSectionsMapper.selectBySectionIds(courseId, null);
            for (NbchatTrainSections section : nbchatTrainSections) {
                Rsp rsp = this.nbchatTrainSectionApi.querySection(section.getSectionId());
                this.createAudioTask(null, section.getSectionId(), (String)rsp.getData(), true);
            }
        }
    }

    @Override
    public AsrVoiceTaskContext createAsrTask(AsrVoiceTaskRequest request) {
        return this.createAsrTask(request.getCourseId(), request.getFileId(), request.getFilePath(), false);
    }

    @Override
    public AsrVoiceTaskContext createAsrTask(String courseId, String fileId, String filepath, boolean async) {
        CommonRequest postRequest = new CommonRequest();
        postRequest.setDomain(ASR_FILETRANS_DOMAN);
        postRequest.setVersion("2018-08-17");
        postRequest.setAction("SubmitTask");
        postRequest.setProduct(ASR_FILETRANS_PRODUCT);
        postRequest.setHttpContentType(FormatType.JSON);
        JSONObject taskObject = new JSONObject();
        taskObject.put("appkey", (Object)this.aliTtsConfigProperties.getAppKey());
        taskObject.put("file_link", (Object)filepath);
        taskObject.put("version", (Object)"4.0");
        String task = taskObject.toJSONString();
        postRequest.putBodyParameter("Task", (Object)task);
        postRequest.setMethod(MethodType.POST);
        Object err = "\u4efb\u52a1\u6267\u884c\u5f02\u5e38:";
        AsrVoiceTaskContext context = new AsrVoiceTaskContext();
        context.setCourseId(courseId);
        try {
            log.info("\u5f55\u97f3\u6587\u4ef6\u8bc6\u522b[{}]-\u4efb\u52a1\u521b\u5efa-\u5f00\u59cb:{}", (Object)courseId, (Object)filepath);
            CommonResponse postResponse = this.aliAccessTokenHelper.getiAcsClient().getCommonResponse(postRequest);
            log.info("\u5f55\u97f3\u6587\u4ef6\u8bc6\u522b[{}]-\u4efb\u52a1\u521b\u5efa-\u5b8c\u6210:{}", (Object)courseId, (Object)postResponse.getData());
            if (postResponse.getHttpStatus() == 200) {
                JSONObject result = JSONObject.parseObject((String)postResponse.getData());
                String statusText = result.getString("StatusText");
                if ("SUCCESS".equals(statusText)) {
                    String taskId = result.getString("TaskId");
                    log.info("\u5f55\u97f3\u6587\u4ef6\u8bc6\u522b[{}]-\u62c9\u53d6\u4efb\u52a1-\u5f00\u59cb:{}", (Object)courseId, (Object)taskId);
                    if (async) {
                        new Thread(() -> this.getAsrTaskResult(courseId, fileId, taskId)).start();
                        context.setTaskId(taskId);
                        return context;
                    }
                    return this.getAsrTaskResult(courseId, fileId, taskId);
                }
            } else {
                err = (String)err + postResponse.getHttpStatus();
            }
        }
        catch (Exception e) {
            log.info("\u5f55\u97f3\u6587\u4ef6\u8bc6\u522b[{}]-\u5f02\u5e38:", (Object)courseId, (Object)e);
            err = e.getMessage();
        }
        CourseVoiceOnError onError = CourseVoiceOnError.builder().courseId(courseId).fileId(fileId).error((String)err).build();
        Optional.ofNullable(this.courseVoiceAsrListener).ifPresent(listener -> listener.onError(onError));
        return context;
    }

    @Override
    public TtsVoiceTaskContext createAudioTask(TtsVoiceTaskRequest taskRequest) {
        String text = taskRequest.getText();
        String voice = taskRequest.getVoice();
        String sectionId = taskRequest.getSectionId();
        String courseId = taskRequest.getCourseId();
        boolean async = taskRequest.isAsync();
        Integer volume = taskRequest.getVolume();
        Integer speech_rate = taskRequest.getSpeechRate();
        Integer pitch_rate = taskRequest.getPitchRate();
        TtsVoiceTaskContext ttsVoiceTaskContext = new TtsVoiceTaskContext();
        String appKey = this.aliTtsConfigProperties.getAppKey();
        String token = this.aliAccessTokenHelper.getAccessToken();
        String url = this.aliTtsConfigProperties.getTtsApi();
        JSONObject context = new JSONObject();
        context.put("device_id", (Object)"dyc_nbchat_train");
        JSONObject header = new JSONObject();
        header.put("appkey", (Object)appKey);
        header.put("token", (Object)token);
        JSONObject tts = new JSONObject();
        text = text.replace("&", "");
        tts.put("text", (Object)TrainCommonUtil.trimXmlTagName(text, "emotion"));
        tts.put("voice", (Object)voice);
        if (volume != null) {
            tts.put("volume", (Object)volume);
        }
        if (speech_rate != null) {
            tts.put("speech_rate", (Object)speech_rate);
        }
        if (pitch_rate != null) {
            tts.put("pitch_rate", (Object)pitch_rate);
        }
        tts.put("format", (Object)this.aliTtsConfigProperties.getFormat());
        tts.put("sample_rate", (Object)this.aliTtsConfigProperties.getSampleRate());
        tts.put("enable_subtitle", (Object)true);
        JSONObject payload = new JSONObject();
        payload.put("enable_notify", (Object)false);
        payload.put("notify_url", (Object)this.aliTtsConfigProperties.getNotifyUrl());
        payload.put("tts_request", (Object)tts);
        JSONObject json = new JSONObject();
        json.put("context", (Object)context);
        json.put("header", (Object)header);
        json.put("payload", (Object)payload);
        String bodyContent = json.toJSONString();
        log.info("\u8bed\u97f3\u5408\u6210-\u4efb\u52a1\u5f00\u59cb[{}]: {}", (Object)sectionId, (Object)bodyContent);
        RequestBody reqBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)bodyContent);
        Request request = new Request.Builder().url(url).header("Content-Type", "application/json").post(reqBody).build();
        try {
            OkHttpClient client = new OkHttpClient();
            Response response = client.newCall(request).execute();
            String result = response.body().string();
            response.close();
            log.info("\u8bed\u97f3\u5408\u6210-\u4efb\u52a1\u7ed3\u679c[{}]: {}", (Object)sectionId, (Object)result);
            JSONObject resultJson = JSON.parseObject((String)result);
            if (resultJson.containsKey((Object)"error_code") && resultJson.getIntValue("error_code") == 20000000) {
                String taskId = resultJson.getJSONObject("data").getString("task_id");
                String requestId = resultJson.getString("request_id");
                log.info("\u8bed\u97f3\u5408\u6210-\u83b7\u53d6\u4efb\u52a1\u4fe1\u606f[{}]: task_id = {},request_id = {}", new Object[]{sectionId, taskId, requestId});
                if (async) {
                    new Thread(() -> this.getAudioResult(courseId, sectionId, taskId, requestId)).start();
                } else {
                    ttsVoiceTaskContext = this.getAudioResult(courseId, sectionId, taskId, requestId);
                }
            } else {
                String error = resultJson.getString("error_message");
                log.error("\u8bed\u97f3\u5408\u6210-\u4efb\u52a1\u5f02\u5e38[{}]: status={}, error_code={}, error_message={}", new Object[]{sectionId, resultJson.getIntValue("status"), resultJson.getIntValue("error_code"), error});
                CourseVoiceOnError onError = CourseVoiceOnError.builder().sectionId(sectionId).error(error).build();
                Optional.ofNullable(this.courseVoiceListener).ifPresent(listener -> listener.onError(onError));
            }
        }
        catch (Exception e) {
            CourseVoiceOnError onError = CourseVoiceOnError.builder().sectionId(sectionId).error(e.getMessage()).build();
            Optional.ofNullable(this.courseVoiceListener).ifPresent(listener -> listener.onError(onError));
            log.error("\u8bed\u97f3\u5408\u6210-\u4efb\u52a1\u5f02\u5e38[{}]: ", (Object)sectionId, (Object)e);
        }
        ttsVoiceTaskContext.setCourseId(courseId);
        ttsVoiceTaskContext.setSectionId(sectionId);
        return ttsVoiceTaskContext;
    }

    @Override
    public TtsVoiceTaskContext createAudioTask(String courseId, String sectionId, String text, boolean async) {
        return this.createAudioTask(courseId, sectionId, text, this.aliTtsConfigProperties.getVoice(), async);
    }

    @Override
    public TtsVoiceTaskContext createAudioTask(String courseId, String sectionId, String text, String voice, boolean async) {
        TtsVoiceTaskRequest taskRequest = new TtsVoiceTaskRequest();
        taskRequest.setCourseId(courseId);
        taskRequest.setSectionId(sectionId);
        taskRequest.setText(text);
        taskRequest.setVoice(voice);
        taskRequest.setAsync(async);
        return this.createAudioTask(taskRequest);
    }

    private TtsVoiceTaskContext getAudioResult(String courseId, String sectionId, String taskId, String requestId) {
        String appKey = this.aliTtsConfigProperties.getAppKey();
        String token = this.aliAccessTokenHelper.getAccessToken();
        String fullUrl = this.aliTtsConfigProperties.getTtsApi() + "?appkey=" + appKey + "&task_id=" + taskId + "&token=" + token + "&request_id=" + requestId;
        String address = "";
        log.info("\u8bed\u97f3\u5408\u6210-\u83b7\u53d6\u5f55\u97f3[{}]: {}", (Object)sectionId, (Object)fullUrl);
        TtsVoiceTaskContext context = new TtsVoiceTaskContext();
        while (true) {
            Request request = new Request.Builder().url(fullUrl).get().build();
            try {
                OkHttpClient client = new OkHttpClient();
                Response response = client.newCall(request).execute();
                String result = response.body().string();
                response.close();
                log.info("\u8bed\u97f3\u5408\u6210-\u83b7\u53d6\u5f55\u97f3-\u7ed3\u679c[{}]: {}", (Object)sectionId, (Object)result);
                JSONObject resultJson = JSON.parseObject((String)result);
                if (resultJson.containsKey((Object)"error_code") && resultJson.getIntValue("error_code") == 40000000 && resultJson.containsKey((Object)"data") && resultJson.getJSONObject("data") == null) {
                    log.warn("\u8bed\u97f3\u5408\u6210-\u5931\u8d25: {}", (Object)resultJson);
                    break;
                }
                if (resultJson.containsKey((Object)"error_code") && resultJson.getIntValue("error_code") == 20000000 && resultJson.containsKey((Object)"data") && resultJson.getJSONObject("data").getString("audio_address") != null) {
                    context = (TtsVoiceTaskContext)resultJson.getObject("data", TtsVoiceTaskContext.class);
                    Optional.ofNullable(context.getSentences()).ifPresent(sens -> {
                        for (TtsVoiceResult voiceResult : sens) {
                            String txt = TrainCommonUtil.removeXMLTags(voiceResult.getText()).trim();
                            voiceResult.setText(txt);
                        }
                    });
                    address = context.getAudio_address();
                    log.info("\u8bed\u97f3\u5408\u6210-\u83b7\u53d6\u5f55\u97f3-\u5730\u5740[{}]: {}", (Object)sectionId, (Object)address);
                    break;
                }
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                log.error("\u8bed\u97f3\u5408\u6210-\u83b7\u53d6\u5f55\u97f3-\u5f02\u5e38[{}]: taskId = {}, requestId = {}", new Object[]{sectionId, taskId, requestId, e});
                CourseVoiceOnError onError = CourseVoiceOnError.builder().sectionId(sectionId).taskId(taskId).error(e.getMessage()).build();
                Optional.ofNullable(this.courseVoiceListener).ifPresent(listener -> listener.onError(onError));
            }
        }
        CourseVoiceOnSuccess onSuccess = CourseVoiceOnSuccess.builder().courseId(courseId).sectionId(sectionId).taskId(taskId).address(address).build();
        TtsVoiceTaskContext finalContext = context;
        Optional.ofNullable(this.courseVoiceListener).ifPresent(listener -> finalContext.setAudio_address(listener.onSuccess(onSuccess)));
        return finalContext;
    }

    public AsrVoiceTaskContext getAsrTaskResult(String courseId, String fileId, String taskId) {
        AsrVoiceTaskContext context;
        block4: {
            CommonRequest getRequest = new CommonRequest();
            getRequest.setDomain(ASR_FILETRANS_DOMAN);
            getRequest.setVersion("2018-08-17");
            getRequest.setAction("GetTaskResult");
            getRequest.setProduct(ASR_FILETRANS_PRODUCT);
            getRequest.putQueryParameter("TaskId", taskId);
            getRequest.setMethod(MethodType.GET);
            context = new AsrVoiceTaskContext();
            try {
                JSONObject result;
                String statusText = "";
                context.setCourseId(courseId);
                while (true) {
                    Thread.sleep(1000L);
                    log.info("\u5f55\u97f3\u6587\u4ef6\u8bc6\u522b[{}]-\u4efb\u52a1\u67e5\u8be2:{}", (Object)courseId, (Object)taskId);
                    CommonResponse getResponse = this.aliAccessTokenHelper.getiAcsClient().getCommonResponse(getRequest);
                    if (getResponse.getHttpStatus() != 200) {
                        log.info("\u5f55\u97f3\u6587\u4ef6\u8bc6\u522b[{}]-\u4efb\u52a1\u5931\u8d25:{}", (Object)courseId, (Object)getResponse.getData());
                        break block4;
                    }
                    result = JSONObject.parseObject((String)getResponse.getData());
                    statusText = result.getString("StatusText");
                    if (!"RUNNING".equals(statusText) && !"QUEUEING".equals(statusText)) break;
                    log.info("\u5f55\u97f3\u6587\u4ef6\u8bc6\u522b[{}]-\u4efb\u52a1\u72b6\u6001:{}", (Object)courseId, (Object)statusText);
                }
                log.info("\u5f55\u97f3\u6587\u4ef6\u8bc6\u522b[{}]-\u4efb\u52a1\u5b8c\u6210:{}", (Object)courseId, (Object)result.toJSONString());
                context = (AsrVoiceTaskContext)result.toJavaObject(AsrVoiceTaskContext.class);
                List sentences = result.getJSONObject("Result").getJSONArray("Sentences").toJavaList(AsrVoiceResult.class);
                context.setSentences(sentences);
                context.setCourseId(courseId);
                CourseVoiceAsrOnSuccess onSuccess = CourseVoiceAsrOnSuccess.builder().courseId(courseId).fileId(fileId).taskContext(context).taskId(taskId).build();
                Optional.ofNullable(this.courseVoiceAsrListener).ifPresent(listener -> listener.onSuccess(onSuccess));
            }
            catch (Exception e) {
                log.error("\u5f55\u97f3\u6587\u4ef6\u8bc6\u522b[{}]-\u4efb\u52a1\u5f02\u5e38:", (Object)courseId, (Object)e);
                CourseVoiceOnError onError = CourseVoiceOnError.builder().taskId(taskId).courseId(courseId).fileId(fileId).error(e.getMessage()).build();
                Optional.ofNullable(this.courseVoiceAsrListener).ifPresent(listener -> listener.onError(onError));
            }
        }
        return context;
    }
}

