/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.helper;

import com.alibaba.excel.write.handler.SheetWriteHandler;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.metadata.holder.WriteWorkbookHolder;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;

public class CustomSheetWriteHandler
implements SheetWriteHandler {
    private final int maxColumn;

    public CustomSheetWriteHandler(int maxColumn) {
        this.maxColumn = maxColumn;
    }

    public void afterSheetCreate(WriteWorkbookHolder writeWorkbookHolder, WriteSheetHolder writeSheetHolder) {
        Sheet sheet = writeSheetHolder.getSheet();
        Workbook workbook = writeWorkbookHolder.getWorkbook();
        sheet.createRow(0);
        CellRangeAddress cellRangeAddress = new CellRangeAddress(0, 0, 0, this.maxColumn - 1);
        sheet.addMergedRegion(cellRangeAddress);
        sheet.setColumnWidth(0, 2816);
        sheet.setColumnWidth(1, 11520);
        sheet.setColumnWidth(2, 2816);
        sheet.setColumnWidth(3, 11520);
        int defaultWidth = 7936;
        for (int i = 4; i < this.maxColumn; ++i) {
            sheet.setColumnWidth(i, defaultWidth);
        }
        Row row = sheet.createRow(0);
        row.setHeight((short)900);
        Cell cell = row.createCell(0);
        cell.setCellValue("\u8bfe\u4ef6\u5e2e-\u8bd5\u9898\u5bfc\u51fa");
        Font font = workbook.createFont();
        font.setFontName("\u5b8b\u4f53");
        font.setFontHeightInPoints((short)20);
        font.setBold(true);
        CellStyle cellStyle = workbook.createCellStyle();
        cellStyle.setFont(font);
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyle.setFillForegroundColor(IndexedColors.LIGHT_YELLOW.getIndex());
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cell.setCellStyle(cellStyle);
    }
}

