/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.nbchat.train.api.bo.asr_tts.AsrVoiceTaskContext;
import com.tydic.nbchat.train.api.bo.asr_tts.AsrVoiceTaskRequest;
import com.tydic.nbchat.train.api.bo.asr_tts.TtsVoiceResult;
import com.tydic.nbchat.train.api.bo.asr_tts.TtsVoiceTaskContext;
import com.tydic.nbchat.train.api.bo.asr_tts.TtsVoiceTaskRequest;
import com.tydic.nbchat.train.api.bo.eums.AnchorType;
import com.tydic.nbchat.train.core.config.CosyVoiceConfigProperties;
import com.tydic.nbchat.train.core.helper.NlsHelperApi;
import com.tydic.nicc.dc.boot.starter.http.RestApiHelper;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CvoNlsHelper
implements NlsHelperApi {
    private static final Logger log = LoggerFactory.getLogger(CvoNlsHelper.class);
    private final CosyVoiceConfigProperties configProperties;
    private final RestApiHelper restApiHelper;

    public CvoNlsHelper(CosyVoiceConfigProperties configProperties, RestApiHelper restApiHelper) {
        this.configProperties = configProperties;
        this.restApiHelper = restApiHelper;
    }

    @Override
    public String anchorConfig() {
        return AnchorType.COSYVOICE.getCode();
    }

    @Override
    public void createAudioTask(String courseId, String sectionId, boolean courseAll) {
    }

    @Override
    public TtsVoiceTaskContext createAudioTask(String courseId, String sectionId, String text, String voice, boolean async) {
        return null;
    }

    @Override
    public TtsVoiceTaskContext createAudioTask(TtsVoiceTaskRequest request) {
        log.info("\u8bed\u97f3\u5408\u6210[{}]-\u4efb\u52a1-\u5f00\u59cb: {}", (Object)this.anchorConfig(), (Object)request);
        String ttsUrl = this.configProperties.getTtsUrl();
        String text = request.getText();
        TtsVoiceTaskContext ttsVoiceTaskContext = new TtsVoiceTaskContext();
        ttsVoiceTaskContext.setSentences(new ArrayList());
        if (StringUtils.isBlank((CharSequence)text)) {
            log.info("\u8bed\u97f3\u5408\u6210-\u4efb\u52a1-\u8bed\u97f3\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\uff01:{}", (Object)request);
            return ttsVoiceTaskContext;
        }
        JSONObject tts = new JSONObject();
        tts.put("tts_name", (Object)"cosy_voice_underline");
        tts.put("content", (Object)text);
        JSONObject obj = new JSONObject();
        obj.put("action", (Object)"a2a");
        obj.put("voice_id", (Object)request.getVoice());
        tts.put("infer_params_user", (Object)obj);
        Integer volume = request.getVolume();
        Integer speech_rate = request.getSpeechRate();
        float volumeRange = NlsHelperApi.convertRange(volume, 1.0f, 0.0f, 100.0f, 0.1f, 2.0f);
        tts.put("volume", (Object)Float.valueOf(volumeRange));
        float speechRange = NlsHelperApi.convertRange(speech_rate, 1.0f, -500.0f, 500.0f, 0.2f, 2.0f);
        tts.put("change_speed", (Object)Float.valueOf(speechRange));
        log.info("\u8bed\u97f3\u5408\u6210[{}]-\u4efb\u52a1-\u8bf7\u6c42: {}", (Object)this.anchorConfig(), (Object)tts);
        try {
            String response = this.restApiHelper.post(ttsUrl, (Object)tts);
            if (JSONObject.isValid((String)response)) {
                JSONObject result = JSON.parseObject((String)response);
                Integer code = result.getInteger("code");
                if (code != 0) {
                    log.error("\u8bed\u97f3\u5408\u6210[{}]-\u4efb\u52a1-\u5931\u8d25: {}|{}", new Object[]{this.anchorConfig(), tts, result});
                }
                JSONObject data = result.getJSONObject("data");
                Integer duration = data.getInteger("duration");
                String url = data.getJSONObject("save").getString("url");
                JSONArray sentences = data.getJSONArray("sentences");
                List ttsVoiceResults = JSONArray.parseArray((String)sentences.toJSONString(), TtsVoiceResult.class);
                ttsVoiceTaskContext.setDuration(duration.intValue());
                ttsVoiceTaskContext.setAudio_address(url);
                ttsVoiceTaskContext.setSentences(ttsVoiceResults);
            } else {
                log.error("\u8bed\u97f3\u5408\u6210[{}]-\u4efb\u52a1-\u5931\u8d25: {}\uff5c{}", new Object[]{this.anchorConfig(), tts, request});
            }
        }
        catch (Exception e) {
            log.error("\u8bed\u97f3\u5408\u6210[{}]-\u4efb\u52a1-\u5f02\u5e38: {}|{}", new Object[]{this.anchorConfig(), tts, request, e});
        }
        return ttsVoiceTaskContext;
    }

    @Override
    public TtsVoiceTaskContext createAudioTask(String courseId, String sectionId, String text, boolean async) {
        return null;
    }

    @Override
    public AsrVoiceTaskContext createAsrTask(String courseId, String fileId, String filepath, boolean async) {
        return null;
    }

    @Override
    public AsrVoiceTaskContext createAsrTask(AsrVoiceTaskRequest request) {
        return null;
    }
}

