/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.helper;

import com.alibaba.fastjson.JSONObject;
import com.tydic.nbchat.train.api.CourseVoiceAsrListener;
import com.tydic.nbchat.train.api.CourseVoiceListener;
import com.tydic.nbchat.train.api.bo.asr_tts.AsrVoiceTaskContext;
import com.tydic.nbchat.train.api.bo.asr_tts.AsrVoiceTaskRequest;
import com.tydic.nbchat.train.api.bo.asr_tts.TtsVoiceTaskContext;
import com.tydic.nbchat.train.api.bo.asr_tts.TtsVoiceTaskRequest;
import com.tydic.nbchat.train.api.bo.eums.AnchorType;
import com.tydic.nbchat.train.api.bo.listener.CourseVoiceOnSuccess;
import com.tydic.nbchat.train.core.config.MobvoiConfigProperties;
import com.tydic.nbchat.train.core.helper.NlsHelperApi;
import com.tydic.nbchat.train.core.util.HttpClientUtil;
import com.tydic.nbchat.train.core.util.SrtToJsonConverter;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MobvoiNlsHelper
implements NlsHelperApi {
    private static final Logger log = LoggerFactory.getLogger(MobvoiNlsHelper.class);
    private static final String TTS_URL = "https://open.mobvoi.com/api/tts/v1";
    private final MobvoiConfigProperties configProperties;
    private final CourseVoiceListener courseVoiceListener;
    private final CourseVoiceAsrListener courseVoiceAsrListener;

    public MobvoiNlsHelper(MobvoiConfigProperties configProperties, CourseVoiceListener courseVoiceListener, CourseVoiceAsrListener courseVoiceAsrListener) {
        this.configProperties = configProperties;
        this.courseVoiceListener = courseVoiceListener;
        this.courseVoiceAsrListener = courseVoiceAsrListener;
    }

    @Override
    public String anchorConfig() {
        return AnchorType.MOBVOI.getCode();
    }

    @Override
    public void createAudioTask(String courseId, String sectionId, boolean courseAll) {
    }

    @Override
    public TtsVoiceTaskContext createAudioTask(String courseId, String sectionId, String text, String voice, boolean async) {
        TtsVoiceTaskRequest request = new TtsVoiceTaskRequest();
        request.setCourseId(courseId);
        request.setSectionId(sectionId);
        request.setText(text);
        request.setVoice(voice);
        request.setAsync(async);
        return this.createAudioTask(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TtsVoiceTaskContext createAudioTask(TtsVoiceTaskRequest request) {
        String taskId = NiccCommonUtil.createMsgId();
        JSONObject tts = new JSONObject();
        long timestamp = System.currentTimeMillis() / 1000L;
        String signature = this.configProperties.getAppKey() + this.configProperties.getSecretKey() + timestamp;
        tts.put("signature", (Object)NiccCommonUtil.stringToMD5((String)signature));
        tts.put("timestamp", (Object)timestamp);
        tts.put("appkey", (Object)this.configProperties.getAppKey());
        tts.put("speaker", (Object)request.getVoice());
        tts.put("ignore_limit", (Object)true);
        tts.put("gen_srt", (Object)true);
        tts.put("audio_type", (Object)"wav");
        tts.put("text", (Object)request.getText());
        Integer volume = request.getVolume();
        Integer speech_rate = request.getSpeechRate();
        Integer pitch_rate = request.getPitchRate();
        TtsVoiceTaskContext context = new TtsVoiceTaskContext();
        context.setTask_id(taskId);
        context.setSectionId("1");
        context.setCourseId("1");
        float volumeRange = NlsHelperApi.convertRange(volume, 1.0f, 0.0f, 100.0f, 0.1f, 1.0f);
        tts.put("volume", (Object)Float.valueOf(volumeRange));
        float speechRange = NlsHelperApi.convertRange(speech_rate, 1.0f, -500.0f, 500.0f, 0.5f, 2.0f);
        tts.put("speed", (Object)Float.valueOf(speechRange));
        float pitchRange = NlsHelperApi.convertRange(pitch_rate, 0.0f, -500.0f, 500.0f, -10.0f, 10.0f);
        tts.put("pitch", (Object)Float.valueOf(pitchRange));
        CloseableHttpResponse audioResponse = null;
        CloseableHttpResponse srtResponse = null;
        try {
            log.info("\u8bed\u97f3\u5408\u6210-\u4efb\u52a1\u5f00\u59cb[{}]: {}", (Object)this.anchorConfig(), (Object)tts.toJSONString());
            audioResponse = HttpClientUtil.doPostJsonStreaming(TTS_URL, tts.toJSONString());
            Header firstHeader = audioResponse.getFirstHeader("Content-Type");
            if (audioResponse.getEntity().isStreaming() && !firstHeader.getValue().contains("application/json")) {
                InputStream input = audioResponse.getEntity().getContent();
                byte[] bytes = IOUtils.toByteArray((InputStream)input);
                CourseVoiceOnSuccess onSuccess = CourseVoiceOnSuccess.builder().courseId(context.getCourseId()).sectionId(context.getSectionId()).taskId(taskId).file(bytes).build();
                Header srtHeader = audioResponse.getFirstHeader("srt_address");
                String srtAddress = srtHeader.getValue();
                srtResponse = HttpClientUtil.getResult(srtAddress, null);
                if (srtResponse != null) {
                    String srtContent = EntityUtils.toString((HttpEntity)srtResponse.getEntity(), (String)"utf-8");
                    context.setSentences(SrtToJsonConverter.parseSrt(srtContent));
                }
                TtsVoiceTaskContext finalContext = context;
                Optional.ofNullable(this.courseVoiceListener).ifPresent(listener -> finalContext.setAudio_address(listener.onSuccess(onSuccess)));
                long end = System.currentTimeMillis() / 1000L;
                log.info("\u8bed\u97f3\u5408\u6210-\u4efb\u52a1\u5b8c\u6210[{}]: {}, {} s", new Object[]{this.anchorConfig(), finalContext.getAudio_address(), end - timestamp});
                TtsVoiceTaskContext ttsVoiceTaskContext = finalContext;
                return ttsVoiceTaskContext;
            }
            String content = EntityUtils.toString((HttpEntity)audioResponse.getEntity(), (String)"utf-8");
            log.error("\u8bed\u97f3\u5408\u6210-\u4efb\u52a1\u5931\u8d25[{}]: {}, {}", new Object[]{this.anchorConfig(), request, content});
        }
        catch (Exception e) {
            log.error("\u8bed\u97f3\u5408\u6210-\u4efb\u52a1\u5f02\u5e38[{}]: {}", new Object[]{this.anchorConfig(), request, e});
        }
        finally {
            try {
                if (audioResponse != null) {
                    audioResponse.close();
                }
                if (srtResponse != null) {
                    srtResponse.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return context;
    }

    @Override
    public TtsVoiceTaskContext createAudioTask(String courseId, String sectionId, String text, boolean async) {
        TtsVoiceTaskRequest request = new TtsVoiceTaskRequest();
        request.setCourseId(courseId);
        request.setSectionId(sectionId);
        request.setText(text);
        request.setVoice(this.configProperties.getVoice());
        request.setAsync(async);
        return this.createAudioTask(request);
    }

    @Override
    public AsrVoiceTaskContext createAsrTask(String courseId, String fileId, String filepath, boolean async) {
        return null;
    }

    @Override
    public AsrVoiceTaskContext createAsrTask(AsrVoiceTaskRequest request) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String AppKey = "xx";
        String AppSecret = "xx";
        JSONObject tts = new JSONObject();
        long timestamp = System.currentTimeMillis() / 1000L;
        String signature = AppKey + AppSecret + timestamp;
        tts.put("signature", (Object)NiccCommonUtil.stringToMD5((String)signature));
        tts.put("timestamp", (Object)timestamp);
        tts.put("appkey", (Object)AppKey);
        tts.put("speaker", (Object)"mercury_fatima_24k");
        tts.put("ignore_limit", (Object)true);
        tts.put("gen_srt", (Object)true);
        tts.put("audio_type", (Object)"wav");
        tts.put("text", (Object)"\u0644\u0627 \u064a\u0647\u0645 \u0643\u0645 \u0623\u0646\u062a \u0628\u0637\u064a\u0626 \u0637\u0627\u0644\u0645\u0627 \u0623\u0646\u0643 \u0644\u0646 \u062a\u062a\u0648\u0642\u0641. \u0644\u0627 \u064a\u0648\u062c\u062f \u0637\u0631\u064a\u0642 \u0645\u062e\u062a\u0635\u0631 \u0625\u0644\u0649 \u0645\u0643\u0627\u0646 \u064a\u0633\u062a\u062d\u0642 \u0627\u0644\u0630\u0647\u0627\u0628 \u0625\u0644\u064a\u0647. \u062f\u0627\u0626\u0645\u0627 \u062e\u0630 \u0641\u064a \u0639\u064a\u0646 \u0627\u0644\u0625\u0639\u062a\u0628\u064a\u0627\u0631 \u0623\u0646 \u0642\u0631\u0627\u0631 \u0627\u0644\u0646\u062c\u0627\u062d \u0647\u0648 \u0623\u0647\u0645 \u0645\u0646 \u0623\u064a \u0634\u064a\u0626 \u0622\u062e\u0631.");
        tts.put("speed", (Object)"1.0");
        tts.put("volume", (Object)1.0);
        tts.put("pitch", (Object)1.0);
        System.out.println(tts.toJSONString());
        CloseableHttpResponse audioResponse = null;
        CloseableHttpResponse srtResponse = null;
        try {
            audioResponse = HttpClientUtil.doPostJsonStreaming(TTS_URL, tts.toJSONString());
            Header firstHeader = audioResponse.getFirstHeader("Content-Type");
            if (audioResponse.getEntity().isStreaming() && !firstHeader.getValue().contains("application/json")) {
                InputStream input = audioResponse.getEntity().getContent();
                byte[] bytes = IOUtils.toByteArray((InputStream)input);
                FileUtils.writeByteArrayToFile((File)new File("/Users/kangkang/Downloads/sample.wav"), (byte[])bytes);
            } else {
                System.out.println(EntityUtils.toString((HttpEntity)audioResponse.getEntity(), (String)"utf-8"));
            }
            Header srtHeader = audioResponse.getFirstHeader("srt_address");
            String srtAddress = srtHeader.getValue();
            System.out.println("srt_address: " + srtAddress);
            srtResponse = HttpClientUtil.getResult(srtAddress, null);
            InputStream input = srtResponse.getEntity().getContent();
            byte[] bytes = IOUtils.toByteArray((InputStream)input);
            FileUtils.writeByteArrayToFile((File)new File("/Users/kangkang/Downloads/sample.srt"), (byte[])bytes);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (audioResponse != null) {
                    audioResponse.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (srtResponse != null) {
                    srtResponse.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

