/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.helper;

import com.alibaba.fastjson.JSONObject;
import com.tydic.nbchat.train.api.CourseVoiceAsrListener;
import com.tydic.nbchat.train.api.CourseVoiceListener;
import com.tydic.nbchat.train.api.NbchatTrainSectionApi;
import com.tydic.nbchat.train.api.bo.asr_tts.AsrVoiceResult;
import com.tydic.nbchat.train.api.bo.asr_tts.AsrVoiceTaskContext;
import com.tydic.nbchat.train.api.bo.asr_tts.AsrVoiceTaskRequest;
import com.tydic.nbchat.train.api.bo.asr_tts.TtsVoiceTaskContext;
import com.tydic.nbchat.train.api.bo.asr_tts.TtsVoiceTaskRequest;
import com.tydic.nbchat.train.api.bo.asr_tts.modelscope.AsrResponse;
import com.tydic.nbchat.train.api.bo.asr_tts.modelscope.TtsResponse;
import com.tydic.nbchat.train.api.bo.eums.AnchorType;
import com.tydic.nbchat.train.api.bo.listener.CourseVoiceAsrOnSuccess;
import com.tydic.nbchat.train.api.bo.listener.CourseVoiceOnError;
import com.tydic.nbchat.train.core.config.ModelscopeConfigProperties;
import com.tydic.nbchat.train.core.helper.NlsHelperApi;
import com.tydic.nbchat.train.core.util.TrainCommonUtil;
import com.tydic.nbchat.train.mapper.NbchatTrainCourseMapper;
import com.tydic.nbchat.train.mapper.NbchatTrainSectionsMapper;
import com.tydic.nbchat.train.mapper.po.NbchatTrainCourse;
import com.tydic.nbchat.train.mapper.po.NbchatTrainSections;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import com.tydic.nicc.framework.utils.HttpClientHelper;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ModelscopeNlsHelper
implements NlsHelperApi {
    private static final Logger log = LoggerFactory.getLogger(ModelscopeNlsHelper.class);
    private final ModelscopeConfigProperties configProperties;
    private final CourseVoiceListener courseVoiceListener;
    private final CourseVoiceAsrListener courseVoiceAsrListener;
    private final NbchatTrainSectionApi nbchatTrainSectionApi;
    @Resource
    NbchatTrainCourseMapper nbchatTrainCourseMapper;
    @Resource
    NbchatTrainSectionsMapper nbchatTrainSectionsMapper;

    public ModelscopeNlsHelper(ModelscopeConfigProperties configProperties, CourseVoiceListener courseVoiceListener, CourseVoiceAsrListener courseVoiceAsrListener, NbchatTrainSectionApi nbchatTrainSectionApi) {
        this.configProperties = configProperties;
        this.courseVoiceListener = courseVoiceListener;
        this.courseVoiceAsrListener = courseVoiceAsrListener;
        this.nbchatTrainSectionApi = nbchatTrainSectionApi;
    }

    @Override
    public String anchorConfig() {
        return AnchorType.MODELSCOPE.getCode();
    }

    private TtsResponse buildTtsRequest(String courseId, String text, String voice) {
        JSONObject taskObject = new JSONObject();
        taskObject.put("tts_name", (Object)voice);
        taskObject.put("content", (Object)text);
        taskObject.put("if_sentences", (Object)"true");
        log.info("\u8bed\u97f3\u5408\u6210[{}]-\u4efb\u52a1-\u5f00\u59cb:{},{}", new Object[]{courseId, this.configProperties.getPrivateTtsApi(), taskObject});
        String result = HttpClientHelper.doPost((String)this.configProperties.getPrivateTtsApi(), new HashMap(), (Object)taskObject, (int)240000);
        log.info("\u8bed\u97f3\u5408\u6210[{}]-\u4efb\u52a1-\u5b8c\u6210:{}", (Object)courseId, (Object)result);
        if (JSONObject.isValid((String)result)) {
            return (TtsResponse)JSONObject.parseObject((String)result, TtsResponse.class);
        }
        return new TtsResponse();
    }

    @Override
    public void createAudioTask(String courseId, String sectionId, boolean courseAll) {
        if (!courseAll && StringUtils.isNotEmpty((CharSequence)courseId)) {
            NbchatTrainCourse course = this.nbchatTrainCourseMapper.selectByPrimaryKey(courseId);
            this.createAudioTask(courseId, null, course.getCourseDesc(), true);
        }
        if (StringUtils.isNotEmpty((CharSequence)sectionId)) {
            Rsp rsp = this.nbchatTrainSectionApi.querySection(sectionId);
            this.createAudioTask(null, sectionId, (String)rsp.getData(), true);
        }
        if (courseAll && StringUtils.isNotEmpty((CharSequence)courseId)) {
            List nbchatTrainSections = this.nbchatTrainSectionsMapper.selectBySectionIds(courseId, null);
            for (NbchatTrainSections section : nbchatTrainSections) {
                Rsp rsp = this.nbchatTrainSectionApi.querySection(section.getSectionId());
                this.createAudioTask(null, section.getSectionId(), (String)rsp.getData(), true);
            }
        }
    }

    @Override
    public TtsVoiceTaskContext createAudioTask(String courseId, String sectionId, String text, String voice, boolean async) {
        TtsVoiceTaskRequest request = new TtsVoiceTaskRequest();
        request.setCourseId(courseId);
        request.setSectionId(sectionId);
        request.setText(text);
        request.setVoice(voice);
        request.setAsync(async);
        return this.createAudioTask(request);
    }

    @Override
    public TtsVoiceTaskContext createAudioTask(TtsVoiceTaskRequest request) {
        String text = request.getText();
        String courseId = request.getCourseId();
        String sectionId = request.getSectionId();
        String voice = request.getVoice();
        String taskId = IdWorker.nextAutoIdStr();
        TtsVoiceTaskContext context = new TtsVoiceTaskContext();
        Object err = "";
        try {
            if (StringUtils.isBlank((CharSequence)text)) {
                log.info("\u8bed\u97f3\u5408\u6210[{}]-\u4efb\u52a1-\u8bed\u97f3\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\uff01:{}", (Object)courseId, (Object)voice);
                return context;
            }
            TtsResponse response = this.buildTtsRequest(courseId, text = TrainCommonUtil.removeXMLTags(text).trim(), voice);
            if (response.success()) {
                context.setTask_id(taskId);
                context.setCourseId(courseId);
                context.setSentences(response.getData().getSentences());
                context.setSectionId(sectionId);
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{response.getData().getUrl()})) {
                    context.setAudio_address(response.getData().getUrl());
                    return context;
                }
                log.error("\u8bed\u97f3\u5408\u6210[{}]-\u4efb\u52a1-\u4e0b\u8f7d\u5730\u5740\u4e3a\u7a7a\uff01:{}", (Object)courseId, (Object)response);
            }
            err = "\u8bed\u97f3\u5408\u6210\u5931\u8d25:" + response.getCode();
        }
        catch (Exception e) {
            log.error("\u8bed\u97f3\u5408\u6210[{}]-\u5f02\u5e38:", (Object)courseId, (Object)e);
            err = e.getMessage();
        }
        CourseVoiceOnError onError = CourseVoiceOnError.builder().sectionId(sectionId).taskId(taskId).error((String)err).build();
        Optional.ofNullable(this.courseVoiceListener).ifPresent(listener -> listener.onError(onError));
        return context;
    }

    @Override
    public TtsVoiceTaskContext createAudioTask(String courseId, String sectionId, String text, boolean async) {
        return this.createAudioTask(courseId, sectionId, text, this.configProperties.getVoice(), async);
    }

    @Override
    public AsrVoiceTaskContext createAsrTask(String courseId, String fileId, String filepath, boolean async) {
        Long requestTime = System.currentTimeMillis();
        String taskId = IdWorker.nextAutoIdStr();
        String asrApi = this.configProperties.getPrivateAsrApi();
        AsrVoiceTaskContext context = new AsrVoiceTaskContext();
        String err = "";
        try {
            AsrResponse response;
            if (StringUtils.isNotBlank((CharSequence)this.configProperties.getPrivateAsrApi())) {
                return this.createPrivateAsrTask(filepath);
            }
            JSONObject taskObject = new JSONObject();
            taskObject.put("audio_in", (Object)filepath);
            taskObject.put("enable_sentences", (Object)true);
            log.info("\u5f55\u97f3\u6587\u4ef6\u8bc6\u522b[{}]-\u4efb\u52a1-\u5f00\u59cb:{}", (Object)courseId, (Object)taskObject);
            String result = HttpClientHelper.doPost((String)asrApi, new HashMap(), (Object)taskObject, (int)60000);
            log.info("\u5f55\u97f3\u6587\u4ef6\u8bc6\u522b[{}]-\u4efb\u52a1-\u5b8c\u6210:{}", (Object)courseId, (Object)result);
            if (JSONObject.isValid((String)result) && (response = (AsrResponse)JSONObject.parseObject((String)result, AsrResponse.class)).success()) {
                context.setTaskId(taskId);
                context.setRequestId(taskId);
                context.setCourseId(courseId);
                context.setRequestTime(requestTime);
                context.setStatusCode(Integer.valueOf(200));
                context.setSentences(response.getData().getSentences());
                CourseVoiceAsrOnSuccess onSuccess = CourseVoiceAsrOnSuccess.builder().courseId(courseId).fileId(fileId).taskContext(context).taskId(taskId).build();
                Optional.ofNullable(this.courseVoiceAsrListener).ifPresent(listener -> listener.onSuccess(onSuccess));
                return context;
            }
            err = result;
        }
        catch (Exception e) {
            log.error("\u5f55\u97f3\u6587\u4ef6\u8bc6\u522b[{}]-\u5f02\u5e38:", (Object)courseId, (Object)e);
            err = e.getMessage();
        }
        CourseVoiceOnError onError = CourseVoiceOnError.builder().courseId(courseId).fileId(fileId).error(err).build();
        Optional.ofNullable(this.courseVoiceAsrListener).ifPresent(listener -> listener.onError(onError));
        return context;
    }

    private AsrVoiceTaskContext createPrivateAsrTask(String inputUrl) throws Exception {
        String taskId = IdWorker.nextAutoIdStr();
        String url = this.configProperties.getPrivateAsrApi();
        String sign = this.configProperties.getPrivateAsrSign();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("sign", sign);
        InputStream inputStream = new URL(inputUrl).openStream();
        HttpEntity entity = HttpClientHelper.buildMultipartEntity((String)"files", (InputStream)inputStream, (ContentType)ContentType.APPLICATION_OCTET_STREAM, (String)(taskId + ".wav"), paramMap);
        String res = HttpClientHelper.doPostFile((String)url, new HashMap(), (HttpEntity)entity);
        if (JSONObject.isValid((String)res)) {
            AsrResponse response = (AsrResponse)JSONObject.parseObject((String)res, AsrResponse.class);
            if (response.success()) {
                AsrVoiceTaskContext context = new AsrVoiceTaskContext();
                context.setTaskId(taskId);
                context.setRequestId(taskId);
                context.setStatusCode(Integer.valueOf(200));
                ArrayList<AsrVoiceResult> sentences = new ArrayList<AsrVoiceResult>();
                AsrVoiceResult result = new AsrVoiceResult();
                result.setText(response.getData().getText());
                result.setBeginTime(Integer.valueOf(0));
                result.setEndTime(Integer.valueOf(100));
                sentences.add(result);
                context.setSentences(sentences);
                return context;
            }
        } else {
            log.error("\u79c1\u6709\u8bed\u97f3\u8bc6\u522b\u5f02\u5e38: {},{}", (Object)sign, (Object)res);
        }
        return new AsrVoiceTaskContext();
    }

    @Override
    public AsrVoiceTaskContext createAsrTask(AsrVoiceTaskRequest request) {
        return this.createAsrTask(request.getCourseId(), request.getFileId(), request.getFilePath(), request.isAsync());
    }
}

