/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.helper;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.nbchat.robot.api.NbchatRobotToolsApi;
import com.tydic.nbchat.robot.api.bo.tools.RobotPromptMessageRequest;
import com.tydic.nbchat.robot.api.bo.tools.RobotToolsChatResponse;
import com.tydic.nbchat.train.api.bo.asr_tts.AsrVoiceTaskContext;
import com.tydic.nbchat.train.api.bo.asr_tts.AsrVoiceTaskRequest;
import com.tydic.nbchat.train.api.bo.asr_tts.TtsVoiceResult;
import com.tydic.nbchat.train.api.bo.asr_tts.TtsVoiceTaskContext;
import com.tydic.nbchat.train.api.bo.asr_tts.TtsVoiceTaskRequest;
import com.tydic.nbchat.train.api.bo.asr_tts.TtsWordResult;
import com.tydic.nbchat.train.api.bo.eums.AnchorType;
import com.tydic.nbchat.train.core.config.NbchatTrainConfigProperties;
import com.tydic.nbchat.train.core.helper.NlsHelperApi;
import com.tydic.nbchat.train.core.util.OptimizedSubtitlesUtil;
import com.tydic.nbchat.train.core.util.TrainCommonUtil;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class NlsStrategyInvokeFactory {
    private static final Logger log = LoggerFactory.getLogger(NlsStrategyInvokeFactory.class);
    private static final String TTS_CACHE_KEY_PREFIX = "nbchat-train:tts-cache:";
    private final RedisHelper redisHelper;
    private final NbchatTrainConfigProperties nbchatTrainConfigProperties;
    private final List<NlsHelperApi> nlsHelperApis;
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=30000)
    private NbchatRobotToolsApi nbchatRobotToolsApi;

    public NlsStrategyInvokeFactory(RedisHelper redisHelper, NbchatTrainConfigProperties nbchatTrainConfigProperties, List<NlsHelperApi> nlsHelperApis) {
        this.redisHelper = redisHelper;
        this.nbchatTrainConfigProperties = nbchatTrainConfigProperties;
        this.nlsHelperApis = nlsHelperApis;
    }

    public String getAnchorConfig() {
        return this.nbchatTrainConfigProperties.getAnchorConfig();
    }

    public NlsHelperApi getApi() {
        return this.getApi(this.nbchatTrainConfigProperties.getAnchorConfig());
    }

    public NlsHelperApi getApi(String anchorType) {
        for (NlsHelperApi nlsHelperApi : this.nlsHelperApis) {
            if (!anchorType.equals(nlsHelperApi.anchorConfig())) continue;
            return nlsHelperApi;
        }
        throw new RuntimeException("\u627e\u4e0d\u5230NlsHelperApi\u5b9e\u73b0\u63a5\u53e3: anchorType=" + anchorType);
    }

    public TtsVoiceTaskContext createAudioTask(TtsVoiceTaskRequest request) {
        if (StringUtils.isBlank((CharSequence)request.getAnchorType())) {
            request.setAnchorType(this.nbchatTrainConfigProperties.getTtsType());
            if (StringUtils.isBlank((CharSequence)request.getVoice())) {
                request.setVoice(AnchorType.getDefaultVoiceByCode((String)request.getAnchorType()));
            }
        }
        request.setText(TrainCommonUtil.trimXmlTagName(request.getText(), "mark"));
        String cacheKey = TTS_CACHE_KEY_PREFIX + NiccCommonUtil.stringToMD5((String)request.getCacheHashCode());
        TtsVoiceTaskContext cacheContext = (TtsVoiceTaskContext)this.redisHelper.get(cacheKey);
        if (cacheContext != null) {
            log.info("\u4ece\u7f13\u5b58\u4e2d\u83b7\u53d6TTS\u4efb\u52a1\uff1a{}|{}", (Object)request, (Object)cacheContext);
            return cacheContext;
        }
        TtsVoiceTaskContext context = this.getApi(request.getAnchorType()).createAudioTask(request);
        try {
            if (context.getSentences() != null) {
                List<TtsVoiceResult> subtitles = OptimizedSubtitlesUtil.isEnglishSubtitles(context.getSentences()) ? OptimizedSubtitlesUtil.optimizeEnglishSubtitles(context.getSentences()) : OptimizedSubtitlesUtil.optimizeSubtitles(context.getSentences());
                ArrayList<TtsWordResult> words = new ArrayList<TtsWordResult>();
                for (TtsVoiceResult subtitle : subtitles) {
                    if (request.isWordSplit()) {
                        List<TtsWordResult> wordResults = OptimizedSubtitlesUtil.calculateWordTime(subtitle.getText(), subtitle.getBegin_Time(), subtitle.getEnd_time());
                        words.addAll(wordResults);
                    }
                    subtitle.setText(OptimizedSubtitlesUtil.removeLastPunctuation(subtitle.getText()));
                }
                context.setSubtitles(subtitles);
                context.setWords(words);
                if (request.isBilingual()) {
                    try {
                        this.translateSubtitles(request, context);
                    }
                    catch (Exception e) {
                        log.error("\u5b57\u5e55\u4f18\u5316-\u7ffb\u8bd1\u5f02\u5e38\uff1a{}", (Object)request, (Object)e);
                    }
                }
            }
            if (StringUtils.isNotBlank((CharSequence)context.getAudio_address())) {
                this.redisHelper.set(cacheKey, (Object)context, 259200L);
            }
        }
        catch (Exception e) {
            log.error("\u5b57\u5e55\u4f18\u5316\u5f02\u5e38\uff1a{}", (Object)request, (Object)e);
            context.setSubtitles(context.getSentences());
        }
        return context;
    }

    public AsrVoiceTaskContext createAsrTask(AsrVoiceTaskRequest request) {
        if (StringUtils.isBlank((CharSequence)request.getAnchorType())) {
            request.setAnchorType(this.nbchatTrainConfigProperties.getAsrType());
        }
        return this.getApi(request.getAnchorType()).createAsrTask(request);
    }

    private void translateSubtitles(TtsVoiceTaskRequest _request, TtsVoiceTaskContext context) {
        RobotToolsChatResponse response;
        List subtitles = context.getSubtitles();
        if (subtitles == null || subtitles.isEmpty()) {
            return;
        }
        List inputList = subtitles.stream().map(subtitle -> {
            TtsVoiceResult ttsVoiceResult = new TtsVoiceResult();
            ttsVoiceResult.setText(subtitle.getText());
            return ttsVoiceResult;
        }).collect(Collectors.toList());
        boolean isCh = OptimizedSubtitlesUtil.isChineseDominant(_request.getText());
        RobotPromptMessageRequest request = new RobotPromptMessageRequest();
        ArrayList<String> promptsList = new ArrayList<String>();
        promptsList.add(JSONObject.toJSONString(inputList, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.SkipTransientField}));
        if (isCh) {
            promptsList.add("\u82f1\u6587");
        } else {
            promptsList.add("\u4e2d\u6587");
        }
        request.setUserId(_request.getUserId());
        request.setTenantCode(_request.getTenantCode());
        request.setPresetPrompts(promptsList);
        request.setRobotType("doubao_lite_32k");
        request.setPresetId("text_split_trans");
        request.setTrim(true);
        log.info("\u7ffb\u8bd1\u5b57\u5e55-\u8bf7\u6c42\uff1a{}, ARG0 = {}", (Object)request, (Object)JSONObject.toJSONString(inputList, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.SkipTransientField}));
        Rsp resultMap = this.nbchatRobotToolsApi.getChatResult(request);
        log.info("\u7ffb\u8bd1\u5b57\u5e55-\u7ed3\u679c\uff1a{}", (Object)resultMap);
        if (resultMap.isSuccess() && StringUtils.isNotBlank((CharSequence)(response = (RobotToolsChatResponse)resultMap.getData()).getContent())) {
            JSONArray subtitlesArray = JSONArray.parseArray((String)response.getContent());
            if (subtitlesArray.size() != subtitles.size()) {
                log.warn("\u7ffb\u8bd1\u5b57\u5e55-\u7ed3\u679c-\u5b57\u5e55\u957f\u5ea6\u4e0d\u4e00\u81f4\uff1a{} -> {}", (Object)subtitles.size(), (Object)subtitlesArray.size());
            }
            for (int i = 0; i < subtitlesArray.size() && i < subtitles.size(); ++i) {
                JSONObject subtitleObject = subtitlesArray.getJSONObject(i);
                String text = subtitleObject.getString("trans");
                ((TtsVoiceResult)subtitles.get(i)).setBilingualText(text);
                ((TtsVoiceResult)subtitles.get(i)).setIsCh(Boolean.valueOf(isCh));
            }
        }
    }
}

