/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.tydic.nbchat.train.api.CourseVoiceAsrListener;
import com.tydic.nbchat.train.api.CourseVoiceListener;
import com.tydic.nbchat.train.api.NbchatTrainSectionApi;
import com.tydic.nbchat.train.api.bo.asr_tts.AsrVoiceTaskContext;
import com.tydic.nbchat.train.api.bo.asr_tts.AsrVoiceTaskRequest;
import com.tydic.nbchat.train.api.bo.asr_tts.TtsVoiceResult;
import com.tydic.nbchat.train.api.bo.asr_tts.TtsVoiceTaskContext;
import com.tydic.nbchat.train.api.bo.asr_tts.TtsVoiceTaskRequest;
import com.tydic.nbchat.train.api.bo.asr_tts.modelscope.AsrResponse;
import com.tydic.nbchat.train.api.bo.eums.AnchorType;
import com.tydic.nbchat.train.api.bo.listener.CourseVoiceAsrOnSuccess;
import com.tydic.nbchat.train.api.bo.listener.CourseVoiceOnError;
import com.tydic.nbchat.train.api.bo.listener.CourseVoiceOnSuccess;
import com.tydic.nbchat.train.core.config.VolcengineConfigProperties;
import com.tydic.nbchat.train.core.helper.NlsHelperApi;
import com.tydic.nbchat.train.core.util.TrainCommonUtil;
import com.tydic.nbchat.train.mapper.NbchatTrainCourseMapper;
import com.tydic.nbchat.train.mapper.NbchatTrainSectionsMapper;
import com.tydic.nbchat.train.mapper.po.NbchatTrainCourse;
import com.tydic.nbchat.train.mapper.po.NbchatTrainSections;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import com.tydic.nicc.framework.utils.HttpClientHelper;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class VolcengineNlsHelper
implements NlsHelperApi {
    private static final Logger log = LoggerFactory.getLogger(VolcengineNlsHelper.class);
    private final VolcengineConfigProperties configProperties;
    private final CourseVoiceListener courseVoiceListener;
    private final CourseVoiceAsrListener courseVoiceAsrListener;
    private final NbchatTrainSectionApi nbchatTrainSectionApi;
    @Resource
    NbchatTrainCourseMapper nbchatTrainCourseMapper;
    @Resource
    NbchatTrainSectionsMapper nbchatTrainSectionsMapper;
    private static Map<String, String> langMap = new HashMap<String, String>();
    private static Map<String, String> langKeyMap = new HashMap<String, String>();
    private static final ObjectMapper mapper;

    public static ObjectMapper defaultObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
        return mapper;
    }

    public VolcengineNlsHelper(VolcengineConfigProperties configProperties, CourseVoiceListener courseVoiceListener, CourseVoiceAsrListener courseVoiceAsrListener, NbchatTrainSectionApi nbchatTrainSectionApi) {
        this.configProperties = configProperties;
        this.courseVoiceListener = courseVoiceListener;
        this.courseVoiceAsrListener = courseVoiceAsrListener;
        this.nbchatTrainSectionApi = nbchatTrainSectionApi;
    }

    @Override
    public String anchorConfig() {
        return AnchorType.VOLCENGINE.getCode();
    }

    @Override
    public void createAudioTask(String courseId, String sectionId, boolean courseAll) {
        if (!courseAll && StringUtils.isNotEmpty((CharSequence)courseId)) {
            NbchatTrainCourse course = this.nbchatTrainCourseMapper.selectByPrimaryKey(courseId);
            this.createAudioTask(courseId, null, course.getCourseDesc(), true);
        }
        if (StringUtils.isNotEmpty((CharSequence)sectionId)) {
            Rsp rsp = this.nbchatTrainSectionApi.querySection(sectionId);
            this.createAudioTask(null, sectionId, (String)rsp.getData(), true);
        }
        if (courseAll && StringUtils.isNotEmpty((CharSequence)courseId)) {
            List nbchatTrainSections = this.nbchatTrainSectionsMapper.selectBySectionIds(courseId, null);
            for (NbchatTrainSections section : nbchatTrainSections) {
                Rsp rsp = this.nbchatTrainSectionApi.querySection(section.getSectionId());
                this.createAudioTask(null, section.getSectionId(), (String)rsp.getData(), true);
            }
        }
    }

    public TtsVoiceTaskContext createAiAudioTask(TtsVoiceTaskRequest request, Float speedRatio) {
        String text = TrainCommonUtil.removeXMLTags(request.getText());
        String courseId = request.getCourseId();
        String sectionId = request.getSectionId();
        String voice = request.getVoice();
        String api = "https://openspeech.bytedance.com/api/v1/tts";
        String appId = this.configProperties.getAppId();
        String token = this.configProperties.getAccessKey();
        String taskId = NiccCommonUtil.createGuestUID((boolean)true);
        if (speedRatio == null) {
            speedRatio = Float.valueOf(1.0f);
        }
        TtsVoiceTaskContext ttsVoiceTaskContext = new TtsVoiceTaskContext();
        ttsVoiceTaskContext.setCourseId(courseId);
        ttsVoiceTaskContext.setSectionId(sectionId);
        try {
            String body = "{\n    \"app\": {\n        \"appid\": \"" + appId + "\",\n        \"token\": \"" + token + "\",\n        \"cluster\": \"volcano_tts\"\n    },\n    \"user\": {\n        \"uid\": \"nbchat_train_001\"\n    },\n    \"audio\": {\n        \"voice_type\": \"" + voice + "\",\n        \"encoding\": \"wav\",\n        \"speed_ratio\": " + speedRatio + "\n    },   \"request\":{\n        \"reqid\": \"" + NiccCommonUtil.createGuestUID((boolean)true) + "\",\n        \"text\": \"" + text + "\",\n        \"operation\": \"query\"\n    }}";
            JSONObject bodyJson = JSON.parseObject((String)body);
            log.info("\u706b\u5c71\u5927\u6a21\u578b\u8bed\u97f3\u5408\u6210-\u4efb\u52a1\u5f00\u59cb[{}]: {}", (Object)sectionId, (Object)bodyJson.toJSONString());
            HashMap<String, Object> headers = new HashMap<String, Object>();
            headers.put("Content-Type", "application/json");
            headers.put("Authorization", "Bearer; " + token);
            String resp = HttpClientHelper.doPost((String)"https://openspeech.bytedance.com/api/v1/tts", headers, (Object)bodyJson, (int)120000);
            JSONObject resultJson = JSON.parseObject((String)resp);
            if (resultJson.containsKey((Object)"code") && resultJson.getIntValue("code") == 3000) {
                byte[] data = Base64.getDecoder().decode(resultJson.getString("data"));
                CourseVoiceOnSuccess onSuccess = CourseVoiceOnSuccess.builder().courseId(courseId).sectionId(sectionId).taskId(taskId).file(data).build();
                Optional.ofNullable(this.courseVoiceListener).ifPresent(listener -> ttsVoiceTaskContext.setAudio_address(listener.onSuccess(onSuccess)));
                int duration = resultJson.getJSONObject("addition").getIntValue("duration");
                ttsVoiceTaskContext.setDuration(duration);
                ArrayList<TtsVoiceResult> sentences = new ArrayList<TtsVoiceResult>();
                sentences.add(TtsVoiceResult.builder().text(text).begin_Time(Integer.valueOf(0)).end_time(Integer.valueOf(duration)).build());
                ttsVoiceTaskContext.setSentences(sentences);
            } else {
                log.warn("\u706b\u5c71\u5927\u6a21\u578b\u8bed\u97f3\u5408\u6210-\u4efb\u52a1\u5931\u8d25[{}]: {}", (Object)sectionId, (Object)resp);
            }
        }
        catch (Exception e) {
            log.error("\u706b\u5c71\u5927\u6a21\u578b\u8bed\u97f3\u5408\u6210-\u4efb\u52a1\u5f02\u5e38[{}]: ", (Object)sectionId, (Object)e);
        }
        return ttsVoiceTaskContext;
    }

    private boolean isAiVoice(String voice) {
        return voice.endsWith("_tob") || voice.endsWith("_bigtts");
    }

    @Override
    public TtsVoiceTaskContext createAudioTask(String courseId, String sectionId, String text, String voice, boolean async) {
        TtsVoiceTaskRequest request = new TtsVoiceTaskRequest();
        request.setCourseId(courseId);
        request.setSectionId(sectionId);
        request.setText(text);
        request.setVoice(voice);
        request.setAsync(async);
        return this.createAudioTask(request);
    }

    @Override
    public TtsVoiceTaskContext createAudioTask(TtsVoiceTaskRequest request) {
        String text = request.getText();
        String courseId = request.getCourseId();
        String sectionId = request.getSectionId();
        String voice = request.getVoice();
        String ttsApi = this.configProperties.getNlsBaseUrl() + this.configProperties.getTtsLongApi();
        TtsVoiceTaskContext ttsVoiceTaskContext = new TtsVoiceTaskContext();
        String err = "";
        if (StringUtils.isBlank((CharSequence)text)) {
            log.info("\u8bed\u97f3\u5408\u6210[{}]-\u4efb\u52a1-\u8bed\u97f3\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\uff01:{}", (Object)courseId, (Object)voice);
            return ttsVoiceTaskContext;
        }
        JSONObject tts = new JSONObject();
        String requestId = NiccCommonUtil.createGuestUID((boolean)true);
        tts.put("reqid", (Object)requestId);
        tts.put("appid", (Object)this.configProperties.getAppId());
        tts.put("text", (Object)text);
        tts.put("voice_type", (Object)voice);
        tts.put("enable_subtitle", (Object)1);
        tts.put("format", (Object)"wav");
        if (StringUtils.isNotBlank((CharSequence)request.getLanguage())) {
            if (langMap.containsKey(request.getLanguage())) {
                tts.put("language", (Object)langMap.get(request.getLanguage()));
            } else {
                tts.put("language", (Object)request.getLanguage());
            }
        }
        Integer volume = request.getVolume();
        Integer speech_rate = request.getSpeechRate();
        Integer pitch_rate = request.getPitchRate();
        float volumeRange = NlsHelperApi.convertRange(volume, 1.0f, 0.0f, 100.0f, 0.1f, 2.0f);
        tts.put("volume", (Object)Float.valueOf(volumeRange));
        float speechRange = NlsHelperApi.convertRange(speech_rate, 1.0f, -500.0f, 500.0f, 0.2f, 2.0f);
        tts.put("speed", (Object)Float.valueOf(speechRange));
        float pitchRange = NlsHelperApi.convertRange(pitch_rate, 1.0f, -500.0f, 500.0f, 0.1f, 2.0f);
        tts.put("pitch", (Object)Float.valueOf(pitchRange));
        if (this.isAiVoice(voice)) {
            return this.createAiAudioTask(request, Float.valueOf(speechRange));
        }
        log.info("\u8bed\u97f3\u5408\u6210-\u4efb\u52a1\u5f00\u59cb[{}]: {}", (Object)sectionId, (Object)tts.toJSONString());
        RequestBody reqBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)tts.toJSONString());
        Request tts_request = new Request.Builder().url(ttsApi).header("Resource-Id", "volc.tts_async.default").header("Authorization", "Bearer; " + this.configProperties.getAccessKey()).header("Content-Type", "application/json").post(reqBody).build();
        try {
            OkHttpClient client = new OkHttpClient();
            Response response = client.newCall(tts_request).execute();
            String result = response.body().string();
            response.close();
            log.info("\u8bed\u97f3\u5408\u6210-\u4efb\u52a1\u7ed3\u679c[{}]: {}", (Object)sectionId, (Object)result);
            JSONObject resultJson = JSON.parseObject((String)result);
            if (resultJson.containsKey((Object)"task_id")) {
                String taskId = resultJson.getString("task_id");
                log.info("\u8bed\u97f3\u5408\u6210-\u83b7\u53d6\u4efb\u52a1\u4fe1\u606f[{}]: task_id = {}", (Object)sectionId, (Object)taskId);
                if (request.isAsync()) {
                    new Thread(() -> this.getAudioResult(courseId, sectionId, taskId, requestId)).start();
                } else {
                    ttsVoiceTaskContext = this.getAudioResult(courseId, sectionId, taskId, requestId);
                }
            } else {
                String error = resultJson.getString("message");
                log.error("\u8bed\u97f3\u5408\u6210-\u4efb\u52a1\u5f02\u5e38[{}]: {}", (Object)sectionId, (Object)resultJson.toJSONString());
                CourseVoiceOnError onError = CourseVoiceOnError.builder().sectionId(sectionId).error(error).build();
                Optional.ofNullable(this.courseVoiceListener).ifPresent(listener -> listener.onError(onError));
            }
        }
        catch (Exception e) {
            CourseVoiceOnError onError = CourseVoiceOnError.builder().sectionId(sectionId).error(e.getMessage()).build();
            Optional.ofNullable(this.courseVoiceListener).ifPresent(listener -> listener.onError(onError));
            log.error("\u8bed\u97f3\u5408\u6210-\u4efb\u52a1\u5f02\u5e38[{}]: ", (Object)sectionId, (Object)e);
        }
        ttsVoiceTaskContext.setCourseId(courseId);
        ttsVoiceTaskContext.setSectionId(sectionId);
        return ttsVoiceTaskContext;
    }

    public TtsVoiceTaskContext getSyncAudioTask(JSONObject ttsParam, String sectionId) {
        TtsVoiceTaskContext ttsVoiceTaskContext = new TtsVoiceTaskContext();
        String ttsApi = this.configProperties.getNlsBaseUrl() + this.configProperties.getTtsApi();
        System.out.println(ttsApi);
        RequestBody reqBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)ttsParam.toJSONString());
        Request tts_request = new Request.Builder().url(ttsApi).header("Authorization", "Bearer;" + this.configProperties.getAccessKey()).post(reqBody).build();
        try {
            OkHttpClient client = new OkHttpClient();
            Response response = client.newCall(tts_request).execute();
            String result = response.body().string();
            response.close();
            log.info("\u8bed\u97f3\u5408\u6210-\u4efb\u52a1\u7ed3\u679c[{}]: {}", (Object)sectionId, (Object)result);
            JSONObject resultJson = JSON.parseObject((String)result);
            if (resultJson != null && resultJson.containsKey((Object)"data")) {
                String base64 = resultJson.getString("data");
                byte[] bytes = VolcengineNlsHelper.base64ToBytes(base64);
                CourseVoiceOnSuccess success = CourseVoiceOnSuccess.builder().sectionId(sectionId).file(bytes).build();
                Optional.ofNullable(this.courseVoiceListener).ifPresent(listener -> ttsVoiceTaskContext.setAudio_address(listener.onSuccess(success)));
            } else {
                String error = "";
                if (resultJson != null) {
                    error = resultJson.toJSONString();
                }
                CourseVoiceOnError onError = CourseVoiceOnError.builder().sectionId(sectionId).error(error).build();
                Optional.ofNullable(this.courseVoiceListener).ifPresent(listener -> listener.onError(onError));
            }
        }
        catch (Exception e) {
            CourseVoiceOnError onError = CourseVoiceOnError.builder().sectionId(sectionId).error(e.getMessage()).build();
            Optional.ofNullable(this.courseVoiceListener).ifPresent(listener -> listener.onError(onError));
            log.error("\u8bed\u97f3\u5408\u6210-\u4efb\u52a1\u5f02\u5e38[{}]: ", (Object)sectionId, (Object)e);
        }
        return ttsVoiceTaskContext;
    }

    private static byte[] base64ToBytes(String base64) {
        return Base64.getDecoder().decode(base64);
    }

    @Override
    public TtsVoiceTaskContext createAudioTask(String courseId, String sectionId, String text, boolean async) {
        return this.createAudioTask(courseId, sectionId, text, this.configProperties.getVoice(), async);
    }

    @Override
    public AsrVoiceTaskContext createAsrTask(String courseId, String fileId, String filepath, boolean async) {
        Long requestTime = System.currentTimeMillis();
        String taskId = IdWorker.nextAutoIdStr();
        String asrApi = this.configProperties.getNlsBaseUrl() + this.configProperties.getAsrApi();
        AsrVoiceTaskContext context = new AsrVoiceTaskContext();
        String err = "";
        try {
            AsrResponse response;
            JSONObject taskObject = new JSONObject();
            taskObject.put("audio_in", (Object)filepath);
            taskObject.put("enable_sentences", (Object)true);
            log.info("\u5f55\u97f3\u6587\u4ef6\u8bc6\u522b[{}]-\u4efb\u52a1-\u5f00\u59cb:{}", (Object)courseId, (Object)taskObject);
            String result = HttpClientHelper.doPost((String)asrApi, new HashMap(), (Object)taskObject, (int)60000);
            log.info("\u5f55\u97f3\u6587\u4ef6\u8bc6\u522b[{}]-\u4efb\u52a1-\u5b8c\u6210:{}", (Object)courseId, (Object)result);
            if (JSONObject.isValid((String)result) && (response = (AsrResponse)JSONObject.parseObject((String)result, AsrResponse.class)).success()) {
                context.setTaskId(taskId);
                context.setRequestId(taskId);
                context.setCourseId(courseId);
                context.setRequestTime(requestTime);
                context.setStatusCode(Integer.valueOf(200));
                context.setSentences(response.getData().getSentences());
                CourseVoiceAsrOnSuccess onSuccess = CourseVoiceAsrOnSuccess.builder().courseId(courseId).fileId(fileId).taskContext(context).taskId(taskId).build();
                Optional.ofNullable(this.courseVoiceAsrListener).ifPresent(listener -> listener.onSuccess(onSuccess));
                return context;
            }
            err = result;
        }
        catch (Exception e) {
            log.error("\u5f55\u97f3\u6587\u4ef6\u8bc6\u522b[{}]-\u5f02\u5e38:", (Object)courseId, (Object)e);
            err = e.getMessage();
        }
        CourseVoiceOnError onError = CourseVoiceOnError.builder().courseId(courseId).fileId(fileId).error(err).build();
        Optional.ofNullable(this.courseVoiceAsrListener).ifPresent(listener -> listener.onError(onError));
        return context;
    }

    @Override
    public AsrVoiceTaskContext createAsrTask(AsrVoiceTaskRequest request) {
        return this.createAsrTask(request.getCourseId(), request.getFileId(), request.getFilePath(), request.isAsync());
    }

    private TtsVoiceTaskContext getAudioResult(String courseId, String sectionId, String taskId, String requestId) {
        String appId = this.configProperties.getAppId();
        String address = "";
        String urlBuilder = this.configProperties.getTtsResultApi().replace("{appId}", appId).replace("{taskId}", taskId);
        String apiUrl = this.configProperties.getNlsBaseUrl() + urlBuilder;
        log.info("\u8bed\u97f3\u5408\u6210-\u83b7\u53d6\u5f55\u97f3[{}]: {}|{}", new Object[]{sectionId, taskId, apiUrl});
        TtsVoiceTaskContext context = new TtsVoiceTaskContext();
        int count = 0;
        while (++count < 500) {
            try {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                Request request = new Request.Builder().url(apiUrl).header("Resource-Id", "volc.tts_async.default").header("Authorization", "Bearer; " + this.configProperties.getAccessKey()).get().build();
                OkHttpClient client = new OkHttpClient();
                Response response = client.newCall(request).execute();
                String result = null;
                if (response.body() != null) {
                    result = response.body().string();
                }
                response.close();
                log.info("\u8bed\u97f3\u5408\u6210-\u83b7\u53d6\u5f55\u97f3-\u7ed3\u679c[{}]: {}", (Object)sectionId, (Object)result);
                JSONObject resultJson = (JSONObject)mapper.readValue(result, JSONObject.class);
                if (resultJson == null) continue;
                if (resultJson.containsKey((Object)"code")) {
                    log.error("\u8bed\u97f3\u5408\u6210-\u83b7\u53d6\u5f55\u97f3-\u5931\u8d25[{}]: {}", (Object)sectionId, (Object)resultJson);
                    break;
                }
                if (!resultJson.containsKey((Object)"task_id") || resultJson.getIntValue("task_status") != 1) continue;
                context = (TtsVoiceTaskContext)resultJson.toJavaObject(TtsVoiceTaskContext.class);
                Optional.ofNullable(context.getSentences()).ifPresent(sens -> {
                    for (TtsVoiceResult voiceResult : sens) {
                        String txt = TrainCommonUtil.removeXMLTags(voiceResult.getText()).trim();
                        voiceResult.setText(txt);
                    }
                });
                address = context.getAudio_address();
                log.info("\u8bed\u97f3\u5408\u6210-\u83b7\u53d6\u5f55\u97f3-\u5730\u5740[{}]: {}", (Object)sectionId, (Object)address);
                break;
            }
            catch (Exception e) {
                log.error("\u8bed\u97f3\u5408\u6210-\u83b7\u53d6\u5f55\u97f3-\u5f02\u5e38[{}]: taskId = {}, requestId = {}", new Object[]{sectionId, taskId, requestId, e});
            }
        }
        if (StringUtils.isBlank((CharSequence)address)) {
            log.warn("\u8bed\u97f3\u5408\u6210-\u83b7\u53d6\u5f55\u97f3-\u5931\u8d25[{}]: taskId = {}, requestId = {}", new Object[]{sectionId, taskId, requestId});
            CourseVoiceOnError onError = CourseVoiceOnError.builder().sectionId(sectionId).taskId(taskId).error("\u8bed\u97f3\u5408\u6210-\u83b7\u53d6\u5f55\u97f3-\u5931\u8d25").build();
            Optional.ofNullable(this.courseVoiceListener).ifPresent(listener -> listener.onError(onError));
            return context;
        }
        CourseVoiceOnSuccess onSuccess = CourseVoiceOnSuccess.builder().courseId(courseId).sectionId(sectionId).taskId(taskId).address(address).build();
        TtsVoiceTaskContext finalContext = context;
        Optional.ofNullable(this.courseVoiceListener).ifPresent(listener -> finalContext.setAudio_address(listener.onSuccess(onSuccess)));
        return finalContext;
    }

    static {
        langMap.put("\u4e2d\u6587", "cmn");
        langMap.put("\u82f1\u8bed", "eng");
        langMap.put("\u65e5\u8bed", "jpn");
        langMap.put("\u8461\u8404\u7259\u8bed", "por");
        langMap.put("\u897f\u73ed\u7259\u8bed", "spa");
        langMap.put("\u5370\u5c3c\u8bed", "ind");
        langMap.put("\u8d8a\u5357\u8bed", "vie");
        langMap.put("\u6cf0\u8bed", "tha");
        langMap.put("\u6cd5\u8bed", "fra");
        langMap.put("\u5fb7\u8bed", "deu");
        langMap.put("\u610f\u5927\u5229\u8bed", "ita");
        langMap.put("\u963f\u62c9\u4f2f\u8bed", "ara");
        langKeyMap.put("cmn", "\u4e2d\u6587");
        langKeyMap.put("eng", "\u82f1\u8bed");
        langKeyMap.put("jpn", "\u65e5\u8bed");
        langKeyMap.put("por", "\u8461\u8404\u7259\u8bed");
        langKeyMap.put("spa", "\u897f\u73ed\u7259\u8bed");
        langKeyMap.put("ind", "\u5370\u5c3c\u8bed");
        langKeyMap.put("vie", "\u8d8a\u5357\u8bed");
        langKeyMap.put("tha", "\u6cf0\u8bed");
        langKeyMap.put("fra", "\u6cd5\u8bed");
        langKeyMap.put("deu", "\u5fb7\u8bed");
        langKeyMap.put("ita", "\u610f\u5927\u5229\u8bed");
        langKeyMap.put("ara", "\u963f\u62c9\u4f2f\u8bed");
        mapper = VolcengineNlsHelper.defaultObjectMapper();
    }
}

