/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.listener.impl;

import com.tydic.nbchat.admin.api.bo.file.FileUploadRequest;
import com.tydic.nbchat.admin.api.fileMannager.FileManageService;
import com.tydic.nbchat.train.api.CourseVoiceListener;
import com.tydic.nbchat.train.api.bo.eums.FileUploadDirEnum;
import com.tydic.nbchat.train.api.bo.listener.CourseVoiceOnError;
import com.tydic.nbchat.train.api.bo.listener.CourseVoiceOnSuccess;
import com.tydic.nbchat.train.core.config.AliTtsConfigProperties;
import com.tydic.nicc.common.bo.file.FileManageSaveBO;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import java.io.File;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CourseVoiceListenerImpl
implements CourseVoiceListener {
    private static final Logger log = LoggerFactory.getLogger(CourseVoiceListenerImpl.class);
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=10000)
    private FileManageService fileManageService;
    @Resource
    AliTtsConfigProperties aliTtsConfigProperties;

    public String onSuccess(CourseVoiceOnSuccess onSuccess) {
        String accessUrl = "";
        try {
            String dir = FileUploadDirEnum.TTS_TEMP.getCode();
            if (StringUtils.isNotBlank((CharSequence)onSuccess.getSectionId())) {
                dir = onSuccess.getSectionId();
            }
            accessUrl = this.saveRemoteVoice(onSuccess.getAddress(), onSuccess.getFile(), dir);
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58tts\u8bed\u97f3-\u5f02\u5e38\uff1a", (Throwable)e);
        }
        log.info("\u4fdd\u5b58tts\u8bed\u97f3-\u5b8c\u6210:{}", (Object)accessUrl);
        return accessUrl;
    }

    public String onError(CourseVoiceOnError onError) {
        return "";
    }

    public String saveRemoteVoice(String address, String targetDir) {
        return this.saveRemoteVoice(address, null, targetDir);
    }

    public String saveRemoteVoice(String address, byte[] byteFile, String targetDir) {
        String retUrl = "";
        try {
            RspList rspList;
            String fileName = IdWorker.nextAutoIdStr() + "." + this.aliTtsConfigProperties.getFormat();
            if (byteFile == null) {
                log.info("\u4fdd\u5b58tts\u8bed\u97f3-\u5f00\u59cb: {}| {}/{}", new Object[]{address, targetDir, fileName});
                String filePath = System.getProperty("java.io.tmpdir") + File.separator + fileName;
                File file = new File(filePath);
                URL url = new URL(address);
                url.openConnection().setConnectTimeout(20000);
                Files.copy(url.openStream(), Paths.get(file.toURI()), new CopyOption[0]);
                byteFile = Files.readAllBytes(Paths.get(filePath, new String[0]));
                if (file.exists()) {
                    file.delete();
                }
            }
            FileUploadRequest uploadRequest = FileUploadRequest.builder().file(byteFile).fileName(fileName).uploadUser("1").tenantCode("00000000").build();
            if (StringUtils.isNotBlank((CharSequence)targetDir)) {
                uploadRequest.setTargetDir(targetDir);
            }
            if ((rspList = this.fileManageService.fileUploadRequest(uploadRequest)).isSuccess()) {
                retUrl = ((FileManageSaveBO)rspList.getRows().get(0)).getAccessUrl();
            } else {
                log.error("\u4fdd\u5b58tts\u8bed\u97f3-\u5931\u8d25: {},{}", (Object)address, (Object)retUrl);
            }
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58tts\u8bed\u97f3-\u5f02\u5e38: {}", (Object)address, (Object)e);
        }
        return retUrl;
    }
}

