/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONValidator;
import com.alibaba.nacos.shaded.com.google.common.base.Function;
import com.tydic.nbchat.robot.api.bo.tools.RobotToolsChatResponse;
import com.tydic.nbchat.train.api.AutoBuildApi;
import com.tydic.nbchat.train.api.NbcahtExamQuestionApi;
import com.tydic.nbchat.train.api.NbchatCourseAiToolApi;
import com.tydic.nbchat.train.api.NbchatTrainCatalogApi;
import com.tydic.nbchat.train.api.NbchatTrainCourseApi;
import com.tydic.nbchat.train.api.NbchatTrainDialogueApi;
import com.tydic.nbchat.train.api.NbchatTrainSectionApi;
import com.tydic.nbchat.train.api.bo.QuestionSaveRequest;
import com.tydic.nbchat.train.api.bo.autoBuild.AutoBuildBO;
import com.tydic.nbchat.train.api.bo.autoBuild.CatalogTmpl;
import com.tydic.nbchat.train.api.bo.course.TranCourseBO;
import com.tydic.nbchat.train.api.bo.course.TranCourseQueryReqBO;
import com.tydic.nbchat.train.api.bo.course.TranCourseSaveReqBO;
import com.tydic.nbchat.train.api.bo.dialogue.DialogueBO;
import com.tydic.nbchat.train.api.bo.eums.AiCourseGeneType;
import com.tydic.nbchat.train.api.bo.eums.QuestionType;
import com.tydic.nbchat.train.api.bo.eums.StateEnum;
import com.tydic.nbchat.train.api.bo.generate.TranCourseGenerateRequest;
import com.tydic.nbchat.train.api.bo.train.catalog.TrainCatalogBO;
import com.tydic.nbchat.train.api.bo.train.section.SectionsSaveRequest;
import com.tydic.nbchat.train.core.helper.NlsStrategyInvokeFactory;
import com.tydic.nbchat.train.mapper.po.NbchatTrainCatalog;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class AutoBuildServiceImpl
implements AutoBuildApi {
    private static final Logger log = LoggerFactory.getLogger(AutoBuildServiceImpl.class);
    @Resource
    NbchatCourseAiToolApi nbchatCourseAiToolApi;
    @Resource
    NbchatTrainCourseApi nbchatTrainCourseApi;
    @Resource
    NbchatTrainCatalogApi nbchatTrainCatalogApi;
    @Resource
    NbchatTrainSectionApi nbchatTrainSectionApi;
    @Resource
    NbcahtExamQuestionApi nbcahtExamQuestionApi;
    @Resource
    NbchatTrainDialogueApi nbchatTrainDialogueApi;
    @Resource
    private NlsStrategyInvokeFactory nlsStrategyInvokeFactory;

    private FutureTask<Rsp> taskFunction(Function<AutoBuildBO, Rsp> function, AutoBuildBO request, String code) {
        String name = AiCourseGeneType.getNameByCode((String)code);
        Callable<Rsp> call = () -> {
            log.info("\u4e00\u952e\u751f\u6210-{}-\u5f00\u59cb", (Object)name);
            long start = System.currentTimeMillis();
            Rsp rsp1 = (Rsp)function.apply((Object)request);
            log.info("\u4e00\u952e\u751f\u6210-{}-\u7ed3\u675f\uff1a{}|{}/ms", new Object[]{name, rsp1, System.currentTimeMillis() - start});
            return rsp1;
        };
        return new FutureTask<Rsp>(call);
    }

    @Deprecated
    public void build(AutoBuildBO request) {
        log.info("\u81ea\u52a8\u751f\u6210\uff1a{}", (Object)request);
        if (this.checkTaskIsRunning(request.getCourseId())) {
            return;
        }
        if (CollectionUtils.isEmpty((Collection)request.getSteps())) {
            List<String> steps = Arrays.asList(AiCourseGeneType.train_course_desc.getCode(), AiCourseGeneType.train_course_catalog.getCode(), AiCourseGeneType.train_course_section.getCode());
            request.setSteps(steps);
        }
        this.updateCourseTaskState(request.getCourseId(), StateEnum.TASK.RUNNING.getCode(), null);
        HashMap<String, FutureTask<Rsp>> map = new HashMap<String, FutureTask<Rsp>>();
        try {
            FutureTask cateTask;
            if (request.getSteps().contains(AiCourseGeneType.train_course_desc.getCode())) {
                Function buildCourseDesc = this::buildCourseDesc;
                FutureTask<Rsp> descTask = this.taskFunction((Function<AutoBuildBO, Rsp>)buildCourseDesc, request, AiCourseGeneType.train_course_desc.getCode());
                new Thread(descTask).start();
                map.put(AiCourseGeneType.train_course_desc.getCode(), descTask);
            }
            if (request.getSteps().contains(AiCourseGeneType.train_course_catalog.getCode())) {
                Function buildCourseCategory = this::buildCourseCategory;
                cateTask = this.taskFunction((Function<AutoBuildBO, Rsp>)buildCourseCategory, request, AiCourseGeneType.train_course_catalog.getCode());
                new Thread(cateTask).start();
                map.put(AiCourseGeneType.train_course_catalog.getCode(), cateTask);
            }
            if (request.getSteps().contains(AiCourseGeneType.train_course_section.getCode())) {
                boolean cateTaskIsOk = true;
                if (map.containsKey(AiCourseGeneType.train_course_catalog.getCode())) {
                    cateTask = (FutureTask)map.get(AiCourseGeneType.train_course_catalog.getCode());
                    Rsp rsp = null;
                    try {
                        rsp = (Rsp)cateTask.get();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    if (!rsp.isSuccess()) {
                        log.info("\u4e00\u952e\u751f\u6210-\u76ee\u5f55-\u5931\u8d25\uff1a{}", (Object)rsp);
                        cateTaskIsOk = false;
                    }
                }
                if (cateTaskIsOk) {
                    Function buildCourseContent = this::buildSectionContent;
                    FutureTask<Rsp> sectionTask = this.taskFunction((Function<AutoBuildBO, Rsp>)buildCourseContent, request, AiCourseGeneType.train_course_section.getCode());
                    new Thread(sectionTask).start();
                    map.put(AiCourseGeneType.train_course_section.getCode(), sectionTask);
                }
            }
            if (request.getSteps().contains(AiCourseGeneType.train_course_exam_s_choice.getCode())) {
                Function buildExam = this::buildExam;
                FutureTask<Rsp> examTask = this.taskFunction((Function<AutoBuildBO, Rsp>)buildExam, request, AiCourseGeneType.train_course_exam_s_choice.getCode());
                new Thread(examTask).start();
                map.put(AiCourseGeneType.train_course_exam_s_choice.getCode(), examTask);
            }
            if (request.getSteps().contains(AiCourseGeneType.train_course_scene_dialogue.getCode())) {
                Function buildDialogue = this::buildDialogue;
                FutureTask<Rsp> dialogueTask = this.taskFunction((Function<AutoBuildBO, Rsp>)buildDialogue, request, AiCourseGeneType.train_course_scene_dialogue.getCode());
                new Thread(dialogueTask).start();
                map.put(AiCourseGeneType.train_course_scene_dialogue.getCode(), dialogueTask);
            }
        }
        catch (Exception e) {
            this.updateCourseTaskState(request.getCourseId(), StateEnum.TASK.ERROR.getCode(), null);
            throw new RuntimeException(e);
        }
        this.loopModifyTask(map, request.getCourseId());
    }

    public void loopModifyTask(Map<String, FutureTask<Rsp>> map, String courseId) {
        int size = map.size();
        HashSet<String> finishSet = new HashSet<String>();
        boolean state = true;
        while (state) {
            log.info("\u4e00\u952e\u751f\u6210-\u603b\u6b65\u9aa4{},\u5df2\u5b8c\u6210{}", map.keySet(), finishSet);
            if (finishSet.size() == size) {
                log.info("\u4e00\u952e\u751f\u6210-\u4efb\u52a1\u7ed3\u675f");
                this.updateCourseTaskState(courseId, StateEnum.TASK.FINISH.getCode(), StateEnum.COURSE.EDIT.getCode());
                break;
            }
            for (Map.Entry<String, FutureTask<Rsp>> task : map.entrySet()) {
                Rsp rsp = null;
                try {
                    rsp = task.getValue().get();
                }
                catch (Exception e) {
                    this.updateCourseTaskState(courseId, StateEnum.TASK.ERROR.getCode(), null);
                    throw new RuntimeException(e);
                }
                if (rsp == null) continue;
                log.info("\u4efb\u52a1\u72b6\u6001\u68c0\u67e5\uff1a{}", (Object)rsp);
                if (rsp.isSuccess()) {
                    finishSet.add(task.getKey());
                    continue;
                }
                this.updateCourseTaskState(courseId, StateEnum.TASK.ERROR.getCode(), null, rsp.getRspDesc());
                state = false;
                break;
            }
            try {
                TimeUnit.SECONDS.sleep(5L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void updateCourseTaskState(String courseId, String taskState, String courseState) {
        this.updateCourseTaskState(courseId, taskState, courseState, "");
    }

    public void updateCourseTaskState(String courseId, String taskState, String courseState, String errorDesc) {
        log.info("\u4e00\u952e\u751f\u6210-\u66f4\u65b0\u8bfe\u7a0b\u4efb\u52a1\u72b6\u6001\uff1a{}|{}|{}", new Object[]{courseId, taskState, courseState});
        TranCourseSaveReqBO course = new TranCourseSaveReqBO();
        course.setCourseId(courseId);
        course.setTaskState(taskState);
        course.setCourseState(courseState);
        course.setTaskFailDesc(errorDesc);
        this.nbchatTrainCourseApi.saveCourse(course);
    }

    public boolean checkTaskIsRunning(String courseId) {
        String taskState;
        log.info("\u4e00\u952e\u751f\u6210-\u68c0\u67e5\u8bfe\u7a0b\u4efb\u52a1\u72b6\u6001\uff1a{}", (Object)courseId);
        TranCourseQueryReqBO course = new TranCourseQueryReqBO();
        course.setCourseId(courseId);
        Rsp res = this.nbchatTrainCourseApi.getCourse(course);
        if (res.isSuccess() && StringUtils.isNotEmpty((CharSequence)(taskState = ((TranCourseBO)res.getData()).getTaskState())) && StateEnum.TASK.RUNNING.getCode().equals(taskState)) {
            log.info("\u751f\u6210\u8bfe\u7a0b\u4efb\u52a1\u6b63\u5728\u6267\u884c\uff0c\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4");
            return true;
        }
        return false;
    }

    public Rsp buildCourseDesc(AutoBuildBO request) {
        String content = this.process(AiCourseGeneType.train_course_desc.getCode(), request.getCourseId());
        if (StringUtils.isEmpty((CharSequence)content)) {
            log.error("\u4e00\u952e\u751f\u6210-\u751f\u6210\u8bfe\u7a0b\u7b80\u4ecb-\u5931\u8d25");
            return BaseRspUtils.createErrorRsp((String)"\u4e00\u952e\u751f\u6210-\u751f\u6210\u8bfe\u7a0b\u7b80\u4ecb-\u5931\u8d25");
        }
        TranCourseSaveReqBO course = new TranCourseSaveReqBO();
        BeanUtils.copyProperties((Object)request, (Object)course);
        course.setCourseDesc(content);
        return this.nbchatTrainCourseApi.saveCourse(course);
    }

    public Rsp buildCourseCategory(AutoBuildBO request) {
        String content = this.process(AiCourseGeneType.train_course_catalog.getCode(), request.getCourseId());
        if (StringUtils.isEmpty((CharSequence)content)) {
            return BaseRspUtils.createErrorRsp((String)"\u751f\u6210\u7c7b\u76ee\u5931\u8d25");
        }
        List catalogTmpls = JSONObject.parseArray((String)content, CatalogTmpl.class);
        TrainCatalogBO catalogBO = new TrainCatalogBO();
        BeanUtils.copyProperties((Object)request, (Object)catalogBO);
        Rsp delete = this.nbchatTrainCatalogApi.delete(catalogBO);
        log.info("\u4e00\u952e\u751f\u6210-\u7c7b\u76ee-\u5220\u9664\u7ed3\u679c\uff1a{}", (Object)delete);
        int index = 1;
        for (CatalogTmpl tmpl : catalogTmpls) {
            catalogBO.setCatalogTitle(tmpl.getTitle());
            catalogBO.setCatalogLevel(Short.valueOf((short)1));
            catalogBO.setCatalogIndex(Short.valueOf((short)index++));
            catalogBO.setParentId("-1");
            Rsp saveRes = this.nbchatTrainCatalogApi.save(catalogBO);
            if (!saveRes.isSuccess()) continue;
            String parentId = (String)saveRes.getData();
            for (String title : tmpl.getSubtitle()) {
                catalogBO.setCatalogTitle(title);
                catalogBO.setCatalogLevel(Short.valueOf((short)2));
                catalogBO.setCatalogIndex(Short.valueOf((short)index++));
                catalogBO.setParentId(parentId);
                this.nbchatTrainCatalogApi.save(catalogBO);
            }
        }
        log.info("\u4e00\u952e\u751f\u6210-\u7c7b\u76ee-\u4e2a\u6570\uff1a{}", (Object)index);
        return BaseRspUtils.createSuccessRsp(null);
    }

    public Rsp buildSectionContent(AutoBuildBO request) {
        TrainCatalogBO reqBO = new TrainCatalogBO();
        reqBO.setCourseId(request.getCourseId());
        RspList query = this.nbchatTrainCatalogApi.query(reqBO);
        List catalogs = query.getRows();
        if (!query.isSuccess() || CollectionUtils.isEmpty((Collection)catalogs)) {
            return BaseRspUtils.createErrorRsp((String)"\u4e00\u952e\u751f\u6210-\u7ae0\u8282\u5185\u5bb9-\u83b7\u53d6\u7c7b\u76ee\u5931\u8d25");
        }
        Rsp delete = this.nbchatTrainSectionApi.delete(request.getCourseId());
        List<CatalogTmpl> catalogTmpls = this.buildTmpl(catalogs);
        int sectionIndex = 1;
        for (CatalogTmpl tmpl : catalogTmpls) {
            String catalog = JSON.toJSONString((Object)tmpl);
            log.info("\u4e00\u952e\u751f\u6210-\u7ae0\u8282\u5185\u5bb9-\u76ee\u5f55\u5165\u53c2\uff1a{}", (Object)catalog);
            String content = this.process(AiCourseGeneType.train_course_section.getCode(), request.getCourseId(), catalog);
            if (StringUtils.isEmpty((CharSequence)content)) {
                log.info("\u4e00\u952e\u751f\u6210-\u7ae0\u8282\u5185\u5bb9-\u5931\u8d25\uff1a{}", (Object)tmpl);
                continue;
            }
            if (!JSONValidator.from((String)content).validate()) {
                log.info("\u4e00\u952e\u751f\u6210-\u7ae0\u8282\u5185\u5bb9-json\u683c\u5f0f\u5316\u5931\u8d25\uff1a{}", (Object)content);
                continue;
            }
            SectionsSaveRequest section = new SectionsSaveRequest();
            BeanUtils.copyProperties((Object)request, (Object)section);
            section.setCatalogId(tmpl.getCatalogId());
            section.setContent(content);
            section.setCreateTime(new Date());
            section.setSectionsIndex(Short.valueOf((short)sectionIndex++));
            this.nbchatTrainSectionApi.saveSection(section);
        }
        return BaseRspUtils.createSuccessRsp(null);
    }

    public Rsp buildExam(AutoBuildBO request) {
        String content = this.process(AiCourseGeneType.train_course_exam_s_choice.getCode(), request.getCourseId());
        if (StringUtils.isEmpty((CharSequence)content)) {
            log.info("\u4e00\u952e\u751f\u6210-\u8bd5\u9898-\u5931\u8d25\uff1a{}", (Object)request);
            return BaseRspUtils.createErrorRsp((String)"\u4e00\u952e\u751f\u6210-\u8bd5\u9898-\u5931\u8d25");
        }
        QuestionSaveRequest saveRequest = new QuestionSaveRequest();
        BeanUtils.copyProperties((Object)request, (Object)saveRequest);
        saveRequest.setQuestionType(QuestionType.CHOICE_S.getCode());
        saveRequest.setContent(content);
        return this.nbcahtExamQuestionApi.saveQuestion(saveRequest);
    }

    public Rsp buildDialogue(AutoBuildBO request) {
        String content = this.process(AiCourseGeneType.train_course_scene_dialogue.getCode(), request.getCourseId());
        if (StringUtils.isEmpty((CharSequence)content)) {
            log.info("\u4e00\u952e\u751f\u6210-\u5bf9\u8bdd-\u5931\u8d25\uff1a{}", (Object)request);
            return BaseRspUtils.createErrorRsp((String)"\u4e00\u952e\u751f\u6210-\u5bf9\u8bdd-\u5931\u8d25");
        }
        DialogueBO dialogueBO = new DialogueBO();
        dialogueBO.setCourseId(request.getCourseId());
        dialogueBO.setTenantCode(request.getTenantCode());
        dialogueBO.setContent(content);
        return this.nbchatTrainDialogueApi.save(dialogueBO);
    }

    public List<CatalogTmpl> buildTmpl(List<NbchatTrainCatalog> catalogs) {
        ArrayList<CatalogTmpl> tmpls = new ArrayList<CatalogTmpl>();
        for (NbchatTrainCatalog catalog : catalogs) {
            if (!catalog.getParentId().equals("-1")) continue;
            CatalogTmpl tmpl = new CatalogTmpl();
            tmpl.setCatalogId(catalog.getCatalogId());
            tmpl.setTitle(catalog.getCatalogTitle());
            tmpl.setSubtitle(new ArrayList());
            tmpls.add(tmpl);
            for (NbchatTrainCatalog subCatalog : catalogs) {
                if (!subCatalog.getParentId().equals(catalog.getCatalogId())) continue;
                tmpl.getSubtitle().add(subCatalog.getCatalogTitle());
            }
        }
        return tmpls;
    }

    public String process(String presetId, String courseId) {
        return this.process(presetId, courseId, "");
    }

    public String process(String presetId, String courseId, String catalog) {
        TranCourseGenerateRequest desc = new TranCourseGenerateRequest();
        desc.setPresetId(presetId);
        desc.setCourseId(courseId);
        desc.setCatalog(catalog);
        if (AiCourseGeneType.train_course_exam_s_choice.getCode().equals(presetId)) {
            desc.setCount("25");
        }
        if (AiCourseGeneType.train_course_scene_dialogue.getCode().equals(presetId)) {
            desc.setCount("10");
        }
        Rsp generate = this.nbchatCourseAiToolApi.generate(desc);
        log.info("\u4e00\u952e\u751f\u6210-\u8c03\u7528\u751f\u6210\u5de5\u5177-\u7ed3\u679c\uff1a{}", (Object)generate);
        if (!generate.isSuccess()) {
            log.error("\u4e00\u952e\u751f\u6210-\u8bfe\u7a0b [{}]-\u5931\u8d25", (Object)AiCourseGeneType.getNameByCode((String)presetId));
            return "";
        }
        RobotToolsChatResponse data = (RobotToolsChatResponse)generate.getData();
        return data.getContent();
    }
}

