/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.tydic.nbchat.admin.api.SysRobotConfigApi;
import com.tydic.nbchat.robot.api.NbchatRobotToolsApi;
import com.tydic.nbchat.robot.api.bo.tools.RobotPromptMessageRequest;
import com.tydic.nbchat.robot.api.bo.tools.RobotToolsChatResponse;
import com.tydic.nbchat.train.api.NbchatCourseAiToolApi;
import com.tydic.nbchat.train.api.bo.eums.AiCourseGeneType;
import com.tydic.nbchat.train.api.bo.generate.TranCourseGenerateRequest;
import com.tydic.nbchat.train.core.util.TrainCommonUtil;
import com.tydic.nbchat.train.mapper.NbchatTrainCourseTextMapper;
import com.tydic.nbchat.train.mapper.po.NbchatTrainCourseText;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class NbchatCourseAiToolServiceImpl
implements NbchatCourseAiToolApi {
    private static final Logger log = LoggerFactory.getLogger(NbchatCourseAiToolServiceImpl.class);
    @Resource
    private NbchatTrainCourseTextMapper nbchatTrainCourseTextMapper;
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=3000)
    private SysRobotConfigApi sysRobotConfigApi;
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=120000)
    private NbchatRobotToolsApi nbchatRobotToolsApi;

    public Rsp generateCourseDesc(String courseId) {
        return this.getChatResult(courseId, AiCourseGeneType.train_course_desc.getCode(), "");
    }

    public Rsp generateCourseCatalog(String courseId) {
        return this.getChatResult(courseId, AiCourseGeneType.train_course_catalog.getCode(), "");
    }

    public Rsp generateCourseSections(String courseId, String catalog) {
        return this.getChatResult(courseId, AiCourseGeneType.train_course_section_all.getCode(), catalog);
    }

    public Rsp generate(TranCourseGenerateRequest request) {
        return this.getChatResult(request);
    }

    private Rsp<RobotToolsChatResponse> getChatResult(String courseId, String presetId, String catalog) {
        TranCourseGenerateRequest request = new TranCourseGenerateRequest();
        request.setCourseId(courseId);
        request.setPresetId(presetId);
        request.setCatalog(catalog);
        return this.getChatResult(request);
    }

    private Rsp<RobotToolsChatResponse> getChatResult(TranCourseGenerateRequest request) {
        NbchatTrainCourseText courseText;
        String presetId = request.getPresetId();
        String catalog = request.getCatalog();
        String courseId = request.getCourseId();
        if (StringUtils.isBlank((CharSequence)request.getCount())) {
            request.setCount("5");
        }
        if ((courseText = this.nbchatTrainCourseTextMapper.queryById(courseId)) == null || StringUtils.isBlank((CharSequence)courseText.getText())) {
            return BaseRspUtils.createErrorRsp((String)"\u751f\u6210\u5931\u8d25:\u8bf7\u5148\u63d0\u4ea4\u8bfe\u7a0b\u8d44\u6599!");
        }
        String text = courseText.getText();
        String robotValue = this.sysRobotConfigApi.getRobotValue(request.getTenantCode(), request.getUserId());
        ArrayList prompts = Lists.newArrayList((Object[])new String[]{text});
        if (AiCourseGeneType.train_course_exam_s_choice.getCode().equals(presetId) || AiCourseGeneType.train_course_scene_dialogue.getCode().equals(presetId)) {
            prompts.add(request.getCount());
        }
        if (AiCourseGeneType.prac_course_scene_dialogue.getCode().equals(presetId)) {
            prompts.add(request.getCount());
            prompts.add(request.getDialogueDesc());
            if (!StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{request.getUserRole(), request.getRobotRole()})) {
                prompts.add(request.getUserRole());
                prompts.add(request.getRobotRole());
            }
        }
        if (AiCourseGeneType.train_course_section.getCode().equals(presetId) || AiCourseGeneType.train_course_section_all.getCode().equals(presetId)) {
            if (StringUtils.isBlank((CharSequence)catalog)) {
                return BaseRspUtils.createErrorRsp((String)"\u751f\u6210\u5931\u8d25:\u7ae0\u8282\u6807\u9898\u4e0d\u5f97\u4e3a\u7a7a!");
            }
            if (JSONObject.isValidArray((String)catalog)) {
                prompts.add(JSONObject.parseArray((String)catalog).toString());
            } else if (JSONObject.isValid((String)catalog)) {
                prompts.add(JSONObject.parseObject((String)catalog).toString());
            } else {
                prompts.add(catalog);
            }
        }
        RobotPromptMessageRequest messageRequest = new RobotPromptMessageRequest();
        messageRequest.setUserId(courseId);
        messageRequest.setPresetPrompts((List)prompts);
        messageRequest.setPresetId(presetId);
        messageRequest.setTrim(true);
        messageRequest.setRobotType(robotValue);
        log.info("\u8bf7\u6c42\u673a\u5668\u4eba\u6a21\u5757:{}|{}|{}", new Object[]{request.getUserId(), presetId, robotValue});
        Rsp rsp = this.nbchatRobotToolsApi.getChatResult(messageRequest);
        String jsonStr = "";
        if (rsp.isSuccess()) {
            String examContent;
            jsonStr = ((RobotToolsChatResponse)rsp.getData()).getContent();
            if (!JSONObject.isValid((String)jsonStr)) {
                jsonStr = TrainCommonUtil.extractJson(jsonStr);
                ((RobotToolsChatResponse)rsp.getData()).setContent(jsonStr);
            }
            if (AiCourseGeneType.train_course_exam_s_choice.getCode().equals(presetId) && JSONObject.isValidArray((String)(examContent = jsonStr))) {
                JSONArray array = JSONObject.parseArray((String)examContent);
                for (int i = 0; i < array.size(); ++i) {
                    String answers = array.getJSONObject(i).getString("answers");
                    answers = this.replaceAnswers(answers);
                    array.getJSONObject(i).put("answers", (Object)JSONObject.parseArray((String)answers));
                    String items = array.getJSONObject(i).getString("items");
                    items = this.replaceItems(items);
                    array.getJSONObject(i).put("items", (Object)JSONObject.parseArray((String)items));
                }
                ((RobotToolsChatResponse)rsp.getData()).setContent(array.toString());
            }
        }
        return rsp;
    }

    private String replaceItems(String items) {
        return items.replaceAll("\"A\uff1a", "\"").replaceAll("\"B\uff1a", "\"").replaceAll("\"C\uff1a", "\"").replaceAll("\"D\uff1a", "\"").replaceAll("\"E\uff1a", "\"");
    }

    private String replaceAnswers(String answers) {
        return answers.replaceAll("A", "0").replaceAll("B", "1").replaceAll("C", "2").replaceAll("D", "3").replaceAll("E", "4");
    }
}

