/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONValidator;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.tydic.nbchat.train.api.NbcahtExamQuestionApi;
import com.tydic.nbchat.train.api.bo.QuestionSaveRequest;
import com.tydic.nbchat.train.api.bo.eums.QuestionType;
import com.tydic.nbchat.train.api.bo.question.ChoiceQuestion;
import com.tydic.nbchat.train.api.bo.question.FillBlanksQuestion;
import com.tydic.nbchat.train.api.bo.question.QaQuestion;
import com.tydic.nbchat.train.api.bo.question.Question;
import com.tydic.nbchat.train.mapper.NbchatExamQuestionItemsMapper;
import com.tydic.nbchat.train.mapper.NbchatExamQuestionMapper;
import com.tydic.nbchat.train.mapper.po.NbchatExamQuestion;
import com.tydic.nbchat.train.mapper.po.NbchatExamQuestionItems;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class NbchatExamQuestionServiceImpl
implements NbcahtExamQuestionApi {
    private static final Logger log = LoggerFactory.getLogger(NbchatExamQuestionServiceImpl.class);
    @Resource
    NbchatExamQuestionMapper nbchatExamQuestionMapper;
    @Resource
    NbchatExamQuestionItemsMapper nbchatExamQuestionItemsMapper;

    @Transactional(rollbackFor={Exception.class})
    public Rsp saveQuestion(QuestionSaveRequest saveRequest) {
        log.info("\u4fdd\u5b58\u8bd5\u9898-\u5f00\u59cb:{}", (Object)saveRequest);
        if (!JSONValidator.from((String)saveRequest.getContent()).validate()) {
            return BaseRspUtils.createErrorRsp((String)"\u8bd5\u9898\u7ed3\u6784\u5f02\u5e38");
        }
        if (QuestionType.isChoice((String)saveRequest.getQuestionType()) || QuestionType.isJudgment((String)saveRequest.getQuestionType())) {
            return this.handleChoiceType(saveRequest);
        }
        if (QuestionType.isFillBlank((String)saveRequest.getQuestionType())) {
            return this.handleFillBlank(saveRequest);
        }
        if (QuestionType.isQA((String)saveRequest.getQuestionType())) {
            return this.handleQA(saveRequest);
        }
        log.warn("\u4fdd\u5b58\u8bd5\u9898-\u672a\u9884\u8bbe\u7684\u8bd5\u9898\u7c7b\u578b:{}", (Object)saveRequest.getQuestionType());
        return BaseRspUtils.createErrorRsp((String)"\u672a\u9884\u8bbe\u7684\u8bd5\u9898\u7c7b\u578b");
    }

    @Transactional(rollbackFor={Exception.class})
    public Rsp appendQuestion(QuestionSaveRequest request) {
        if (!JSONValidator.from((String)request.getContent()).validate()) {
            log.info("\u4fdd\u5b58\u8003\u8bd5\u914d\u7f6e:\u8bd5\u9898\u7ed3\u6784\u5f02\u5e38:{}", (Object)request.getContent());
            return BaseRspUtils.createErrorRsp((String)"\u8bd5\u9898\u7ed3\u6784\u5f02\u5e38");
        }
        this.saveQuestions(request, QuestionType.CHOICE_S.getCode());
        this.saveQuestions(request, QuestionType.CHOICE_M.getCode());
        this.saveQuestions(request, QuestionType.TRUE_FALSE.getCode());
        return BaseRspUtils.createSuccessRsp((Object)"\u4fdd\u5b58\u6210\u529f");
    }

    private void saveQuestions(QuestionSaveRequest questionSaveRequest, String questionType) {
        List list = (List)JSON.parseObject((String)questionSaveRequest.getContent(), (TypeReference)new TypeReference<List<String>>(){}, (Feature[])new Feature[0]);
        List questionsList = list.stream().filter(json -> questionType.equals(JSON.parseObject((String)json).getString("type"))).collect(Collectors.toList());
        log.info("\u4fdd\u5b58\u8bd5\u9898-\u5f00\u59cb:{}", (Object)questionsList.size());
        if (CollectionUtils.isNotEmpty(questionsList)) {
            QuestionSaveRequest request = new QuestionSaveRequest();
            request.setContent(questionsList.toString());
            request.setCourseId(questionSaveRequest.getCourseId());
            request.setTenantCode(questionSaveRequest.getTenantCode());
            request.setQuestionType(questionType);
            request.setUserId(questionSaveRequest.getUserId());
            request.setPartId(questionSaveRequest.getPartId());
            Rsp rsp = this.saveQuestion(request);
            if (rsp.isSuccess()) {
                log.info("\u4fdd\u5b58\u8bd5\u9898-\u6210\u529f:{}|{}", (Object)questionType, (Object)rsp);
            } else {
                log.error("\u4fdd\u5b58\u8bd5\u9898-\u5931\u8d25:{}|{}", (Object)questionType, (Object)rsp);
            }
        }
    }

    public Rsp handleChoiceType(QuestionSaveRequest saveRequest) {
        List choiceQuestions = JSONObject.parseArray((String)saveRequest.getContent(), ChoiceQuestion.class);
        for (ChoiceQuestion question : choiceQuestions) {
            NbchatExamQuestion record = this.saveQuestionRecord(saveRequest, question);
            List items = question.getItems();
            List answers = question.getAnswers();
            this.saveAnswerRecord(record, items, answers);
        }
        return BaseRspUtils.createSuccessRsp(null);
    }

    public Rsp handleFillBlank(QuestionSaveRequest saveRequest) {
        String content = saveRequest.getContent();
        List fillBlanksQuestions = JSONObject.parseArray((String)content, FillBlanksQuestion.class);
        for (FillBlanksQuestion question : fillBlanksQuestions) {
            NbchatExamQuestion record = this.saveQuestionRecord(saveRequest, question);
            List items = question.getAnswers();
            this.saveAnswerRecord(record, items);
        }
        return BaseRspUtils.createSuccessRsp(null);
    }

    public Rsp handleQA(QuestionSaveRequest saveRequest) {
        String content = saveRequest.getContent();
        List questions = JSONObject.parseArray((String)content, QaQuestion.class);
        for (QaQuestion question : questions) {
            NbchatExamQuestion record = this.saveQuestionRecord(saveRequest, question);
            String answerContent = question.getAnswer();
            List<String> items = Collections.singletonList(answerContent);
            this.saveAnswerRecord(record, items);
        }
        return BaseRspUtils.createSuccessRsp(null);
    }

    public void consumerQuestion(QuestionSaveRequest saveRequest, Question question, List<String> items, List<Integer> answers) {
        NbchatExamQuestion nbchatExamQuestion = this.saveQuestionRecord(saveRequest, question);
        NbchatExamQuestion quest = new NbchatExamQuestion();
        quest.setQuestionId(nbchatExamQuestion.getQuestionId());
        quest.setQuestionType(nbchatExamQuestion.getQuestionType());
        this.saveAnswerRecord(quest, items, answers);
    }

    public <T extends Question> NbchatExamQuestion saveQuestionRecord(QuestionSaveRequest saveRequest, T question) {
        NbchatExamQuestion record = new NbchatExamQuestion();
        record.setQuestionId(IdWorker.nextAutoIdStr());
        record.setCourseId(saveRequest.getCourseId());
        record.setTenantCode(saveRequest.getTenantCode());
        record.setQuestionName(question.getQuestion());
        record.setQuestionType(saveRequest.getQuestionType());
        record.setCreateTime(new Date());
        record.setPartId(saveRequest.getPartId());
        record.setDifficulty(question.getDifficulty());
        record.setExplan(question.getExplan());
        record.setKnowledges(saveRequest.getKnowledges());
        this.nbchatExamQuestionMapper.insertSelective(record);
        return record;
    }

    public void saveAnswerRecord(NbchatExamQuestion record, List<String> items) {
        this.saveAnswerRecord(record, items, null);
    }

    public void saveAnswerRecord(NbchatExamQuestion record, List<String> items, List<Integer> answers) {
        NbchatExamQuestionItems answer = new NbchatExamQuestionItems();
        for (String item : items) {
            answer.setItemId(IdWorker.nextAutoIdStr());
            answer.setQuestionId(record.getQuestionId());
            answer.setQuestionType(record.getQuestionType());
            answer.setItemValue(item);
            answer.setItemIndex(Short.valueOf((short)items.indexOf(item)));
            if (CollectionUtils.isNotEmpty(answers)) {
                String isRight = answers.contains(items.indexOf(item)) ? "1" : "0";
                answer.setIsRight(isRight);
            } else {
                answer.setIsRight("1");
            }
            answer.setCreateTime(new Date());
            this.nbchatExamQuestionItemsMapper.insertSelective(answer);
        }
    }
}

