/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.service.impl;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.read.builder.ExcelReaderBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.metadata.style.WriteCellStyle;
import com.alibaba.excel.write.metadata.style.WriteFont;
import com.alibaba.excel.write.style.HorizontalCellStyleStrategy;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONValidator;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.tydic.nbchat.admin.api.bo.file.FileUploadRequest;
import com.tydic.nbchat.admin.api.fileMannager.FileManageService;
import com.tydic.nbchat.train.api.NbcahtExamQuestionApi;
import com.tydic.nbchat.train.api.NbchatExamRuleTestApi;
import com.tydic.nbchat.train.api.bo.QuestionSaveRequest;
import com.tydic.nbchat.train.api.bo.constants.QuestionConstants;
import com.tydic.nbchat.train.api.bo.eums.ExamTestType;
import com.tydic.nbchat.train.api.bo.eums.QuestionType;
import com.tydic.nbchat.train.api.bo.eums.StateEnum;
import com.tydic.nbchat.train.api.bo.exam.ExamQuestion;
import com.tydic.nbchat.train.api.bo.exam.ExamQuestionItem;
import com.tydic.nbchat.train.api.bo.examRule.ExamRuleBO;
import com.tydic.nbchat.train.api.bo.examRule.ExamRuleReqBO;
import com.tydic.nbchat.train.api.bo.examRule.ExamRuleRspBO;
import com.tydic.nbchat.train.api.bo.question.QuestionSaveRspBO;
import com.tydic.nbchat.train.core.helper.CustomSheetWriteHandler;
import com.tydic.nbchat.train.core.helper.QuestionExcelRowWriteHandler;
import com.tydic.nbchat.train.core.service.impl.excel.ExamReadListener;
import com.tydic.nbchat.train.mapper.NbchatExamQuestionItemsMapper;
import com.tydic.nbchat.train.mapper.NbchatExamQuestionMapper;
import com.tydic.nbchat.train.mapper.NbchatExamTestPaperMapper;
import com.tydic.nbchat.train.mapper.NbchatTrainCourseCategoryMapper;
import com.tydic.nbchat.train.mapper.NbchatTrainCourseMapper;
import com.tydic.nbchat.train.mapper.po.NbchatExamQuestion;
import com.tydic.nbchat.train.mapper.po.NbchatExamQuestionItems;
import com.tydic.nbchat.train.mapper.po.NbchatExamTestPaper;
import com.tydic.nbchat.train.mapper.po.NbchatQuestion;
import com.tydic.nbchat.train.mapper.po.NbchatTrainCourse;
import com.tydic.nbchat.train.mapper.po.NbchatTrainCourseCategory;
import com.tydic.nbchat.train.mapper.po.NbchatTrainCourseSelectCondition;
import com.tydic.nicc.common.eums.EntityValidType;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.framework.utils.FileManagerHelper;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import java.io.File;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class NbchatExamRuleTestServiceImpl
implements NbchatExamRuleTestApi {
    private static final Logger log = LoggerFactory.getLogger(NbchatExamRuleTestServiceImpl.class);
    @Resource
    private NbchatExamTestPaperMapper nbchatExamTestPaperMapper;
    @Resource
    private NbchatTrainCourseMapper nbchatTrainCourseMapper;
    @Resource
    private NbchatTrainCourseCategoryMapper nbchatTrainCourseCategoryMapper;
    @Resource
    private NbcahtExamQuestionApi nbcahtExamQuestionApi;
    @Resource
    private NbchatExamQuestionMapper nbchatExamQuestionMapper;
    @Resource
    private NbchatExamQuestionItemsMapper nbchatExamQuestionItemsMapper;
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=5000)
    private FileManageService fileManageService;

    @Transactional(rollbackFor={Exception.class})
    public Rsp save(ExamRuleBO request) {
        log.info("\u4fdd\u5b58\u8003\u8bd5\u914d\u7f6e:{}", (Object)request);
        NbchatTrainCourse course = this.nbchatTrainCourseMapper.selectByPrimaryKey(request.getCourseId());
        if (course == null || !EntityValidType.NORMAL.getCode().equals(course.getIsValid())) {
            log.info("\u4fdd\u5b58\u8003\u8bd5\u914d\u7f6e:\u67e5\u8be2\u5931\u8d25\uff1a\u8be5\u8bfe\u7a0b\u4e0d\u5b58\u5728!{}", (Object)request.getCourseId());
            return BaseRspUtils.createErrorRsp((String)"\u8be5\u8bfe\u7a0b\u4e0d\u5b58\u5728!");
        }
        log.info("\u4fdd\u5b58\u8003\u8bd5\u914d\u7f6e:\u8bfe\u7a0b\u67e5\u8be2\u6210\u529f!{}", (Object)course);
        int testNum = request.getTestNum();
        if (testNum >= 5 && testNum <= 50 && testNum % 5 == 0) {
            log.info("\u4fdd\u5b58\u8003\u8bd5\u914d\u7f6e:\u8003\u8bd5\u6b21\u6570\u6ee1\u8db3\u6761\u4ef6!{}", (Object)request.getTestNum());
        } else {
            log.info("\u4fdd\u5b58\u8003\u8bd5\u914d\u7f6e:\u8003\u8bd5\u6b21\u6570\u4e0d\u6ee1\u8db3\u6761\u4ef6!{},\u5df2\u8bbe\u7f6e\u4e3a\u9ed8\u8ba4", (Object)request.getTestNum());
            request.setTestNum(Integer.valueOf(10));
        }
        if (request.getMultiple() + request.getSingle() + request.getTrueOrFalse() != request.getTestNum()) {
            log.info("\u4fdd\u5b58\u8003\u8bd5\u914d\u7f6e:\u8bd5\u9898\u7c7b\u578b\u7684\u6570\u91cf\u8bbe\u7f6e\u4e0d\u6b63\u786e-\u5355\u9009|\u591a\u9009|\u5224\u65ad|\u8bd5\u5377\u6570\u91cf:{}|{}|{}|{}", new Object[]{request.getSingle(), request.getMultiple(), request.getTestNum(), request.getTestNum()});
            return BaseRspUtils.createErrorRsp((String)"\u8bd5\u9898\u6570\u91cf\u4e0d\u7b26\u5408");
        }
        if (StringUtils.isNotBlank((CharSequence)request.getTestType()) || ExamTestType.ORDER.getCode() != request.getTestType() && ExamTestType.RANDOM.getCode() != request.getTestType()) {
            request.setTestType(ExamTestType.RANDOM.getCode());
        }
        if (StringUtils.isBlank((CharSequence)request.getPassingScore())) {
            request.setPassingScore("90");
        }
        if (StringUtils.isBlank((CharSequence)request.getTrainState())) {
            request.setTrainState("0");
        }
        log.info("\u4fdd\u5b58\u8003\u8bd5\u914d\u7f6e:\u51fa\u9898\u987a\u5e8f\u4e3a\uff1a{}", (Object)request.getTestType());
        NbchatExamTestPaper nbchatExamTestPaper = this.nbchatExamTestPaperMapper.queryByCourseId(request.getCourseId(), request.getTenantCode());
        if (nbchatExamTestPaper == null) {
            log.info("\u4fdd\u5b58\u8003\u8bd5\u914d\u7f6e:\u8be5\u8bfe\u7a0b{}\u2014\u2014{}\u672a\u914d\u7f6e\u8fc7\u8003\u8bd5\u914d\u7f6e!\u8fdb\u884c\u4fdd\u5b58\u64cd\u4f5c\uff01", (Object)request.getCourseId(), (Object)course.getCourseName());
            nbchatExamTestPaper = new NbchatExamTestPaper();
            BeanUtils.copyProperties((Object)request, (Object)nbchatExamTestPaper);
            this.nbchatExamTestPaperMapper.insert(nbchatExamTestPaper);
            log.info("\u4fdd\u5b58\u8003\u8bd5\u914d\u7f6e-\u6210\u529f:{}", (Object)nbchatExamTestPaper);
        } else {
            log.info("\u4fdd\u5b58\u8003\u8bd5\u914d\u7f6e:\u8be5\u8bfe\u7a0b{}\u2014\u2014{}\u5df2\u914d\u7f6e\u8fc7\u8003\u8bd5\u914d\u7f6e!\u8fdb\u884c\u66f4\u65b0\u64cd\u4f5c\uff01", (Object)request.getCourseId(), (Object)course.getCourseName());
            nbchatExamTestPaper = new NbchatExamTestPaper();
            BeanUtils.copyProperties((Object)request, (Object)nbchatExamTestPaper);
            nbchatExamTestPaper.setUpdateTime(new Date());
            this.nbchatExamTestPaperMapper.update(nbchatExamTestPaper);
            log.info("\u66f4\u65b0\u8003\u8bd5\u914d\u7f6e-\u6210\u529f:{}", (Object)nbchatExamTestPaper);
        }
        NbchatTrainCourse nbchatTrainCourse = new NbchatTrainCourse();
        nbchatTrainCourse.setCourseId(request.getCourseId());
        nbchatTrainCourse.setUpdateTime(new Date());
        nbchatTrainCourse.setTestPaperState(StateEnum.COURSE.EDIT.getCode());
        this.nbchatTrainCourseMapper.updateByPrimaryKeySelective(nbchatTrainCourse);
        if (StringUtils.isNotBlank((CharSequence)request.getContent())) {
            log.info("\u4fdd\u5b58\u8003\u8bd5\u914d\u7f6e:\u8bd5\u9898\u5185\u5bb9\u4e0d\u4e3a\u7a7a:{}", (Object)request.getContent());
            QuestionSaveRequest questionSaveRequest = new QuestionSaveRequest();
            BeanUtils.copyProperties((Object)request, (Object)questionSaveRequest);
            Rsp rsp = this.saveQuestion(questionSaveRequest, request.getSingle(), request.getMultiple(), request.getTrueOrFalse());
            return rsp;
        }
        return BaseRspUtils.createSuccessRsp((Object)"\u4fdd\u5b58\u6210\u529f");
    }

    public Rsp query(ExamRuleReqBO request) {
        log.info("\u67e5\u8be2\u8003\u8bd5\u914d\u7f6e:{}", (Object)request);
        NbchatTrainCourse nbchatTrainCourse = this.nbchatTrainCourseMapper.selectByPrimaryKey(request.getCourseId());
        if (nbchatTrainCourse == null || !EntityValidType.NORMAL.getCode().equals(nbchatTrainCourse.getIsValid())) {
            log.error("\u67e5\u8be2\u8003\u8bd5\u914d\u7f6e:\u67e5\u8be2\u5931\u8d25\uff1a\u8be5\u8bfe\u7a0b\u4e0d\u5b58\u5728!{}", (Object)request.getCourseId());
            return BaseRspUtils.createErrorRsp((String)"\u8be5\u8bfe\u7a0b\u4e0d\u5b58\u5728!");
        }
        log.info("\u67e5\u8be2\u8003\u8bd5\u914d\u7f6e:\u67e5\u8be2\u8bfe\u7a0b\u6210\u529f!{}", (Object)nbchatTrainCourse);
        ExamRuleRspBO examRuleRspBO = new ExamRuleRspBO();
        examRuleRspBO.setCourseName(nbchatTrainCourse.getCourseName());
        examRuleRspBO.setExamState(nbchatTrainCourse.getTestPaperState());
        examRuleRspBO.setTenantCode(nbchatTrainCourse.getTenantCode());
        examRuleRspBO.setCourseId(nbchatTrainCourse.getCourseId());
        examRuleRspBO.setCourseState(nbchatTrainCourse.getCourseState());
        examRuleRspBO.setCourseType(nbchatTrainCourse.getCourseType());
        NbchatTrainCourseCategory nbchatTrainCourseCategory = this.nbchatTrainCourseCategoryMapper.queryById(nbchatTrainCourse.getCategory2());
        if (nbchatTrainCourseCategory == null) {
            log.warn("\u67e5\u8be2\u8003\u8bd5\u914d\u7f6e:\u67e5\u8be2\u5931\u8d25\uff1a\u8be5\u8bfe\u7a0b\u5206\u7c7b\u4e0d\u5b58\u5728!{}", (Object)nbchatTrainCourse.getCategory2());
        } else {
            examRuleRspBO.setCatalogName(nbchatTrainCourseCategory.getCateName());
            log.info("\u67e5\u8be2\u8003\u8bd5\u914d\u7f6e:\u67e5\u8be2\u8bfe\u7a0b\u5206\u7c7b\u6210\u529f!{}", (Object)nbchatTrainCourseCategory);
        }
        NbchatExamTestPaper nbchatExamTestPapers = this.nbchatExamTestPaperMapper.queryByCourseId(request.getCourseId(), request.getTenantCode());
        if (nbchatExamTestPapers == null) {
            log.warn("\u67e5\u8be2\u8003\u8bd5\u914d\u7f6e:\u67e5\u8be2\u5931\u8d25\uff1a\u8be5\u8bfe\u7a0b\u7684\u8003\u8bd5\u914d\u7f6e\u4e0d\u5b58\u5728!{}", (Object)request.getCourseId());
            return BaseRspUtils.createSuccessRsp((Object)examRuleRspBO, (String)"\u8be5\u8bfe\u7a0b\u7684\u8003\u8bd5\u914d\u7f6e\u4e0d\u5b58\u5728!");
        }
        log.info("\u67e5\u8be2\u8003\u8bd5\u914d\u7f6e:\u67e5\u8be2\u8bfe\u7a0b\u7684\u8003\u8bd5\u914d\u7f6e\u6210\u529f!{}", (Object)nbchatExamTestPapers);
        BeanUtils.copyProperties((Object)nbchatExamTestPapers, (Object)examRuleRspBO);
        if ("0".equals(request.getQueryQuestion())) {
            log.info("\u67e5\u8be2\u8003\u8bd5\u914d\u7f6e-\u6210\u529f:{}", (Object)examRuleRspBO);
            return BaseRspUtils.createSuccessRsp((Object)examRuleRspBO, (String)"\u67e5\u8be2\u6210\u529f");
        }
        List<ExamQuestion> examQuestionList = this.queryQuestion(request.getCourseId());
        if (CollectionUtils.isNotEmpty(examQuestionList)) {
            examRuleRspBO.setQuestions(examQuestionList);
        }
        log.info("\u67e5\u8be2\u8003\u8bd5\u914d\u7f6e-\u6210\u529f:{}", (Object)examRuleRspBO);
        return BaseRspUtils.createSuccessRsp((Object)examRuleRspBO, (String)"\u67e5\u8be2\u6210\u529f");
    }

    public RspList getCourseExamList(ExamRuleReqBO request) {
        log.info("\u67e5\u8be2\u8003\u8bd5\u914d\u7f6e(\u5206\u9875): {}", (Object)request);
        ArrayList result = new ArrayList();
        NbchatTrainCourseSelectCondition condition = new NbchatTrainCourseSelectCondition();
        BeanUtils.copyProperties((Object)request, (Object)condition);
        condition.setIsValid(EntityValidType.NORMAL.getCode());
        Page page = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        this.nbchatTrainCourseMapper.selectCourseByCondition(condition);
        page.getResult().forEach(nbchatTrainCourse -> {
            request.setCourseId(nbchatTrainCourse.getCourseId());
            request.setQueryQuestion("0");
            Rsp rsp = this.query(request);
            if (rsp.isSuccess()) {
                ExamRuleRspBO examRuleRspBO = (ExamRuleRspBO)rsp.getData();
                result.add(examRuleRspBO);
            }
        });
        log.info("\u67e5\u8be2\u8003\u8bd5\u914d\u7f6e(\u5206\u9875): {}", (Object)page.getTotal());
        return BaseRspUtils.createSuccessRspList(result, (long)page.getTotal());
    }

    public Rsp putOnShelves(ExamRuleReqBO request) {
        if (StringUtils.isBlank((CharSequence)request.getTestPaperState())) {
            log.warn("\u67e5\u8be2\u8003\u8bd5\u914d\u7f6e:\u67e5\u8be2\u5931\u8d25\uff1a\u8bd5\u9898\u914d\u7f6e\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a!{}", (Object)request.getTestPaperState());
            return BaseRspUtils.createErrorRsp((String)"\u8bd5\u9898\u914d\u7f6e\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StateEnum.COURSE.ON.getCode().equals(request.getTestPaperState())) {
            List nbchatExamQuestionList = this.nbchatExamQuestionMapper.selectByCourseId(request.getCourseId());
            if (nbchatExamQuestionList == null || nbchatExamQuestionList.size() == 0) {
                log.warn("\u67e5\u8be2\u8003\u8bd5\u914d\u7f6e:\u67e5\u8be2\u5931\u8d25\uff1a\u8bd5\u9898\u4e0d\u5b58\u5728!{}", (Object)request.getCourseId());
                return BaseRspUtils.createErrorRsp((String)"\u8bf7\u5148 \u751f\u6210\u8bd5\u9898\uff01");
            }
            int examQuestionsNum = nbchatExamQuestionList.size();
            NbchatExamTestPaper nbchatExamTestPaper = this.nbchatExamTestPaperMapper.queryByCourseId(request.getCourseId(), request.getTenantCode());
            if (nbchatExamTestPaper == null) {
                log.warn("\u67e5\u8be2\u8003\u8bd5\u914d\u7f6e:\u67e5\u8be2\u5931\u8d25\uff1a\u8be5\u8bfe\u7a0b\u7684\u8003\u8bd5\u914d\u7f6e\u4e0d\u5b58\u5728!{}", (Object)request.getCourseId());
                return BaseRspUtils.createErrorRsp((String)"\u8be5\u8bfe\u7a0b\u7684\u8003\u8bd5\u914d\u7f6e\u4e0d\u5b58\u5728\uff01");
            }
            int num = nbchatExamTestPaper.getTestNum();
            if (examQuestionsNum < num) {
                log.warn("\u67e5\u8be2\u8003\u8bd5\u914d\u7f6e:\u67e5\u8be2\u5931\u8d25\uff1a\u914d\u7f6e\u9898\u6570\u5927\u4e8e\u9898\u5e93\u9898\u6570!{}", (Object)request.getCourseId());
                return BaseRspUtils.createErrorRsp((String)"\u914d\u7f6e\u9898\u6570\u5927\u4e8e\u9898\u5e93\u9898\u6570\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e\uff01");
            }
        }
        NbchatTrainCourse nbchatTrainCourse = new NbchatTrainCourse();
        nbchatTrainCourse.setCourseId(request.getCourseId());
        nbchatTrainCourse.setUpdateTime(new Date());
        nbchatTrainCourse.setTestPaperState(request.getTestPaperState());
        this.nbchatTrainCourseMapper.updateByPrimaryKeySelective(nbchatTrainCourse);
        return BaseRspUtils.createSuccessRsp((Object)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    public Rsp export(ExamRuleReqBO request) {
        log.info("\u8bd5\u9898\u5bfc\u51fa:{}", (Object)request);
        List<ExamQuestion> questions = this.queryQuestion(request.getIds(), null);
        Rsp rsp = this.export(questions, request);
        return rsp;
    }

    @Transactional
    public Rsp importFile(InputStream inputStream, String courseId, String tenantCode) {
        ExamReadListener listener = new ExamReadListener(this.nbcahtExamQuestionApi, courseId, tenantCode);
        ((ExcelReaderBuilder)((ExcelReaderBuilder)EasyExcel.read((InputStream)inputStream).headRowNumber(Integer.valueOf(2))).registerReadListener((ReadListener)listener)).sheet().doRead();
        return BaseRspUtils.createSuccessRsp((Object)"\u5bfc\u5165\u6210\u529f");
    }

    public Rsp exportQuestion(ExamRuleReqBO request) {
        String content = request.getContent();
        JSONArray jsonArray = JSON.parseArray((String)content);
        ArrayList<ExamQuestion> questions = new ArrayList<ExamQuestion>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            ExamQuestion examQuestion = new ExamQuestion();
            examQuestion.setQuestionName(jsonObject.getString("question"));
            examQuestion.setQuestionType(jsonObject.getString("type"));
            examQuestion.setDifficulty(jsonObject.getString("difficulty"));
            examQuestion.setExplan(jsonObject.getString("explan"));
            examQuestion.setKnowledges(jsonObject.getString("knowledges"));
            JSONArray itemsArray = jsonObject.getJSONArray("items");
            ArrayList<ExamQuestionItem> items = new ArrayList<ExamQuestionItem>();
            for (int j = 0; j < itemsArray.size(); ++j) {
                ExamQuestionItem item = new ExamQuestionItem();
                item.setItemValue(itemsArray.getString(j));
                item.setItemIndex(Short.valueOf((short)j));
                items.add(item);
            }
            examQuestion.setItems(items);
            if (QuestionType.isChoice((String)jsonObject.getString("type")) || QuestionType.isJudgment((String)jsonObject.getString("type"))) {
                JSONArray answersJsonArray = jsonObject.getJSONArray("answers");
                ArrayList<String> answers = new ArrayList<String>();
                for (int j = 0; j < answersJsonArray.size(); ++j) {
                    answers.add(answersJsonArray.getString(j));
                }
                examQuestion.setAnswers(answers);
            } else {
                List answers = items.stream().map(ExamQuestionItem::getItemValue).collect(Collectors.toList());
                examQuestion.setAnswers(answers);
            }
            questions.add(examQuestion);
        }
        Rsp rsp = this.export(questions, request);
        return rsp;
    }

    private Rsp export(List<ExamQuestion> questions, ExamRuleReqBO request) {
        QuestionSaveRspBO rspBO = new QuestionSaveRspBO();
        try {
            String fileName = "\u667a\u80fd\u751f\u6210\u8bd5\u9898_" + new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5HH\u65f6mm\u5206ss\u79d2").format(new Date()) + ".xlsx";
            String tempPath = System.getProperty("java.io.tmpdir");
            File dirFile = new File(tempPath + "/" + fileName);
            List<NbchatQuestion> data = this.convertToExportFormat(questions);
            int maxOptions = data.stream().mapToInt(e -> e.getOptions().size()).max().orElse(0);
            int totalColumns = 6 + maxOptions;
            List<List<String>> head = this.createDynamicHead(maxOptions);
            HorizontalCellStyleStrategy horizontalCellStyleStrategy = this.setExcelStyle();
            ((ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)((ExcelWriterBuilder)EasyExcel.write((File)dirFile).head(head)).sheet("\u667a\u80fd\u751f\u6210\u8bd5\u9898_").registerWriteHandler((WriteHandler)new CustomSheetWriteHandler(totalColumns))).registerWriteHandler((WriteHandler)horizontalCellStyleStrategy)).registerWriteHandler((WriteHandler)new QuestionExcelRowWriteHandler())).useDefaultStyle(Boolean.valueOf(true))).relativeHeadRowIndex(Integer.valueOf(1))).doWrite((Collection)data.stream().map(item -> {
                ArrayList<String> row = new ArrayList<String>();
                row.add(item.getQuestionType());
                row.add(item.getQuestionName());
                row.add(item.getDifficulty());
                row.add(item.getExplan());
                row.add(item.getKnowledges());
                row.add(item.getAnswer());
                row.addAll(item.getOptions());
                return row;
            }).collect(Collectors.toList()));
            log.info("\u8bd5\u9898\u5bfc\u51fa:{}|{}", (Object)dirFile.exists(), (Object)dirFile.getAbsolutePath());
            MultipartFile multipartFile = FileManagerHelper.parseToMultipartFile((File)dirFile);
            FileUploadRequest uploadRequest = new FileUploadRequest();
            uploadRequest.setTenantCode(request.getTenantCode());
            uploadRequest.setUploadUser(request.getUserId());
            uploadRequest.setFileName(dirFile.getName());
            uploadRequest.setFile(multipartFile.getBytes());
            uploadRequest.setUseOriginalName(true);
            RspList fileManageSaveBOS = this.fileManageService.fileUploadRequest(uploadRequest);
            log.info("\u6587\u4ef6\u4e0a\u4f20\u5b8c\u6bd5\uff0c\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)fileManageSaveBOS));
            if (!fileManageSaveBOS.isSuccess()) {
                return BaseRspUtils.createErrorRsp((String)"\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25");
            }
            rspBO.setFileManageSaveBO(fileManageSaveBOS.getRows());
            log.info("\u8bd5\u9898\u5bfc\u51fa-\u5bfc\u51fa\u6210\u529f");
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
        return BaseRspUtils.createSuccessRsp((Object)rspBO, (String)"\u5bfc\u51fa\u6210\u529f");
    }

    public List<ExamQuestion> queryQuestion(List<String> qIds, Object obj) {
        if (CollectionUtils.isNotEmpty(qIds)) {
            List questions = this.nbchatExamQuestionMapper.queryQuestions(qIds);
            return this.queryQuestion(questions);
        }
        return new ArrayList<ExamQuestion>();
    }

    public List<ExamQuestion> queryQuestion(List<NbchatExamQuestion> questions) {
        ArrayList<ExamQuestion> examQuestions = new ArrayList<ExamQuestion>();
        questions.forEach(nbchatExamQuestion -> {
            ExamQuestion examQuestion = new ExamQuestion();
            examQuestion.setQuestionId(nbchatExamQuestion.getQuestionId());
            examQuestion.setQuestionName(nbchatExamQuestion.getQuestionName());
            examQuestion.setQuestionType(nbchatExamQuestion.getQuestionType());
            examQuestion.setExplan(nbchatExamQuestion.getExplan());
            examQuestion.setKnowledges(nbchatExamQuestion.getKnowledges());
            examQuestion.setDifficulty(nbchatExamQuestion.getDifficulty());
            NbchatExamQuestionItems condition = new NbchatExamQuestionItems();
            condition.setQuestionId(nbchatExamQuestion.getQuestionId());
            List itemRec = this.nbchatExamQuestionItemsMapper.selectByCondition(condition);
            if (itemRec == null || itemRec.size() == 0) {
                log.error("\u67e5\u8be2\u8003\u8bd5\u914d\u7f6e:\u67e5\u8be2\u5931\u8d25\uff1a\u8bd5\u9898\u9009\u9879\u4e0d\u5b58\u5728!{}", (Object)nbchatExamQuestion.getQuestionId());
            }
            ArrayList items = new ArrayList();
            NiccCommonUtil.copyList((List)itemRec, items, ExamQuestionItem.class);
            examQuestion.setItems(items);
            if (QuestionType.isChoice((String)nbchatExamQuestion.getQuestionType()) || QuestionType.isJudgment((String)nbchatExamQuestion.getQuestionType())) {
                List answers = items.stream().filter(item -> "1".equals(item.getIsRight())).map(ExamQuestionItem::getItemIndex).map(String::valueOf).collect(Collectors.toList());
                examQuestion.setAnswers(answers);
            } else {
                List answers = items.stream().map(ExamQuestionItem::getItemValue).collect(Collectors.toList());
                examQuestion.setAnswers(answers);
            }
            examQuestions.add(examQuestion);
        });
        return examQuestions;
    }

    public List<ExamQuestion> queryQuestion(String courseId) {
        log.info("\u67e5\u8be2\u8003\u8bd5\u914d\u7f6e:\u5f00\u59cb\u67e5\u8be2\u8bd5\u9898:{}", (Object)courseId);
        List nbchatExamQuestionList = this.nbchatExamQuestionMapper.selectByCourseId(courseId);
        if (nbchatExamQuestionList == null || nbchatExamQuestionList.size() == 0) {
            log.warn("\u67e5\u8be2\u8003\u8bd5\u914d\u7f6e:\u67e5\u8be2\u5931\u8d25\uff1a\u8bd5\u9898\u4e0d\u5b58\u5728!{}", (Object)courseId);
            return null;
        }
        log.info("\u67e5\u8be2\u8003\u8bd5\u914d\u7f6e:\u67e5\u8be2\u8bd5\u9898\u6210\u529f!\u5171\u6709\uff1a{}\u6761", (Object)nbchatExamQuestionList.size());
        List<ExamQuestion> examQuestions = this.queryQuestion(nbchatExamQuestionList);
        log.info("\u67e5\u8be2\u8003\u8bd5\u914d\u7f6e:\u67e5\u8be2\u6210\u529f!\u5171\u6709\uff1a{}\u6761", (Object)examQuestions.size());
        return examQuestions;
    }

    @Transactional(rollbackFor={Exception.class})
    public Rsp saveQuestion(QuestionSaveRequest questionSaveRequest, int singleNum, int multipleNum, int trueOrFalseNum) {
        log.info("\u4fdd\u5b58\u8003\u8bd5\u914d\u7f6e:\u5f00\u59cb\u4fdd\u5b58\u8bd5\u9898");
        int del = this.nbchatExamTestPaperMapper.deleteQuestion(questionSaveRequest.getCourseId(), questionSaveRequest.getTenantCode());
        log.info("\u5220\u9664\u539f\u6709\u8bd5\u9898-\u6210\u529f:{}\u6761", (Object)del);
        int delItem = this.nbchatExamTestPaperMapper.deleteQuestionItem(questionSaveRequest.getCourseId(), questionSaveRequest.getTenantCode());
        log.info("\u5220\u9664\u539f\u6709\u8bd5\u9898\u9009\u9879-\u6210\u529f:{}\u6761", (Object)delItem);
        if (!JSONValidator.from((String)questionSaveRequest.getContent()).validate()) {
            log.info("\u4fdd\u5b58\u8003\u8bd5\u914d\u7f6e:\u8bd5\u9898\u7ed3\u6784\u5f02\u5e38:{}", (Object)questionSaveRequest.getContent());
            return BaseRspUtils.createErrorRsp((String)"\u8bd5\u9898\u7ed3\u6784\u5f02\u5e38");
        }
        int single = this.saveQuestions(questionSaveRequest, QuestionType.CHOICE_S.getCode());
        int multiple = this.saveQuestions(questionSaveRequest, QuestionType.CHOICE_M.getCode());
        int trueOrFalse = this.saveQuestions(questionSaveRequest, QuestionType.TRUE_FALSE.getCode());
        if (singleNum > single || multipleNum > multiple || trueOrFalseNum > trueOrFalse) {
            return BaseRspUtils.createErrorRsp((String)"\u8bd5\u9898\u7c7b\u578b\u6570\u91cf\u4e0d\u7b26\u5408");
        }
        return BaseRspUtils.createSuccessRsp((Object)"\u4fdd\u5b58\u6210\u529f");
    }

    private int saveQuestions(QuestionSaveRequest questionSaveRequest, String questionType) {
        List list = (List)JSON.parseObject((String)questionSaveRequest.getContent(), (TypeReference)new TypeReference<List<String>>(){}, (Feature[])new Feature[0]);
        List questionsList = list.stream().filter(json -> questionType.equals(JSON.parseObject((String)json).getString("type"))).collect(Collectors.toList());
        log.info("\u4fdd\u5b58\u8bd5\u9898-\u5f00\u59cb:{}", (Object)questionsList.size());
        if (CollectionUtils.isNotEmpty(questionsList)) {
            QuestionSaveRequest request = new QuestionSaveRequest();
            request.setContent(questionsList.toString());
            request.setCourseId(questionSaveRequest.getCourseId());
            request.setTenantCode(questionSaveRequest.getTenantCode());
            request.setQuestionType(questionType);
            request.setUserId(questionSaveRequest.getUserId());
            request.setPartId(questionSaveRequest.getPartId());
            Rsp rsp = this.nbcahtExamQuestionApi.saveQuestion(request);
            if (rsp.isSuccess()) {
                log.info("\u4fdd\u5b58\u8bd5\u9898-\u6210\u529f:{}|{}", (Object)questionType, (Object)rsp);
            } else {
                log.error("\u4fdd\u5b58\u8bd5\u9898-\u5931\u8d25:{}|{}", (Object)questionType, (Object)rsp);
            }
        }
        return questionsList.size();
    }

    public List<NbchatQuestion> convertToExportFormat(List<ExamQuestion> examQuestions) {
        OptionalInt maxItemsSizeOptional = examQuestions.stream().mapToInt(examQuestion -> examQuestion.getItems().size()).max();
        int maxItemsSize = maxItemsSizeOptional.orElse(0);
        ArrayList<NbchatQuestion> exports = new ArrayList<NbchatQuestion>();
        for (ExamQuestion question : examQuestions) {
            NbchatQuestion export = new NbchatQuestion();
            export.setQuestionType(QuestionType.getNameByCode((String)question.getQuestionType()));
            export.setQuestionName(question.getQuestionName());
            export.setDifficulty(question.getDifficulty());
            export.setExplan(question.getExplan());
            export.setKnowledges(question.getKnowledges());
            ArrayList<String> options = new ArrayList<String>();
            for (ExamQuestionItem item : question.getItems()) {
                options.add(item.getItemValue());
            }
            if (question.getItems().size() < maxItemsSize) {
                for (int i = 0; i < maxItemsSize - question.getItems().size(); ++i) {
                    options.add("");
                }
            }
            export.setOptions(options);
            StringBuilder answer = new StringBuilder();
            if (QuestionType.isChoice((String)question.getQuestionType()) || QuestionType.isJudgment((String)question.getQuestionType())) {
                List answers = question.getAnswers().stream().map(Short::parseShort).collect(Collectors.toList());
                Iterator iterator = answers.iterator();
                while (iterator.hasNext()) {
                    short ans = (Short)iterator.next();
                    if (answer.length() > 0) {
                        answer.append(",");
                    }
                    answer.append((char)(65 + ans));
                }
            } else {
                for (String ans : question.getAnswers()) {
                    if (answer.length() > 0) {
                        answer.append("\uff1b");
                    }
                    answer.append(ans);
                }
            }
            export.setAnswer(answer.toString());
            exports.add(export);
        }
        return exports;
    }

    private List<List<String>> createDynamicHead(int maxOptions) {
        ArrayList<List<String>> head = new ArrayList<List<String>>();
        head.add(Collections.singletonList("\u8bd5\u9898\u7c7b\u578b"));
        head.add(Collections.singletonList("\u9898\u76ee"));
        head.add(Collections.singletonList("\u96be\u5ea6"));
        head.add(Collections.singletonList("\u8bd5\u9898\u89e3\u6790"));
        head.add(Collections.singletonList("\u77e5\u8bc6\u8981\u70b9"));
        head.add(Collections.singletonList("\u6b63\u786e\u7b54\u6848"));
        for (int i = 0; i < maxOptions; ++i) {
            head.add(Collections.singletonList("\u9009\u9879" + (char)(65 + i)));
        }
        return head;
    }

    private HorizontalCellStyleStrategy setExcelStyle() {
        WriteCellStyle contentWriteCellStyle = new WriteCellStyle();
        WriteFont contentWriteFont = new WriteFont();
        contentWriteFont.setFontHeightInPoints(QuestionConstants.CONTENT_FONT_HEIGHT);
        contentWriteFont.setFontName("\u5b8b\u4f53");
        contentWriteCellStyle.setWriteFont(contentWriteFont);
        contentWriteCellStyle.setHorizontalAlignment(HorizontalAlignment.CENTER);
        contentWriteCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        contentWriteCellStyle.setBorderBottom(BorderStyle.THIN);
        contentWriteCellStyle.setBorderLeft(BorderStyle.THIN);
        contentWriteCellStyle.setBorderRight(BorderStyle.THIN);
        contentWriteCellStyle.setBorderTop(BorderStyle.THIN);
        WriteCellStyle headWriteCellStyle = new WriteCellStyle();
        WriteFont headWriteFont = new WriteFont();
        headWriteFont.setFontName("\u5b8b\u4f53");
        headWriteFont.setFontHeightInPoints(QuestionConstants.HEAD_FONT_HEIGHT);
        headWriteFont.setBold(Boolean.valueOf(false));
        headWriteCellStyle.setWriteFont(headWriteFont);
        HorizontalCellStyleStrategy horizontalCellStyleStrategy = new HorizontalCellStyleStrategy(headWriteCellStyle, contentWriteCellStyle);
        return horizontalCellStyleStrategy;
    }
}

