/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.service.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.nbchat.train.api.NbchatExamTestApi;
import com.tydic.nbchat.train.api.NbchatUserTrainRecordApi;
import com.tydic.nbchat.train.api.bo.course.TranUserCourseSaveReqBO;
import com.tydic.nbchat.train.api.bo.eums.QuestionType;
import com.tydic.nbchat.train.api.bo.eums.TrainCommonState;
import com.tydic.nbchat.train.api.bo.exam.ExamQuestion;
import com.tydic.nbchat.train.api.bo.exam.ExamQuestionItem;
import com.tydic.nbchat.train.api.bo.exam.ExamTestCreateReqBO;
import com.tydic.nbchat.train.api.bo.exam.ExamTestCreateRspBO;
import com.tydic.nbchat.train.api.bo.exam.ExamTestPaper;
import com.tydic.nbchat.train.api.bo.exam.ExamTestResultReqBO;
import com.tydic.nbchat.train.api.bo.exam.ExamTestResultRspBO;
import com.tydic.nbchat.train.api.bo.exam.ExamTestSubmitAnswer;
import com.tydic.nbchat.train.api.bo.exam.ExamTestSubmitReqBO;
import com.tydic.nbchat.train.mapper.NbchatExamQuestionItemsMapper;
import com.tydic.nbchat.train.mapper.NbchatExamQuestionMapper;
import com.tydic.nbchat.train.mapper.NbchatExamTestPaperMapper;
import com.tydic.nbchat.train.mapper.NbchatExamTestRecordMapper;
import com.tydic.nbchat.train.mapper.NbchatTrainRecordMapper;
import com.tydic.nbchat.train.mapper.po.NbchatExamNewTestPaper;
import com.tydic.nbchat.train.mapper.po.NbchatExamQuestion;
import com.tydic.nbchat.train.mapper.po.NbchatExamQuestionItems;
import com.tydic.nbchat.train.mapper.po.NbchatExamTestPaper;
import com.tydic.nbchat.train.mapper.po.NbchatExamTestRecordWithBLOBs;
import com.tydic.nbchat.train.mapper.po.NbchatTrainRecord;
import com.tydic.nicc.common.eums.EntityValidType;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class NbchatExamTestServiceImpl
implements NbchatExamTestApi {
    private static final Logger log = LoggerFactory.getLogger(NbchatExamTestServiceImpl.class);
    @Resource
    NbchatExamTestRecordMapper nbchatExamTestRecordMapper;
    @Resource
    NbchatExamQuestionMapper nbchatExamQuestionMapper;
    @Resource
    NbchatExamQuestionItemsMapper nbchatExamQuestionItemsMapper;
    @Resource
    NbchatTrainRecordMapper nbchatTrainRecordMapper;
    @Resource
    NbchatExamTestPaperMapper nbchatExamTestPaperMapper;
    private final NbchatUserTrainRecordApi nbchatUserTrainRecordApi;

    public NbchatExamTestServiceImpl(NbchatUserTrainRecordApi nbchatUserTrainRecordApi) {
        this.nbchatUserTrainRecordApi = nbchatUserTrainRecordApi;
    }

    public Rsp createExamTest(ExamTestCreateReqBO reqBO) {
        List<NbchatExamQuestion> questions;
        log.info("\u521b\u5efa\u8bd5\u5377-\u5f00\u59cb\uff1a{}", (Object)reqBO);
        NbchatExamTestPaper examPaper = this.nbchatExamTestPaperMapper.queryByCourseId(reqBO.getCourseId(), reqBO.getTenantCode());
        if (ObjectUtils.isEmpty((Object)examPaper)) {
            log.warn("\u672a\u914d\u7f6e\u8bd5\u5377\uff1a{}", (Object)reqBO);
            return BaseRspUtils.createSuccessRsp((Object)"\u672a\u914d\u7f6e\u8bd5\u5377");
        }
        if (examPaper.getTestNum() != examPaper.getSingle() + examPaper.getMultiple() + examPaper.getTrueOrFalse()) {
            return BaseRspUtils.createSuccessRsp((Object)"\u8bd5\u5377\u914d\u7f6e\u8003\u8bd5\u9898\u6570\u91cf\u4e0e\u5404\u7c7b\u578b\u603b\u6570\u4e0d\u7b26");
        }
        NbchatExamTestRecordWithBLOBs query = new NbchatExamTestRecordWithBLOBs();
        BeanUtils.copyProperties((Object)reqBO, (Object)query);
        this.saveTrainRecord(reqBO);
        NbchatExamTestRecordWithBLOBs testPapering = this.nbchatExamTestRecordMapper.queryValidTestPaper(query);
        if (testPapering != null) {
            return this.buildTestPaper(testPapering);
        }
        NbchatExamNewTestPaper condition = new NbchatExamNewTestPaper();
        BeanUtils.copyProperties((Object)reqBO, (Object)condition);
        condition.setCreateType(examPaper.getTestType());
        ArrayList<NbchatExamQuestion> allQuestions = new ArrayList<NbchatExamQuestion>();
        if (examPaper.getSingle() > 0) {
            questions = this.getQuestionByType(condition, QuestionType.CHOICE_S.getCode(), examPaper.getSingle());
            if (CollectionUtils.isNotEmpty(questions) && questions.size() == examPaper.getSingle().intValue()) {
                allQuestions.addAll(questions);
            } else {
                return BaseRspUtils.createSuccessRsp((Object)"\u8be5\u8bfe\u7a0b\u4e0b\u5355\u9009\u9898\u76ee\u6570\u91cf\u4e0d\u8db3");
            }
        }
        if (examPaper.getMultiple() > 0) {
            questions = this.getQuestionByType(condition, QuestionType.CHOICE_M.getCode(), examPaper.getMultiple());
            if (CollectionUtils.isNotEmpty(questions) && questions.size() == examPaper.getMultiple().intValue()) {
                allQuestions.addAll(questions);
            } else {
                return BaseRspUtils.createSuccessRsp((Object)"\u8be5\u8bfe\u7a0b\u4e0b\u591a\u9009\u9898\u6570\u91cf\u4e0d\u8db3");
            }
        }
        if (examPaper.getTrueOrFalse() > 0) {
            questions = this.getQuestionByType(condition, QuestionType.TRUE_FALSE.getCode(), examPaper.getTrueOrFalse());
            if (CollectionUtils.isNotEmpty(questions) && questions.size() == examPaper.getTrueOrFalse().intValue()) {
                allQuestions.addAll(questions);
            } else {
                return BaseRspUtils.createSuccessRsp((Object)"\u8be5\u8bfe\u7a0b\u4e0b\u5224\u65ad\u9898\u76ee\u6570\u91cf\u4e0d\u8db3");
            }
        }
        NbchatExamTestRecordWithBLOBs record = new NbchatExamTestRecordWithBLOBs();
        record.setTestId(IdWorker.nextAutoIdStr());
        record.setCourseId(reqBO.getCourseId());
        record.setUserId(reqBO.getUserId());
        record.setTenantCode(reqBO.getTenantCode());
        record.setTestPaperId(IdWorker.nextAutoIdStr());
        record.setStartTime(new Date());
        Map content = allQuestions.stream().collect(Collectors.groupingBy(NbchatExamQuestion::getQuestionType, Collectors.mapping(NbchatExamQuestion::getQuestionId, Collectors.toList())));
        record.setTestPaperContent(JSON.toJSONString(content));
        this.nbchatExamTestRecordMapper.insertSelective(record);
        return this.buildTestPaper(record);
    }

    public List<NbchatExamQuestion> getQuestionByType(NbchatExamNewTestPaper condition, String questionType, Integer questionNum) {
        condition.setQuestionType(questionType);
        condition.setQuestions(questionNum);
        return this.nbchatExamQuestionMapper.newTestPaper(condition);
    }

    public void saveTrainRecord(ExamTestCreateReqBO reqBO) {
        TranUserCourseSaveReqBO queryReqBO = new TranUserCourseSaveReqBO();
        queryReqBO.setTenantCode(reqBO.getTenantCode());
        queryReqBO.setCourseId(reqBO.getCourseId());
        queryReqBO.setUserId(reqBO.getUserId());
        this.nbchatUserTrainRecordApi.saveUserTrainRecord(queryReqBO);
    }

    public Rsp<ExamTestCreateRspBO> buildTestPaper(NbchatExamTestRecordWithBLOBs record) {
        long start = System.currentTimeMillis();
        ExamTestCreateRspBO rspBO = new ExamTestCreateRspBO();
        rspBO.setTenantCode(record.getTenantCode());
        rspBO.setUserId(record.getUserId());
        rspBO.setCourseId(record.getCourseId());
        rspBO.setStartTime(record.getStartTime());
        rspBO.setTestId(record.getTestId());
        String content = record.getTestPaperContent();
        List<Object> questions = new ArrayList();
        Map map = (Map)JSON.parseObject((String)content, Map.class);
        for (Map.Entry entry : map.entrySet()) {
            ExamTestPaper paper = new ExamTestPaper();
            paper.setQuestionType((String)entry.getKey());
            ArrayList<ExamQuestion> examQuestions = new ArrayList<ExamQuestion>();
            for (String questionId : (List)entry.getValue()) {
                NbchatExamQuestion questionRecord = this.nbchatExamQuestionMapper.selectByPrimaryKey(questionId);
                ExamQuestion examQuestion = new ExamQuestion();
                examQuestion.setQuestionId(questionId);
                examQuestion.setQuestionName(questionRecord.getQuestionName());
                examQuestion.setExplan(questionRecord.getExplan());
                examQuestion.setDifficulty(questionRecord.getDifficulty());
                if (QuestionType.isChoice((String)questionRecord.getQuestionType()) || QuestionType.isJudgment((String)questionRecord.getQuestionType())) {
                    NbchatExamQuestionItems condition = new NbchatExamQuestionItems();
                    condition.setQuestionId(questionId);
                    List itemRec = this.nbchatExamQuestionItemsMapper.selectByCondition(condition);
                    ArrayList items = new ArrayList();
                    NiccCommonUtil.copyList((List)itemRec, items, ExamQuestionItem.class);
                    examQuestion.setItems(items);
                }
                examQuestions.add(examQuestion);
            }
            paper.setQuestions(examQuestions);
            questions.add(paper);
        }
        questions = questions.stream().sorted(Comparator.comparing(ExamTestPaper::getQuestionType)).collect(Collectors.toList());
        rspBO.setTestPapers(questions);
        log.info("\u521b\u5efa\u8bd5\u5377\u7ed3\u675f\uff0c\u6784\u5efa\u8bd5\u5377\u8017\u65f6\uff1a{}/ms", (Object)(System.currentTimeMillis() - start));
        return BaseRspUtils.createSuccessRsp((Object)rspBO);
    }

    @Transactional(rollbackFor={Exception.class})
    public Rsp submitExamTestPaper(ExamTestSubmitReqBO reqBO) {
        log.info("\u63d0\u4ea4\u8bd5\u5377-\u5f00\u59cb\uff1a{}", (Object)reqBO);
        int correctCount = 0;
        List answers = reqBO.getAnswers();
        Map<String, List<ExamTestSubmitAnswer>> typeMap = answers.stream().collect(Collectors.groupingBy(ExamTestSubmitAnswer::getType));
        for (Map.Entry<String, List<ExamTestSubmitAnswer>> entry : typeMap.entrySet()) {
            if (entry.getKey().equals(QuestionType.CHOICE_S.getCode()) || entry.getKey().equals(QuestionType.TRUE_FALSE.getCode())) {
                List<NbchatExamQuestionItems> choice_s_correct = this.queryCorrectQuestion(reqBO.getTestId(), entry.getValue());
                correctCount += choice_s_correct.size();
                log.info("\u5355\u9009/\u5224\u65ad\u7b54\u5bf9\uff1a{} \u9053", (Object)choice_s_correct.size());
                continue;
            }
            if (entry.getKey().equals(QuestionType.CHOICE_M.getCode())) {
                List<ExamTestSubmitAnswer> m_answers = entry.getValue();
                for (ExamTestSubmitAnswer mAnswer : m_answers) {
                    List userItems;
                    NbchatExamQuestionItems cond = new NbchatExamQuestionItems();
                    cond.setQuestionId(mAnswer.getQuestionId());
                    cond.setIsRight("1");
                    List qCorrectItems = this.nbchatExamQuestionItemsMapper.selectByCondition(cond);
                    List collect = qCorrectItems.stream().map(NbchatExamQuestionItems::getItemId).collect(Collectors.toList());
                    if (!collect.containsAll(userItems = mAnswer.getItemIds()) || !userItems.containsAll(collect)) continue;
                    ++correctCount;
                }
                continue;
            }
            log.info("\u672a\u8bc6\u522b\u7684\u9898\u76ee\u7c7b\u578b");
        }
        NbchatExamTestRecordWithBLOBs testRecord = new NbchatExamTestRecordWithBLOBs();
        testRecord.setTestId(reqBO.getTestId());
        testRecord.setAnswerContent(JSON.toJSONString((Object)reqBO.getAnswers()));
        testRecord.setEndTime(new Date());
        testRecord.setScore(Short.valueOf((short)0));
        if (correctCount > 0) {
            if (reqBO.getAnswers().size() == 50) {
                testRecord.setScore(Short.valueOf((short)(2 * correctCount)));
            }
            if (reqBO.getAnswers().size() == 25) {
                testRecord.setScore(Short.valueOf((short)(4 * correctCount)));
            }
            if (reqBO.getAnswers().size() == 20) {
                testRecord.setScore(Short.valueOf((short)(5 * correctCount)));
            }
            if (reqBO.getAnswers().size() == 10) {
                testRecord.setScore(Short.valueOf((short)(10 * correctCount)));
            }
            if (reqBO.getAnswers().size() == 5) {
                testRecord.setScore(Short.valueOf((short)(20 * correctCount)));
            }
        }
        this.nbchatExamTestRecordMapper.updateByPrimaryKeySelective(testRecord);
        NbchatTrainRecord trainRecord = this.nbchatTrainRecordMapper.selectByUserAndCourseId(reqBO.getUserId(), reqBO.getCourseId());
        if (trainRecord != null) {
            NbchatExamTestPaper nbchatExamTestPaper = this.nbchatExamTestPaperMapper.queryByCourseId(reqBO.getCourseId(), reqBO.getTenantCode());
            String score = nbchatExamTestPaper.getPassingScore();
            if (testRecord.getScore() >= Integer.parseInt(score)) {
                trainRecord.setTestPassState(TrainCommonState.PASS.getCode());
            }
            trainRecord.setTestState(EntityValidType.NORMAL.getCode());
            this.nbchatTrainRecordMapper.updateByPrimaryKeySelective(trainRecord);
        }
        return BaseRspUtils.createSuccessRsp((Object)trainRecord);
    }

    public List<NbchatExamQuestionItems> queryCorrectQuestion(String testId, List<ExamTestSubmitAnswer> answers) {
        if (CollectionUtils.isEmpty(answers)) {
            NbchatExamTestRecordWithBLOBs record = this.nbchatExamTestRecordMapper.selectByPrimaryKey(testId);
            String content = record.getAnswerContent();
            answers = JSON.parseArray((String)content, ExamTestSubmitAnswer.class);
        }
        List items = answers.stream().flatMap(v -> v.getItemIds().stream()).collect(Collectors.toList());
        return this.nbchatExamQuestionItemsMapper.queryCorrectItems(items);
    }

    public Rsp<ExamTestResultRspBO> getExamTestResult(ExamTestResultReqBO reqBO) {
        log.info("\u67e5\u8be2\u8003\u8bd5\u7ed3\u679c-\u5f00\u59cb\uff1a{}", (Object)reqBO);
        NbchatExamTestRecordWithBLOBs condition = new NbchatExamTestRecordWithBLOBs();
        condition.setCourseId(reqBO.getCourseId());
        condition.setUserId(reqBO.getUserId());
        condition.setQueryType(reqBO.getQueryType());
        NbchatExamTestRecordWithBLOBs record = this.nbchatExamTestRecordMapper.queryByCondition(condition);
        if (ObjectUtils.isEmpty((Object)record)) {
            ExamTestResultRspBO rspBO = new ExamTestResultRspBO();
            rspBO.setScore(Double.valueOf(0.0));
            return BaseRspUtils.createSuccessRsp((Object)rspBO, (String)"\u672a\u67e5\u8be2\u5230\u8003\u8bd5\u5b8c\u6210\u4fe1\u606f");
        }
        String answerContent = record.getAnswerContent();
        List answers = JSON.parseArray((String)answerContent, ExamTestSubmitAnswer.class);
        Map<String, List> answersMap = answers.stream().collect(Collectors.toMap(ExamTestSubmitAnswer::getQuestionId, ExamTestSubmitAnswer::getItemIds));
        String testContent = record.getTestPaperContent();
        Map testContentMap = (Map)JSON.parseObject((String)testContent, Map.class);
        List questionIds = testContentMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        ArrayList<ExamQuestion> questions = new ArrayList<ExamQuestion>();
        for (String questionId : questionIds) {
            ExamQuestion question = new ExamQuestion();
            NbchatExamQuestion questionRecord = this.nbchatExamQuestionMapper.selectByPrimaryKey(questionId);
            NbchatExamQuestionItems queryItem = new NbchatExamQuestionItems();
            queryItem.setQuestionId(questionId);
            queryItem.setIsRight("1");
            List correctItems = this.nbchatExamQuestionItemsMapper.selectByCondition(queryItem);
            ArrayList items = new ArrayList();
            NiccCommonUtil.copyList((List)correctItems, items, ExamQuestionItem.class);
            List userAnswerItems = answersMap.get(questionId);
            NbchatExamQuestionItems queryUserItem = new NbchatExamQuestionItems();
            queryUserItem.setItemIds(userAnswerItems);
            List userAnswerItemsInfo = this.nbchatExamQuestionItemsMapper.selectByCondition(queryUserItem);
            ArrayList userItems = new ArrayList();
            NiccCommonUtil.copyList((List)userAnswerItemsInfo, userItems, ExamQuestionItem.class);
            question.setQuestionId(questionId);
            question.setQuestionName(questionRecord.getQuestionName());
            question.setItems(items);
            question.setUserItems(userItems);
            question.setQuestionType(questionRecord.getQuestionType());
            question.setDifficulty(questionRecord.getDifficulty());
            question.setExplan(questionRecord.getExplan());
            questions.add(question);
        }
        ExamTestResultRspBO rspBO = new ExamTestResultRspBO();
        rspBO.setScore(Double.valueOf(record.getScore().shortValue()));
        rspBO.setCourseId(reqBO.getCourseId());
        rspBO.setUserId(reqBO.getUserId());
        rspBO.setQuestions(questions);
        NbchatExamTestPaper examPaper = this.nbchatExamTestPaperMapper.queryByCourseId(reqBO.getCourseId(), reqBO.getTenantCode());
        if (ObjectUtils.isNotEmpty((Object)examPaper)) {
            rspBO.setPassScore(Double.valueOf(examPaper.getPassingScore()));
        }
        return BaseRspUtils.createSuccessRsp((Object)rspBO);
    }
}

