/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.service.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.nbchat.train.api.NbchatTrainCatalogApi;
import com.tydic.nbchat.train.api.bo.eums.StateEnum;
import com.tydic.nbchat.train.api.bo.train.catalog.TrainCatalogBO;
import com.tydic.nbchat.train.api.bo.train.catalog.TrainCatalogBatchSaveBO;
import com.tydic.nbchat.train.mapper.NbchatTrainCatalogMapper;
import com.tydic.nbchat.train.mapper.NbchatTrainCourseMapper;
import com.tydic.nbchat.train.mapper.NbchatTrainSectionsMapper;
import com.tydic.nbchat.train.mapper.po.NbchatTrainCatalog;
import com.tydic.nbchat.train.mapper.po.NbchatTrainSections;
import com.tydic.nicc.common.eums.EntityValidType;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class NbchatTrainCatalogServiceImpl
implements NbchatTrainCatalogApi {
    private static final Logger log = LoggerFactory.getLogger(NbchatTrainCatalogServiceImpl.class);
    @Resource
    NbchatTrainCatalogMapper nbchatTrainCatalogMapper;
    @Resource
    NbchatTrainCourseMapper nbchatTrainCourseMapper;
    @Resource
    NbchatTrainSectionsMapper nbchatTrainSectionsMapper;

    public Rsp save(TrainCatalogBO request) {
        log.info("\u66f4\u65b0/\u4fdd\u5b58 \u7c7b\u76ee\uff1a{}", (Object)request);
        NbchatTrainCatalog record = new NbchatTrainCatalog();
        BeanUtils.copyProperties((Object)request, (Object)record);
        if (StringUtils.isEmpty((CharSequence)request.getCatalogId())) {
            record.setCatalogId(IdWorker.nextAutoIdStr());
            record.setCreateTime(new Date());
            this.nbchatTrainCatalogMapper.insertSelective(record);
        } else {
            this.nbchatTrainCatalogMapper.updateByPrimaryKeySelective(record);
        }
        this.nbchatTrainCourseMapper.updateStepState(request.getCourseId(), StateEnum.STEP.CATEGORY.getCode());
        return BaseRspUtils.createSuccessRsp((Object)record.getCatalogId());
    }

    @Transactional
    public Rsp saveBatch(TrainCatalogBatchSaveBO request) {
        log.info("\u7c7b\u76ee\u6279\u91cf\u4fdd\u5b58/\u66f4\u65b0\uff1a{}", (Object)request);
        List catalogs = request.getCatalogs();
        if (CollectionUtils.isEmpty((Collection)catalogs)) {
            return BaseRspUtils.createErrorRsp((String)"\u4fdd\u5b58\u7c7b\u76ee\u3001\u7ae0\u8282\u4e0d\u5f97\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)request.getCourseId())) {
            return BaseRspUtils.createErrorRsp((String)"\u8bfe\u7a0bID\u4e0d\u5f97\u4e3a\u7a7a");
        }
        List sectionIds = catalogs.stream().map(TrainCatalogBatchSaveBO.Node::getSectionId).collect(Collectors.toList());
        List sectionsList = this.nbchatTrainSectionsMapper.selectBySectionIds(request.getCourseId(), null);
        if (CollectionUtils.isNotEmpty((Collection)sectionsList)) {
            List originSectionIds = sectionsList.stream().map(NbchatTrainSections::getSectionId).collect(Collectors.toList());
            List deleteIds = originSectionIds.stream().filter(v -> !sectionIds.contains(v)).collect(Collectors.toList());
            log.info("\u5220\u9664\u7684\u7ae0\u8282id\uff1a{}", deleteIds);
            if (CollectionUtils.isNotEmpty(deleteIds)) {
                this.nbchatTrainSectionsMapper.delete(deleteIds);
                for (String deleteId : deleteIds) {
                    this.nbchatTrainCatalogMapper.delete(deleteId);
                }
            }
        }
        List trainCatalogs = this.nbchatTrainCatalogMapper.selectByCourseId(request.getCourseId(), null, null);
        List catalogIds = catalogs.stream().map(TrainCatalogBatchSaveBO.Node::getCatalogId).collect(Collectors.toList());
        List subCollectIds = catalogs.stream().flatMap(v -> v.getCatalog2().stream().map(TrainCatalogBatchSaveBO.Node::getCatalogId)).collect(Collectors.toList());
        catalogIds.addAll(subCollectIds);
        if (CollectionUtils.isNotEmpty((Collection)trainCatalogs) && CollectionUtils.isNotEmpty(catalogIds)) {
            List originCatalogIds = trainCatalogs.stream().map(NbchatTrainCatalog::getCatalogId).collect(Collectors.toList());
            List deleteIds = originCatalogIds.stream().filter(v -> !catalogIds.contains(v)).collect(Collectors.toList());
            log.info("\u5220\u9664\u7684\u76ee\u5f55id\uff1a{}", deleteIds);
            for (String deleteId : deleteIds) {
                this.nbchatTrainCatalogMapper.deleteById(deleteId);
            }
        }
        int index = 1;
        int sectionIndex = 1;
        for (TrainCatalogBatchSaveBO.Node node : catalogs) {
            NbchatTrainSections section = new NbchatTrainSections();
            section.setTenantCode(request.getTenantCode());
            section.setVideoUrl(node.getVideoUrl());
            section.setContent(node.getSectionContent());
            section.setCourseId(request.getCourseId());
            section.setSectionsIndex(Short.valueOf((short)sectionIndex++));
            section.setCreateTime(new Date());
            if (StringUtils.isNotEmpty((CharSequence)node.getSectionId())) {
                section.setSectionId(node.getSectionId());
                this.nbchatTrainSectionsMapper.updateByPrimaryKeySelective(section);
            } else {
                section.setSectionId(IdWorker.nextAutoIdStr());
                this.nbchatTrainSectionsMapper.insertSelective(section);
            }
            String sections = JSON.toJSONString(Arrays.asList(section.getSectionId()));
            NbchatTrainCatalog record = new NbchatTrainCatalog();
            record.setCourseId(request.getCourseId());
            record.setSectionIds(sections);
            record.setCatalogTitle(node.getCatalogName());
            record.setCatalogLevel(Short.valueOf((short)1));
            record.setCatalogIndex(Short.valueOf((short)index++));
            record.setParentId("-1");
            record.setCreateTime(new Date());
            this.processCatalog(node, record);
            String parentCatalogId = record.getCatalogId();
            List catalog2 = node.getCatalog2();
            for (TrainCatalogBatchSaveBO.Node node2 : catalog2) {
                record.setSectionIds(null);
                record.setCatalogTitle(node2.getCatalogName());
                record.setCatalogLevel(Short.valueOf((short)2));
                record.setCatalogIndex(Short.valueOf((short)index++));
                record.setParentId(parentCatalogId);
                this.processCatalog(node2, record);
            }
        }
        this.nbchatTrainCourseMapper.updateClassHour(request.getCourseId());
        this.nbchatTrainCourseMapper.updateStepState(request.getCourseId(), StateEnum.STEP.CONTENT.getCode());
        new Thread(() -> {}).start();
        return BaseRspUtils.createSuccessRsp(null);
    }

    public void processCatalog(TrainCatalogBatchSaveBO.Node node, NbchatTrainCatalog record) {
        if (StringUtils.isNotEmpty((CharSequence)node.getCatalogId())) {
            record.setCatalogId(node.getCatalogId());
            record.setIsValid(EntityValidType.NORMAL.getCode());
            this.nbchatTrainCatalogMapper.updateByPrimaryKeySelective(record);
        } else {
            record.setCatalogId(IdWorker.nextAutoIdStr());
            this.nbchatTrainCatalogMapper.insertSelective(record);
        }
    }

    public Rsp delete(String courseId) {
        TrainCatalogBO request = new TrainCatalogBO();
        request.setCourseId(courseId);
        return this.delete(request);
    }

    public Rsp delete(TrainCatalogBO request) {
        log.info("\u5220\u9664 \u7c7b\u76ee\uff1a{}", (Object)request);
        if (StringUtils.isEmpty((CharSequence)request.getCourseId())) {
            return BaseRspUtils.createErrorRsp((String)"\u8bfe\u7a0bID\u4e0d\u5f97\u4e3a\u7a7a");
        }
        int update = this.nbchatTrainCatalogMapper.update(request.getCourseId());
        return BaseRspUtils.createSuccessRsp((Object)update);
    }

    public RspList query(TrainCatalogBO request) {
        log.info("\u67e5\u8be2 \u76ee\u5f55\uff1a{}", (Object)request);
        if (StringUtils.isEmpty((CharSequence)request.getCourseId())) {
            return BaseRspUtils.createErrorRspList((String)"\u8bfe\u7a0bid\u4e0d\u5f97\u4e3a\u7a7a");
        }
        List catalogs = this.nbchatTrainCatalogMapper.selectByCourseId(request.getCourseId(), null, null);
        return BaseRspUtils.createSuccessRspList((List)catalogs);
    }
}

