/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.service.impl;

import com.tydic.nbchat.robot.api.NbchatResearchMajorApi;
import com.tydic.nbchat.robot.api.bo.research.FileResearchMajorAnalysisStatus;
import com.tydic.nbchat.robot.api.bo.research.FileResearchMajorQueryRequest;
import com.tydic.nbchat.robot.api.bo.research.FileResearchMajorSaveRequest;
import com.tydic.nbchat.robot.api.bo.research.NbchatResearchMajorRspBO;
import com.tydic.nbchat.train.api.NbchatTrainCourseApi;
import com.tydic.nbchat.train.api.NbchatTrainSectionApi;
import com.tydic.nbchat.train.api.bo.course.NbchatTrainCourseTextBO;
import com.tydic.nbchat.train.api.bo.course.TrainCourseHotHubBO;
import com.tydic.nbchat.train.api.bo.course.TrainCourseSectionsQueryReqBO;
import com.tydic.nbchat.train.api.bo.course.TrainCourseSectionsQueryRspBO;
import com.tydic.nbchat.train.api.bo.course.TranCourseBO;
import com.tydic.nbchat.train.api.bo.course.TranCourseQueryReqBO;
import com.tydic.nbchat.train.api.bo.course.TranCourseSaveReqBO;
import com.tydic.nbchat.train.api.bo.eums.ExamTestType;
import com.tydic.nbchat.train.api.bo.eums.StateEnum;
import com.tydic.nbchat.train.api.bo.eums.TaskStateType;
import com.tydic.nbchat.train.api.bo.train.section.SectionsSaveRequest;
import com.tydic.nbchat.train.api.bo.train.section.TrainSectionsBO;
import com.tydic.nbchat.train.mapper.NameMapper;
import com.tydic.nbchat.train.mapper.NbchatExamTestPaperMapper;
import com.tydic.nbchat.train.mapper.NbchatTrainCatalogMapper;
import com.tydic.nbchat.train.mapper.NbchatTrainCourseCategoryMapper;
import com.tydic.nbchat.train.mapper.NbchatTrainCourseMapper;
import com.tydic.nbchat.train.mapper.NbchatTrainCourseTextMapper;
import com.tydic.nbchat.train.mapper.NbchatTrainRecordMapper;
import com.tydic.nbchat.train.mapper.TdhCreationRecordMapper;
import com.tydic.nbchat.train.mapper.TdhCreationTaskMapper;
import com.tydic.nbchat.train.mapper.po.NbchatExamTestPaper;
import com.tydic.nbchat.train.mapper.po.NbchatTrainCatalog;
import com.tydic.nbchat.train.mapper.po.NbchatTrainCourse;
import com.tydic.nbchat.train.mapper.po.NbchatTrainCourseCategory;
import com.tydic.nbchat.train.mapper.po.NbchatTrainCourseSelectCondition;
import com.tydic.nbchat.train.mapper.po.NbchatTrainCourseText;
import com.tydic.nbchat.train.mapper.po.TdhCreationRecord;
import com.tydic.nbchat.train.mapper.po.TdhCreationTask;
import com.tydic.nicc.common.eums.EntityValidType;
import com.tydic.nicc.dc.base.annotions.MethodParamVerifyEnable;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class NbchatTrainCourseServiceImpl
implements NbchatTrainCourseApi {
    private static final Logger log = LoggerFactory.getLogger(NbchatTrainCourseServiceImpl.class);
    @Resource
    private NbchatTrainCourseMapper nbchatTrainCourseMapper;
    @Resource
    private NbchatTrainRecordMapper nbchatTrainRecordMapper;
    @Resource
    private NbchatTrainCourseCategoryMapper nbchatTrainCourseCategoryMapper;
    @Resource
    private NbchatTrainCourseTextMapper nbchatTrainCourseTextMapper;
    @Resource
    private NbchatExamTestPaperMapper nbchatExamTestPaperMapper;
    @Resource
    private TdhCreationTaskMapper taskMapper;
    @Resource
    private NbchatTrainCatalogMapper trainCatalogMapper;
    @Resource
    private TdhCreationRecordMapper tdhCreationRecordMapper;
    @Resource
    private NbchatTrainSectionApi nbchatTrainSectionApi;
    @Resource
    private NameMapper nameMapper;
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=100000)
    private NbchatResearchMajorApi nbchatResearchMajorApi;

    public Rsp deleteCourse(TranCourseQueryReqBO queryReqBO) {
        log.info("\u8bfe\u7a0b\u7ba1\u7406-\u5220\u9664\u5bf9\u8c61:{}", (Object)queryReqBO);
        NbchatTrainCourse course = this.nbchatTrainCourseMapper.selectByPrimaryKey(queryReqBO.getCourseId());
        if (course == null || !EntityValidType.NORMAL.getCode().equals(course.getIsValid())) {
            return BaseRspUtils.createErrorRsp((String)"\u5220\u9664\u5931\u8d25\uff1a\u8be5\u8bfe\u7a0b\u4e0d\u5b58\u5728!");
        }
        NbchatTrainCourse delete = new NbchatTrainCourse();
        delete.setCourseState(StateEnum.COURSE.OFF.getCode());
        delete.setIsValid(EntityValidType.DELETE.getCode());
        delete.setUpdateTime(new Date());
        delete.setCourseId(queryReqBO.getCourseId());
        this.nbchatTrainCourseMapper.updateByPrimaryKeySelective(delete);
        return BaseRspUtils.createSuccessRsp((Object)queryReqBO.getCourseId());
    }

    public Rsp<TranCourseBO> getCourse(TranCourseQueryReqBO queryReqBO) {
        NbchatTrainCourseCategory category2;
        log.info("\u8bfe\u7a0b\u7ba1\u7406-\u67e5\u8be2\u5bf9\u8c61:{}", (Object)queryReqBO);
        NbchatTrainCourse course = this.nbchatTrainCourseMapper.selectByPrimaryKey(queryReqBO.getCourseId());
        if (course == null || !EntityValidType.NORMAL.getCode().equals(course.getIsValid())) {
            return BaseRspUtils.createErrorRsp((String)"\u67e5\u8be2\u5931\u8d25\uff1a\u8be5\u8bfe\u7a0b\u4e0d\u5b58\u5728!");
        }
        TranCourseBO courseBO = new TranCourseBO();
        BeanUtils.copyProperties((Object)course, (Object)courseBO);
        int count = this.nbchatTrainRecordMapper.countTrained(courseBO.getCourseId());
        courseBO.setTrainCount(count);
        courseBO.setCourseState(StateEnum.COURSE.getNameByCode((String)courseBO.getCourseState()));
        NbchatTrainCourseCategory category = this.nbchatTrainCourseCategoryMapper.queryById(course.getCategory());
        if (ObjectUtils.isNotEmpty((Object)category)) {
            courseBO.setCategoryName(category.getCateName());
        }
        if (ObjectUtils.isNotEmpty((Object)(category2 = this.nbchatTrainCourseCategoryMapper.queryById(course.getCategory2())))) {
            courseBO.setCategory2Name(category2.getCateName());
        }
        FileResearchMajorQueryRequest request = new FileResearchMajorQueryRequest();
        request.setMajorId(course.getMajorId());
        Rsp majorStatus = this.nbchatResearchMajorApi.getMajorAnalysisStatus(request);
        if (!majorStatus.isSuccess() || ((FileResearchMajorAnalysisStatus)majorStatus.getData()).getDocTotalCount() <= 0) {
            courseBO.setMajorId("");
        }
        return BaseRspUtils.createSuccessRsp((Object)courseBO);
    }

    public RspList<TranCourseBO> getCourses(TranCourseQueryReqBO queryReqBO) {
        ArrayList list = Lists.newArrayList();
        NbchatTrainCourseSelectCondition condition = new NbchatTrainCourseSelectCondition();
        BeanUtils.copyProperties((Object)queryReqBO, (Object)condition);
        condition.setIsValid(EntityValidType.NORMAL.getCode());
        if (StringUtils.isEmpty((CharSequence)queryReqBO.getCourseState()) && !queryReqBO.isSearchAll()) {
            condition.setCourseState(StateEnum.COURSE.ON.getCode());
        }
        List nbchatTrainCourses = this.nbchatTrainCourseMapper.selectByCondition(condition);
        NiccCommonUtil.copyList((List)nbchatTrainCourses, (List)list, TranCourseBO.class);
        for (TranCourseBO tranCourseBO : list) {
            int count = this.nbchatTrainRecordMapper.countTrained(tranCourseBO.getCourseId());
            tranCourseBO.setTrainCount(count);
        }
        Stream<Object> stream = list.stream();
        if (queryReqBO.isOrder()) {
            stream = list.stream().sorted(Comparator.comparing(TranCourseBO::getTrainCount).reversed());
        }
        List page = stream.skip((long)(queryReqBO.getPage() - 1) * (long)queryReqBO.getLimit()).limit(queryReqBO.getLimit()).collect(Collectors.toList());
        for (TranCourseBO tranCourseBO : page) {
            this.setNames(tranCourseBO, queryReqBO);
            int i = this.nbchatTrainRecordMapper.countVideo(tranCourseBO.getCourseId());
            tranCourseBO.setVideoCount(i);
        }
        return BaseRspUtils.createSuccessRspList(page, (long)list.size());
    }

    public void setNames(TranCourseBO tranCourseBO, TranCourseQueryReqBO queryReqBO) {
        String userId;
        String sceneName;
        String name;
        NbchatTrainCourseCategory category2;
        NbchatTrainCourseCategory category = this.nbchatTrainCourseCategoryMapper.queryById(tranCourseBO.getCategory());
        if (ObjectUtils.isNotEmpty((Object)category)) {
            tranCourseBO.setCategoryName(category.getCateName());
        }
        if (ObjectUtils.isNotEmpty((Object)(category2 = this.nbchatTrainCourseCategoryMapper.queryById(tranCourseBO.getCategory2())))) {
            tranCourseBO.setCategory2Name(category2.getCateName());
        }
        if (StringUtils.isNotEmpty((CharSequence)(name = StateEnum.COURSE.getNameByCode((String)tranCourseBO.getCourseState())))) {
            tranCourseBO.setCourseState(name);
        }
        if (StringUtils.isNotEmpty((CharSequence)(sceneName = StateEnum.COURSE.getNameByCode((String)tranCourseBO.getSceneState())))) {
            tranCourseBO.setSceneState(sceneName);
        }
        if (StringUtils.isNotEmpty((CharSequence)(userId = tranCourseBO.getUserId()))) {
            String userName = this.nameMapper.queryUserName(userId, queryReqBO.getTenantCode());
            tranCourseBO.setCreateUserName(userName);
        }
    }

    @MethodParamVerifyEnable
    @Transactional
    public Rsp saveCourse(TranCourseSaveReqBO saveReqBO) {
        log.debug("\u8bfe\u7a0b\u7ba1\u7406-\u4fdd\u5b58\u8bfe\u7a0b:{}", (Object)saveReqBO);
        String courseId = saveReqBO.getCourseId();
        if (StringUtils.isBlank((CharSequence)courseId)) {
            courseId = IdWorker.nextAutoIdStr();
            if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{saveReqBO.getCourseName(), saveReqBO.getUserId()})) {
                return BaseRspUtils.createErrorRsp((String)"\u8bfe\u7a0b\u65b0\u589e\u5931\u8d25\uff1a\u53c2\u6570\u5f02\u5e38!");
            }
            NbchatTrainCourse insert = new NbchatTrainCourse();
            BeanUtils.copyProperties((Object)saveReqBO, (Object)insert);
            String majorId = this.createMajor(insert);
            insert.setMajorId(majorId);
            insert.setCreateTime(new Date());
            insert.setIsValid(EntityValidType.NORMAL.getCode());
            insert.setUpdateTime(new Date());
            insert.setCourseId(courseId);
            insert.setStepState(StateEnum.STEP.BASE_INFO.getCode());
            this.nbchatTrainCourseMapper.insertSelective(insert);
            this.addExamConfig(insert);
        } else {
            NbchatTrainCourse course = this.nbchatTrainCourseMapper.selectByPrimaryKey(saveReqBO.getCourseId());
            if (course == null || !EntityValidType.NORMAL.getCode().equals(course.getIsValid())) {
                return BaseRspUtils.createErrorRsp((String)"\u66f4\u65b0\u5931\u8d25\uff1a\u8be5\u8bfe\u7a0b\u4e0d\u5b58\u5728!");
            }
            NbchatTrainCourse update = new NbchatTrainCourse();
            BeanUtils.copyProperties((Object)saveReqBO, (Object)update);
            update.setUpdateTime(new Date());
            update.setStepState(null);
            update.setVideoSource(saveReqBO.getVideoSource());
            log.info("\u66f4\u65b0\u8bfe\u7a0b:{}", (Object)update);
            this.nbchatTrainCourseMapper.updateByPrimaryKeySelective(update);
            if (StringUtils.isNotEmpty((CharSequence)saveReqBO.getStepState())) {
                this.nbchatTrainCourseMapper.updateStepState(saveReqBO.getCourseId(), saveReqBO.getStepState());
            }
        }
        return BaseRspUtils.createSuccessRsp((Object)courseId);
    }

    public Rsp newCourse(TranCourseSaveReqBO saveReqBO) {
        log.info("\u65b0\u589e\u8003\u8bd5\u3001\u5bf9\u6218\u7c7b\u578b\u8bfe\u7a0b:{}", (Object)saveReqBO);
        NbchatTrainCourse po = new NbchatTrainCourse();
        BeanUtils.copyProperties((Object)saveReqBO, (Object)po);
        po.setCreateTime(new Date());
        po.setIsValid(EntityValidType.NORMAL.getCode());
        po.setUpdateTime(new Date());
        po.setCourseId(IdWorker.nextAutoIdStr());
        po.setStepState(StateEnum.STEP.BASE_INFO.getCode());
        po.setCourseState(StateEnum.COURSE.PRE_EDIT.getCode());
        this.nbchatTrainCourseMapper.insertSelective(po);
        if (saveReqBO.getCourseType().equals("3")) {
            this.addExamConfig(po);
        }
        return BaseRspUtils.createSuccessRsp((Object)po.getCourseId());
    }

    public RspList getTopHubCourse(TrainCourseHotHubBO reqBO) {
        log.info("\u67e5\u8be2\u70ed\u70b9\u8bfe\u7a0b:{}", (Object)reqBO);
        ArrayList list = Lists.newArrayList();
        NbchatTrainCourseSelectCondition condition = new NbchatTrainCourseSelectCondition();
        BeanUtils.copyProperties((Object)reqBO, (Object)condition);
        condition.setIsValid(EntityValidType.NORMAL.getCode());
        condition.setCourseState(StateEnum.COURSE.ON.getCode());
        List nbchatTrainCourses = this.nbchatTrainCourseMapper.selectByCondition(condition);
        NiccCommonUtil.copyList((List)nbchatTrainCourses, (List)list, TranCourseBO.class);
        for (TranCourseBO tranCourseBO : list) {
            int count = this.nbchatTrainRecordMapper.countTrained(tranCourseBO.getCourseId());
            tranCourseBO.setTrainCount(count);
        }
        List collect = list.stream().sorted(Comparator.comparing(TranCourseBO::getTrainCount).reversed()).limit(reqBO.getLimit().intValue()).collect(Collectors.toList());
        return BaseRspUtils.createSuccessRspList(collect);
    }

    public Rsp getCourseContent(NbchatTrainCourseTextBO reqBO) {
        log.info("\u67e5\u8be2\u8bfe\u7a0b\u5185\u5bb9\uff1a{}", (Object)reqBO);
        NbchatTrainCourseTextBO rspBO = new NbchatTrainCourseTextBO();
        NbchatTrainCourseText courseText = this.nbchatTrainCourseTextMapper.queryById(reqBO.getCourseId());
        if (ObjectUtils.isEmpty((Object)courseText)) {
            return BaseRspUtils.createSuccessRsp((Object)"\u672a\u627e\u5230\u8bfe\u7a0b\u8d44\u6599\u5185\u5bb9");
        }
        BeanUtils.copyProperties((Object)courseText, (Object)rspBO);
        return BaseRspUtils.createSuccessRsp((Object)rspBO);
    }

    @Transactional
    public Rsp saveCourseContent(NbchatTrainCourseTextBO reqBO) {
        log.debug("\u4fdd\u5b58\u8bfe\u7a0b\u5185\u5bb9\uff1a{}", (Object)reqBO);
        NbchatTrainCourseText record = new NbchatTrainCourseText();
        BeanUtils.copyProperties((Object)reqBO, (Object)record);
        record.setUpdateTime(new Date());
        NbchatTrainCourseText courseText = this.nbchatTrainCourseTextMapper.queryById(reqBO.getCourseId());
        if (ObjectUtils.isEmpty((Object)courseText)) {
            this.nbchatTrainCourseTextMapper.insertSelective(record);
        } else {
            this.nbchatTrainCourseTextMapper.update(record);
        }
        this.nbchatTrainCourseMapper.updateStepState(reqBO.getCourseId(), StateEnum.STEP.ANALYSIS.getCode());
        return BaseRspUtils.createSuccessRsp(null);
    }

    @Transactional(rollbackFor={Exception.class})
    public Rsp saveCourseSections(TrainCourseSectionsQueryReqBO request) {
        log.debug("\u4fdd\u5b58\u8bfe\u7a0b\u7ae0\u8282\uff1a{}", (Object)request);
        List list = request.getSectionsSaveRequest();
        list.forEach(sectionsSaveRequest -> {
            SectionsSaveRequest reqBO = new SectionsSaveRequest();
            BeanUtils.copyProperties((Object)sectionsSaveRequest, (Object)reqBO);
            Rsp rsp = this.nbchatTrainSectionApi.saveSection(reqBO);
            if (!rsp.isSuccess()) {
                log.info("\u4fdd\u5b58\u8bfe\u7a0b\u7ae0\u8282\u5931\u8d25\uff1a{}", (Object)rsp);
            }
            log.info("\u4fdd\u5b58\u8bfe\u7a0b\u7ae0\u8282\u7ed3\u679c\uff1a{}", (Object)rsp);
        });
        TranCourseSaveReqBO courseSaveReqBO = request.getCourseSaveReqBO();
        BeanUtils.copyProperties((Object)request.getCourseSaveReqBO(), (Object)courseSaveReqBO);
        Rsp rsp = this.saveCourse(courseSaveReqBO);
        if (!rsp.isSuccess()) {
            log.info("\u4fdd\u5b58\u8bfe\u7a0b\u5185\u5bb9\u5931\u8d25\uff1a{}", (Object)rsp);
            return rsp;
        }
        log.info("\u4fdd\u5b58\u8bfe\u7a0b\u5185\u5bb9\u7ed3\u679c\uff1a{}", (Object)rsp);
        return BaseRspUtils.createSuccessRsp((Object)"\u4fdd\u5b58\u6210\u529f");
    }

    public Rsp queryCourseSections(TrainCourseSectionsQueryReqBO request) {
        log.info("\u67e5\u8be2\u8bfe\u7a0b\u7ae0\u8282\uff1a{}", (Object)request);
        String courseId = request.getCourseSaveReqBO().getCourseId();
        TrainCourseSectionsQueryRspBO rspBO = new TrainCourseSectionsQueryRspBO();
        RspList rspList = this.nbchatTrainSectionApi.queryCourse(courseId);
        List trainSectionsBOList = new ArrayList();
        if (!rspList.isSuccess()) {
            log.info("\u67e5\u8be2\u8bfe\u7a0b\u7ae0\u8282\u5931\u8d25\uff1a{}", (Object)rspList);
        } else {
            trainSectionsBOList = rspList.getRows();
            log.info("\u67e5\u8be2\u8bfe\u7a0b\u7ae0\u8282\u7ed3\u679c\uff1a{}\u6761", (Object)trainSectionsBOList.size());
            trainSectionsBOList.forEach(trainSectionsBO -> {
                trainSectionsBO.setTaskId("");
                trainSectionsBO.setCreationId("");
                trainSectionsBO.setTaskState(TaskStateType.MISSION_COMPLETED.getCode());
                NbchatTrainCatalog catalog = this.trainCatalogMapper.selectBySectionId(trainSectionsBO.getSectionId());
                log.info("\u67e5\u8be2\u7ae0\u8282\u7684\u540d\u79f0\uff1a{}", (Object)catalog);
                trainSectionsBO.setCatalogId(catalog.getCatalogId());
                trainSectionsBO.setCatalogTitle(catalog.getCatalogTitle());
            });
            rspBO.setTrainSectionsBOList(trainSectionsBOList);
        }
        TranCourseQueryReqBO tranCourseQueryReqBO = new TranCourseQueryReqBO();
        BeanUtils.copyProperties((Object)request.getCourseSaveReqBO(), (Object)tranCourseQueryReqBO);
        Rsp<TranCourseBO> rsp = this.getCourse(tranCourseQueryReqBO);
        TranCourseBO tranCourseBO = new TranCourseBO();
        if (!rsp.isSuccess()) {
            rspBO.setTranCourseBO(tranCourseBO);
            log.info("\u67e5\u8be2\u8bfe\u7a0b\u5185\u5bb9\u5931\u8d25\uff1a{}", rsp);
        } else {
            tranCourseBO = (TranCourseBO)rsp.getData();
            tranCourseBO.setTaskId("");
            tranCourseBO.setCreationId("");
            tranCourseBO.setTaskState(TaskStateType.MISSION_COMPLETED.getCode());
            rspBO.setTranCourseBO(tranCourseBO);
        }
        log.info("\u67e5\u8be2\u8bfe\u7a0b\u7ae0\u8282\u7ed3\u679c\uff1a{}", (Object)rspBO);
        return BaseRspUtils.createSuccessRsp((Object)rspBO, (String)"\u67e5\u8be2\u6210\u529f");
    }

    private void addExamConfig(NbchatTrainCourse course) {
        try {
            NbchatExamTestPaper testPaper = new NbchatExamTestPaper();
            testPaper.setCourseId(course.getCourseId());
            testPaper.setTenantCode(course.getTenantCode());
            testPaper.setCreateTime(new Date());
            testPaper.setCreateUser(course.getUserId());
            testPaper.setUpdateTime(new Date());
            testPaper.setPassingScore("90");
            testPaper.setTestNum(Integer.valueOf(10));
            testPaper.setTestType(ExamTestType.RANDOM.getCode());
            testPaper.setTrainState("0");
            this.nbchatExamTestPaperMapper.insertSelective(testPaper);
        }
        catch (Exception e) {
            log.error("\u6dfb\u52a0\u8003\u8bd5\u914d\u7f6e\u5931\u8d25", (Throwable)e);
        }
    }

    private String createMajor(NbchatTrainCourse courseInfo) {
        try {
            FileResearchMajorSaveRequest request = new FileResearchMajorSaveRequest();
            request.setMajorName(courseInfo.getCourseName() + "\u673a\u5668\u4eba");
            request.setMajorDesc(courseInfo.getCourseName());
            request.setTenantCode(courseInfo.getTenantCode());
            request.setUserId(courseInfo.getUserId());
            request.setMajorSource(Integer.valueOf(StateEnum.SOURCE.OTHER_1.getCode()));
            request.setCollectionName("kb_base_course");
            request.setEmbedModel("bce-embedding-base_v1");
            request.setMajorConfig("{\"topK\": 3, \"score\": 0.3, \"rerank\": false, \"searchType\": \"both\", \"rerankModel\": \"bce-reranker-base_v1\"}");
            Rsp rsp = this.nbchatResearchMajorApi.saveMajor(request);
            if (rsp.isSuccess()) {
                NbchatResearchMajorRspBO data = (NbchatResearchMajorRspBO)rsp.getData();
                return data.getMajorId();
            }
            log.info("\u521b\u5efa\u4e13\u5c5e\u673a\u5668\u4eba\u7ed3\u679c\uff1a{}", (Object)rsp);
        }
        catch (Exception e) {
            log.error("\u521b\u5efa\u4e13\u5c5e\u673a\u5668\u4eba\u5931\u8d25", (Throwable)e);
        }
        return null;
    }

    private TrainSectionsBO getSectionTaskState(TrainSectionsBO trainSectionsBO) {
        TdhCreationTask task;
        TdhCreationTask tdhCreationTask = new TdhCreationTask();
        tdhCreationTask.setCourseId(trainSectionsBO.getCourseId());
        tdhCreationTask.setSectionId(trainSectionsBO.getSectionId());
        tdhCreationTask.setTenantCode(trainSectionsBO.getTenantCode());
        if (StringUtils.isNotBlank((CharSequence)trainSectionsBO.getVideoUrl())) {
            tdhCreationTask.setVideoUrl(trainSectionsBO.getVideoUrl());
        }
        if ((task = this.getTaskId(tdhCreationTask, false)) != null) {
            Date startTime;
            Date updateTime;
            int comparison;
            trainSectionsBO.setTaskId(task.getTaskId());
            trainSectionsBO.setTaskState(task.getTaskState());
            trainSectionsBO.setCreationId("");
            List<TdhCreationRecord> tdhCreationRecord = this.querySectionCreationRecord(trainSectionsBO);
            if (TaskStateType.TASK_EXCEPTION.getCode().equals(task.getTaskState())) {
                String taskState = tdhCreationRecord.size() == 0 ? TaskStateType.TASK_EXCEPTION.getCode() : TaskStateType.EDIT.getCode();
                trainSectionsBO.setTaskState(taskState);
                TdhCreationRecord creationRecord = this.getCreationId(tdhCreationRecord, false);
                if (TaskStateType.EDIT.getCode().equals(taskState) && creationRecord != null) {
                    trainSectionsBO.setTaskId("");
                    trainSectionsBO.setVideoUrl("");
                    String creationId = creationRecord.getCreationId();
                    trainSectionsBO.setCreationId(creationId);
                }
            }
            TdhCreationRecord creationRecord = this.getCreationId(tdhCreationRecord, false);
            if (!CollectionUtils.isEmpty(tdhCreationRecord) && creationRecord != null && (comparison = (updateTime = creationRecord.getUpdateTime()).compareTo(startTime = task.getStartTime())) > 0) {
                trainSectionsBO.setTaskState(TaskStateType.EDIT.getCode());
                trainSectionsBO.setTaskId("");
                trainSectionsBO.setVideoUrl("");
                trainSectionsBO.setCreationId(creationRecord.getCreationId());
            }
        } else {
            trainSectionsBO.setTaskId("");
            List<TdhCreationRecord> tdhCreationRecord = this.querySectionCreationRecord(trainSectionsBO);
            String taskState = tdhCreationRecord.isEmpty() ? TaskStateType.TO_BE_EDITED.getCode() : TaskStateType.EDIT.getCode();
            trainSectionsBO.setTaskState(taskState);
            trainSectionsBO.setCreationId("");
            TdhCreationRecord creationRecord = this.getCreationId(tdhCreationRecord, false);
            if (TaskStateType.EDIT.getCode().equals(taskState) && creationRecord != null) {
                String creationId = creationRecord.getCreationId();
                trainSectionsBO.setVideoUrl("");
                trainSectionsBO.setCreationId(creationId);
            }
        }
        return trainSectionsBO;
    }

    private TranCourseBO getCourseTaskState(TranCourseBO tranCourseBO) {
        TdhCreationTask task;
        TdhCreationTask tdhCreationTask = new TdhCreationTask();
        tdhCreationTask.setCourseId(tranCourseBO.getCourseId());
        tdhCreationTask.setTenantCode(tranCourseBO.getTenantCode());
        if (StringUtils.isNotBlank((CharSequence)tranCourseBO.getVideoUrl())) {
            tdhCreationTask.setVideoUrl(tranCourseBO.getVideoUrl());
        }
        if ((task = this.getTaskId(tdhCreationTask, true)) != null) {
            Date startTime;
            Date updateTime;
            int comparison;
            tranCourseBO.setTaskId(task.getTaskId());
            tranCourseBO.setTaskState(task.getTaskState());
            tranCourseBO.setCreationId("");
            List<TdhCreationRecord> tdhCreationRecord = this.queryCourseCreationRecord(tranCourseBO, false);
            if (TaskStateType.TASK_EXCEPTION.getCode().equals(task.getTaskState())) {
                String taskState = tdhCreationRecord.size() == 0 ? TaskStateType.TASK_EXCEPTION.getCode() : TaskStateType.EDIT.getCode();
                tranCourseBO.setTaskState(taskState);
                TdhCreationRecord creationRecord = this.getCreationId(tdhCreationRecord, true);
                if (TaskStateType.EDIT.getCode().equals(taskState) && creationRecord != null) {
                    tranCourseBO.setTaskId("");
                    tranCourseBO.setVideoUrl("");
                    String creationId = creationRecord.getCreationId();
                    tranCourseBO.setCreationId(creationId);
                }
            }
            TdhCreationRecord creationRecord = this.getCreationId(tdhCreationRecord, true);
            if (!CollectionUtils.isEmpty(tdhCreationRecord) && creationRecord != null && (comparison = (updateTime = creationRecord.getUpdateTime()).compareTo(startTime = task.getStartTime())) > 0) {
                tranCourseBO.setTaskState(TaskStateType.EDIT.getCode());
                tranCourseBO.setTaskId("");
                tranCourseBO.setVideoUrl("");
                tranCourseBO.setCreationId(creationRecord.getCreationId());
            }
        } else {
            tranCourseBO.setTaskId("");
            List<TdhCreationRecord> tdhCreationRecord = this.queryCourseCreationRecord(tranCourseBO, true);
            String taskState = tdhCreationRecord.size() == 0 ? TaskStateType.TO_BE_EDITED.getCode() : TaskStateType.EDIT.getCode();
            tranCourseBO.setTaskState(taskState);
            tranCourseBO.setCreationId("");
            TdhCreationRecord creationRecord = this.getCreationId(tdhCreationRecord, true);
            if (TaskStateType.EDIT.getCode().equals(taskState) && creationRecord != null) {
                String creationId = creationRecord.getCreationId();
                tranCourseBO.setVideoUrl("");
                tranCourseBO.setCreationId(creationId);
            }
        }
        return tranCourseBO;
    }

    private TdhCreationTask getTaskId(TdhCreationTask task, Boolean course) {
        log.info("\u67e5\u8be2TaskId\uff1a{}", (Object)task);
        String courseId = task.getCourseId();
        String sectionId = task.getSectionId();
        String videoUrl = task.getVideoUrl();
        if (StringUtils.isNotBlank((CharSequence)sectionId) && StringUtils.isNotBlank((CharSequence)task.getVideoUrl())) {
            task.setCourseId(null);
            task.setSectionId(null);
        }
        if (course.booleanValue() && StringUtils.isNotBlank((CharSequence)videoUrl)) {
            task.setCourseId(null);
        }
        task.setIsValid(EntityValidType.NORMAL.getCode());
        List list = this.taskMapper.selectAll(task);
        log.info("\u67e5\u8be2TaskId\u7ed3\u679c\uff1a{}", (Object)list);
        if (CollectionUtils.isEmpty((Collection)list) && StringUtils.isNotBlank((CharSequence)task.getVideoUrl())) {
            task.setVideoUrl("");
            task.setCourseId(courseId);
            task.setSectionId(sectionId);
            list = this.taskMapper.selectAll(task);
        }
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        list = list.stream().filter(li -> li.getStartTime() != null).collect(Collectors.toList());
        if (course.booleanValue() && StringUtils.isBlank((CharSequence)videoUrl)) {
            list = list.stream().filter(li -> li.getSectionId() == null || li.getSectionId().equals("")).collect(Collectors.toList());
        }
        Date now = new Date();
        TdhCreationTask tdhCreationTask = list.stream().min((task1, task2) -> {
            if (task1.getStartTime() == null || task2.getStartTime() == null) {
                return 0;
            }
            long diff1 = Math.abs(now.getTime() - task1.getStartTime().getTime());
            long diff2 = Math.abs(now.getTime() - task2.getStartTime().getTime());
            return Long.compare(diff1, diff2);
        }).orElse(null);
        log.info("\u67e5\u8be2TaskId\u7ed3\u679c\uff1a{}", (Object)tdhCreationTask);
        return tdhCreationTask;
    }

    private List<TdhCreationRecord> querySectionCreationRecord(TrainSectionsBO trainSectionsBO) {
        TdhCreationRecord record = new TdhCreationRecord();
        record.setCourseId(trainSectionsBO.getCourseId());
        record.setSectionId(trainSectionsBO.getSectionId());
        record.setTenantCode(trainSectionsBO.getTenantCode());
        record.setIsValid(EntityValidType.NORMAL.getCode());
        List tdhCreationRecord = this.tdhCreationRecordMapper.selectAll(record);
        return tdhCreationRecord;
    }

    private TdhCreationRecord getCreationId(List<TdhCreationRecord> list, Boolean course) {
        if (course.booleanValue()) {
            list = list.stream().filter(li -> li.getSectionId() == null || li.getSectionId().equals("")).collect(Collectors.toList());
        }
        Date now = new Date();
        TdhCreationRecord tdhCreationRecord = list.stream().min((task1, task2) -> {
            if (task1.getUpdateTime() == null || task2.getUpdateTime() == null) {
                return 0;
            }
            long diff1 = Math.abs(now.getTime() - task1.getUpdateTime().getTime());
            long diff2 = Math.abs(now.getTime() - task2.getUpdateTime().getTime());
            return Long.compare(diff1, diff2);
        }).orElse(null);
        return tdhCreationRecord;
    }

    private List<TdhCreationRecord> queryCourseCreationRecord(TranCourseBO tranCourseBO, boolean course) {
        TdhCreationRecord record = new TdhCreationRecord();
        record.setCourseId(tranCourseBO.getCourseId());
        record.setTenantCode(tranCourseBO.getTenantCode());
        record.setIsValid(EntityValidType.NORMAL.getCode());
        List list = this.tdhCreationRecordMapper.selectAll(record);
        if (course) {
            list = list.stream().filter(li -> li.getSectionId() == null || li.getSectionId().equals("")).collect(Collectors.toList());
        }
        return list;
    }

    private void unBundle(TdhCreationRecord tdhCreationRecord, Boolean course) {
        List creationRecordList = this.tdhCreationRecordMapper.selectAll(tdhCreationRecord);
        if (!CollectionUtils.isEmpty((Collection)creationRecordList)) {
            creationRecordList.forEach(record -> {
                TdhCreationRecord creationRecord = new TdhCreationRecord();
                creationRecord.setCreationId(record.getCreationId());
                if (course.booleanValue()) {
                    if (StringUtils.isBlank((CharSequence)record.getSectionId())) {
                        creationRecord.setCourseId("");
                        this.tdhCreationRecordMapper.update(creationRecord);
                    }
                } else {
                    creationRecord.setSectionId("");
                    creationRecord.setCourseId("");
                    this.tdhCreationRecordMapper.update(creationRecord);
                }
            });
        }
    }

    private void unBundleTask(TdhCreationTask task, Boolean course) {
        List list = this.taskMapper.selectAll(task);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            list.forEach(record -> {
                TdhCreationTask creationTask = new TdhCreationTask();
                creationTask.setTaskId(record.getTaskId());
                if (course.booleanValue()) {
                    if (StringUtils.isBlank((CharSequence)record.getSectionId())) {
                        creationTask.setCourseId("");
                        this.taskMapper.update(creationTask);
                    }
                } else {
                    creationTask.setSectionId("");
                    creationTask.setCourseId("");
                    this.taskMapper.update(creationTask);
                }
            });
        }
    }
}

