/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.service.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.nbchat.train.api.NbchatTrainCourseApi;
import com.tydic.nbchat.train.api.NbchatTrainDialogueManageApi;
import com.tydic.nbchat.train.api.bo.course.TranCourseBO;
import com.tydic.nbchat.train.api.bo.course.TranCourseQueryReqBO;
import com.tydic.nbchat.train.api.bo.dialogue.manage.DialogueManageBO;
import com.tydic.nbchat.train.api.bo.dialogue.manage.DialogueManageReqBO;
import com.tydic.nbchat.train.api.bo.eums.RoleType;
import com.tydic.nbchat.train.api.bo.eums.StateEnum;
import com.tydic.nbchat.train.mapper.NbchatTrainCourseCategoryMapper;
import com.tydic.nbchat.train.mapper.NbchatTrainCourseMapper;
import com.tydic.nbchat.train.mapper.NbchatTrainSceneDialogueManageMapper;
import com.tydic.nbchat.train.mapper.NbchatTrainSceneDialogueMapper;
import com.tydic.nbchat.train.mapper.po.NbchatTrainCourse;
import com.tydic.nbchat.train.mapper.po.NbchatTrainCourseCategory;
import com.tydic.nbchat.train.mapper.po.NbchatTrainSceneDialogue;
import com.tydic.nbchat.train.mapper.po.NbchatTrainSceneDialogueManage;
import com.tydic.nicc.common.eums.EntityValidType;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class NbchatTrainDialogueManageServiceImpl
implements NbchatTrainDialogueManageApi {
    private static final Logger log = LoggerFactory.getLogger(NbchatTrainDialogueManageServiceImpl.class);
    @Resource
    NbchatTrainSceneDialogueManageMapper nbchatTrainSceneDialogueManageMapper;
    @Resource
    NbchatTrainSceneDialogueMapper nbchatTrainSceneDialogueMapper;
    @Resource
    NbchatTrainCourseMapper nbchatTrainCourseMapper;
    @Resource
    NbchatTrainCourseCategoryMapper nbchatTrainCourseCategoryMapper;
    @Resource
    NbchatTrainCourseApi nbchatTrainCourseApi;

    @Transactional
    public Rsp save(DialogueManageBO request) {
        log.info("\u4fdd\u5b58\u4f1a\u8bdd\u914d\u7f6e\uff1a{}", (Object)request);
        List dialogue = request.getDialogue();
        if (CollectionUtils.isEmpty((Collection)request.getRole()) || request.getRole().size() != 2) {
            List<String> roles = Arrays.asList(RoleType.DEFAULT_USER.getCode(), RoleType.DEFAULT_ASSISTANT.getCode());
            request.setRole(roles);
        }
        this.updateCourseSceneState(request.getCourseId(), request.getSceneState());
        NbchatTrainSceneDialogueManage manage = this.nbchatTrainSceneDialogueManageMapper.queryByCourseId(request.getCourseId(), request.getTenantCode());
        NbchatTrainSceneDialogueManage record = new NbchatTrainSceneDialogueManage();
        BeanUtils.copyProperties((Object)request, (Object)record);
        record.setDialogueNum(Integer.valueOf(dialogue.size()));
        record.setRole(JSON.toJSONString((Object)request.getRole()));
        if (ObjectUtils.isEmpty((Object)manage)) {
            record.setCreateTime(new Date());
            record.setCreateUser(request.getUserId());
            this.nbchatTrainSceneDialogueManageMapper.insertSelective(record);
        } else {
            record.setId(manage.getId());
            record.setUpdateTime(new Date());
            this.nbchatTrainSceneDialogueManageMapper.update(record);
        }
        NbchatTrainSceneDialogue update = new NbchatTrainSceneDialogue();
        update.setCourseId(request.getCourseId());
        update.setTenantCode(request.getTenantCode());
        this.nbchatTrainSceneDialogueMapper.delete(update);
        List role = request.getRole();
        String role_q = (String)role.get(0);
        String role_a = (String)role.get(1);
        for (DialogueManageBO.Node node : dialogue) {
            NbchatTrainSceneDialogue dialogue1 = new NbchatTrainSceneDialogue();
            dialogue1.setRole(role_q);
            dialogue1.setContent(node.getQuestion());
            dialogue1.setDateTime(new Date());
            dialogue1.setCourseId(request.getCourseId());
            dialogue1.setTenantCode(request.getTenantCode());
            dialogue1.setKeyPoints(node.getKeyPoints());
            dialogue1.setAudioState(EntityValidType.DELETE.getCode());
            this.nbchatTrainSceneDialogueMapper.insertSelective(dialogue1);
            NbchatTrainSceneDialogue dialogue2 = new NbchatTrainSceneDialogue();
            dialogue2.setRole(role_a);
            dialogue2.setContent(node.getAnswer());
            dialogue2.setDateTime(new Date());
            dialogue2.setCourseId(request.getCourseId());
            dialogue2.setTenantCode(request.getTenantCode());
            dialogue2.setKeyPoints(node.getKeyPoints());
            dialogue2.setAudioState(EntityValidType.DELETE.getCode());
            this.nbchatTrainSceneDialogueMapper.insertSelective(dialogue2);
        }
        return BaseRspUtils.createSuccessRsp(null);
    }

    public RspList<DialogueManageBO> queryScene(DialogueManageReqBO request) {
        log.info("\u67e5\u8be2\u573a\u666f\u5b9e\u8df5\u914d\u7f6e\u5217\u8868\uff1a{}", (Object)request);
        TranCourseQueryReqBO reqBO = new TranCourseQueryReqBO();
        BeanUtils.copyProperties((Object)request, (Object)reqBO);
        reqBO.setSearchAll(true);
        reqBO.setOrder(false);
        ArrayList<DialogueManageBO> res = new ArrayList<DialogueManageBO>();
        RspList courses = this.nbchatTrainCourseApi.getCourses(reqBO);
        if (courses.isSuccess()) {
            for (TranCourseBO row : courses.getRows()) {
                DialogueManageBO bo = new DialogueManageBO();
                BeanUtils.copyProperties((Object)row, (Object)bo);
                NbchatTrainSceneDialogueManage dialogueManage = this.nbchatTrainSceneDialogueManageMapper.queryByCourseId(row.getCourseId(), request.getTenantCode());
                if (ObjectUtils.isEmpty((Object)dialogueManage)) {
                    bo.setDialogueNum(Integer.valueOf(0));
                    bo.setSceneState(StateEnum.COURSE.PRE_EDIT.getName());
                } else {
                    bo.setDialogueNum(dialogueManage.getDialogueNum());
                    bo.setId(dialogueManage.getId());
                }
                res.add(bo);
            }
        }
        return BaseRspUtils.createSuccessRspList(res, (long)courses.getCount());
    }

    public Rsp<DialogueManageBO> queryInfo(DialogueManageReqBO request) {
        log.info("\u67e5\u8be2\u573a\u666f\u5b9e\u8df5\u660e\u7ec6\u914d\u7f6e\uff1a{}", (Object)request);
        TranCourseQueryReqBO reqBO = new TranCourseQueryReqBO();
        reqBO.setCourseId(request.getCourseId());
        reqBO.setTenantCode(request.getTenantCode());
        Rsp course = this.nbchatTrainCourseApi.getCourse(reqBO);
        if (!course.isSuccess()) {
            return BaseRspUtils.createErrorRsp((String)course.getRspDesc());
        }
        DialogueManageBO res = new DialogueManageBO();
        BeanUtils.copyProperties((Object)course.getData(), (Object)res);
        NbchatTrainSceneDialogueManage manage = this.nbchatTrainSceneDialogueManageMapper.queryByCourseId(reqBO.getCourseId(), reqBO.getTenantCode());
        if (ObjectUtils.isNotEmpty((Object)manage)) {
            res.setDialogueDesc(manage.getDialogueDesc());
            res.setScore(manage.getScore());
            res.setId(manage.getId());
            String role = manage.getRole();
            if (StringUtils.isEmpty((CharSequence)role)) {
                res.setTrainRole(RoleType.DEFAULT_USER.getName());
            } else {
                List roles = JSON.parseArray((String)role, String.class);
                res.setTrainRole(RoleType.getNameByCode((String)((String)roles.get(0))));
            }
        }
        res.setCategoryName(this.getCataName(res.getCategory()));
        res.setCategory2Name(this.getCataName(res.getCategory2()));
        String sceneStateName = StateEnum.COURSE.getNameByCode((String)res.getSceneState());
        res.setSceneState(sceneStateName);
        NbchatTrainSceneDialogue cond = new NbchatTrainSceneDialogue();
        cond.setTenantCode(request.getTenantCode());
        cond.setCourseId(request.getCourseId());
        List dialogues = this.nbchatTrainSceneDialogueMapper.selectByCondition(cond);
        ArrayList<DialogueManageBO.Node> dialogue = new ArrayList<DialogueManageBO.Node>();
        if (CollectionUtils.isNotEmpty((Collection)dialogues)) {
            for (int i = 0; i < dialogues.size(); ++i) {
                DialogueManageBO.Node node = new DialogueManageBO.Node();
                NbchatTrainSceneDialogue dialogue1 = (NbchatTrainSceneDialogue)dialogues.get(i);
                NbchatTrainSceneDialogue dialogue2 = (NbchatTrainSceneDialogue)dialogues.get(++i);
                if (dialogue1.getRole().equals(RoleType.DEFAULT_USER.getCode())) {
                    node.setKeyPoints(dialogue1.getKeyPoints());
                    node.setQuestion(dialogue1.getContent());
                    node.setQuestionAudio(dialogue1.getAudioUrl());
                }
                if (dialogue2.getRole().equals(RoleType.DEFAULT_ASSISTANT.getCode())) {
                    node.setAnswer(dialogue2.getContent());
                    node.setAnswerAudio(dialogue2.getAudioUrl());
                    node.setKeyPoints(dialogue2.getKeyPoints());
                }
                dialogue.add(node);
            }
        }
        res.setDialogue(dialogue);
        return BaseRspUtils.createSuccessRsp((Object)res);
    }

    public void updateCourseSceneState(String courseId, String code) {
        NbchatTrainCourse rec = new NbchatTrainCourse();
        rec.setCourseId(courseId);
        rec.setSceneState(code);
        rec.setUpdateTime(new Date());
        this.nbchatTrainCourseMapper.updateByPrimaryKeySelective(rec);
    }

    private String getCataName(String cateId) {
        NbchatTrainCourseCategory category = this.nbchatTrainCourseCategoryMapper.queryById(cateId);
        if (ObjectUtils.isNotEmpty((Object)category)) {
            return category.getCateName();
        }
        return "";
    }
}

