/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.tydic.nbchat.train.api.NbchatTrainDialogueApi;
import com.tydic.nbchat.train.api.bo.dialogue.DialogueBO;
import com.tydic.nbchat.train.api.bo.dialogue.DialogueReqBO;
import com.tydic.nbchat.train.api.bo.dialogue.DialogueSessionQueryReqBO;
import com.tydic.nbchat.train.api.bo.dialogue.DialogueSessionRecordBO;
import com.tydic.nbchat.train.api.bo.dialogue.DialogueSessionRspBO;
import com.tydic.nbchat.train.api.bo.dialogue.DialogueSessionSaveReqBO;
import com.tydic.nbchat.train.api.bo.dialogue.manage.DialogueManageBO;
import com.tydic.nbchat.train.api.bo.eums.TrainCommonState;
import com.tydic.nbchat.train.api.bo.train.SceneDialogueContent;
import com.tydic.nbchat.train.core.service.impl.event.EventPublishFactory;
import com.tydic.nbchat.train.mapper.NbchatTrainRecordMapper;
import com.tydic.nbchat.train.mapper.NbchatTrainSceneDialogueManageMapper;
import com.tydic.nbchat.train.mapper.NbchatTrainSceneDialogueMapper;
import com.tydic.nbchat.train.mapper.NbchatTrainSceneDialogueRecordMapper;
import com.tydic.nbchat.train.mapper.NbchatTrainSceneDialogueSessionMapper;
import com.tydic.nbchat.train.mapper.po.NbchatTrainRecord;
import com.tydic.nbchat.train.mapper.po.NbchatTrainSceneDialogue;
import com.tydic.nbchat.train.mapper.po.NbchatTrainSceneDialogueManage;
import com.tydic.nbchat.train.mapper.po.NbchatTrainSceneDialogueRecord;
import com.tydic.nbchat.train.mapper.po.NbchatTrainSceneDialogueSession;
import com.tydic.nicc.common.eums.EntityValidType;
import com.tydic.nicc.dc.base.annotions.MethodParamVerifyEnable;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class NbchatTrainDialogueServiceImpl
implements NbchatTrainDialogueApi {
    private static final Logger log = LoggerFactory.getLogger(NbchatTrainDialogueServiceImpl.class);
    @Resource
    private NbchatTrainSceneDialogueMapper nbchatTrainSceneDialogueMapper;
    @Resource
    private NbchatTrainSceneDialogueRecordMapper nbchatTrainSceneDialogueRecordMapper;
    @Resource
    private NbchatTrainRecordMapper nbchatTrainRecordMapper;
    @Resource
    private NbchatTrainSceneDialogueManageMapper nbchatTrainSceneDialogueManageMapper;
    @Resource
    private NbchatTrainSceneDialogueSessionMapper nbchatTrainSceneDialogueSessionMapper;

    @MethodParamVerifyEnable
    public RspList getCourseDialogues(DialogueReqBO reqBO) {
        log.info("\u67e5\u8be2\u573a\u666f\u5bf9\u8bdd\uff1a{}", (Object)reqBO);
        ArrayList list = Lists.newArrayList();
        NbchatTrainSceneDialogue record = new NbchatTrainSceneDialogue();
        BeanUtils.copyProperties((Object)reqBO, (Object)record);
        Page page = PageHelper.startPage((int)reqBO.getPage(), (int)reqBO.getLimit());
        this.nbchatTrainSceneDialogueMapper.selectByCondition(record);
        NiccCommonUtil.copyList((List)page.getResult(), (List)list, DialogueBO.class);
        return BaseRspUtils.createSuccessRspList((List)list);
    }

    @MethodParamVerifyEnable
    public Rsp getSessionInfo(DialogueSessionQueryReqBO request) {
        log.info("\u67e5\u8be2\u4f1a\u8bdd\u8bb0\u5f55\uff1a{}", (Object)request);
        DialogueSessionRspBO rspBO = new DialogueSessionRspBO();
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{request.getCourseId(), request.getSessionId()})) {
            return BaseRspUtils.createErrorRsp((String)"\u53c2\u6570\u5f02\u5e38: \u8bfe\u7a0bid\u548c\u4f1a\u8bddid\u4e0d\u5f97\u540c\u65f6\u4e3a\u7a7a");
        }
        NbchatTrainSceneDialogueSession session = StringUtils.isNotBlank((CharSequence)request.getSessionId()) ? this.nbchatTrainSceneDialogueSessionMapper.queryById(request.getSessionId()) : this.nbchatTrainSceneDialogueSessionMapper.selectMaxScorePassSession(request.getCourseId(), request.getUserId());
        if (session != null) {
            BeanUtils.copyProperties((Object)session, (Object)rspBO);
            NbchatTrainSceneDialogueRecord record = new NbchatTrainSceneDialogueRecord();
            record.setDialogueSessionId(session.getSessionId());
            List records = this.nbchatTrainSceneDialogueRecordMapper.selectAll(record);
            ArrayList dialogues = Lists.newArrayList();
            NiccCommonUtil.copyList((List)records, (List)dialogues, DialogueSessionRecordBO.class);
            rspBO.setDialogues((List)dialogues);
            return BaseRspUtils.createSuccessRsp((Object)rspBO);
        }
        return BaseRspUtils.createErrorRsp((String)"\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u4f1a\u8bdd");
    }

    @Deprecated
    public Rsp save(DialogueBO request) {
        log.info("\u4fdd\u5b58\u573a\u666f\u5bf9\u8bdd\uff1a{}", (Object)request);
        List dialogueContents = JSONObject.parseArray((String)request.getContent(), SceneDialogueContent.class);
        for (SceneDialogueContent dialogueContent : dialogueContents) {
            NbchatTrainSceneDialogue dialogue = new NbchatTrainSceneDialogue();
            dialogue.setRole("user");
            dialogue.setContent(dialogueContent.getUser());
            dialogue.setDateTime(new Date());
            dialogue.setCourseId(request.getCourseId());
            dialogue.setTenantCode(request.getTenantCode());
            this.nbchatTrainSceneDialogueMapper.insertSelective(dialogue);
            NbchatTrainSceneDialogue dialogue1 = new NbchatTrainSceneDialogue();
            dialogue1.setRole("assistant");
            dialogue1.setContent(dialogueContent.getAssistant());
            dialogue1.setDateTime(new Date());
            dialogue1.setCourseId(request.getCourseId());
            dialogue1.setTenantCode(request.getTenantCode());
            this.nbchatTrainSceneDialogueMapper.insertSelective(dialogue1);
        }
        return BaseRspUtils.createSuccessRsp(null);
    }

    public Rsp saveSession(DialogueSessionSaveReqBO request) {
        log.info("\u4fdd\u5b58\u573a\u666f\u5b9e\u8df5\u8bb0\u5f55:{}", (Object)request);
        String sessionId = request.getSessionId();
        if (StringUtils.isBlank((CharSequence)request.getSessionId())) {
            sessionId = IdWorker.nextAutoIdStr();
            NbchatTrainSceneDialogueSession session = new NbchatTrainSceneDialogueSession();
            session.setSessionId(sessionId);
            session.setCourseId(request.getCourseId());
            session.setTenantCode(request.getTenantCode());
            session.setUserId(request.getUserId());
            session.setStartTime(new Date());
            session.setSessionState(TrainCommonState.NOT_PASS.getCode());
            session.setSceneState(TrainCommonState.NOT_PASS.getCode());
            session.setDialogueType(request.getDialogueType());
            NbchatTrainSceneDialogueManage manage = this.nbchatTrainSceneDialogueManageMapper.queryByCourseId(request.getCourseId(), request.getTenantCode());
            if (manage != null) {
                session.setPassScore(manage.getScore());
            }
            this.nbchatTrainSceneDialogueSessionMapper.insertSelective(session);
        } else {
            if (request.getDialogues() != null && !request.getDialogues().isEmpty()) {
                this.nbchatTrainSceneDialogueRecordMapper.delete(sessionId, request.getTenantCode());
                for (DialogueSessionRecordBO recordBO : request.getDialogues()) {
                    NbchatTrainSceneDialogueRecord record = new NbchatTrainSceneDialogueRecord();
                    record.setDialogueSessionId(sessionId);
                    BeanUtils.copyProperties((Object)request, (Object)record);
                    BeanUtils.copyProperties((Object)recordBO, (Object)record);
                    if (record.getCreateTime() == null) {
                        record.setCreateTime(new Date());
                    }
                    this.nbchatTrainSceneDialogueRecordMapper.insertSelective(record);
                }
            }
            if (request.getUserScore() != null) {
                NbchatTrainSceneDialogueSession session = this.nbchatTrainSceneDialogueSessionMapper.queryById(sessionId);
                if (session != null) {
                    NbchatTrainRecord nbchatTrainRecord = this.nbchatTrainRecordMapper.selectByUserAndCourseId(request.getUserId(), request.getCourseId());
                    if (nbchatTrainRecord == null) {
                        return BaseRspUtils.createErrorRsp((String)"\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u57f9\u8bad\u4efb\u52a1");
                    }
                    nbchatTrainRecord.setSceneState(TrainCommonState.PASS.getCode());
                    session.setUserScore(request.getUserScore());
                    session.setAnalysis(request.getAnalysis());
                    session.setSessionState(EntityValidType.NORMAL.getCode());
                    session.setSceneState(EntityValidType.NORMAL.getCode());
                    if (StringUtils.isNotEmpty((CharSequence)request.getDialogueType()) && request.getDialogueType().equals("3") && request.getUserScore() >= session.getPassScore()) {
                        nbchatTrainRecord.setLastTime(new Date());
                        nbchatTrainRecord.setScenePassState(TrainCommonState.PASS.getCode());
                    }
                    session.setEndTime(new Date());
                    this.nbchatTrainSceneDialogueSessionMapper.update(session);
                    this.nbchatTrainRecordMapper.updateByPrimaryKeySelective(nbchatTrainRecord);
                    if (TrainCommonState.PASS.getCode().equals(nbchatTrainRecord.getScenePassState())) {
                        EventPublishFactory.publishUserCompleteTaskEvent(request.getTenantCode(), request.getUserId());
                    }
                } else {
                    return BaseRspUtils.createErrorRsp((String)"\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u4f1a\u8bdd");
                }
            }
        }
        return BaseRspUtils.createSuccessRsp((Object)sessionId);
    }

    @Deprecated
    public Rsp updateScore(DialogueManageBO request) {
        log.info("\u66f4\u65b0\u573a\u666f\u8bc4\u5206:{}", (Object)request);
        NbchatTrainSceneDialogueManage dialogueManage = this.nbchatTrainSceneDialogueManageMapper.queryByCourseId(request.getCourseId(), request.getTenantCode());
        if (ObjectUtils.isEmpty((Object)dialogueManage)) {
            return BaseRspUtils.createErrorRsp((String)"\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u8bfe\u7a0b");
        }
        NbchatTrainRecord nbchatTrainRecord = this.nbchatTrainRecordMapper.selectByUserAndCourseId(request.getUserId(), request.getCourseId());
        if (ObjectUtils.isNotEmpty((Object)nbchatTrainRecord) && "0".equals(nbchatTrainRecord.getSceneState()) && request.getScore() >= dialogueManage.getScore()) {
            nbchatTrainRecord.setSceneState("1");
            this.nbchatTrainRecordMapper.updateByPrimaryKeySelective(nbchatTrainRecord);
        }
        return BaseRspUtils.createSuccessRsp((Object)"\u66f4\u65b0\u7ed3\u675f");
    }
}

