/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson2.JSON;
import com.tydic.nbchat.train.api.NbchatTrainSectionApi;
import com.tydic.nbchat.train.api.bo.eums.StateEnum;
import com.tydic.nbchat.train.api.bo.train.catalog.TrainCatalogBO;
import com.tydic.nbchat.train.api.bo.train.catalog.TrainCatalogQueryReqBO;
import com.tydic.nbchat.train.api.bo.train.section.SectionInfo;
import com.tydic.nbchat.train.api.bo.train.section.SectionsSaveRequest;
import com.tydic.nbchat.train.api.bo.train.section.TrainSectionQueryRspBO;
import com.tydic.nbchat.train.api.bo.train.section.TrainSectionsBO;
import com.tydic.nbchat.train.mapper.NbchatTrainCatalogMapper;
import com.tydic.nbchat.train.mapper.NbchatTrainCourseMapper;
import com.tydic.nbchat.train.mapper.NbchatTrainSectionsMapper;
import com.tydic.nbchat.train.mapper.NbchatTrainSectionsPageMapper;
import com.tydic.nbchat.train.mapper.NbchatTrainUserRecordMapper;
import com.tydic.nbchat.train.mapper.po.NbchatTrainCatalog;
import com.tydic.nbchat.train.mapper.po.NbchatTrainCourse;
import com.tydic.nbchat.train.mapper.po.NbchatTrainSections;
import com.tydic.nbchat.train.mapper.po.NbchatTrainSectionsPage;
import com.tydic.nbchat.train.mapper.po.NbchatTrainUserRecord;
import com.tydic.nicc.dc.base.annotions.MethodParamVerifyEnable;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class NbchatTrainSectionServiceImpl
implements NbchatTrainSectionApi {
    private static final Logger log = LoggerFactory.getLogger(NbchatTrainSectionServiceImpl.class);
    @Resource
    private NbchatTrainSectionsMapper nbchatTrainSectionsMapper;
    @Resource
    private NbchatTrainSectionsPageMapper nbchatTrainSectionsPageMapper;
    @Resource
    private NbchatTrainCatalogMapper nbchatTrainCatalogMapper;
    @Resource
    private NbchatTrainUserRecordMapper nbchatTrainUserRecordMapper;
    @Resource
    private NbchatTrainCourseMapper nbchatTrainCourseMapper;

    @MethodParamVerifyEnable
    public Rsp addTrainCount(TrainCatalogQueryReqBO reqBO) {
        log.info("\u4fdd\u5b58\u5b66\u4e60\u4eba\u6570,\u4fdd\u5b58\u5b66\u4e60\u7ae0\u8282\u8bb0\u5f55:{}", (Object)reqBO);
        int update = this.nbchatTrainCatalogMapper.addTrainCount(reqBO.getCourseId(), reqBO.getCatalogId());
        NbchatTrainUserRecord record = new NbchatTrainUserRecord();
        BeanUtils.copyProperties((Object)reqBO, (Object)record);
        record.setCreateTime(new Date());
        this.nbchatTrainUserRecordMapper.insertSelective(record);
        return BaseRspUtils.createSuccessRsp((Object)update);
    }

    public Rsp saveCatalog(TrainCatalogBO reqBO) {
        log.info("\u4fdd\u5b58\u76ee\u5f55\uff1a{}", (Object)reqBO);
        NbchatTrainCatalog catalog = new NbchatTrainCatalog();
        BeanUtils.copyProperties((Object)reqBO, (Object)catalog);
        catalog.setCreateTime(new Date());
        this.nbchatTrainCatalogMapper.insertSelective(catalog);
        return BaseRspUtils.createSuccessRsp((Object)"");
    }

    @MethodParamVerifyEnable
    public RspList<TrainCatalogBO> getSectionCatalogs(TrainCatalogQueryReqBO reqBO) {
        log.info("\u67e5\u8be2\u7ae0\u8282\u76ee\u5f55:{}", (Object)reqBO);
        List catalogs = this.nbchatTrainCatalogMapper.selectByCourseId(reqBO.getCourseId(), reqBO.getCatalogId(), "-1");
        for (NbchatTrainCatalog catalog : catalogs) {
            String sectionId;
            NbchatTrainSections trainSections;
            JSONArray array;
            int count = this.nbchatTrainUserRecordMapper.queryStudied(catalog.getCatalogId(), reqBO.getUserId());
            if (count > 0) {
                catalog.setStudied(Integer.valueOf(1));
            }
            if (!catalog.getParentId().equals("-1") || StringUtils.isEmpty((CharSequence)catalog.getSectionIds()) || CollectionUtils.isEmpty((Collection)(array = JSONArray.parseArray((String)catalog.getSectionIds()))) || ObjectUtils.isEmpty((Object)(trainSections = this.nbchatTrainSectionsMapper.selectByPrimaryKey(sectionId = (String)array.get(0))))) continue;
            catalog.setSectionId(sectionId);
            catalog.setSectionVideoUrl(trainSections.getVideoUrl());
            catalog.setSectionContent(trainSections.getContent());
        }
        ArrayList catalogBOS = Lists.newArrayList();
        NiccCommonUtil.copyList((List)catalogs, (List)catalogBOS, TrainCatalogBO.class);
        this.parseCatalogs(catalogBOS);
        return BaseRspUtils.createSuccessRspList((List)catalogBOS);
    }

    public Rsp<TrainSectionQueryRspBO> getSectionContents(TrainCatalogQueryReqBO reqBO) {
        NbchatTrainCourse nbchatTrainCourse;
        NbchatTrainCatalog catalog;
        log.info("\u67e5\u8be2\u7ae0\u8282\u5185\u5bb9:{}", (Object)reqBO);
        TrainSectionQueryRspBO rspBO = new TrainSectionQueryRspBO();
        List sectionIds = reqBO.getSectionIds();
        if ((sectionIds == null || sectionIds.isEmpty()) && StringUtils.isNotBlank((CharSequence)reqBO.getCatalogId()) && (catalog = this.nbchatTrainCatalogMapper.selectByPrimaryKey(reqBO.getCatalogId())) != null && StringUtils.isNotBlank((CharSequence)catalog.getSectionIds())) {
            sectionIds = JSONArray.parseArray((String)catalog.getSectionIds(), String.class);
            rspBO.setCatalogTitle(catalog.getCatalogTitle());
            rspBO.setTrainCount(catalog.getTrainCount());
        }
        List sections = this.nbchatTrainSectionsMapper.selectBySectionIds(reqBO.getCourseId(), sectionIds);
        ArrayList sectionBOS = Lists.newArrayList();
        NiccCommonUtil.copyList((List)sections, (List)sectionBOS, SectionInfo.class);
        rspBO.setSectionInfos((List)sectionBOS);
        if (CollectionUtils.isNotEmpty((Collection)sectionBOS)) {
            rspBO.setVideoUrl(((NbchatTrainSections)sections.get(0)).getVideoUrl());
            rspBO.setVideoImg(((NbchatTrainSections)sections.get(0)).getVideoImg());
        }
        if (ObjectUtils.isNotEmpty((Object)(nbchatTrainCourse = this.nbchatTrainCourseMapper.selectByPrimaryKey(reqBO.getCourseId())))) {
            String pdfUrl = nbchatTrainCourse.getCourseFileUrl();
            rspBO.setPdfUrl(pdfUrl);
        }
        NbchatTrainSectionsPage query = new NbchatTrainSectionsPage();
        query.setSectionIds(sectionIds);
        query.setCourseId(reqBO.getCourseId());
        int pageNum = this.nbchatTrainSectionsPageMapper.selectSectionMinPageNum(query);
        rspBO.setPdfNum(Integer.valueOf(pageNum));
        return BaseRspUtils.createSuccessRsp((Object)rspBO);
    }

    public Rsp saveSection(SectionsSaveRequest reqBO) {
        log.info("\u4fdd\u5b58\u7ae0\u8282\uff1a{}", (Object)reqBO);
        NbchatTrainSections section = new NbchatTrainSections();
        BeanUtils.copyProperties((Object)reqBO, (Object)section);
        if (StringUtils.isEmpty((CharSequence)reqBO.getSectionId())) {
            section.setSectionId(IdWorker.nextAutoIdStr());
            section.setCreateTime(new Date());
            this.nbchatTrainSectionsMapper.insertSelective(section);
        } else {
            this.nbchatTrainSectionsMapper.updateByPrimaryKeySelective(section);
        }
        if (StringUtils.isNotEmpty((CharSequence)reqBO.getCatalogId())) {
            NbchatTrainCatalog catalog = this.nbchatTrainCatalogMapper.selectByPrimaryKey(reqBO.getCatalogId());
            String sectionIds = catalog.getSectionIds();
            if (StringUtils.isEmpty((CharSequence)sectionIds)) {
                sectionIds = JSON.toJSONString(Collections.singletonList(section.getSectionId()));
            } else {
                JSONArray array = JSONObject.parseArray((String)sectionIds);
                array.add((Object)section.getSectionId());
                HashSet hs = new HashSet(array);
                sectionIds = JSON.toJSONString(hs);
            }
            NbchatTrainCatalog record = new NbchatTrainCatalog();
            record.setCatalogId(reqBO.getCatalogId());
            record.setSectionIds(sectionIds);
            this.nbchatTrainCatalogMapper.updateByPrimaryKeySelective(record);
        }
        this.nbchatTrainCourseMapper.updateStepState(reqBO.getCourseId(), StateEnum.STEP.CONTENT.getCode());
        this.nbchatTrainCourseMapper.updateClassHour(reqBO.getCourseId());
        return BaseRspUtils.createSuccessRsp((Object)section.getSectionId());
    }

    public Rsp<String> querySection(String sectionId) {
        log.info("\u67e5\u8be2\u7ae0\u8282\uff1a{}", (Object)sectionId);
        NbchatTrainSections section = this.nbchatTrainSectionsMapper.selectByPrimaryKey(sectionId);
        return BaseRspUtils.createSuccessRsp((Object)section.getContent());
    }

    public RspList<TrainSectionsBO> queryCourse(String courseId) {
        log.info("\u67e5\u8be2\u8bfe\u7a0b\u4e0b\u7ae0\u8282\u5185\u5bb9\uff1a{}", (Object)courseId);
        ArrayList res = Lists.newArrayList();
        List nbchatTrainSections = this.nbchatTrainSectionsMapper.selectBySectionIds(courseId, null);
        NiccCommonUtil.copyList((List)nbchatTrainSections, (List)res, TrainSectionsBO.class);
        return BaseRspUtils.createSuccessRspList((List)res);
    }

    private void parseCatalogs(List<TrainCatalogBO> catalogs) {
        for (TrainCatalogBO catalog : catalogs) {
            List list = this.nbchatTrainCatalogMapper.selectByCourseId(catalog.getCourseId(), "", catalog.getCatalogId());
            if (list.isEmpty()) continue;
            ArrayList tempList = Lists.newArrayList();
            NiccCommonUtil.copyList((List)list, (List)tempList, TrainCatalogBO.class);
            catalog.setChildren((List)tempList);
            this.parseCatalogs(catalog.getChildren());
        }
    }

    public Rsp delete(String courseId) {
        log.info("\u5220\u9664\u7ae0\u8282\uff1a{}", (Object)courseId);
        int update = this.nbchatTrainSectionsMapper.update(courseId);
        return BaseRspUtils.createSuccessRsp((Object)update);
    }
}

