/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.service.impl;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.tydic.nbchat.train.api.NbchatTrainTaskWhiteListApi;
import com.tydic.nbchat.train.api.bo.task.NbchatTrainTaskWhiteListReqBO;
import com.tydic.nbchat.train.api.bo.task.NbchatTrainTaskWhiteListRspBO;
import com.tydic.nbchat.train.mapper.NbchatTrainTaskWhiteListMapper;
import com.tydic.nbchat.train.mapper.po.NbchatTrainTaskWhiteListCondition;
import com.tydic.nicc.dc.base.annotions.MethodParamVerifyEnable;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class NbchatTrainTaskWhiteListServiceImpl
implements NbchatTrainTaskWhiteListApi {
    private static final Logger log = LoggerFactory.getLogger(NbchatTrainTaskWhiteListServiceImpl.class);
    private final NbchatTrainTaskWhiteListMapper nbchatTrainTaskWhiteListMapper;

    @Transactional(rollbackFor={Exception.class})
    @MethodParamVerifyEnable
    public Rsp addWhiteList(NbchatTrainTaskWhiteListReqBO reqBO) {
        List list = reqBO.getNbchatTrainTaskWhiteList();
        int num = this.nbchatTrainTaskWhiteListMapper.insertList(list);
        return BaseRspUtils.createSuccessRsp((Object)num, (String)"\u6dfb\u52a0\u6210\u529f");
    }

    public RspList queryWhiteList(NbchatTrainTaskWhiteListReqBO reqBO) {
        ArrayList list = new ArrayList();
        NbchatTrainTaskWhiteListCondition condition = new NbchatTrainTaskWhiteListCondition();
        BeanUtils.copyProperties((Object)reqBO, (Object)condition);
        Page page = PageHelper.startPage((int)reqBO.getPage(), (int)reqBO.getLimit());
        condition.setUserId(null);
        condition.setTenantCode(reqBO.getTargetTenantCode());
        this.nbchatTrainTaskWhiteListMapper.queryWhiteList(condition);
        if (CollectionUtils.isEmpty((Collection)page.getResult())) {
            log.info("\u67e5\u8be2\u767d\u540d\u5355-\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff1a{}", (Object)reqBO);
            return BaseRspUtils.createSuccessRspList(list, (long)list.size());
        }
        NiccCommonUtil.copyList((List)page.getResult(), list, NbchatTrainTaskWhiteListRspBO.class);
        return BaseRspUtils.createSuccessRspList(list, (long)page.getTotal());
    }

    @Transactional(rollbackFor={Exception.class})
    public Rsp deleteWhiteList(NbchatTrainTaskWhiteListReqBO reqBO) {
        List list = reqBO.getNbchatTrainTaskWhiteList();
        int num = this.nbchatTrainTaskWhiteListMapper.deleteList(list);
        return BaseRspUtils.createSuccessRsp((Object)num, (String)"\u5220\u9664\u6210\u529f");
    }

    public NbchatTrainTaskWhiteListServiceImpl(NbchatTrainTaskWhiteListMapper nbchatTrainTaskWhiteListMapper) {
        this.nbchatTrainTaskWhiteListMapper = nbchatTrainTaskWhiteListMapper;
    }
}

