/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.service.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.nbchat.train.api.NbchatTrainVideoQaApi;
import com.tydic.nbchat.train.api.NbchatVideoQaRecordApi;
import com.tydic.nbchat.train.api.bo.exam.ExamQuestion;
import com.tydic.nbchat.train.api.bo.video.NbchatVideoQaBO;
import com.tydic.nbchat.train.api.bo.video.NbchatVideoQaRecordBO;
import com.tydic.nbchat.train.api.bo.video.NbchatVideoQaRspBO;
import com.tydic.nbchat.train.api.bo.video.VideoExamSubmitReqBO;
import com.tydic.nbchat.train.core.service.impl.NbchatExamRuleTestServiceImpl;
import com.tydic.nbchat.train.mapper.NbchatVideoQaMapper;
import com.tydic.nbchat.train.mapper.po.NbchatVideoQa;
import com.tydic.nicc.common.eums.EntityValidType;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class NbchatTrainVideoQaServiceImpl
implements NbchatTrainVideoQaApi {
    private static final Logger log = LoggerFactory.getLogger(NbchatTrainVideoQaServiceImpl.class);
    private final NbchatVideoQaRecordApi nbchatVideoQaRecordApi;
    private final NbchatVideoQaMapper nbchatVideoQaMapper;
    private final NbchatExamRuleTestServiceImpl nbchatExamRuleTestService;

    NbchatTrainVideoQaServiceImpl(NbchatVideoQaRecordApi nbchatVideoQaRecordApi, NbchatVideoQaMapper nbchatVideoQaMapper, NbchatExamRuleTestServiceImpl nbchatExamRuleTestService) {
        this.nbchatVideoQaRecordApi = nbchatVideoQaRecordApi;
        this.nbchatVideoQaMapper = nbchatVideoQaMapper;
        this.nbchatExamRuleTestService = nbchatExamRuleTestService;
    }

    public Rsp add(NbchatVideoQaBO request) {
        log.info("\u89c6\u9891\u63d2\u5165\u8bd5\u9898\u5f00\u59cb\uff1a{}", (Object)request);
        NbchatVideoQa rec = new NbchatVideoQa();
        BeanUtils.copyProperties((Object)request, (Object)rec);
        int i = this.nbchatVideoQaMapper.insertSelective(rec);
        if (i > 0) {
            return BaseRspUtils.createSuccessRsp(null);
        }
        return BaseRspUtils.createErrorRsp((String)"\u63d2\u5165\u5931\u8d25");
    }

    public RspList query(NbchatVideoQaBO request) {
        log.info("\u89c6\u9891\u67e5\u8be2\u8bd5\u9898\u5f00\u59cb\uff1a{}", (Object)request);
        NbchatVideoQa cond = new NbchatVideoQa();
        BeanUtils.copyProperties((Object)request, (Object)cond);
        cond.setUserId(null);
        cond.setIsValid(Integer.valueOf(EntityValidType.NORMAL.getCode()));
        List qas = this.nbchatVideoQaMapper.selectAll(cond);
        List<String> ids = qas.stream().map(NbchatVideoQa::getQid).collect(Collectors.toList());
        List<ExamQuestion> questions = this.nbchatExamRuleTestService.queryQuestion(ids, null);
        Map<String, ExamQuestion> questionMap = questions.stream().collect(Collectors.toMap(ExamQuestion::getQuestionId, v -> v));
        ArrayList<NbchatVideoQaRspBO> res = new ArrayList<NbchatVideoQaRspBO>();
        for (NbchatVideoQa qa : qas) {
            NbchatVideoQaRspBO entity = new NbchatVideoQaRspBO();
            entity.setQuestion(questionMap.get(qa.getQid()));
            entity.setKeyFrameTime(qa.getKeyFrameTime());
            res.add(entity);
        }
        return BaseRspUtils.createSuccessRspList(res);
    }

    public Rsp submit(VideoExamSubmitReqBO request) {
        log.info("\u63d0\u4ea4\u89c6\u9891\u8003\u8bd5\u7b54\u6848\uff1a{}", (Object)request);
        NbchatVideoQaRecordBO req = new NbchatVideoQaRecordBO();
        BeanUtils.copyProperties((Object)request, (Object)req);
        String answerContent = JSON.toJSONString((Object)request.getAnswers());
        req.setAnswerContent(answerContent);
        this.nbchatVideoQaRecordApi.save(req);
        return BaseRspUtils.createSuccessRsp(null);
    }
}

