/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.nbchat.train.api.NbchatUserTrainRecordApi;
import com.tydic.nbchat.train.api.bo.course.TranUserCourseQueryReqBO;
import com.tydic.nbchat.train.api.bo.course.TranUserCourseQueryRspBO;
import com.tydic.nbchat.train.api.bo.course.TranUserCourseSaveReqBO;
import com.tydic.nbchat.train.api.bo.eums.OriginEnum;
import com.tydic.nbchat.train.api.bo.eums.QuestionType;
import com.tydic.nbchat.train.api.bo.eums.StateEnum;
import com.tydic.nbchat.train.api.bo.report.course.TrainRpCoursePnSaveReqBO;
import com.tydic.nbchat.train.api.rp_course.NbcahtTrainRpCourseSaveApi;
import com.tydic.nbchat.train.core.service.impl.event.EventPublishFactory;
import com.tydic.nbchat.train.mapper.NbchatExamQuestionMapper;
import com.tydic.nbchat.train.mapper.NbchatExamTestPaperMapper;
import com.tydic.nbchat.train.mapper.NbchatTrainCourseMapper;
import com.tydic.nbchat.train.mapper.NbchatTrainRecordMapper;
import com.tydic.nbchat.train.mapper.NbchatTrainSceneDialogueManageMapper;
import com.tydic.nbchat.train.mapper.po.NbchatExamNewTestPaper;
import com.tydic.nbchat.train.mapper.po.NbchatExamTestPaper;
import com.tydic.nbchat.train.mapper.po.NbchatTrainCourse;
import com.tydic.nbchat.train.mapper.po.NbchatTrainRecord;
import com.tydic.nbchat.train.mapper.po.NbchatTrainSceneDialogueManage;
import com.tydic.nbchat.train.mapper.po.NbchatUserTrainRecordSelectCondition;
import com.tydic.nicc.common.eums.EntityValidType;
import com.tydic.nicc.dc.base.annotions.MethodParamVerifyEnable;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class NbchatUserTrainRecordServiceImpl
implements NbchatUserTrainRecordApi {
    private static final Logger log = LoggerFactory.getLogger(NbchatUserTrainRecordServiceImpl.class);
    @Resource
    private NbcahtTrainRpCourseSaveApi nbcahtTrainRpCourseSaveApi;
    @Resource
    private NbchatTrainRecordMapper nbchatTrainRecordMapper;
    @Resource
    private NbchatExamTestPaperMapper nbchatExamTestPaperMapper;
    @Resource
    private NbchatTrainSceneDialogueManageMapper nbchatTrainSceneDialogueManageMapper;
    @Resource
    private NbchatTrainCourseMapper nbchatTrainCourseMapper;
    @Resource
    private NbchatExamQuestionMapper nbchatExamQuestionMapper;

    public RspList<TranUserCourseQueryRspBO> getUserTrainCourses(TranUserCourseQueryReqBO request) {
        log.info("\u7528\u6237\u8bfe\u7a0b-\u67e5\u8be2\u5217\u8868:{}", (Object)request);
        NbchatUserTrainRecordSelectCondition condition = new NbchatUserTrainRecordSelectCondition();
        BeanUtils.copyProperties((Object)request, (Object)condition);
        ArrayList list = Lists.newArrayList();
        condition.setIsValid(EntityValidType.NORMAL.getCode());
        condition.setCourseState(StateEnum.COURSE.ON.getCode());
        List nbchatUserTrainRecords = this.nbchatTrainRecordMapper.selectUserTrainRecord(condition);
        NiccCommonUtil.copyList((List)nbchatUserTrainRecords, (List)list, TranUserCourseQueryRspBO.class);
        ArrayList resList = Lists.newArrayList();
        for (TranUserCourseQueryRspBO rspBO : list) {
            int count = this.nbchatTrainRecordMapper.countTrained(rspBO.getCourseId());
            rspBO.setTrainCount(count);
            NbchatExamTestPaper testPaperManage = this.nbchatExamTestPaperMapper.queryByCourseId(rspBO.getCourseId(), request.getTenantCode());
            NbchatTrainSceneDialogueManage dialogueManage = this.nbchatTrainSceneDialogueManageMapper.queryByCourseId(rspBO.getCourseId(), request.getTenantCode());
            rspBO.setCourseTestState(StateEnum.BUTTON.GRAY.getCode());
            rspBO.setDialogueState(StateEnum.BUTTON.GRAY.getCode());
            rspBO.setQaState(StateEnum.BUTTON.INVALID.getCode());
            NbchatExamNewTestPaper po = new NbchatExamNewTestPaper();
            po.setQuestions(Integer.valueOf(1));
            po.setTenantCode(request.getTenantCode());
            po.setCourseId(rspBO.getCourseId());
            po.setQuestionType(QuestionType.QA_MIN.getCode());
            List questions = this.nbchatExamQuestionMapper.checkNewTestPaper(po);
            if (CollectionUtils.isNotEmpty((Collection)questions)) {
                rspBO.setQaState(StateEnum.BUTTON.VALID.getCode());
            }
            if (ObjectUtils.isEmpty((Object)testPaperManage) || !rspBO.getTestPaperState().equals(StateEnum.COURSE.ON.getCode())) {
                rspBO.setCourseTestState(StateEnum.BUTTON.INVALID.getCode());
            } else if (rspBO.getTestPaperState().equals(StateEnum.COURSE.ON.getCode()) && (testPaperManage.getTrainState().equals(EntityValidType.DELETE.getCode()) || testPaperManage.getTrainState().equals(EntityValidType.NORMAL.getCode()) && rspBO.getTrainState().equals(EntityValidType.NORMAL.getCode()))) {
                rspBO.setCourseTestState(StateEnum.BUTTON.VALID.getCode());
            }
            if (ObjectUtils.isNotEmpty((Object)dialogueManage) && rspBO.getSceneState().equals(StateEnum.COURSE.ON.getCode()) && dialogueManage.getDialogueNum() > 0) {
                rspBO.setDialogueState(StateEnum.BUTTON.VALID.getCode());
            }
            if (!(!request.getOrigin().equals(OriginEnum.COURSE_TRAIN.getCode()) || rspBO.getCourseTestState().equals(StateEnum.BUTTON.INVALID.getCode()) && rspBO.getDialogueState().equals(StateEnum.BUTTON.GRAY.getCode()))) {
                resList.add(rspBO);
            }
            if (request.getOrigin().equals(OriginEnum.HIST_TEST.getCode()) && rspBO.getCourseTestState().equals(StateEnum.BUTTON.VALID.getCode())) {
                resList.add(rspBO);
            }
            if (!request.getOrigin().equals(OriginEnum.COURSE_DETAIL.getCode())) continue;
            resList.add(rspBO);
        }
        List page = resList.stream().sorted(Comparator.comparing(TranUserCourseQueryRspBO::getTrainCount).reversed()).skip((request.getPage() - 1) * request.getLimit()).limit(request.getLimit()).collect(Collectors.toList());
        return BaseRspUtils.createSuccessRspList(page, (long)resList.size());
    }

    @MethodParamVerifyEnable
    public Rsp saveUserTrainRecord(TranUserCourseSaveReqBO queryReqBO) {
        log.info("\u7528\u6237\u8bfe\u7a0b-\u4fdd\u5b58\u5b66\u4e60\u8bb0\u5f55:{}", (Object)queryReqBO);
        NbchatTrainRecord save = new NbchatTrainRecord();
        BeanUtils.copyProperties((Object)queryReqBO, (Object)save);
        save.setLastTime(new Date());
        NbchatTrainCourse course = this.nbchatTrainCourseMapper.selectByPrimaryKey(queryReqBO.getCourseId());
        if (course == null) {
            return BaseRspUtils.createErrorRsp((String)"\u8bfe\u7a0b\u4e0d\u5b58\u5728!");
        }
        NbchatTrainRecord trainRecord = this.nbchatTrainRecordMapper.selectByUserAndCourseId(queryReqBO.getUserId(), queryReqBO.getCourseId());
        if (trainRecord == null) {
            save.setCreateTime(new Date());
            int learn = this.nbchatTrainRecordMapper.countLearnSections(queryReqBO.getCourseId());
            save.setClassHourTotal(Float.valueOf(learn));
            if (queryReqBO.getTrainSections() != null) {
                save.setTrainSections(JSONObject.toJSONString((Object)queryReqBO.getTrainSections(), (boolean)false));
            }
            save.setClassHourTotal(course.getClassHour());
            if (course.getClassHour() != null && course.getClassHour().equals(save.getClassHourLearned())) {
                save.setTrainState(EntityValidType.NORMAL.getCode());
            }
            this.nbchatTrainRecordMapper.insertSelective(save);
            if (EntityValidType.NORMAL.getCode().equals(save.getTrainState())) {
                EventPublishFactory.publishUserCompleteTaskEvent(queryReqBO.getTenantCode(), queryReqBO.getUserId());
            }
        } else {
            save.setId(trainRecord.getId());
            if (EntityValidType.NORMAL.getCode().equals(trainRecord.getTrainState())) {
                save.setClassHourLearned(trainRecord.getClassHourTotal());
            }
            if (ObjectUtils.allNotNull((Object[])new Object[]{queryReqBO.getClassHourLearned(), trainRecord.getClassHourTotal()}) && queryReqBO.getClassHourLearned().equals(trainRecord.getClassHourTotal())) {
                save.setTrainState(EntityValidType.NORMAL.getCode());
            }
            if (queryReqBO.getTrainSections() != null) {
                try {
                    Set trainSet = (Set)JSONObject.parseObject((String)trainRecord.getTrainSections(), Set.class);
                    trainSet.addAll(queryReqBO.getTrainSections());
                    save.setTrainSections(JSONObject.toJSONString((Object)trainSet, (boolean)false));
                }
                catch (Exception trainSet) {
                    // empty catch block
                }
            }
            this.nbchatTrainRecordMapper.updateByPrimaryKeySelective(save);
            if (EntityValidType.NORMAL.getCode().equals(save.getTrainState())) {
                EventPublishFactory.publishUserCompleteTaskEvent(queryReqBO.getTenantCode(), queryReqBO.getUserId());
            }
        }
        TrainRpCoursePnSaveReqBO reqBO = new TrainRpCoursePnSaveReqBO();
        BeanUtils.copyProperties((Object)queryReqBO, (Object)reqBO);
        reqBO.setDateDay(new Date());
        this.nbcahtTrainRpCourseSaveApi.saveRpCoursePnRecord(reqBO);
        return BaseRspUtils.createSuccessRsp((Object)save);
    }

    @MethodParamVerifyEnable
    public Rsp collectCourse(TranUserCourseSaveReqBO request) {
        log.info("\u7528\u6237\u8bfe\u7a0b-\u6536\u85cf\u8bfe\u7a0b:{}", (Object)request);
        if (StringUtils.isNotBlank((CharSequence)request.getStar()) && (request.getStar().equals(EntityValidType.NORMAL.getCode()) || request.getStar().equals(EntityValidType.DELETE.getCode()))) {
            NbchatTrainRecord trainRecord = this.nbchatTrainRecordMapper.selectByUserAndCourseId(request.getUserId(), request.getCourseId());
            if (trainRecord == null) {
                return BaseRspUtils.createErrorRsp((String)"\u64cd\u4f5c\u5931\u8d25");
            }
            NbchatTrainRecord update = new NbchatTrainRecord();
            BeanUtils.copyProperties((Object)request, (Object)update);
            update.setId(trainRecord.getId());
            update.setStar(request.getStar());
            int updated = this.nbchatTrainRecordMapper.updateByPrimaryKeySelective(update);
            if (updated == 1) {
                return BaseRspUtils.createSuccessRsp((Object)"\u64cd\u4f5c\u6210\u529f");
            }
            return BaseRspUtils.createErrorRsp((String)"\u64cd\u4f5c\u5931\u8d25");
        }
        return BaseRspUtils.createErrorRsp((String)"\u975e\u6cd5\u8bf7\u6c42");
    }
}

